/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.memgroupby;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.math.stat.descriptive.rank.Percentile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueDataUtil;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.memgroupby.Aggregate;
import org.pentaho.di.trans.steps.memgroupby.MemoryGroupByData;
import org.pentaho.di.trans.steps.memgroupby.MemoryGroupByMeta;

public class MemoryGroupBy
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MemoryGroupByMeta.class;
    private MemoryGroupByMeta meta = (MemoryGroupByMeta)this.getStepMeta().getStepMetaInterface();
    private MemoryGroupByData data;
    private boolean allNullsAreZero = false;
    private boolean minNullIsValued = false;
    private boolean compatibilityMode = false;

    public MemoryGroupBy(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (MemoryGroupByData)stepDataInterface;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (MemoryGroupByMeta)smi;
        this.data = (MemoryGroupByData)sdi;
        Object[] r = this.getRow();
        if (this.first) {
            if (r == null && !this.meta.isAlwaysGivingBackOneRow()) {
                this.setOutputDone();
                return false;
            }
            String val = this.getVariable("KETTLE_AGGREGATION_ALL_NULLS_ARE_ZERO", "N");
            this.allNullsAreZero = ValueMetaBase.convertStringToBoolean((String)val);
            val = this.getVariable("KETTLE_AGGREGATION_MIN_NULL_IS_VALUED", "N");
            this.minNullIsValued = ValueMetaBase.convertStringToBoolean((String)val);
            this.compatibilityMode = ValueMetaBase.convertStringToBoolean((String)this.getVariable("KETTLE_COMPATIBILITY_MEMORY_GROUP_BY_SUM_AVERAGE_RETURN_NUMBER_TYPE", "N"));
            this.data.inputRowMeta = this.getInputRowMeta();
            if (this.data.inputRowMeta == null) {
                this.data.inputRowMeta = this.getTransMeta().getPrevStepFields(this.getStepMeta());
            }
            this.data.outputRowMeta = this.data.inputRowMeta.clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.data.subjectnrs = new int[this.meta.getSubjectField().length];
            this.data.groupnrs = new int[this.meta.getGroupField().length];
            if (r != null) {
                int i;
                for (i = 0; i < this.meta.getSubjectField().length; ++i) {
                    this.data.subjectnrs[i] = this.meta.getAggregateType()[i] == 16 ? 0 : this.data.inputRowMeta.indexOfValue(this.meta.getSubjectField()[i]);
                    if (this.data.subjectnrs[i] >= 0) continue;
                    this.logError(BaseMessages.getString(PKG, (String)"MemoryGroupBy.Log.AggregateSubjectFieldCouldNotFound", (String[])new String[]{this.meta.getSubjectField()[i]}));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                for (i = 0; i < this.meta.getGroupField().length; ++i) {
                    this.data.groupnrs[i] = this.data.inputRowMeta.indexOfValue(this.meta.getGroupField()[i]);
                    if (this.data.groupnrs[i] >= 0) continue;
                    this.logError(BaseMessages.getString(PKG, (String)"MemoryGroupBy.Log.GroupFieldCouldNotFound", (String[])new String[]{this.meta.getGroupField()[i]}));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
            }
            this.data.valueMetaInteger = new ValueMetaInteger("count");
            this.data.valueMetaNumber = new ValueMetaNumber("sum");
            this.initGroupMeta(this.data.inputRowMeta);
        }
        if (this.first) {
            this.newAggregate(r, null);
            this.data.groupAggMeta = new RowMeta();
            this.data.groupAggMeta.addRowMeta(this.data.groupMeta);
            this.data.groupAggMeta.addRowMeta(this.data.aggMeta);
        }
        if (r == null) {
            this.updateValueMeta();
            this.handleLastOfGroup();
            this.setOutputDone();
            return false;
        }
        if (this.first || this.data.newBatch) {
            this.first = false;
            this.data.newBatch = false;
        }
        this.addToAggregate(r);
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"MemoryGroupBy.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    private void handleLastOfGroup() throws KettleException {
        for (MemoryGroupByData.HashEntry entry : this.data.map.keySet()) {
            int i;
            Aggregate aggregate = this.data.map.get(entry);
            Object[] aggregateResult = this.getAggregateResult(aggregate);
            Object[] outputRowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            int index = 0;
            for (i = 0; i < this.data.groupMeta.size(); ++i) {
                outputRowData[index++] = this.data.groupMeta.getValueMeta(i).convertToNormalStorageType(entry.getGroupData()[i]);
            }
            for (i = 0; i < this.data.aggMeta.size(); ++i) {
                outputRowData[index++] = this.data.aggMeta.getValueMeta(i).convertToNormalStorageType(aggregateResult[i]);
            }
            this.putRow(this.data.outputRowMeta, outputRowData);
        }
        if (this.data.map.isEmpty() && this.meta.isAlwaysGivingBackOneRow()) {
            int i;
            Object[] outputRowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            int index = 0;
            for (i = 0; i < this.data.groupMeta.size(); ++i) {
                outputRowData[index++] = null;
            }
            for (i = 0; i < this.data.aggMeta.size(); ++i) {
                outputRowData[index++] = this.meta.getAggregateType()[i] == 7 || this.meta.getAggregateType()[i] == 16 || this.meta.getAggregateType()[i] == 15 ? Long.valueOf(0L) : null;
            }
            this.putRow(this.data.outputRowMeta, outputRowData);
        }
    }

    @VisibleForTesting
    void updateValueMeta() throws KettleException {
        List outputValueMetaList = this.data.outputRowMeta.getValueMetaList();
        List aggMetaValueMetaList = this.data.aggMeta.getValueMetaList();
        for (int outputIndex = 0; outputIndex < outputValueMetaList.size(); ++outputIndex) {
            for (int aggIndex = 0; aggIndex < aggMetaValueMetaList.size(); ++aggIndex) {
                if (!((ValueMetaInterface)aggMetaValueMetaList.get(aggIndex)).getName().equals(((ValueMetaInterface)outputValueMetaList.get(outputIndex)).getName())) continue;
                this.data.outputRowMeta.removeValueMeta(((ValueMetaInterface)outputValueMetaList.get(outputIndex)).getName());
                this.data.outputRowMeta.addValueMeta(outputIndex, (ValueMetaInterface)aggMetaValueMetaList.get(aggIndex));
            }
        }
    }

    void addToAggregate(Object[] r) throws KettleException {
        Object[] groupData = new Object[this.data.groupMeta.size()];
        for (int i = 0; i < this.data.groupnrs.length; ++i) {
            groupData[i] = r[this.data.groupnrs[i]];
        }
        MemoryGroupByData.HashEntry entry = this.data.getHashEntry(groupData);
        Aggregate aggregate = this.data.map.get(entry);
        if (aggregate == null) {
            aggregate = new Aggregate();
            this.newAggregate(r, aggregate);
            this.data.map.put(entry, aggregate);
        }
        block18: for (int i = 0; i < this.data.subjectnrs.length; ++i) {
            Object subj = r[this.data.subjectnrs[i]];
            ValueMetaInterface subjMeta = this.data.inputRowMeta.getValueMeta(this.data.subjectnrs[i]);
            Object value = aggregate.agg[i];
            ValueMetaInterface valueMeta = this.data.aggMeta.getValueMeta(i);
            switch (this.meta.getAggregateType()[i]) {
                case 1: {
                    aggregate.agg[i] = ValueDataUtil.sum((ValueMetaInterface)valueMeta, (Object)value, (ValueMetaInterface)subjMeta, (Object)subj);
                    continue block18;
                }
                case 2: {
                    if (subjMeta.isNull(subj)) continue block18;
                    aggregate.agg[i] = ValueDataUtil.sum((ValueMetaInterface)valueMeta, (Object)value, (ValueMetaInterface)subjMeta, (Object)subj);
                    int n = i;
                    aggregate.counts[n] = aggregate.counts[n] + 1L;
                    continue block18;
                }
                case 3: 
                case 4: {
                    if (subjMeta.isNull(subj)) continue block18;
                    ((List)aggregate.agg[i]).add(subjMeta.getNumber(subj));
                    continue block18;
                }
                case 13: {
                    if (aggregate.mean == null) {
                        aggregate.mean = new double[this.meta.getSubjectField().length];
                    }
                    int n = i;
                    aggregate.counts[n] = aggregate.counts[n] + 1L;
                    double n2 = aggregate.counts[i];
                    double x = subjMeta.getNumber(subj);
                    double sum = value == null ? new Double(0.0) : (Double)value;
                    double mean = aggregate.mean[i];
                    double delta = x - mean;
                    aggregate.mean[i] = mean;
                    aggregate.agg[i] = sum += delta * (x - (mean += delta / n2));
                    continue block18;
                }
                case 15: {
                    if (aggregate.distinctObjs == null) {
                        aggregate.distinctObjs = new Set[this.meta.getSubjectField().length];
                    }
                    if (aggregate.distinctObjs[i] == null) {
                        aggregate.distinctObjs[i] = new TreeSet<Object>();
                    }
                    if (!subjMeta.isNull(subj)) {
                        Object obj = subjMeta.convertToNormalStorageType(subj);
                        if (obj instanceof byte[]) {
                            obj = new String((byte[])obj);
                        }
                        if (!aggregate.distinctObjs[i].contains(obj)) {
                            aggregate.distinctObjs[i].add(obj);
                        }
                    }
                    aggregate.counts[i] = aggregate.distinctObjs[i].size();
                    continue block18;
                }
                case 7: {
                    if (subjMeta.isNull(subj)) continue block18;
                    int n = i;
                    aggregate.counts[n] = aggregate.counts[n] + 1L;
                    continue block18;
                }
                case 16: {
                    int n = i;
                    aggregate.counts[n] = aggregate.counts[n] + 1L;
                    continue block18;
                }
                case 5: {
                    boolean subjIsNull = subjMeta.isNull(subj);
                    boolean valueIsNull = valueMeta.isNull(value);
                    if (this.minNullIsValued || !subjIsNull && !valueIsNull) {
                        aggregate.agg[i] = subjMeta.compare(subj, valueMeta, value) < 0 ? subj : value;
                        continue block18;
                    }
                    if (!valueIsNull || subjIsNull) continue block18;
                    aggregate.agg[i] = subj;
                    continue block18;
                }
                case 6: {
                    if (subjMeta.compare(subj, valueMeta, value) <= 0) continue block18;
                    aggregate.agg[i] = subj;
                    continue block18;
                }
                case 9: {
                    if (subjMeta.isNull(subj) || value != null) continue block18;
                    aggregate.agg[i] = subj;
                    continue block18;
                }
                case 10: {
                    if (subjMeta.isNull(subj)) continue block18;
                    aggregate.agg[i] = subj;
                    continue block18;
                }
                case 11: {
                    if (aggregate.counts[i] != 0L) continue block18;
                    aggregate.agg[i] = subj;
                    int n = i;
                    aggregate.counts[n] = aggregate.counts[n] + 1L;
                    continue block18;
                }
                case 12: {
                    aggregate.agg[i] = subj;
                    continue block18;
                }
                case 8: {
                    if (subj == null) continue block18;
                    StringBuilder sb = (StringBuilder)value;
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(subjMeta.getString(subj));
                    continue block18;
                }
                case 14: {
                    StringBuilder sb;
                    if (subj == null) continue block18;
                    String separator = "";
                    if (!Utils.isEmpty((CharSequence)this.meta.getValueField()[i])) {
                        separator = this.environmentSubstitute(this.meta.getValueField()[i]);
                    }
                    if ((sb = (StringBuilder)value).length() > 0) {
                        sb.append(separator);
                    }
                    sb.append(subjMeta.getString(subj));
                    continue block18;
                }
            }
        }
    }

    void newAggregate(Object[] r, Aggregate aggregate) throws KettleException {
        int i;
        if (aggregate == null) {
            this.data.aggMeta = new RowMeta();
        } else {
            aggregate.counts = new long[this.data.subjectnrs.length];
            for (i = 0; i < aggregate.counts.length; ++i) {
                aggregate.counts[i] = 0L;
            }
            aggregate.distinctObjs = null;
            aggregate.agg = new Object[this.data.subjectnrs.length];
            aggregate.mean = new double[this.data.subjectnrs.length];
        }
        for (i = 0; i < this.data.subjectnrs.length; ++i) {
            ValueMetaInterface subjMeta = this.data.inputRowMeta.getValueMeta(this.data.subjectnrs[i]);
            Serializable v = null;
            ValueMetaInterface vMeta = null;
            switch (this.meta.getAggregateType()[i]) {
                case 3: 
                case 4: {
                    vMeta = new ValueMetaNumber(this.meta.getAggregateField()[i]);
                    v = new ArrayList();
                    break;
                }
                case 13: {
                    vMeta = new ValueMetaNumber(this.meta.getAggregateField()[i]);
                    break;
                }
                case 7: 
                case 15: 
                case 16: {
                    vMeta = new ValueMetaInteger(this.meta.getAggregateField()[i]);
                    break;
                }
                case 1: 
                case 2: {
                    vMeta = !this.compatibilityMode && subjMeta.isNumeric() ? subjMeta.clone() : new ValueMetaNumber();
                    vMeta.setName(this.meta.getAggregateField()[i]);
                    break;
                }
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    vMeta = subjMeta.clone();
                    vMeta.setName(this.meta.getAggregateField()[i]);
                    v = r == null ? null : r[this.data.subjectnrs[i]];
                    break;
                }
                case 8: {
                    vMeta = new ValueMetaString(this.meta.getAggregateField()[i]);
                    v = new StringBuilder();
                    break;
                }
                case 14: {
                    vMeta = new ValueMetaString(this.meta.getAggregateField()[i]);
                    v = new StringBuilder();
                    break;
                }
                default: {
                    throw new KettleException("Unknown data type for aggregation : " + this.meta.getAggregateField()[i]);
                }
            }
            if (this.meta.getAggregateType()[i] != 7 && this.meta.getAggregateType()[i] != 15 && this.meta.getAggregateType()[i] != 16) {
                vMeta.setLength(subjMeta.getLength(), subjMeta.getPrecision());
            }
            if (aggregate == null) {
                this.data.aggMeta.addValueMeta(vMeta);
                continue;
            }
            aggregate.agg[i] = v;
        }
    }

    private void initGroupMeta(RowMetaInterface previousRowMeta) throws KettleValueException {
        this.data.groupMeta = new RowMeta();
        this.data.entryMeta = new RowMeta();
        for (int i = 0; i < this.data.groupnrs.length; ++i) {
            ValueMetaInterface valueMeta = previousRowMeta.getValueMeta(this.data.groupnrs[i]);
            this.data.groupMeta.addValueMeta(valueMeta);
            ValueMetaInterface normalMeta = valueMeta.clone();
            normalMeta.setStorageType(0);
        }
    }

    Object[] getAggregateResult(Aggregate aggregate) throws KettleValueException {
        Object[] result = new Object[this.data.subjectnrs.length];
        if (this.data.subjectnrs != null) {
            for (int i = 0; i < this.data.subjectnrs.length; ++i) {
                Object ag = aggregate.agg[i];
                switch (this.meta.getAggregateType()[i]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        ag = ValueDataUtil.divide((ValueMetaInterface)this.data.aggMeta.getValueMeta(i), (Object)ag, (ValueMetaInterface)new ValueMetaInteger("c"), (Object)aggregate.counts[i]);
                        break;
                    }
                    case 3: 
                    case 4: {
                        double percentile = 50.0;
                        if (this.meta.getAggregateType()[i] == 4) {
                            percentile = Double.parseDouble(this.meta.getValueField()[i]);
                        }
                        List valuesList = (List)aggregate.agg[i];
                        double[] values = new double[valuesList.size()];
                        for (int v = 0; v < values.length; ++v) {
                            values[v] = (Double)valuesList.get(v);
                        }
                        ag = new Percentile().evaluate(values, percentile);
                        break;
                    }
                    case 7: 
                    case 15: 
                    case 16: {
                        ag = aggregate.counts[i];
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 13: {
                        double sum = (Double)ag / (double)aggregate.counts[i];
                        ag = Math.sqrt(sum);
                        break;
                    }
                    case 8: 
                    case 14: {
                        ag = ((StringBuilder)ag).toString();
                        break;
                    }
                }
                if (ag == null && this.allNullsAreZero) {
                    ValueMetaInterface vm = this.data.aggMeta.getValueMeta(i);
                    ag = ValueDataUtil.getZeroForValueMetaType((ValueMetaInterface)vm);
                }
                result[i] = ag;
            }
        }
        return result;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MemoryGroupByMeta)smi;
        this.data = (MemoryGroupByData)sdi;
        if (super.init(smi, sdi)) {
            this.data.map = new HashMap(5000);
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        super.dispose(smi, sdi);
        ((MemoryGroupByData)sdi).clear();
    }

    @Override
    public void batchComplete() throws KettleException {
        this.handleLastOfGroup();
        this.data.map.clear();
        this.data.newBatch = true;
    }

    void setAllNullsAreZero(boolean allNullsAreZero) {
        this.allNullsAreZero = allNullsAreZero;
    }

    void setMinNullIsValued(boolean minNullIsValued) {
        this.minNullIsValued = minNullIsValued;
    }
}

