/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fileinput.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.errorhandling.FileErrorHandler;
import org.pentaho.di.trans.steps.file.BaseFileField;
import org.pentaho.di.trans.steps.file.BaseFileInputAdditionalField;
import org.pentaho.di.trans.steps.fileinput.text.BufferedInputStreamReader;
import org.pentaho.di.trans.steps.fileinput.text.EncodingType;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputMeta;
import org.pentaho.di.trans.steps.fileinput.text.TextFileLine;

public class TextFileInputUtils {
    private static Class<?> PKG = TextFileInputUtils.class;

    public static final String[] guessStringsFromLine(VariableSpace space, LogChannelInterface log, String line, TextFileInputMeta inf, String delimiter, String enclosure, String escapeCharacter) throws KettleException {
        ArrayList<String> strings = new ArrayList<String>();
        try {
            if (line == null) {
                return null;
            }
            if (inf.content.fileType.equalsIgnoreCase("CSV")) {
                int len_esc;
                int pos = 0;
                int length = line.length();
                boolean dencl = false;
                int len_encl = enclosure == null ? 0 : enclosure.length();
                int n = len_esc = escapeCharacter == null ? 0 : escapeCharacter.length();
                while (pos < length) {
                    String pol;
                    int next;
                    boolean encl_found;
                    int from = pos;
                    boolean contains_escaped_enclosures = false;
                    boolean contains_escaped_separators = false;
                    boolean contains_escaped_escape = false;
                    if (len_encl > 0 && line.substring(from, from + len_encl).equalsIgnoreCase(enclosure)) {
                        String strnext;
                        if (log.isRowLevel()) {
                            log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRow", (String[])new String[]{line.substring(from, from + len_encl)})});
                        }
                        encl_found = true;
                        int p = from + len_encl;
                        boolean is_enclosure = len_encl > 0 && p + len_encl < length && line.substring(p, p + len_encl).equalsIgnoreCase(enclosure);
                        boolean is_escape = len_esc > 0 && p + len_esc < length && line.substring(p, p + len_esc).equalsIgnoreCase(escapeCharacter);
                        boolean enclosure_after = false;
                        if ((is_enclosure || is_escape) && p < length - 1) {
                            strnext = line.substring(p + len_encl, p + 2 * len_encl);
                            if (strnext.equalsIgnoreCase(enclosure)) {
                                ++p;
                                enclosure_after = true;
                                dencl = true;
                                if (is_escape) {
                                    contains_escaped_enclosures = true;
                                }
                            } else if (strnext.equals(escapeCharacter)) {
                                ++p;
                                if (is_escape) {
                                    contains_escaped_escape = true;
                                }
                            }
                        }
                        while ((!is_enclosure || enclosure_after) && p < line.length()) {
                            enclosure_after = false;
                            is_enclosure = len_encl > 0 && ++p + len_encl < length && line.substring(p, p + len_encl).equals(enclosure);
                            boolean bl = is_escape = len_esc > 0 && p + len_esc < length && line.substring(p, p + len_esc).equals(escapeCharacter);
                            if (!is_enclosure && !is_escape || p >= length - 1) continue;
                            strnext = line.substring(p + len_encl, p + 2 * len_encl);
                            if (strnext.equals(enclosure)) {
                                ++p;
                                enclosure_after = true;
                                dencl = true;
                                if (!is_escape) continue;
                                contains_escaped_enclosures = true;
                                continue;
                            }
                            if (!strnext.equals(escapeCharacter)) continue;
                            ++p;
                            if (!is_escape) continue;
                            contains_escaped_escape = true;
                        }
                        next = p >= length ? p : p + len_encl;
                        if (log.isRowLevel()) {
                            log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.EndOfEnclosure", (String[])new String[]{"" + p})});
                        }
                    } else {
                        encl_found = false;
                        boolean found = false;
                        int startpoint = from;
                        do {
                            next = line.indexOf(delimiter, startpoint);
                            if (len_esc > 0 && next - len_esc > 0) {
                                String before = line.substring(next - len_esc, next);
                                if (escapeCharacter.equals(before)) {
                                    startpoint = next + 1;
                                    contains_escaped_separators = true;
                                    continue;
                                }
                                found = true;
                                continue;
                            }
                            found = true;
                        } while (!found && next >= 0);
                    }
                    if (next == -1) {
                        next = length;
                    }
                    if (encl_found) {
                        pol = line.substring(from + len_encl, next - len_encl);
                        if (log.isRowLevel()) {
                            log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.EnclosureFieldFound", (String[])new String[]{"" + pol})});
                        }
                    } else {
                        pol = line.substring(from, next);
                        if (log.isRowLevel()) {
                            log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.NormalFieldFound", (String[])new String[]{"" + pol})});
                        }
                    }
                    if (dencl) {
                        StringBuilder sbpol = new StringBuilder(pol);
                        int idx = sbpol.indexOf(enclosure + enclosure);
                        while (idx >= 0) {
                            sbpol.delete(idx, idx + enclosure.length());
                            idx = sbpol.indexOf(enclosure + enclosure);
                        }
                        pol = sbpol.toString();
                    }
                    if (contains_escaped_enclosures) {
                        String replace = escapeCharacter + enclosure;
                        String replaceWith = enclosure;
                        pol = Const.replace((String)pol, (String)replace, (String)replaceWith);
                    }
                    if (contains_escaped_separators) {
                        String replace = escapeCharacter + delimiter;
                        String replaceWith = delimiter;
                        pol = Const.replace((String)pol, (String)replace, (String)replaceWith);
                    }
                    if (contains_escaped_escape) {
                        String replace = escapeCharacter + escapeCharacter;
                        String replaceWith = escapeCharacter;
                        pol = Const.replace((String)pol, (String)replace, (String)replaceWith);
                    }
                    strings.add(pol);
                    pos = next + delimiter.length();
                }
                if (pos == length) {
                    if (log.isRowLevel()) {
                        log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.EndOfEmptyLineFound", (String[])new String[0])});
                    }
                    strings.add("");
                }
            } else {
                for (int i = 0; i < inf.inputFields.length; ++i) {
                    BaseFileField field = inf.inputFields[i];
                    int length = line.length();
                    if (field.getPosition() + field.getLength() <= length) {
                        strings.add(line.substring(field.getPosition(), field.getPosition() + field.getLength()));
                        continue;
                    }
                    if (field.getPosition() < length) {
                        strings.add(line.substring(field.getPosition()));
                        continue;
                    }
                    strings.add("");
                }
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TextFileInput.Log.Error.ErrorConvertingLine", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static final String getLine(LogChannelInterface log, BufferedInputStreamReader reader, int formatNr, StringBuilder line) throws KettleFileException {
        EncodingType type = EncodingType.guessEncodingType(reader.getEncoding());
        return TextFileInputUtils.getLine(log, reader, type, formatNr, line);
    }

    public static final String getLine(LogChannelInterface log, BufferedInputStreamReader reader, EncodingType encodingType, int fileFormatType, StringBuilder line, String regex) throws KettleFileException {
        return TextFileInputUtils.getLine((LogChannelInterface)log, (BufferedInputStreamReader)reader, (EncodingType)encodingType, (int)fileFormatType, (StringBuilder)line, (String)regex, (long)0L).line;
    }

    public static final String getLine(LogChannelInterface log, BufferedInputStreamReader reader, EncodingType encodingType, int fileFormatType, StringBuilder line, String regex, String escapeChar) throws KettleFileException {
        return TextFileInputUtils.getLine((LogChannelInterface)log, (BufferedInputStreamReader)reader, (EncodingType)encodingType, (int)fileFormatType, (StringBuilder)line, (String)regex, (String)escapeChar, (long)0L).line;
    }

    public static final TextFileLine getLine(LogChannelInterface log, BufferedInputStreamReader reader, EncodingType encodingType, int fileFormatType, StringBuilder line, String regex, long lineNumberInFile) throws KettleFileException {
        return TextFileInputUtils.getLine(log, reader, encodingType, fileFormatType, line, regex, "", lineNumberInFile);
    }

    public static final TextFileLine getLine(LogChannelInterface log, BufferedInputStreamReader reader, EncodingType encodingType, int fileFormatType, StringBuilder line, String regex, String escapeChar, long lineNumberInFile) throws KettleFileException {
        String sline = TextFileInputUtils.getLine(log, reader, encodingType, fileFormatType, line);
        boolean lenientEnclosureHandling = ValueMetaBase.convertStringToBoolean((String)Const.NVL((String)EnvUtil.getSystemProperty((String)"KETTLE_COMPATIBILITY_TEXT_FILE_INPUT_USE_LENIENT_ENCLOSURE_HANDLING"), (String)"N"));
        if (lenientEnclosureHandling || sline == null) {
            return new TextFileLine(sline, lineNumberInFile, null);
        }
        StringBuilder sb = new StringBuilder(sline);
        while (TextFileInputUtils.checkPattern(sb.toString(), regex, escapeChar) % 2 != 0) {
            sline = TextFileInputUtils.getLine(log, reader, encodingType, fileFormatType, line);
            if (sline == null) {
                return new TextFileLine(sline, lineNumberInFile, null);
            }
            sb.append("\n" + sline);
            ++lineNumberInFile;
        }
        return new TextFileLine(sb.toString(), lineNumberInFile, null);
    }

    public static final String getLine(LogChannelInterface log, BufferedInputStreamReader reader, EncodingType encodingType, int formatNr, StringBuilder line) throws KettleFileException {
        int c = 0;
        line.setLength(0);
        try {
            switch (formatNr) {
                case 0: {
                    while (c >= 0) {
                        c = reader.read();
                        if (encodingType.isReturn(c) || encodingType.isLinefeed(c)) {
                            c = reader.read();
                            if (!encodingType.isReturn(c) && !encodingType.isLinefeed(c)) {
                                throw new KettleFileException(BaseMessages.getString(PKG, (String)"TextFileInput.Log.SingleLineFound", (String[])new String[0]));
                            }
                            return line.toString();
                        }
                        if (c < 0) continue;
                        line.append((char)c);
                    }
                    break;
                }
                case 1: {
                    while (c >= 0) {
                        c = reader.read();
                        if (encodingType.isLinefeed(c) || encodingType.isReturn(c)) {
                            return line.toString();
                        }
                        if (c < 0) continue;
                        line.append((char)c);
                    }
                    break;
                }
                case 2: {
                    while (c >= 0) {
                        c = reader.read();
                        if (encodingType.isLinefeed(c)) {
                            return line.toString();
                        }
                        if (encodingType.isReturn(c)) {
                            if (!reader.markSupported()) continue;
                            reader.mark(1);
                            c = reader.read();
                            if (!encodingType.isLinefeed(c)) {
                                reader.reset();
                            }
                            return line.toString();
                        }
                        if (c < 0) continue;
                        line.append((char)c);
                    }
                    break;
                }
            }
        }
        catch (KettleFileException e) {
            throw e;
        }
        catch (Exception e) {
            if (line.length() == 0) {
                throw new KettleFileException(BaseMessages.getString(PKG, (String)"TextFileInput.Log.Error.ExceptionReadingLine", (String[])new String[]{e.toString()}), (Throwable)e);
            }
            return line.toString();
        }
        if (line.length() > 0) {
            return line.toString();
        }
        return null;
    }

    public static final Object[] convertLineToRow(LogChannelInterface log, TextFileLine textFileLine, TextFileInputMeta info, Object[] passThruFields, int nrPassThruFields, RowMetaInterface outputRowMeta, RowMetaInterface convertRowMeta, String fname, long rowNr, String delimiter, String enclosure, String escapeCharacter, FileErrorHandler errorHandler, BaseFileInputAdditionalField additionalOutputFields, String shortFilename, String path, boolean hidden, Date modificationDateTime, String uri, String rooturi, String extension, Long size) throws KettleException {
        return TextFileInputUtils.convertLineToRow(log, textFileLine, info, passThruFields, nrPassThruFields, outputRowMeta, convertRowMeta, fname, rowNr, delimiter, enclosure, escapeCharacter, errorHandler, additionalOutputFields, shortFilename, path, hidden, modificationDateTime, uri, rooturi, extension, size, true);
    }

    public static final Object[] convertLineToRow(LogChannelInterface log, TextFileLine textFileLine, TextFileInputMeta info, Object[] passThruFields, int nrPassThruFields, RowMetaInterface outputRowMeta, RowMetaInterface convertRowMeta, String fname, long rowNr, String delimiter, String enclosure, String escapeCharacter, FileErrorHandler errorHandler, BaseFileInputAdditionalField additionalOutputFields, String shortFilename, String path, boolean hidden, Date modificationDateTime, String uri, String rooturi, String extension, Long size, boolean failOnParseError) throws KettleException {
        if (textFileLine == null || textFileLine.line == null) {
            return null;
        }
        Object[] r = RowDataUtil.allocateRowData((int)outputRowMeta.size());
        int nrfields = info.inputFields.length;
        Long errorCount = null;
        if (info.errorHandling.errorIgnored && info.getErrorCountField() != null && info.getErrorCountField().length() > 0) {
            errorCount = new Long(0L);
        }
        String errorFields = null;
        if (info.errorHandling.errorIgnored && info.getErrorFieldsField() != null && info.getErrorFieldsField().length() > 0) {
            errorFields = "";
        }
        String errorText = null;
        if (info.errorHandling.errorIgnored && info.getErrorTextField() != null && info.getErrorTextField().length() > 0) {
            errorText = "";
        }
        try {
            int fieldnr;
            String[] strings = TextFileInputUtils.convertLineToStrings(log, textFileLine.line, info, delimiter, enclosure, escapeCharacter);
            int shiftFields = passThruFields == null ? 0 : nrPassThruFields;
            for (fieldnr = 0; fieldnr < nrfields; ++fieldnr) {
                Object value;
                block39: {
                    int trim_type;
                    BaseFileField f = info.inputFields[fieldnr];
                    int valuenr = shiftFields + fieldnr;
                    ValueMetaInterface valueMeta = outputRowMeta.getValueMeta(valuenr);
                    ValueMetaInterface convertMeta = convertRowMeta.getValueMeta(valuenr);
                    String nullif = fieldnr < nrfields ? f.getNullString() : "";
                    String ifnull = fieldnr < nrfields ? f.getIfNullValue() : "";
                    int n = trim_type = fieldnr < nrfields ? f.getTrimType() : 0;
                    if (fieldnr < strings.length) {
                        String pol = strings[fieldnr];
                        try {
                            if (valueMeta.isNull((Object)pol) || !Utils.isEmpty((CharSequence)nullif) && nullif.equals(pol)) {
                                pol = null;
                            }
                            value = valueMeta.convertDataFromString(pol, convertMeta, nullif, ifnull, trim_type);
                        }
                        catch (Exception e) {
                            if (failOnParseError) {
                                String message = BaseMessages.getString(PKG, (String)"TextFileInput.Log.CoundNotParseField", (String[])new String[]{valueMeta.toStringMeta(), "" + pol, valueMeta.getConversionMask(), "" + rowNr});
                                if (info.errorHandling.errorIgnored) {
                                    StringBuilder sb;
                                    log.logDetailed(fname, new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.Warning", (String[])new String[0]) + ": " + message + " : " + e.getMessage()});
                                    value = null;
                                    if (errorCount != null) {
                                        errorCount = new Long(errorCount + 1L);
                                    }
                                    if (errorFields != null) {
                                        sb = new StringBuilder(errorFields);
                                        if (sb.length() > 0) {
                                            sb.append("\t");
                                        }
                                        sb.append(valueMeta.getName());
                                        errorFields = sb.toString();
                                    }
                                    if (errorText != null) {
                                        sb = new StringBuilder(errorText);
                                        if (sb.length() > 0) {
                                            sb.append(Const.CR);
                                        }
                                        sb.append(message);
                                        errorText = sb.toString();
                                    }
                                    if (errorHandler != null) {
                                        errorHandler.handleLineError(textFileLine.lineNumber, "NO_PARTS");
                                    }
                                    if (info.isErrorLineSkipped()) {
                                        r = null;
                                    }
                                    break block39;
                                }
                                throw new KettleException(message, (Throwable)e);
                            }
                            value = pol;
                        }
                    } else {
                        value = null;
                    }
                }
                if (r == null) continue;
                r[valuenr] = value;
            }
            if (r != null) {
                if (fieldnr < nrfields) {
                    for (int i = fieldnr; i < info.inputFields.length; ++i) {
                        r[shiftFields + i] = null;
                    }
                }
                int index = shiftFields + nrfields;
                if (errorCount != null) {
                    r[index] = errorCount;
                    ++index;
                }
                if (errorFields != null) {
                    r[index] = errorFields;
                    ++index;
                }
                if (errorText != null) {
                    r[index] = errorText;
                    ++index;
                }
                if (info.content.includeFilename) {
                    r[index] = fname;
                    ++index;
                }
                if (info.content.includeRowNumber) {
                    r[index] = new Long(rowNr);
                    ++index;
                }
                if (additionalOutputFields.shortFilenameField != null) {
                    r[index] = shortFilename;
                    ++index;
                }
                if (additionalOutputFields.extensionField != null) {
                    r[index] = extension;
                    ++index;
                }
                if (additionalOutputFields.pathField != null) {
                    r[index] = path;
                    ++index;
                }
                if (additionalOutputFields.sizeField != null) {
                    r[index] = size;
                    ++index;
                }
                if (additionalOutputFields.hiddenField != null) {
                    r[index] = hidden;
                    ++index;
                }
                if (additionalOutputFields.lastModificationField != null) {
                    r[index] = modificationDateTime;
                    ++index;
                }
                if (additionalOutputFields.uriField != null) {
                    r[index] = uri;
                    ++index;
                }
                if (additionalOutputFields.rootUriField != null) {
                    r[index] = rooturi;
                    ++index;
                }
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TextFileInput.Log.Error.ErrorConvertingLineText", (String[])new String[0]), (Throwable)e);
        }
        if (r != null && passThruFields != null) {
            for (int i = 0; i < nrPassThruFields; ++i) {
                r[i] = passThruFields[i];
            }
        }
        return r;
    }

    public static final String[] convertLineToStrings(LogChannelInterface log, String line, TextFileInputMeta inf, String delimiter, String enclosure, String escapeCharacters) throws KettleException {
        String[] strings;
        block44: {
            strings = new String[inf.inputFields.length];
            try {
                if (line == null) {
                    return null;
                }
                if (inf.content.fileType.equalsIgnoreCase("CSV")) {
                    int len_esc;
                    int fieldnr = 0;
                    int pos = 0;
                    int length = line.length();
                    boolean dencl = false;
                    int len_encl = enclosure == null ? 0 : enclosure.length();
                    int n = len_esc = escapeCharacters == null ? 0 : escapeCharacters.length();
                    while (pos < length) {
                        String pol;
                        int next;
                        boolean encl_found;
                        int from = pos;
                        boolean contains_escaped_enclosures = false;
                        boolean contains_escaped_separators = false;
                        boolean contains_escaped_escape = false;
                        if (len_encl > 0 && line.substring(from, from + len_encl).equalsIgnoreCase(enclosure)) {
                            String strnext;
                            if (log.isRowLevel()) {
                                log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.Encloruse", (String[])new String[]{line.substring(from, from + len_encl)})});
                            }
                            encl_found = true;
                            int p = from + len_encl;
                            boolean is_enclosure = len_encl > 0 && p + len_encl < length && line.substring(p, p + len_encl).equalsIgnoreCase(enclosure);
                            boolean is_escape = len_esc > 0 && p + len_esc < length && line.substring(p, p + len_esc).equalsIgnoreCase(inf.content.escapeCharacter);
                            boolean enclosure_after = false;
                            if ((is_enclosure || is_escape) && p < length - 1) {
                                strnext = line.substring(p + len_encl, p + 2 * len_encl);
                                if (strnext.equalsIgnoreCase(enclosure)) {
                                    ++p;
                                    enclosure_after = true;
                                    dencl = true;
                                    if (is_escape) {
                                        contains_escaped_enclosures = true;
                                    }
                                } else if (strnext.equals(inf.content.escapeCharacter)) {
                                    ++p;
                                    if (is_escape) {
                                        contains_escaped_escape = true;
                                    }
                                }
                            }
                            while ((!is_enclosure || enclosure_after) && p < line.length()) {
                                enclosure_after = false;
                                is_enclosure = len_encl > 0 && ++p + len_encl < length && line.substring(p, p + len_encl).equals(enclosure);
                                boolean bl = is_escape = len_esc > 0 && p + len_esc < length && line.substring(p, p + len_esc).equals(inf.content.escapeCharacter);
                                if (!is_enclosure && !is_escape || p >= length - 1) continue;
                                strnext = line.substring(p + len_encl, p + 2 * len_encl);
                                if (strnext.equals(enclosure)) {
                                    ++p;
                                    enclosure_after = true;
                                    dencl = true;
                                    if (!is_escape) continue;
                                    contains_escaped_enclosures = true;
                                    continue;
                                }
                                if (!strnext.equals(inf.content.escapeCharacter)) continue;
                                ++p;
                                if (!is_escape) continue;
                                contains_escaped_escape = true;
                            }
                            next = p >= length ? p : p + len_encl;
                            if (log.isRowLevel()) {
                                log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.EndOfEnclosure", (String[])new String[]{"" + p})});
                            }
                        } else {
                            encl_found = false;
                            boolean found = false;
                            int startpoint = from;
                            do {
                                next = line.indexOf(delimiter, startpoint);
                                if (len_esc > 0 && next > 0) {
                                    String before = line.substring(next - len_esc, next);
                                    if (inf.content.escapeCharacter.equals(before)) {
                                        int previous_escapes = 1;
                                        int start = next - len_esc - 1;
                                        int end = next - 1;
                                        while (start >= 0 && inf.content.escapeCharacter.equals(line.substring(start, end))) {
                                            ++previous_escapes;
                                            --start;
                                            --end;
                                        }
                                        if (previous_escapes % 2 != 0) {
                                            startpoint = next + 1;
                                            contains_escaped_separators = true;
                                            continue;
                                        }
                                        found = true;
                                        continue;
                                    }
                                    found = true;
                                    continue;
                                }
                                found = true;
                            } while (!found && next >= 0);
                        }
                        if (next == -1) {
                            next = length;
                        }
                        if (encl_found && from + len_encl <= next - len_encl) {
                            pol = line.substring(from + len_encl, next - len_encl);
                            if (log.isRowLevel()) {
                                log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.EnclosureFieldFound", (String[])new String[]{"" + pol})});
                            }
                        } else {
                            pol = line.substring(from, next);
                            if (log.isRowLevel()) {
                                log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.NormalFieldFound", (String[])new String[]{"" + pol})});
                            }
                        }
                        if (dencl && Utils.isEmpty((CharSequence)inf.content.escapeCharacter)) {
                            StringBuilder sbpol = new StringBuilder(pol);
                            int idx = sbpol.indexOf(enclosure + enclosure);
                            while (idx >= 0) {
                                sbpol.delete(idx, idx + enclosure.length());
                                idx = sbpol.indexOf(enclosure + enclosure);
                            }
                            pol = sbpol.toString();
                        }
                        if (!Utils.isEmpty((CharSequence)inf.content.escapeCharacter) && inf.content.escapeCharacter.equals(enclosure) && (contains_escaped_escape || contains_escaped_enclosures)) {
                            String replace = inf.content.escapeCharacter + enclosure;
                            String replaceWith = enclosure;
                            pol = Const.replace((String)pol, (String)replace, (String)replaceWith);
                        } else {
                            if (contains_escaped_enclosures) {
                                String replace = inf.content.escapeCharacter + enclosure;
                                String replaceWith = enclosure;
                                pol = Const.replace((String)pol, (String)replace, (String)replaceWith);
                            }
                            boolean bl = contains_escaped_escape = !Utils.isEmpty((CharSequence)inf.content.escapeCharacter) && pol.contains(inf.content.escapeCharacter + inf.content.escapeCharacter);
                            if (contains_escaped_escape) {
                                String replace = inf.content.escapeCharacter + inf.content.escapeCharacter;
                                String replaceWith = inf.content.escapeCharacter;
                                pol = Const.replace((String)pol, (String)replace, (String)replaceWith);
                            }
                        }
                        if (contains_escaped_separators) {
                            String replace = inf.content.escapeCharacter + delimiter;
                            String replaceWith = delimiter;
                            pol = Const.replace((String)pol, (String)replace, (String)replaceWith);
                        }
                        try {
                            strings[fieldnr] = pol;
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            String[] newStrings = new String[strings.length];
                            for (int x = 0; x < strings.length; ++x) {
                                newStrings[x] = strings[x];
                            }
                            strings = newStrings;
                        }
                        pos = next + delimiter.length();
                        ++fieldnr;
                    }
                    if (pos == length) {
                        if (log.isRowLevel()) {
                            log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.EndOfEmptyLineFound", (String[])new String[0])});
                        }
                        if (fieldnr < strings.length) {
                            strings[fieldnr] = "";
                        }
                        ++fieldnr;
                    }
                    break block44;
                }
                boolean charBased = inf.content.length == null || inf.content.length.equalsIgnoreCase("Characters") || inf.getEncoding() == null;
                for (int i = 0; i < inf.inputFields.length; ++i) {
                    int length;
                    BaseFileField field = inf.inputFields[i];
                    int fPos = field.getPosition();
                    int fLength = field.getLength();
                    int fPl = fPos + fLength;
                    if (charBased) {
                        length = line.length();
                        if (fPl <= length) {
                            strings[i] = line.substring(fPos, fPl);
                            continue;
                        }
                        if (fPos < length) {
                            strings[i] = line.substring(fPos);
                            continue;
                        }
                        strings[i] = "";
                        continue;
                    }
                    byte[] b = null;
                    String enc = inf.getEncoding();
                    b = line.getBytes(enc);
                    length = b.length;
                    strings[i] = fPl <= length ? new String(Arrays.copyOfRange(b, fPos, fPl), enc) : (fPos < length ? new String(Arrays.copyOfRange(b, fPos, length - 1), enc) : "");
                }
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TextFileInput.Log.Error.ErrorConvertingLine", (String[])new String[]{e.toString()}), (Throwable)e);
            }
        }
        return strings;
    }

    public static int checkPattern(String text, String regexChar) {
        return TextFileInputUtils.checkPattern(text, regexChar, "");
    }

    public static int checkPattern(String text, String regexChar, String escapeCharacter) {
        int matches = 0;
        if (StringUtils.isBlank((String)text) || StringUtils.isBlank((String)regexChar)) {
            return matches;
        }
        String regex = (StringUtils.isEmpty((String)escapeCharacter) ? "" : "(?<!" + Pattern.quote(escapeCharacter) + ")") + Pattern.quote(regexChar);
        String textSanitized = StringUtils.isEmpty((String)escapeCharacter) ? text : text.replace(escapeCharacter + escapeCharacter, "");
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(textSanitized);
        while (matcher.find()) {
            ++matches;
        }
        return matches;
    }

    public static long skipLines(LogChannelInterface log, BufferedInputStreamReader reader, EncodingType encodingType, int fileFormatType, StringBuilder line, int nrLinesToSkip, String regex, long lineNumberInFile) throws KettleFileException {
        return TextFileInputUtils.skipLines(log, reader, encodingType, fileFormatType, line, nrLinesToSkip, regex, "", lineNumberInFile);
    }

    public static long skipLines(LogChannelInterface log, BufferedInputStreamReader reader, EncodingType encodingType, int fileFormatType, StringBuilder line, int nrLinesToSkip, String regex, String escapeChar, long lineNumberInFile) throws KettleFileException {
        TextFileLine textFileLine = TextFileInputUtils.getLine(log, reader, encodingType, fileFormatType, line, regex, escapeChar, lineNumberInFile);
        for (int skipped = 1; textFileLine.line != null && skipped < nrLinesToSkip; ++skipped) {
            textFileLine = TextFileInputUtils.getLine(log, reader, encodingType, fileFormatType, line, regex, escapeChar, textFileLine.lineNumber);
        }
        return textFileLine.lineNumber;
    }
}

