/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.file;

import com.google.common.annotations.VisibleForTesting;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.file.BaseFileMeta;

public abstract class BaseFileOutputMeta
extends BaseFileMeta {
    public static final String DEFAULT_DATE_FORMAT = "yyyMMdd";
    public static final String DEFAULT_TIME_FORMAT = "HHmmss";
    @Injection(name="INC_STEPNR_IN_FILENAME")
    protected boolean stepNrInFilename;
    @Injection(name="INC_PARTNR_IN_FILENAME")
    protected boolean partNrInFilename;
    @Injection(name="INC_DATE_IN_FILENAME")
    protected boolean dateInFilename;
    @Injection(name="INC_TIME_IN_FILENAME")
    protected boolean timeInFilename;
    @Injection(name="EXTENSION")
    protected String extension;
    @Injection(name="FILENAME")
    protected String fileName;
    @Injection(name="RUN_AS_COMMAND")
    private boolean fileAsCommand;
    @Injection(name="SPECIFY_DATE_FORMAT")
    private boolean specifyingFormat;
    @Injection(name="DATE_FORMAT")
    private String dateTimeFormat;
    @Injection(name="COMPRESSION")
    private String fileCompression;

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public abstract int getSplitEvery();

    public int getSplitEvery(VariableSpace space) {
        return this.getSplitEvery();
    }

    public abstract void setSplitEvery(int var1);

    public boolean isFileAsCommand() {
        return this.fileAsCommand;
    }

    public void setFileAsCommand(boolean fileAsCommand) {
        this.fileAsCommand = fileAsCommand;
    }

    public boolean isSpecifyingFormat() {
        return this.specifyingFormat;
    }

    public void setSpecifyingFormat(boolean specifyingFormat) {
        this.specifyingFormat = specifyingFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public boolean isTimeInFilename() {
        return this.timeInFilename;
    }

    public boolean isDateInFilename() {
        return this.dateInFilename;
    }

    public boolean isPartNrInFilename() {
        return this.partNrInFilename;
    }

    public boolean isStepNrInFilename() {
        return this.stepNrInFilename;
    }

    public String getFileCompression() {
        return this.fileCompression;
    }

    public void setFileCompression(String fileCompression) {
        this.fileCompression = fileCompression;
    }

    public String[] getFiles(VariableSpace space) {
        return this.getFiles(space, true);
    }

    private String[] getFiles(VariableSpace space, boolean showSamples) {
        String realFileName = space.environmentSubstitute(this.fileName);
        String realExtension = space.environmentSubstitute(this.extension);
        return this.getFiles(realFileName, realExtension, showSamples);
    }

    @VisibleForTesting
    String[] getFiles(String realFileName, String realExtension, boolean showSamples) {
        Date now = new Date();
        if (showSamples) {
            int nr;
            int copies = 1;
            int splits = 1;
            int parts = 1;
            if (this.isStepNrInFilename()) {
                copies = 3;
            }
            if (this.isPartNrInFilename()) {
                parts = 3;
            }
            if (this.getSplitEvery() != 0) {
                splits = 3;
            }
            if ((nr = copies * parts * splits) > 1) {
                ++nr;
            }
            String[] retval = new String[nr];
            int i = 0;
            for (int step = 0; step < copies; ++step) {
                for (int part = 0; part < parts; ++part) {
                    for (int split = 0; split < splits; ++split) {
                        retval[i] = this.buildFilename(realFileName, realExtension, step + "", this.getPartPrefix() + part, split + "", now, false, showSamples);
                        ++i;
                    }
                }
            }
            if (i < nr) {
                retval[i] = "...";
            }
            return retval;
        }
        return new String[]{this.buildFilename(realFileName, realExtension, "<step>", "<partition>", "<split>", now, false, showSamples)};
    }

    protected String getPartPrefix() {
        return "";
    }

    public String buildFilename(VariableSpace space, String stepnr, String partnr, String splitnr, boolean ziparchive) {
        return this.buildFilename(space, stepnr, partnr, splitnr, ziparchive, true);
    }

    public String buildFilename(VariableSpace space, String stepnr, String partnr, String splitnr, boolean ziparchive, boolean showSamples) {
        String realFileName = space.environmentSubstitute(this.fileName);
        String realExtension = space.environmentSubstitute(this.extension);
        return this.buildFilename(realFileName, realExtension, stepnr, partnr, splitnr, new Date(), ziparchive, showSamples);
    }

    private String buildFilename(String realFileName, String realExtension, String stepnr, String partnr, String splitnr, Date date, boolean ziparchive, boolean showSamples) {
        return this.buildFilename(realFileName, realExtension, stepnr, partnr, splitnr, date, ziparchive, showSamples, this);
    }

    protected String buildFilename(String realFileName, String realExtension, String stepnr, String partnr, String splitnr, Date date, boolean ziparchive, boolean showSamples, BaseFileOutputMeta meta) {
        return this.buildFilename(null, realFileName, realExtension, stepnr, partnr, splitnr, date, ziparchive, showSamples, meta);
    }

    protected String buildFilename(VariableSpace space, String realFileName, String realExtension, String stepnr, String partnr, String splitnr, Date date, boolean ziparchive, boolean showSamples, BaseFileOutputMeta meta) {
        Date now;
        SimpleDateFormat daf = new SimpleDateFormat();
        String retval = realFileName;
        if (meta.isFileAsCommand()) {
            return retval;
        }
        Date date2 = now = date == null ? new Date() : date;
        if (meta.isSpecifyingFormat() && !Utils.isEmpty((CharSequence)meta.getDateTimeFormat())) {
            daf.applyPattern(meta.getDateTimeFormat());
            String dt = daf.format(now);
            retval = retval + dt;
        } else {
            if (meta.isDateInFilename()) {
                if (showSamples) {
                    daf.applyPattern(DEFAULT_DATE_FORMAT);
                    String d = daf.format(now);
                    retval = retval + "_" + d;
                } else {
                    retval = retval + "_<yyyMMdd>";
                }
            }
            if (meta.isTimeInFilename()) {
                if (showSamples) {
                    daf.applyPattern(DEFAULT_TIME_FORMAT);
                    String t = daf.format(now);
                    retval = retval + "_" + t;
                } else {
                    retval = retval + "_<HHmmss>";
                }
            }
        }
        if (meta.isStepNrInFilename()) {
            retval = retval + "_" + stepnr;
        }
        if (meta.isPartNrInFilename()) {
            retval = retval + "_" + partnr;
        }
        if (meta.getSplitEvery(space) > 0) {
            retval = retval + "_" + splitnr;
        }
        if ("Zip".equals(meta.getFileCompression())) {
            if (ziparchive) {
                retval = retval + ".zip";
            } else if (realExtension != null && realExtension.length() != 0) {
                retval = retval + "." + realExtension;
            }
        } else {
            if (realExtension != null && realExtension.length() != 0) {
                retval = retval + "." + realExtension;
            }
            if ("GZip".equals(meta.getFileCompression())) {
                retval = retval + ".gz";
            }
        }
        return retval;
    }

    @Override
    public String[] getFilePaths(boolean showSamples) {
        TransMeta parentTransMeta;
        StepMeta parentStepMeta = this.getParentStepMeta();
        if (parentStepMeta != null && (parentTransMeta = parentStepMeta.getParentTransMeta()) != null) {
            return this.getFiles(parentTransMeta, showSamples);
        }
        return new String[0];
    }
}

