/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.csvinput;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleAttributeInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.common.CsvInputAwareMeta;
import org.pentaho.di.trans.steps.csvinput.CsvInput;
import org.pentaho.di.trans.steps.csvinput.CsvInputData;
import org.pentaho.di.trans.steps.textfileinput.InputFileMetaInterface;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class CsvInputMeta
extends BaseStepMeta
implements StepMetaInterface,
InputFileMetaInterface,
StepMetaInjectionInterface,
CsvInputAwareMeta {
    private static Class<?> PKG = CsvInput.class;
    private String filename;
    private String filenameField;
    private boolean includingFilename;
    private String rowNumField;
    private boolean headerPresent;
    private String delimiter;
    private String enclosure;
    private String bufferSize;
    private boolean lazyConversionActive;
    private TextFileInputField[] inputFields;
    private boolean isaddresult;
    private boolean runningInParallel;
    private String fileFormat;
    private String encoding;
    private boolean newlinePossibleInFields;

    public CsvInputMeta() {
        this.allocate(0);
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        CsvInputMeta retval = (CsvInputMeta)super.clone();
        retval.inputFields = new TextFileInputField[this.inputFields.length];
        for (int i = 0; i < this.inputFields.length; ++i) {
            retval.inputFields[i] = (TextFileInputField)this.inputFields[i].clone();
        }
        return retval;
    }

    @Override
    public void setDefault() {
        this.delimiter = ",";
        this.enclosure = "\"";
        this.headerPresent = true;
        this.lazyConversionActive = true;
        this.isaddresult = false;
        this.bufferSize = "50000";
        this.fileFormat = "mixed";
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.filename = XMLHandler.getTagValue((Node)stepnode, (String)this.getXmlCode("FILENAME"));
            this.filenameField = XMLHandler.getTagValue((Node)stepnode, (String)this.getXmlCode("FILENAME_FIELD"));
            this.rowNumField = XMLHandler.getTagValue((Node)stepnode, (String)this.getXmlCode("ROW_NUM_FIELD"));
            this.includingFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)this.getXmlCode("INCLUDE_FILENAME")));
            this.delimiter = XMLHandler.getTagValue((Node)stepnode, (String)this.getXmlCode("DELIMITER"));
            this.enclosure = XMLHandler.getTagValue((Node)stepnode, (String)this.getXmlCode("ENCLOSURE"));
            this.bufferSize = XMLHandler.getTagValue((Node)stepnode, (String)this.getXmlCode("BUFFERSIZE"));
            this.headerPresent = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)this.getXmlCode("HEADER_PRESENT")));
            this.lazyConversionActive = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)this.getXmlCode("LAZY_CONVERSION")));
            this.isaddresult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)this.getXmlCode("ADD_FILENAME_RESULT")));
            this.runningInParallel = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)this.getXmlCode("PARALLEL")));
            String nlp = XMLHandler.getTagValue((Node)stepnode, (String)this.getXmlCode("NEWLINE_POSSIBLE"));
            this.newlinePossibleInFields = Utils.isEmpty((CharSequence)nlp) ? !this.runningInParallel : "Y".equalsIgnoreCase(nlp);
            this.fileFormat = XMLHandler.getTagValue((Node)stepnode, (String)this.getXmlCode("FORMAT"));
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)this.getXmlCode("ENCODING"));
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)this.getXmlCode("FIELDS"));
            int nrfields = XMLHandler.countNodes((Node)fields, (String)this.getXmlCode("FIELD"));
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.inputFields[i] = new TextFileInputField();
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)this.getXmlCode("FIELD"), (int)i);
                this.inputFields[i].setName(XMLHandler.getTagValue((Node)fnode, (String)this.getXmlCode("FIELD_NAME")));
                this.inputFields[i].setType(ValueMetaFactory.getIdForValueMeta((String)XMLHandler.getTagValue((Node)fnode, (String)this.getXmlCode("FIELD_TYPE"))));
                this.inputFields[i].setFormat(XMLHandler.getTagValue((Node)fnode, (String)this.getXmlCode("FIELD_FORMAT")));
                this.inputFields[i].setCurrencySymbol(XMLHandler.getTagValue((Node)fnode, (String)this.getXmlCode("FIELD_CURRENCY")));
                this.inputFields[i].setDecimalSymbol(XMLHandler.getTagValue((Node)fnode, (String)this.getXmlCode("FIELD_DECIMAL")));
                this.inputFields[i].setGroupSymbol(XMLHandler.getTagValue((Node)fnode, (String)this.getXmlCode("FIELD_GROUP")));
                this.inputFields[i].setLength(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)this.getXmlCode("FIELD_LENGTH")), (int)-1));
                this.inputFields[i].setPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)this.getXmlCode("FIELD_PRECISION")), (int)-1));
                this.inputFields[i].setTrimType(ValueMetaString.getTrimTypeByCode((String)XMLHandler.getTagValue((Node)fnode, (String)this.getXmlCode("FIELD_TRIM_TYPE"))));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void allocate(int nrFields) {
        this.inputFields = new TextFileInputField[nrFields];
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(500);
        retval.append("    ").append(XMLHandler.addTagValue((String)this.getXmlCode("FILENAME"), (String)this.filename));
        retval.append("    ").append(XMLHandler.addTagValue((String)this.getXmlCode("FILENAME_FIELD"), (String)this.filenameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)this.getXmlCode("ROW_NUM_FIELD"), (String)this.rowNumField));
        retval.append("    ").append(XMLHandler.addTagValue((String)this.getXmlCode("INCLUDE_FILENAME"), (boolean)this.includingFilename));
        retval.append("    ").append(XMLHandler.addTagValue((String)this.getXmlCode("DELIMITER"), (String)this.delimiter));
        retval.append("    ").append(XMLHandler.addTagValue((String)this.getXmlCode("ENCLOSURE"), (String)this.enclosure));
        retval.append("    ").append(XMLHandler.addTagValue((String)this.getXmlCode("HEADER_PRESENT"), (boolean)this.headerPresent));
        retval.append("    ").append(XMLHandler.addTagValue((String)this.getXmlCode("BUFFERSIZE"), (String)this.bufferSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)this.getXmlCode("LAZY_CONVERSION"), (boolean)this.lazyConversionActive));
        retval.append("    ").append(XMLHandler.addTagValue((String)this.getXmlCode("ADD_FILENAME_RESULT"), (boolean)this.isaddresult));
        retval.append("    ").append(XMLHandler.addTagValue((String)this.getXmlCode("PARALLEL"), (boolean)this.runningInParallel));
        retval.append("    ").append(XMLHandler.addTagValue((String)this.getXmlCode("NEWLINE_POSSIBLE"), (boolean)this.newlinePossibleInFields));
        retval.append("    ").append(XMLHandler.addTagValue((String)this.getXmlCode("FORMAT"), (String)this.fileFormat));
        retval.append("    ").append(XMLHandler.addTagValue((String)this.getXmlCode("ENCODING"), (String)this.encoding));
        retval.append("    ").append(XMLHandler.openTag((String)this.getXmlCode("FIELDS"))).append(Const.CR);
        for (int i = 0; i < this.inputFields.length; ++i) {
            TextFileInputField field = this.inputFields[i];
            retval.append("      ").append(XMLHandler.openTag((String)this.getXmlCode("FIELD"))).append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)this.getXmlCode("FIELD_NAME"), (String)field.getName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)this.getXmlCode("FIELD_TYPE"), (String)ValueMetaFactory.getValueMetaName((int)field.getType())));
            retval.append("        ").append(XMLHandler.addTagValue((String)this.getXmlCode("FIELD_FORMAT"), (String)field.getFormat()));
            retval.append("        ").append(XMLHandler.addTagValue((String)this.getXmlCode("FIELD_CURRENCY"), (String)field.getCurrencySymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)this.getXmlCode("FIELD_DECIMAL"), (String)field.getDecimalSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)this.getXmlCode("FIELD_GROUP"), (String)field.getGroupSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)this.getXmlCode("FIELD_LENGTH"), (int)field.getLength()));
            retval.append("        ").append(XMLHandler.addTagValue((String)this.getXmlCode("FIELD_PRECISION"), (int)field.getPrecision()));
            retval.append("        ").append(XMLHandler.addTagValue((String)this.getXmlCode("FIELD_TRIM_TYPE"), (String)ValueMetaString.getTrimTypeCode((int)field.getTrimType())));
            retval.append("      ").append(XMLHandler.closeTag((String)this.getXmlCode("FIELD"))).append(Const.CR);
        }
        retval.append("    ").append(XMLHandler.closeTag((String)this.getXmlCode("FIELDS"))).append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.filename = rep.getStepAttributeString(id_step, this.getRepCode("FILENAME"));
            this.filenameField = rep.getStepAttributeString(id_step, this.getRepCode("FILENAME_FIELD"));
            this.rowNumField = rep.getStepAttributeString(id_step, this.getRepCode("ROW_NUM_FIELD"));
            this.includingFilename = rep.getStepAttributeBoolean(id_step, this.getRepCode("INCLUDE_FILENAME"));
            this.delimiter = rep.getStepAttributeString(id_step, this.getRepCode("DELIMITER"));
            this.enclosure = rep.getStepAttributeString(id_step, this.getRepCode("ENCLOSURE"));
            this.headerPresent = rep.getStepAttributeBoolean(id_step, this.getRepCode("HEADER_PRESENT"));
            this.bufferSize = rep.getStepAttributeString(id_step, this.getRepCode("BUFFERSIZE"));
            this.lazyConversionActive = rep.getStepAttributeBoolean(id_step, this.getRepCode("LAZY_CONVERSION"));
            this.isaddresult = rep.getStepAttributeBoolean(id_step, this.getRepCode("ADD_FILENAME_RESULT"));
            this.runningInParallel = rep.getStepAttributeBoolean(id_step, this.getRepCode("PARALLEL"));
            this.newlinePossibleInFields = rep.getStepAttributeBoolean(id_step, 0, this.getRepCode("NEWLINE_POSSIBLE"), !this.runningInParallel);
            this.fileFormat = rep.getStepAttributeString(id_step, this.getRepCode("FORMAT"));
            this.encoding = rep.getStepAttributeString(id_step, this.getRepCode("ENCODING"));
            int nrfields = rep.countNrStepAttributes(id_step, this.getRepCode("FIELD_NAME"));
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.inputFields[i] = new TextFileInputField();
                this.inputFields[i].setName(rep.getStepAttributeString(id_step, i, this.getRepCode("FIELD_NAME")));
                this.inputFields[i].setType(ValueMetaFactory.getIdForValueMeta((String)rep.getStepAttributeString(id_step, i, this.getRepCode("FIELD_TYPE"))));
                this.inputFields[i].setFormat(rep.getStepAttributeString(id_step, i, this.getRepCode("FIELD_FORMAT")));
                this.inputFields[i].setCurrencySymbol(rep.getStepAttributeString(id_step, i, this.getRepCode("FIELD_CURRENCY")));
                this.inputFields[i].setDecimalSymbol(rep.getStepAttributeString(id_step, i, this.getRepCode("FIELD_DECIMAL")));
                this.inputFields[i].setGroupSymbol(rep.getStepAttributeString(id_step, i, this.getRepCode("FIELD_GROUP")));
                this.inputFields[i].setLength((int)rep.getStepAttributeInteger(id_step, i, this.getRepCode("FIELD_LENGTH")));
                this.inputFields[i].setPrecision((int)rep.getStepAttributeInteger(id_step, i, this.getRepCode("FIELD_PRECISION")));
                this.inputFields[i].setTrimType(ValueMetaString.getTrimTypeByCode((String)rep.getStepAttributeString(id_step, i, this.getRepCode("FIELD_TRIM_TYPE"))));
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, this.getRepCode("FILENAME"), this.filename);
            rep.saveStepAttribute(id_transformation, id_step, this.getRepCode("FILENAME_FIELD"), this.filenameField);
            rep.saveStepAttribute(id_transformation, id_step, this.getRepCode("ROW_NUM_FIELD"), this.rowNumField);
            rep.saveStepAttribute(id_transformation, id_step, this.getRepCode("INCLUDE_FILENAME"), this.includingFilename);
            rep.saveStepAttribute(id_transformation, id_step, this.getRepCode("DELIMITER"), this.delimiter);
            rep.saveStepAttribute(id_transformation, id_step, this.getRepCode("ENCLOSURE"), this.enclosure);
            rep.saveStepAttribute(id_transformation, id_step, this.getRepCode("BUFFERSIZE"), this.bufferSize);
            rep.saveStepAttribute(id_transformation, id_step, this.getRepCode("HEADER_PRESENT"), this.headerPresent);
            rep.saveStepAttribute(id_transformation, id_step, this.getRepCode("LAZY_CONVERSION"), this.lazyConversionActive);
            rep.saveStepAttribute(id_transformation, id_step, this.getRepCode("ADD_FILENAME_RESULT"), this.isaddresult);
            rep.saveStepAttribute(id_transformation, id_step, this.getRepCode("PARALLEL"), this.runningInParallel);
            rep.saveStepAttribute(id_transformation, id_step, this.getRepCode("NEWLINE_POSSIBLE"), this.newlinePossibleInFields);
            rep.saveStepAttribute(id_transformation, id_step, this.getRepCode("FORMAT"), this.fileFormat);
            rep.saveStepAttribute(id_transformation, id_step, this.getRepCode("ENCODING"), this.encoding);
            for (int i = 0; i < this.inputFields.length; ++i) {
                TextFileInputField field = this.inputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("FIELD_NAME"), field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("FIELD_TYPE"), ValueMetaFactory.getValueMetaName((int)field.getType()));
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("FIELD_FORMAT"), field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("FIELD_CURRENCY"), field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("FIELD_DECIMAL"), field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("FIELD_GROUP"), field.getGroupSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("FIELD_LENGTH"), field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("FIELD_PRECISION"), field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("FIELD_TRIM_TYPE"), ValueMetaString.getTrimTypeCode((int)field.getTrimType()));
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        try {
            rowMeta.clear();
            for (int i = 0; i < this.inputFields.length; ++i) {
                TextFileInputField field = this.inputFields[i];
                ValueMetaInterface valueMeta = ValueMetaFactory.createValueMeta((String)field.getName(), (int)field.getType());
                valueMeta.setConversionMask(field.getFormat());
                valueMeta.setLength(field.getLength());
                valueMeta.setPrecision(field.getPrecision());
                valueMeta.setConversionMask(field.getFormat());
                valueMeta.setDecimalSymbol(field.getDecimalSymbol());
                valueMeta.setGroupingSymbol(field.getGroupSymbol());
                valueMeta.setCurrencySymbol(field.getCurrencySymbol());
                valueMeta.setTrimType(field.getTrimType());
                if (this.lazyConversionActive) {
                    valueMeta.setStorageType(1);
                }
                valueMeta.setStringEncoding(space.environmentSubstitute(this.encoding));
                ValueMetaInterface storageMetadata = ValueMetaFactory.cloneValueMeta((ValueMetaInterface)valueMeta, (int)2);
                storageMetadata.setStorageType(0);
                storageMetadata.setLength(-1, -1);
                valueMeta.setStorageMetadata(storageMetadata);
                valueMeta.setOrigin(origin);
                rowMeta.addValueMeta(valueMeta);
            }
            if (!Utils.isEmpty((CharSequence)this.filenameField) && this.includingFilename) {
                ValueMetaString filenameMeta = new ValueMetaString(this.filenameField);
                filenameMeta.setOrigin(origin);
                if (this.lazyConversionActive) {
                    filenameMeta.setStorageType(1);
                    filenameMeta.setStorageMetadata((ValueMetaInterface)new ValueMetaString(this.filenameField));
                }
                rowMeta.addValueMeta((ValueMetaInterface)filenameMeta);
            }
            if (!Utils.isEmpty((CharSequence)this.rowNumField)) {
                ValueMetaInteger rowNumMeta = new ValueMetaInteger(this.rowNumField);
                rowNumMeta.setLength(10);
                rowNumMeta.setOrigin(origin);
                rowMeta.addValueMeta((ValueMetaInterface)rowNumMeta);
            }
        }
        catch (Exception e) {
            throw new KettleStepException((Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"CsvInputMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"CsvInputMeta.CheckResult.StepRecevingData", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"CsvInputMeta.CheckResult.StepRecevingData2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"CsvInputMeta.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new CsvInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new CsvInputData();
    }

    @Override
    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(String bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isLazyConversionActive() {
        return this.lazyConversionActive;
    }

    public void setLazyConversionActive(boolean lazyConversionActive) {
        this.lazyConversionActive = lazyConversionActive;
    }

    public boolean isHeaderPresent() {
        return this.headerPresent;
    }

    public void setHeaderPresent(boolean headerPresent) {
        this.headerPresent = headerPresent;
    }

    @Override
    public String getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(TransMeta transMeta, StepMeta stepInfo) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        ResourceReference reference = new ResourceReference(stepInfo);
        references.add(reference);
        if (!Utils.isEmpty((CharSequence)this.filename)) {
            reference.getEntries().add(new ResourceEntry(transMeta.environmentSubstitute(this.filename), ResourceEntry.ResourceType.FILE));
        }
        return references;
    }

    @Override
    public TextFileInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(TextFileInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    @Override
    public int getFileFormatTypeNr() {
        if (this.getFileFormat().equalsIgnoreCase("DOS")) {
            return 0;
        }
        if (this.getFileFormat().equalsIgnoreCase("UNIX")) {
            return 1;
        }
        return 2;
    }

    @Override
    public String[] getFilePaths(VariableSpace space) {
        return new String[]{space.environmentSubstitute(this.filename)};
    }

    @Override
    public int getNrHeaderLines() {
        return 1;
    }

    @Override
    public boolean hasHeader() {
        return this.isHeaderPresent();
    }

    @Override
    public String getErrorCountField() {
        return null;
    }

    @Override
    public String getErrorFieldsField() {
        return null;
    }

    @Override
    public String getErrorTextField() {
        return null;
    }

    @Override
    public String getEscapeCharacter() {
        return null;
    }

    @Override
    public String getFileType() {
        return "CSV";
    }

    @Override
    public String getSeparator() {
        return this.delimiter;
    }

    @Override
    public boolean includeFilename() {
        return false;
    }

    @Override
    public boolean includeRowNumber() {
        return false;
    }

    @Override
    public boolean isErrorIgnored() {
        return false;
    }

    @Override
    public boolean isErrorLineSkipped() {
        return false;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public boolean isIncludingFilename() {
        return this.includingFilename;
    }

    public void setIncludingFilename(boolean includingFilename) {
        this.includingFilename = includingFilename;
    }

    public String getRowNumField() {
        return this.rowNumField;
    }

    public void setRowNumField(String rowNumField) {
        this.rowNumField = rowNumField;
    }

    public void setAddResultFile(boolean isaddresult) {
        this.isaddresult = isaddresult;
    }

    public boolean isAddResultFile() {
        return this.isaddresult;
    }

    public boolean isRunningInParallel() {
        return this.runningInParallel;
    }

    public void setRunningInParallel(boolean runningInParallel) {
        this.runningInParallel = runningInParallel;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            FileObject fileObject;
            if (Utils.isEmpty((CharSequence)this.filenameField) && !Utils.isEmpty((CharSequence)this.filename) && (fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.filename), (VariableSpace)space)).exists()) {
                this.filename = resourceNamingInterface.nameResource(fileObject, space, true);
                return this.filename;
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    @Override
    public StepMetaInjectionInterface getStepMetaInjectionInterface() {
        return this;
    }

    @Override
    public void injectStepMetadataEntries(List<StepInjectionMetaEntry> metadata) {
        for (StepInjectionMetaEntry entry : metadata) {
            KettleAttributeInterface attr = this.findAttribute(entry.getKey());
            if (entry.getValueType() != 0) {
                if (attr.getKey().equals("FILENAME")) {
                    this.filename = (String)entry.getValue();
                    continue;
                }
                if (attr.getKey().equals("FILENAME_FIELD")) {
                    this.filenameField = (String)entry.getValue();
                    continue;
                }
                if (attr.getKey().equals("ROW_NUM_FIELD")) {
                    this.rowNumField = (String)entry.getValue();
                    continue;
                }
                if (attr.getKey().equals("HEADER_PRESENT")) {
                    this.headerPresent = (Boolean)entry.getValue();
                    continue;
                }
                if (attr.getKey().equals("DELIMITER")) {
                    this.delimiter = (String)entry.getValue();
                    continue;
                }
                if (attr.getKey().equals("ENCLOSURE")) {
                    this.enclosure = (String)entry.getValue();
                    continue;
                }
                if (attr.getKey().equals("BUFFERSIZE")) {
                    this.bufferSize = (String)entry.getValue();
                    continue;
                }
                if (attr.getKey().equals("LAZY_CONVERSION")) {
                    this.lazyConversionActive = (Boolean)entry.getValue();
                    continue;
                }
                if (attr.getKey().equals("PARALLEL")) {
                    this.runningInParallel = (Boolean)entry.getValue();
                    continue;
                }
                if (attr.getKey().equals("NEWLINE_POSSIBLE")) {
                    this.newlinePossibleInFields = (Boolean)entry.getValue();
                    continue;
                }
                if (attr.getKey().equals("ADD_FILENAME_RESULT")) {
                    this.isaddresult = (Boolean)entry.getValue();
                    continue;
                }
                if (attr.getKey().equals("FORMAT")) {
                    this.fileFormat = (String)entry.getValue();
                    continue;
                }
                if (attr.getKey().equals("ENCODING")) {
                    this.encoding = (String)entry.getValue();
                    continue;
                }
                throw new RuntimeException("Unhandled metadata injection of attribute: " + attr.toString() + " - " + attr.getDescription());
            }
            if (!attr.getKey().equals("FIELDS")) continue;
            List<StepInjectionMetaEntry> inputFieldEntries = entry.getDetails();
            this.inputFields = new TextFileInputField[inputFieldEntries.size()];
            for (int row = 0; row < inputFieldEntries.size(); ++row) {
                StepInjectionMetaEntry inputFieldEntry = inputFieldEntries.get(row);
                TextFileInputField inputField = new TextFileInputField();
                List<StepInjectionMetaEntry> fieldAttributes = inputFieldEntry.getDetails();
                for (int i = 0; i < fieldAttributes.size(); ++i) {
                    StepInjectionMetaEntry fieldAttribute = fieldAttributes.get(i);
                    KettleAttributeInterface fieldAttr = this.findAttribute(fieldAttribute.getKey());
                    String attributeValue = (String)fieldAttribute.getValue();
                    if (fieldAttr.getKey().equals("FIELD_NAME")) {
                        inputField.setName(attributeValue);
                        continue;
                    }
                    if (fieldAttr.getKey().equals("FIELD_TYPE")) {
                        inputField.setType(ValueMetaFactory.getIdForValueMeta((String)attributeValue));
                        continue;
                    }
                    if (fieldAttr.getKey().equals("FIELD_FORMAT")) {
                        inputField.setFormat(attributeValue);
                        continue;
                    }
                    if (fieldAttr.getKey().equals("FIELD_LENGTH")) {
                        inputField.setLength(attributeValue == null ? -1 : Integer.parseInt(attributeValue));
                        continue;
                    }
                    if (fieldAttr.getKey().equals("FIELD_PRECISION")) {
                        inputField.setPrecision(attributeValue == null ? -1 : Integer.parseInt(attributeValue));
                        continue;
                    }
                    if (fieldAttr.getKey().equals("FIELD_CURRENCY")) {
                        inputField.setCurrencySymbol(attributeValue);
                        continue;
                    }
                    if (fieldAttr.getKey().equals("FIELD_DECIMAL")) {
                        inputField.setDecimalSymbol(attributeValue);
                        continue;
                    }
                    if (fieldAttr.getKey().equals("FIELD_GROUP")) {
                        inputField.setGroupSymbol(attributeValue);
                        continue;
                    }
                    if (fieldAttr.getKey().equals("FIELD_TRIM_TYPE")) {
                        inputField.setTrimType(ValueMetaString.getTrimTypeByCode((String)attributeValue));
                        continue;
                    }
                    throw new RuntimeException("Unhandled metadata injection of attribute: " + fieldAttr.toString() + " - " + fieldAttr.getDescription());
                }
                this.inputFields[row] = inputField;
            }
        }
    }

    @Override
    public List<StepInjectionMetaEntry> extractStepMetadataEntries() throws KettleException {
        return null;
    }

    @Override
    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries() throws KettleException {
        return this.getStepInjectionMetadataEntries(PKG);
    }

    public boolean isNewlinePossibleInFields() {
        return this.newlinePossibleInFields;
    }

    public void setNewlinePossibleInFields(boolean newlinePossibleInFields) {
        this.newlinePossibleInFields = newlinePossibleInFields;
    }

    @Override
    public FileObject getHeaderFileObject(TransMeta transMeta) {
        String filename = transMeta.environmentSubstitute(this.getFilename());
        try {
            return KettleVFS.getFileObject((String)filename);
        }
        catch (KettleFileException e) {
            return null;
        }
    }
}

