/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr.delegates.metastore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.repository.LongObjectId;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryMetaStoreDelegate;
import org.pentaho.di.repository.kdr.delegates.metastore.KDBRMetaStoreAttribute;
import org.pentaho.di.repository.kdr.delegates.metastore.KDBRMetaStoreElement;
import org.pentaho.di.repository.kdr.delegates.metastore.KDBRMetaStoreElementType;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.IMetaStoreAttribute;
import org.pentaho.metastore.api.IMetaStoreElement;
import org.pentaho.metastore.api.IMetaStoreElementType;
import org.pentaho.metastore.api.exceptions.MetaStoreDependenciesExistsException;
import org.pentaho.metastore.api.exceptions.MetaStoreElementExistException;
import org.pentaho.metastore.api.exceptions.MetaStoreElementTypeExistsException;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.api.exceptions.MetaStoreNamespaceExistsException;
import org.pentaho.metastore.api.security.IMetaStoreElementOwner;
import org.pentaho.metastore.api.security.MetaStoreElementOwnerType;
import org.pentaho.metastore.stores.memory.MemoryMetaStore;
import org.pentaho.metastore.stores.memory.MemoryMetaStoreElementOwner;

public class KettleDatabaseRepositoryMetaStore
extends MemoryMetaStore
implements IMetaStore {
    protected KettleDatabaseRepository repository;
    private KettleDatabaseRepositoryMetaStoreDelegate delegate;

    public KettleDatabaseRepositoryMetaStore(KettleDatabaseRepository repository) {
        this.repository = repository;
        this.delegate = repository.metaStoreDelegate;
    }

    public List<String> getNamespaces() throws MetaStoreException {
        try {
            ArrayList<String> namespaces = new ArrayList<String>();
            Collection<RowMetaAndData> namespaceRows = this.delegate.getNamespaces();
            for (RowMetaAndData namespaceRow : namespaceRows) {
                String namespace = namespaceRow.getString("NAME", null);
                if (Utils.isEmpty((CharSequence)namespace)) continue;
                namespaces.add(namespace);
            }
            return namespaces;
        }
        catch (Exception e) {
            throw new MetaStoreException((Throwable)e);
        }
    }

    public void createNamespace(String namespace) throws MetaStoreException, MetaStoreNamespaceExistsException {
        try {
            LongObjectId namespaceId = this.delegate.getNamespaceId(namespace);
            if (namespaceId != null) {
                throw new MetaStoreNamespaceExistsException("Namespace with name '" + namespace + "' already exists");
            }
            this.delegate.insertNamespace(namespace);
            this.repository.commit();
        }
        catch (Exception e) {
            this.repository.rollback();
            throw new MetaStoreException((Throwable)e);
        }
    }

    public void deleteNamespace(String namespace) throws MetaStoreException, MetaStoreDependenciesExistsException {
        try {
            ObjectId namespaceId = this.delegate.verifyNamespace(namespace);
            List<IMetaStoreElementType> elementTypes = this.getElementTypes(namespace);
            if (!elementTypes.isEmpty()) {
                ArrayList<String> dependencies = new ArrayList<String>();
                for (IMetaStoreElementType elementType : elementTypes) {
                    dependencies.add(elementType.getId());
                }
                throw new MetaStoreDependenciesExistsException(dependencies, "The namespace to delete, '" + namespace + "' is not empty");
            }
            this.delegate.deleteNamespace(namespaceId);
            this.repository.commit();
        }
        catch (MetaStoreDependenciesExistsException e) {
            throw e;
        }
        catch (MetaStoreException e) {
            this.repository.rollback();
            throw e;
        }
        catch (Exception e) {
            this.repository.rollback();
            throw new MetaStoreException("Unable to delete namespace '" + namespace + "'", (Throwable)e);
        }
    }

    public boolean namespaceExists(String namespace) throws MetaStoreException {
        try {
            return this.delegate.getNamespaceId(namespace) != null;
        }
        catch (Exception e) {
            throw new MetaStoreException("Unable to verify if namespace '" + namespace + "' exists.", (Throwable)e);
        }
    }

    public void createElementType(String namespace, IMetaStoreElementType elementType) throws MetaStoreException, MetaStoreElementTypeExistsException {
        try {
            ObjectId namespaceId = this.delegate.verifyNamespace(namespace);
            IMetaStoreElementType existingType = this.getElementTypeByName(namespace, elementType.getName());
            if (existingType != null) {
                throw new MetaStoreElementTypeExistsException(Arrays.asList(existingType), "Can not create element type with id '" + elementType.getId() + "' because it already exists");
            }
            KDBRMetaStoreElementType newElementType = new KDBRMetaStoreElementType(this.delegate, namespace, namespaceId, elementType.getName(), elementType.getDescription());
            newElementType.save();
            elementType.setId(newElementType.getId());
            this.repository.commit();
        }
        catch (MetaStoreElementTypeExistsException e) {
            throw e;
        }
        catch (MetaStoreException e) {
            this.repository.rollback();
            throw e;
        }
        catch (Exception e) {
            this.repository.rollback();
            throw new MetaStoreException((Throwable)e);
        }
    }

    public List<IMetaStoreElementType> getElementTypes(String namespace) throws MetaStoreException {
        try {
            LongObjectId namespaceId = this.delegate.getNamespaceId(namespace);
            if (namespaceId == null) {
                return new ArrayList<IMetaStoreElementType>();
            }
            Collection<RowMetaAndData> elementTypeRows = this.delegate.getElementTypes(namespaceId);
            ArrayList<IMetaStoreElementType> list = new ArrayList<IMetaStoreElementType>();
            for (RowMetaAndData elementTypeRow : elementTypeRows) {
                KDBRMetaStoreElementType elementType = this.delegate.parseElementType(namespace, (ObjectId)namespaceId, elementTypeRow);
                list.add(elementType);
            }
            return list;
        }
        catch (Exception e) {
            throw new MetaStoreException("Unable to get list of element types for namespace '" + namespace + "'", (Throwable)e);
        }
    }

    public List<String> getElementTypeIds(String namespace) throws MetaStoreException {
        List<IMetaStoreElementType> elementTypes = this.getElementTypes(namespace);
        ArrayList<String> ids = new ArrayList<String>();
        for (IMetaStoreElementType elementType : elementTypes) {
            ids.add(elementType.getId());
        }
        return ids;
    }

    public IMetaStoreElementType getElementType(String namespace, String elementTypeId) throws MetaStoreException {
        try {
            LongObjectId namespaceId = this.delegate.getNamespaceId(namespace);
            if (namespaceId == null) {
                return null;
            }
            RowMetaAndData elementTypeRow = this.delegate.getElementType(new LongObjectId((ObjectId)new StringObjectId(elementTypeId)));
            return this.delegate.parseElementType(namespace, (ObjectId)namespaceId, elementTypeRow);
        }
        catch (Exception e) {
            throw new MetaStoreException("Unable to get element type with id '" + elementTypeId + "' in namespace '" + namespace + "'", (Throwable)e);
        }
    }

    public IMetaStoreElementType getElementTypeByName(String namespace, String elementTypeName) throws MetaStoreException {
        try {
            LongObjectId namespaceId = this.delegate.getNamespaceId(namespace);
            if (namespaceId == null) {
                return null;
            }
            LongObjectId elementTypeId = this.delegate.getElementTypeId(namespaceId, elementTypeName);
            if (elementTypeId == null) {
                return null;
            }
            RowMetaAndData elementTypeRow = this.delegate.getElementType(elementTypeId);
            return this.delegate.parseElementType(namespace, (ObjectId)namespaceId, elementTypeRow);
        }
        catch (Exception e) {
            throw new MetaStoreException("Unable to get element type with name '" + elementTypeName + "' in namespace '" + namespace + "'", (Throwable)e);
        }
    }

    public void updateElementType(String namespace, IMetaStoreElementType elementType) throws MetaStoreException {
        try {
            IMetaStoreElementType type;
            ObjectId namespaceId = this.delegate.verifyNamespace(namespace);
            String elementTypeId = elementType.getId();
            if (elementTypeId == null && (type = this.getElementTypeByName(namespace, elementType.getName())) != null) {
                elementTypeId = type.getId();
            }
            if (elementTypeId == null) {
                throw new MetaStoreException("Unable to update element type: no id was provided and the name '" + elementType.getName() + "' didn't match");
            }
            this.delegate.updateElementType(namespaceId, (ObjectId)new LongObjectId((ObjectId)new StringObjectId(elementType.getId())), elementType);
            this.repository.commit();
        }
        catch (MetaStoreException e) {
            throw e;
        }
        catch (Exception e) {
            this.repository.rollback();
            throw new MetaStoreException("Unable to update element type", (Throwable)e);
        }
    }

    public void deleteElementType(String namespace, IMetaStoreElementType elementType) throws MetaStoreException, MetaStoreDependenciesExistsException {
        try {
            Collection<RowMetaAndData> elementTypeRows = this.delegate.getElements(new LongObjectId((ObjectId)new StringObjectId(elementType.getId())));
            if (!elementTypeRows.isEmpty()) {
                ArrayList<String> dependencies = new ArrayList<String>();
                for (RowMetaAndData elementTypeRow : elementTypeRows) {
                    Long elementTypeId = elementTypeRow.getInteger("ID_ELEMENT_TYPE");
                    dependencies.add(Long.toString(elementTypeId));
                }
                throw new MetaStoreDependenciesExistsException(dependencies, "The namespace to delete, '" + namespace + "' is not empty");
            }
            this.delegate.deleteElementType((ObjectId)new LongObjectId((ObjectId)new StringObjectId(elementType.getId())));
            this.repository.commit();
        }
        catch (MetaStoreDependenciesExistsException e) {
            throw e;
        }
        catch (Exception e) {
            this.repository.rollback();
            throw new MetaStoreException((Throwable)e);
        }
    }

    public List<IMetaStoreElement> getElements(String namespace, IMetaStoreElementType elementType) throws MetaStoreException {
        try {
            IMetaStoreElementType type = this.getElementTypeByName(namespace, elementType.getName());
            if (type == null) {
                return new ArrayList<IMetaStoreElement>();
            }
            Collection<RowMetaAndData> elementRows = this.delegate.getElements(new LongObjectId((ObjectId)new StringObjectId(type.getId())));
            ArrayList<IMetaStoreElement> elements = new ArrayList<IMetaStoreElement>();
            for (RowMetaAndData elementRow : elementRows) {
                KDBRMetaStoreElement element = this.delegate.parseElement(elementType, elementRow);
                elements.add(element);
            }
            return elements;
        }
        catch (Exception e) {
            throw new MetaStoreException("Unable to get list of elements from namespace '" + namespace + "' and for element type '" + elementType.getName() + "'", (Throwable)e);
        }
    }

    public List<String> getElementIds(String namespace, IMetaStoreElementType elementType) throws MetaStoreException {
        ArrayList<String> ids = new ArrayList<String>();
        List<IMetaStoreElement> elements = this.getElements(namespace, elementType);
        for (IMetaStoreElement element : elements) {
            ids.add(element.getId());
        }
        return ids;
    }

    public IMetaStoreElement getElement(String namespace, IMetaStoreElementType elementType, String elementId) throws MetaStoreException {
        try {
            RowMetaAndData elementRow = this.delegate.getElement(new LongObjectId((ObjectId)new StringObjectId(elementId)));
            if (elementRow == null) {
                return null;
            }
            return this.delegate.parseElement(elementType, elementRow);
        }
        catch (Exception e) {
            throw new MetaStoreException("Unable to get element", (Throwable)e);
        }
    }

    public IMetaStoreElement getElementByName(String namespace, IMetaStoreElementType elementType, String name) throws MetaStoreException {
        try {
            LongObjectId namespaceId = this.delegate.getNamespaceId(namespace);
            if (namespaceId == null) {
                return null;
            }
            LongObjectId elementTypeId = this.delegate.getElementTypeId(namespaceId, elementType.getName());
            if (elementTypeId == null) {
                return null;
            }
            LongObjectId elementId = this.delegate.getElementId(elementTypeId, name);
            if (elementId == null) {
                return null;
            }
            RowMetaAndData elementRow = this.delegate.getElement(elementId);
            if (elementRow == null) {
                return null;
            }
            return this.delegate.parseElement(elementType, elementRow);
        }
        catch (Exception e) {
            throw new MetaStoreException("Unable to get element by name '" + name + "' from namespace '" + namespace + "'", (Throwable)e);
        }
    }

    public void createElement(String namespace, IMetaStoreElementType elementType, IMetaStoreElement element) throws MetaStoreException, MetaStoreElementExistException {
        try {
            IMetaStoreElement found = this.getElementByName(namespace, elementType, element.getName());
            if (found != null) {
                throw new MetaStoreElementExistException(Arrays.asList(found), "The element with name '" + element.getName() + "' already exists");
            }
            this.delegate.insertElement(elementType, element);
            this.repository.commit();
        }
        catch (MetaStoreElementExistException e) {
            throw e;
        }
        catch (Exception e) {
            this.repository.rollback();
            throw new MetaStoreException("Unable to create element with name '" + element.getName() + "' of type '" + elementType.getName() + "'", (Throwable)e);
        }
    }

    public void deleteElement(String namespace, IMetaStoreElementType elementType, String elementId) throws MetaStoreException {
        try {
            IMetaStoreElementType type = this.getElementTypeByName(namespace, elementType.getName());
            if (type == null) {
                throw new MetaStoreException("Unable to find element type with name '" + elementType.getName() + "'");
            }
            this.delegate.deleteElement((ObjectId)new LongObjectId((ObjectId)new StringObjectId(elementId)));
            this.repository.commit();
        }
        catch (Exception e) {
            this.repository.rollback();
            throw new MetaStoreException("Unable to delete element with id '" + elementId + "' of type '" + elementType.getName() + "'", (Throwable)e);
        }
    }

    public void updateElement(String namespace, IMetaStoreElementType elementType, String elementId, IMetaStoreElement element) throws MetaStoreException {
        try {
            this.deleteElement(namespace, elementType, elementId);
            this.createElement(namespace, elementType, element);
            this.repository.commit();
        }
        catch (Exception e) {
            this.repository.rollback();
            throw new MetaStoreException("Unable to update element with id '" + elementId + "' called '" + element.getName() + "' in type '" + elementType.getName() + "'", (Throwable)e);
        }
    }

    public IMetaStoreElementType newElementType(String namespace) throws MetaStoreException {
        return new KDBRMetaStoreElementType(this.delegate, namespace, null, null, null);
    }

    public IMetaStoreElement newElement() throws MetaStoreException {
        return new KDBRMetaStoreElement();
    }

    public IMetaStoreElement newElement(IMetaStoreElementType elementType, String id, Object value) throws MetaStoreException {
        return new KDBRMetaStoreElement(this.delegate, elementType, id, value);
    }

    public IMetaStoreAttribute newAttribute(String id, Object value) throws MetaStoreException {
        return new KDBRMetaStoreAttribute(this.delegate, id, value);
    }

    public IMetaStoreElementOwner newElementOwner(String name, MetaStoreElementOwnerType ownerType) throws MetaStoreException {
        return new MemoryMetaStoreElementOwner(name, ownerType);
    }

    public String getName() {
        return this.repository.getName();
    }

    public String getDescription() {
        return this.repository.getRepositoryMeta().getDescription();
    }
}

