/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr.delegates;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.missing.MissingEntry;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.LongObjectId;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryBaseDelegate;
import org.pentaho.di.repository.kdr.delegates.metastore.KettleDatabaseRepositoryMetaStore;

public class KettleDatabaseRepositoryJobEntryDelegate
extends KettleDatabaseRepositoryBaseDelegate {
    public static final String JOBENTRY_ATTRIBUTE_PREFIX = "_ATTR_\t";

    public KettleDatabaseRepositoryJobEntryDelegate(KettleDatabaseRepository repository) {
        super(repository);
    }

    public RowMetaAndData getJobEntry(ObjectId id_jobentry) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_JOBENTRY"), this.quote("ID_JOBENTRY"), id_jobentry);
    }

    public RowMetaAndData getJobEntryCopy(ObjectId id_jobentry_copy) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_JOBENTRY_COPY"), this.quote("ID_JOBENTRY_COPY"), id_jobentry_copy);
    }

    public RowMetaAndData getJobEntryType(ObjectId id_jobentry_type) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_JOBENTRY_TYPE"), this.quote("ID_JOBENTRY_TYPE"), id_jobentry_type);
    }

    public synchronized ObjectId getJobEntryID(String name, ObjectId id_job) throws KettleException {
        return this.repository.connectionDelegate.getIDWithValue(this.quoteTable("R_JOBENTRY"), this.quote("ID_JOBENTRY"), this.quote("NAME"), name, this.quote("ID_JOB"), id_job);
    }

    public synchronized ObjectId getJobEntryTypeID(String code) throws KettleException {
        return this.repository.connectionDelegate.getIDWithValue(this.quoteTable("R_JOBENTRY_TYPE"), this.quote("ID_JOBENTRY_TYPE"), this.quote("CODE"), code);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JobEntryCopy loadJobEntryCopy(ObjectId jobId, ObjectId jobEntryCopyId, List<JobEntryInterface> jobentries, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, String jobname) throws KettleException {
        JobEntryCopy jobEntryCopy = new JobEntryCopy();
        try {
            jobEntryCopy.setObjectId(jobEntryCopyId);
            RowMetaAndData r = this.getJobEntryCopy(jobEntryCopyId);
            if (r == null) throw new KettleException("Unable to find job entry copy in repository with id_jobentry_copy=" + jobEntryCopyId);
            LongObjectId jobEntryId = new LongObjectId(r.getInteger("ID_JOBENTRY", 0L));
            LongObjectId jobEntryTypeId = new LongObjectId(r.getInteger("ID_JOBENTRY_TYPE", 0L));
            jobEntryCopy.setNr((int)r.getInteger("NR", 0L));
            int locx = (int)r.getInteger("GUI_LOCATION_X", 0L);
            int locy = (int)r.getInteger("GUI_LOCATION_Y", 0L);
            boolean isdrawn = r.getBoolean("GUI_DRAW", false);
            boolean isparallel = r.getBoolean("PARALLEL", false);
            jobEntryCopy.setEntry(JobMeta.findJobEntry(jobentries, (ObjectId)jobEntryId));
            if (jobEntryCopy.getEntry() == null) {
                RowMetaAndData rt = this.getJobEntryType((ObjectId)new LongObjectId((ObjectId)jobEntryTypeId));
                if (rt == null) throw new KettleException("Unable to find Job Entry Type with id=" + jobEntryTypeId + " in the repository");
                String jet_code = rt.getString("CODE", null);
                JobEntryInterface jobEntry = null;
                PluginRegistry registry = PluginRegistry.getInstance();
                PluginInterface jobPlugin = registry.findPluginWithId(JobEntryPluginType.class, jet_code);
                jobEntry = jobPlugin == null ? new MissingEntry(jobname, jet_code) : (JobEntryInterface)registry.loadClass(jobPlugin);
                if (jobEntry == null) throw new KettleException("JobEntryLoader was unable to find Job Entry Plugin with description [" + jet_code + "].");
                jobEntryCopy.setEntry(jobEntry);
                if (jobEntry instanceof JobEntryBase) {
                    this.loadJobEntryBase((JobEntryBase)((Object)jobEntry), (ObjectId)jobEntryId, databases, slaveServers);
                    ((JobEntryBase)((Object)jobEntry)).setAttributesMap(this.loadJobEntryAttributesMap(jobId, jobEntryId));
                }
                this.compatibleJobEntryLoadRep(jobEntry, this.repository, (ObjectId)jobEntryTypeId, databases, slaveServers);
                jobEntry.loadRep(this.repository, this.repository.metaStore, (ObjectId)jobEntryId, databases, slaveServers);
                jobEntryCopy.getEntry().setObjectId((ObjectId)jobEntryId);
                jobentries.add(jobEntryCopy.getEntry());
            }
            jobEntryCopy.setLocation(locx, locy);
            jobEntryCopy.setDrawn(isdrawn);
            jobEntryCopy.setLaunchingInParallel(isparallel);
            return jobEntryCopy;
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry copy from repository with id_jobentry_copy=" + jobEntryCopyId, (Throwable)dbe);
        }
    }

    private void compatibleJobEntryLoadRep(JobEntryInterface jobEntry, KettleDatabaseRepository repository, ObjectId id_jobentry_type, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        jobEntry.loadRep(repository, id_jobentry_type, databases, slaveServers);
    }

    public void saveJobEntryCopy(JobEntryCopy copy, ObjectId id_job, KettleDatabaseRepositoryMetaStore metaStore) throws KettleException {
        try {
            ObjectId id_jobentry_type;
            JobEntryInterface entry = copy.getEntry();
            ObjectId id_jobentry = this.getJobEntryID(copy.getName(), id_job);
            if (id_jobentry == null) {
                this.insertJobEntry(id_job, (JobEntryBase)((Object)entry));
                entry.saveRep(this.repository, metaStore, id_job);
                this.compatibleEntrySaveRep(entry, this.repository, id_job);
                if (entry instanceof JobEntryBase) {
                    this.saveAttributesMap(id_job, copy.getObjectId(), ((JobEntryBase)((Object)entry)).getAttributesMap());
                }
                id_jobentry = entry.getObjectId();
            }
            if ((id_jobentry_type = this.getJobEntryTypeID(entry.getPluginId())) == null) {
                this.repository.updateJobEntryTypes();
                id_jobentry_type = this.getJobEntryTypeID(entry.getPluginId());
            }
            copy.setObjectId(this.insertJobEntryCopy(id_job, id_jobentry, id_jobentry_type, copy.getNr(), copy.getLocation().x, copy.getLocation().y, copy.isDrawn(), copy.isLaunchingInParallel()));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry copy to the repository, id_job=" + id_job, (Throwable)dbe);
        }
    }

    private void compatibleEntrySaveRep(JobEntryInterface entry, Repository repository, ObjectId id_job) throws KettleException {
        entry.saveRep(repository, id_job);
    }

    public synchronized ObjectId insertJobEntry(ObjectId id_job, JobEntryBase jobEntryBase) throws KettleException {
        ObjectId id = this.repository.connectionDelegate.getNextJobEntryID();
        ObjectId id_jobentry_type = this.getJobEntryTypeID(jobEntryBase.getPluginId());
        this.log.logDebug("ID_JobEntry_type = " + id_jobentry_type + " for type = [" + jobEntryBase.getPluginId() + "]");
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_JOBENTRY"), (Object)id);
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_JOB"), (Object)id_job);
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_JOBENTRY_TYPE"), (Object)id_jobentry_type);
        table.addValue((ValueMetaInterface)new ValueMetaString("NAME"), (Object)jobEntryBase.getName());
        table.addValue((ValueMetaInterface)new ValueMetaString("DESCRIPTION"), (Object)jobEntryBase.getDescription());
        this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), "R_JOBENTRY");
        this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
        this.repository.connectionDelegate.getDatabase().insertRow();
        this.repository.connectionDelegate.getDatabase().closeInsert();
        jobEntryBase.setObjectId(id);
        return id;
    }

    public synchronized ObjectId insertJobEntryCopy(ObjectId id_job, ObjectId id_jobentry, ObjectId id_jobentry_type, int nr, long gui_location_x, long gui_location_y, boolean gui_draw, boolean parallel) throws KettleException {
        LongObjectId id = this.repository.connectionDelegate.getNextJobEntryCopyID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_JOBENTRY_COPY"), (Object)id);
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_JOBENTRY"), (Object)id_jobentry);
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_JOB"), (Object)id_job);
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_JOBENTRY_TYPE"), (Object)id_jobentry_type);
        table.addValue((ValueMetaInterface)new ValueMetaInteger("NR"), (Object)new Long(nr));
        table.addValue((ValueMetaInterface)new ValueMetaInteger("GUI_LOCATION_X"), (Object)new Long(gui_location_x));
        table.addValue((ValueMetaInterface)new ValueMetaInteger("GUI_LOCATION_Y"), (Object)new Long(gui_location_y));
        table.addValue((ValueMetaInterface)new ValueMetaBoolean("GUI_DRAW"), (Object)gui_draw);
        table.addValue((ValueMetaInterface)new ValueMetaBoolean("PARALLEL"), (Object)parallel);
        this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), "R_JOBENTRY_COPY");
        this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
        this.repository.connectionDelegate.getDatabase().insertRow();
        this.repository.connectionDelegate.getDatabase().closeInsert();
        return id;
    }

    public synchronized int getNrJobEntries(ObjectId id_job) throws KettleException {
        int retval = 0;
        RowMetaAndData par = this.repository.connectionDelegate.getParameterMetaData(id_job);
        String sql = "SELECT COUNT(*) FROM " + this.quoteTable("R_JOBENTRY") + " WHERE " + this.quote("ID_JOB") + " = ? ";
        RowMetaAndData r = this.repository.connectionDelegate.getOneRow(sql, par.getRowMeta(), par.getData());
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public void loadJobEntryBase(JobEntryBase jobEntryBase, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            RowMetaAndData r = this.getJobEntry(id_jobentry);
            if (r != null) {
                jobEntryBase.setName(r.getString("NAME", null));
                jobEntryBase.setDescription(r.getString("DESCRIPTION", null));
                long id_jobentry_type = r.getInteger("ID_JOBENTRY_TYPE", 0L);
                RowMetaAndData jetrow = this.getJobEntryType((ObjectId)new LongObjectId(id_jobentry_type));
                if (jetrow != null) {
                    jobEntryBase.setPluginId(jetrow.getString("CODE", null));
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load base job entry information from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    private void saveAttributesMap(ObjectId jobId, ObjectId entryId, Map<String, Map<String, String>> attributesMap) throws KettleException {
        for (Map.Entry<String, Map<String, String>> attributesEntry : attributesMap.entrySet()) {
            Map<String, String> attributes = attributesEntry.getValue();
            String groupName = attributesEntry.getKey();
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String value = entry.getValue();
                String key = entry.getKey();
                if (key == null || value == null) continue;
                this.repository.connectionDelegate.insertJobEntryAttribute(jobId, entryId, 0L, JOBENTRY_ATTRIBUTE_PREFIX + groupName + '\t' + value, 0.0, value);
            }
        }
    }

    private Map<String, Map<String, String>> loadJobEntryAttributesMap(ObjectId jobId, Object jobEntryId) throws KettleException {
        HashMap<String, Map<String, String>> attributesMap = new HashMap<String, Map<String, String>>();
        List<Object[]> attributeRows = this.repository.connectionDelegate.getJobEntryAttributesWithPrefix(jobId, jobId, JOBENTRY_ATTRIBUTE_PREFIX);
        RowMetaInterface rowMeta = this.repository.connectionDelegate.getReturnRowMeta();
        for (Object[] attributeRow : attributeRows) {
            int tabIndex;
            String code = rowMeta.getString(attributeRow, "CODE", null);
            String value = rowMeta.getString(attributeRow, "VALUE_STR", null);
            if (code == null || value == null || (tabIndex = (code = code.substring(JOBENTRY_ATTRIBUTE_PREFIX.length())).indexOf(9)) <= 0) continue;
            String groupName = code.substring(0, tabIndex);
            String key = code.substring(tabIndex + 1);
            HashMap<String, String> attributes = (HashMap<String, String>)attributesMap.get(groupName);
            if (attributes == null) {
                attributes = new HashMap<String, String>();
                attributesMap.put(groupName, attributes);
            }
            attributes.put(key, value);
        }
        return attributesMap;
    }
}

