/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entry;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.pentaho.di.base.BaseMeta;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.AttributesInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.attributes.AttributesUtil;
import org.pentaho.di.core.changed.ChangedFlagInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.gui.GUIPositionInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.missing.MissingEntry;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryCopy
implements Cloneable,
XMLInterface,
GUIPositionInterface,
ChangedFlagInterface,
AttributesInterface,
BaseMeta {
    private static final String XML_TAG = "entry";
    private static final String XML_ATTRIBUTE_JOB_ENTRY_COPY = "attributes_kjc";
    private JobEntryInterface entry;
    private String suggestion = "";
    private int nr;
    private boolean selected;
    private boolean isDeprecated;
    private Point location;
    private boolean launchingInParallel;
    private boolean draw;
    private ObjectId id;
    private JobMeta parentJobMeta;
    private Map<String, Map<String, String>> attributesMap;

    public JobEntryCopy() {
        this.clear();
    }

    public JobEntryCopy(JobEntryInterface entry) {
        this();
        this.setEntry(entry);
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder(100);
        retval.append("    ").append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
        this.entry.setParentJobMeta(this.parentJobMeta);
        retval.append(this.entry.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"parallel", (boolean)this.launchingInParallel));
        retval.append("      ").append(XMLHandler.addTagValue((String)"draw", (boolean)this.draw));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr", (int)this.nr));
        retval.append("      ").append(XMLHandler.addTagValue((String)"xloc", (int)this.location.x));
        retval.append("      ").append(XMLHandler.addTagValue((String)"yloc", (int)this.location.y));
        retval.append(AttributesUtil.getAttributesXml(this.attributesMap, XML_ATTRIBUTE_JOB_ENTRY_COPY));
        retval.append("    ").append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return retval.toString();
    }

    @Deprecated
    public JobEntryCopy(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        this(entrynode, databases, slaveServers, rep, null);
    }

    public JobEntryCopy(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            String stype = XMLHandler.getTagValue((Node)entrynode, (String)"type");
            PluginRegistry registry = PluginRegistry.getInstance();
            PluginInterface jobPlugin = registry.findPluginWithId(JobEntryPluginType.class, stype, true);
            if (jobPlugin == null) {
                String name = XMLHandler.getTagValue((Node)entrynode, (String)"name");
                this.entry = new MissingEntry(name, stype);
            } else {
                this.entry = (JobEntryInterface)registry.loadClass(jobPlugin, JobEntryInterface.class);
            }
            if (this.entry != null) {
                if (jobPlugin != null) {
                    this.entry.setPluginId(jobPlugin.getIds()[0]);
                }
                this.entry.setMetaStore(metaStore);
                this.entry.loadXML(entrynode, databases, slaveServers, rep, metaStore);
                this.compatibleLoadXml(entrynode, databases, slaveServers, rep);
                this.setNr(Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"nr"), (int)0));
                this.setLaunchingInParallel("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"parallel")));
                this.setDrawn("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"draw")));
                int x = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"xloc"), (int)0);
                int y = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"yloc"), (int)0);
                this.setLocation(x, y);
                Node jobEntryCopyAttributesNode = XMLHandler.getSubNode((Node)entrynode, (String)XML_ATTRIBUTE_JOB_ENTRY_COPY);
                this.attributesMap = jobEntryCopyAttributesNode != null ? AttributesUtil.loadAttributes(jobEntryCopyAttributesNode) : AttributesUtil.loadAttributes(XMLHandler.getLastSubNode((Node)entrynode, (String)"attributes"));
                this.setDeprecationAndSuggestedJobEntry();
            }
        }
        catch (Throwable e) {
            String message = "Unable to read Job Entry copy info from XML node : " + e.toString();
            throw new KettleXMLException(message, e);
        }
    }

    protected void compatibleLoadXml(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        this.entry.loadXML(entrynode, databases, slaveServers, rep);
    }

    public void clear() {
        this.location = null;
        this.entry = null;
        this.nr = 0;
        this.launchingInParallel = false;
        this.attributesMap = new HashMap<String, Map<String, String>>();
        this.setObjectId(null);
    }

    public Object clone() {
        JobEntryCopy ge = new JobEntryCopy();
        ge.replaceMeta(this);
        ge.setObjectId(null);
        for (Map.Entry<String, Map<String, String>> attribute : this.attributesMap.entrySet()) {
            ge.attributesMap.put(attribute.getKey(), attribute.getValue());
        }
        return ge;
    }

    public void replaceMeta(JobEntryCopy jobEntryCopy) {
        this.entry = (JobEntryInterface)jobEntryCopy.entry.clone();
        this.nr = jobEntryCopy.nr;
        this.selected = jobEntryCopy.selected;
        if (jobEntryCopy.location != null) {
            this.location = new Point(jobEntryCopy.location.x, jobEntryCopy.location.y);
        }
        this.launchingInParallel = jobEntryCopy.launchingInParallel;
        this.draw = jobEntryCopy.draw;
        this.id = jobEntryCopy.id;
        this.setChanged();
    }

    public Object clone_deep() {
        JobEntryCopy ge = (JobEntryCopy)this.clone();
        ge.entry = (JobEntryInterface)this.entry.clone();
        return ge;
    }

    public void setObjectId(ObjectId id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        JobEntryCopy je = (JobEntryCopy)o;
        return je.entry.getName().equalsIgnoreCase(this.entry.getName()) && je.getNr() == this.getNr();
    }

    public int hashCode() {
        return this.entry.getName().hashCode() ^ Integer.valueOf(this.getNr()).hashCode();
    }

    public ObjectId getObjectId() {
        return this.id;
    }

    public void setEntry(JobEntryInterface je) {
        this.entry = je;
        if (this.entry != null) {
            if (this.entry.getPluginId() == null) {
                this.entry.setPluginId(PluginRegistry.getInstance().getPluginId(JobEntryPluginType.class, (Object)this.entry));
            }
            this.setDeprecationAndSuggestedJobEntry();
        }
    }

    public JobEntryInterface getEntry() {
        return this.entry;
    }

    public String getTypeDesc() {
        PluginInterface plugin = PluginRegistry.getInstance().findPluginWithId(JobEntryPluginType.class, this.entry.getPluginId());
        return plugin.getDescription();
    }

    public void setLocation(int x, int y) {
        int ny;
        int nx = x >= 0 ? x : 0;
        Point loc = new Point(nx, ny = y >= 0 ? y : 0);
        if (!loc.equals(this.location)) {
            this.setChanged();
        }
        this.location = loc;
    }

    public void setLocation(Point loc) {
        if (loc != null && !loc.equals(this.location)) {
            this.setChanged();
        }
        this.location = loc;
    }

    @Override
    public Point getLocation() {
        return this.location;
    }

    @Override
    public void setChanged() {
        this.setChanged(true);
    }

    @Override
    public void setChanged(boolean ch) {
        this.entry.setChanged(ch);
    }

    @Override
    public void clearChanged() {
        this.entry.setChanged(false);
    }

    @Override
    public boolean hasChanged() {
        return this.entry.hasChanged();
    }

    public int getNr() {
        return this.nr;
    }

    public void setNr(int n) {
        this.nr = n;
    }

    public void setLaunchingInParallel(boolean p) {
        this.launchingInParallel = p;
    }

    public boolean isDrawn() {
        return this.draw;
    }

    public void setDrawn() {
        this.setDrawn(true);
    }

    public void setDrawn(boolean d) {
        this.draw = d;
    }

    public boolean isLaunchingInParallel() {
        return this.launchingInParallel;
    }

    public void setSelected(boolean sel) {
        this.selected = sel;
    }

    public void flipSelected() {
        this.selected = !this.selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setDescription(String description) {
        this.entry.setDescription(description);
    }

    public String getDescription() {
        return this.entry.getDescription();
    }

    public boolean isStart() {
        return this.entry.isStart();
    }

    public boolean isDummy() {
        return this.entry.isDummy();
    }

    public boolean isMissing() {
        return this.entry instanceof MissingEntry;
    }

    public boolean isTransformation() {
        return this.entry.isTransformation();
    }

    public boolean isJob() {
        return this.entry.isJob();
    }

    public boolean evaluates() {
        if (this.entry != null) {
            return this.entry.evaluates();
        }
        return false;
    }

    public boolean isUnconditional() {
        if (this.entry != null) {
            return this.entry.isUnconditional();
        }
        return true;
    }

    public boolean isEvaluation() {
        return this.entry.isEvaluation();
    }

    public boolean isMail() {
        return this.entry.isMail();
    }

    public boolean isSpecial() {
        return this.entry.isSpecial();
    }

    public String toString() {
        if (this.entry != null) {
            return this.entry.getName() + "." + this.getNr();
        }
        return "null." + this.getNr();
    }

    public String getName() {
        if (this.entry != null) {
            return this.entry.getName();
        }
        return "null";
    }

    public void setName(String name) {
        this.entry.setName(name);
    }

    public boolean resetErrorsBeforeExecution() {
        return this.entry.resetErrorsBeforeExecution();
    }

    public JobMeta getParentJobMeta() {
        return this.parentJobMeta;
    }

    public void setParentJobMeta(JobMeta parentJobMeta) {
        this.parentJobMeta = parentJobMeta;
        this.entry.setParentJobMeta(parentJobMeta);
    }

    public void setAttributesMap(Map<String, Map<String, String>> attributesMap) {
        this.attributesMap = attributesMap;
    }

    public Map<String, Map<String, String>> getAttributesMap() {
        return this.attributesMap;
    }

    public void setAttribute(String groupName, String key, String value) {
        Map<String, String> attributes = this.getAttributes(groupName);
        if (attributes == null) {
            attributes = new HashMap<String, String>();
            this.attributesMap.put(groupName, attributes);
        }
        attributes.put(key, value);
    }

    public void setAttributes(String groupName, Map<String, String> attributes) {
        this.attributesMap.put(groupName, attributes);
    }

    public Map<String, String> getAttributes(String groupName) {
        return this.attributesMap.get(groupName);
    }

    public String getAttribute(String groupName, String key) {
        Map<String, String> attributes = this.attributesMap.get(groupName);
        if (attributes == null) {
            return null;
        }
        return attributes.get(key);
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    private void setDeprecationAndSuggestedJobEntry() {
        PluginRegistry registry = PluginRegistry.getInstance();
        List deprecatedJobEntries = registry.getPluginsByCategory(JobEntryPluginType.class, BaseMessages.getString(JobMeta.class, (String)"JobCategory.Category.Deprecated", (String[])new String[0]));
        for (PluginInterface p : deprecatedJobEntries) {
            Object[] ids = p.getIds();
            if (ArrayUtils.isEmpty((Object[])ids) || !((String)ids[0]).equals(this.entry != null ? this.entry.getPluginId() : "")) continue;
            this.isDeprecated = true;
            this.suggestion = registry.findPluginWithId(JobEntryPluginType.class, this.entry.getPluginId()) != null ? registry.findPluginWithId(JobEntryPluginType.class, this.entry.getPluginId()).getSuggestion() : "";
            break;
        }
    }
}

