/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job;

import org.pentaho.di.base.BaseHopMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.w3c.dom.Node;

public class JobHopMeta
extends BaseHopMeta<JobEntryCopy> {
    private static Class<?> PKG = JobHopMeta.class;
    private boolean evaluation;
    private boolean unconditional;

    public JobHopMeta() {
        this((JobEntryCopy)null, (JobEntryCopy)null);
    }

    public JobHopMeta(JobEntryCopy from, JobEntryCopy to) {
        this.from = from;
        this.to = to;
        this.enabled = true;
        this.split = false;
        this.evaluation = true;
        this.unconditional = false;
        this.id = null;
        if (from != null && from.isStart()) {
            this.setUnconditional();
        }
    }

    public JobHopMeta(Node hopnode, JobMeta job) throws KettleXMLException {
        try {
            String fromNameValue = XMLHandler.getTagValue((Node)hopnode, (String)"from");
            String toNameValue = XMLHandler.getTagValue((Node)hopnode, (String)"to");
            String fromNrValue = XMLHandler.getTagValue((Node)hopnode, (String)"from_nr");
            String toNrValue = XMLHandler.getTagValue((Node)hopnode, (String)"to_nr");
            String enabledValue = XMLHandler.getTagValue((Node)hopnode, (String)"enabled");
            String evaluationValue = XMLHandler.getTagValue((Node)hopnode, (String)"evaluation");
            String unconditionalValue = XMLHandler.getTagValue((Node)hopnode, (String)"unconditional");
            int fromNr = Const.toInt((String)fromNrValue, (int)0);
            int toNr = Const.toInt((String)toNrValue, (int)0);
            this.from = job.findJobEntry(fromNameValue, fromNr, true);
            this.to = job.findJobEntry(toNameValue, toNr, true);
            this.enabled = enabledValue == null ? true : "Y".equalsIgnoreCase(enabledValue);
            this.evaluation = evaluationValue == null ? true : "Y".equalsIgnoreCase(evaluationValue);
            this.unconditional = "Y".equalsIgnoreCase(unconditionalValue);
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobHopMeta.Exception.UnableToLoadHopInfoXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder(200);
        String shortSpaces = "    ";
        String longSpaces = "      ";
        if (null != this.from && null != this.to) {
            retval.append(shortSpaces).append(XMLHandler.openTag((String)"hop")).append(Const.CR);
            retval.append(longSpaces).append(XMLHandler.addTagValue((String)"from", (String)((JobEntryCopy)this.from).getName()));
            retval.append(longSpaces).append(XMLHandler.addTagValue((String)"to", (String)((JobEntryCopy)this.to).getName()));
            retval.append(longSpaces).append(XMLHandler.addTagValue((String)"from_nr", (int)((JobEntryCopy)this.from).getNr()));
            retval.append(longSpaces).append(XMLHandler.addTagValue((String)"to_nr", (int)((JobEntryCopy)this.to).getNr()));
            retval.append(longSpaces).append(XMLHandler.addTagValue((String)"enabled", (boolean)this.enabled));
            retval.append(longSpaces).append(XMLHandler.addTagValue((String)"evaluation", (boolean)this.evaluation));
            retval.append(longSpaces).append(XMLHandler.addTagValue((String)"unconditional", (boolean)this.unconditional));
            retval.append(shortSpaces).append(XMLHandler.closeTag((String)"hop")).append(Const.CR);
        }
        return retval.toString();
    }

    public boolean getEvaluation() {
        return this.evaluation;
    }

    public void setEvaluation() {
        if (!this.evaluation) {
            this.setChanged();
        }
        this.setEvaluation(true);
    }

    public void setEvaluation(boolean e) {
        if (this.evaluation != e) {
            this.setChanged();
        }
        this.evaluation = e;
    }

    public void setUnconditional() {
        if (!this.unconditional) {
            this.setChanged();
        }
        this.unconditional = true;
    }

    public void setConditional() {
        if (this.unconditional) {
            this.setChanged();
        }
        this.unconditional = false;
    }

    public boolean isUnconditional() {
        return this.unconditional;
    }

    public void setSplit(boolean split) {
        if (this.split != split) {
            this.setChanged();
        }
        this.split = split;
    }

    public boolean isSplit() {
        return this.split;
    }

    public String getDescription() {
        if (this.isUnconditional()) {
            return BaseMessages.getString(PKG, (String)"JobHopMeta.Msg.ExecNextJobEntryUncondition", (String[])new String[0]);
        }
        if (this.getEvaluation()) {
            return BaseMessages.getString(PKG, (String)"JobHopMeta.Msg.ExecNextJobEntryFlawLess", (String[])new String[0]);
        }
        return BaseMessages.getString(PKG, (String)"JobHopMeta.Msg.ExecNextJobEntryFailed", (String[])new String[0]);
    }

    public String toString() {
        return this.getDescription();
    }

    public JobEntryCopy getFromEntry() {
        return (JobEntryCopy)this.from;
    }

    public void setFromEntry(JobEntryCopy fromEntry) {
        this.from = fromEntry;
        this.changed = true;
    }

    public JobEntryCopy getToEntry() {
        return (JobEntryCopy)this.to;
    }

    public void setToEntry(JobEntryCopy toEntry) {
        this.to = toEntry;
        this.changed = true;
    }

    public void setUnconditional(boolean unconditional) {
        if (this.unconditional != unconditional) {
            this.setChanged();
        }
        this.unconditional = unconditional;
    }
}

