/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LoggingObject;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;

public class AsyncDatabaseAction {
    private static final long TIMEOUT = 2000L;
    private static final int ROW_LIMIT = 10000;

    private AsyncDatabaseAction() {
    }

    public static void executeAction(DatabaseMeta databaseMeta, Consumer<Database> dbAction) {
        CompletableFuture.supplyAsync(() -> AsyncDatabaseAction.internalExec(databaseMeta, dbAction, (LoggingObjectInterface)new LoggingObject((Object)databaseMeta))).acceptEither(AsyncDatabaseAction.timeout(), r -> {});
    }

    public static void executeSql(DatabaseMeta databaseMeta, String sql, Consumer<List<Object[]>> rowConsumer) {
        AsyncDatabaseAction.executeAction(databaseMeta, database -> {
            try {
                rowConsumer.accept(database.getRows(sql, 10000));
            }
            catch (NullPointerException | KettleDatabaseException e) {
                AsyncDatabaseAction.logError(databaseMeta, e);
                rowConsumer.accept(Collections.emptyList());
            }
        });
    }

    public static void getTables(DatabaseMeta databaseMeta, String schema, Consumer<String[]> tablesConsumer) {
        AsyncDatabaseAction.executeAction(databaseMeta, database -> {
            try {
                tablesConsumer.accept(database.getTablenames(schema, false));
            }
            catch (NullPointerException | KettleDatabaseException e) {
                AsyncDatabaseAction.logError(databaseMeta, e);
                tablesConsumer.accept(new String[0]);
            }
        });
    }

    public static void getSchemas(DatabaseMeta databaseMeta, Consumer<String[]> schemasConsumer) {
        AsyncDatabaseAction.executeAction(databaseMeta, database -> {
            try {
                schemasConsumer.accept(database.getSchemas());
            }
            catch (NullPointerException | KettleDatabaseException e) {
                AsyncDatabaseAction.logError(databaseMeta, e);
                schemasConsumer.accept(new String[0]);
            }
        });
    }

    public static void getFields(DatabaseMeta databaseMeta, String tablename, Consumer<RowMetaInterface> fieldsConsumer) {
        AsyncDatabaseAction.executeAction(databaseMeta, database -> {
            try {
                fieldsConsumer.accept(database.getTableFields(tablename));
            }
            catch (NullPointerException | KettleDatabaseException e) {
                AsyncDatabaseAction.logError(databaseMeta, e);
                fieldsConsumer.accept((RowMetaInterface)new RowMeta());
            }
        });
    }

    private static Void internalExec(DatabaseMeta databaseMeta, Consumer<Database> dbAction, LoggingObjectInterface log) {
        if (databaseMeta != null) {
            try (Database db = new Database(log, databaseMeta);){
                db.connect();
                dbAction.accept(db);
            }
            catch (KettleDatabaseException e) {
                AsyncDatabaseAction.logError(databaseMeta, e);
                dbAction.accept(null);
            }
        }
        return null;
    }

    private static void logError(DatabaseMeta database, Throwable e) {
        new LogChannel((Object)database).logError(e.getMessage(), e);
    }

    private static CompletableFuture<Void> timeout() {
        ScheduledExecutorService timeoutThread = Executors.newSingleThreadScheduledExecutor();
        CompletableFuture<Void> f = new CompletableFuture<Void>();
        timeoutThread.schedule(() -> f.completeExceptionally(new TimeoutException()), 2000L, TimeUnit.MILLISECONDS);
        return f;
    }
}

