/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.BaseLogTable;
import org.pentaho.di.core.logging.LogStatus;
import org.pentaho.di.core.logging.LogTableCoreInterface;
import org.pentaho.di.core.logging.LogTableField;
import org.pentaho.di.core.logging.LogTableInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.RepositoryAttributeInterface;
import org.pentaho.di.trans.HasDatabasesInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.step.StepMeta;
import org.w3c.dom.Node;

public class TransLogTable
extends BaseLogTable
implements Cloneable,
LogTableInterface {
    private static Class<?> PKG = TransLogTable.class;
    public static final String XML_TAG = "trans-log-table";
    private String logInterval;
    private String logSizeLimit;
    private List<StepMeta> steps;

    public TransLogTable(VariableSpace space, HasDatabasesInterface databasesInterface, List<StepMeta> steps) {
        super(space, databasesInterface, null, null, null);
        this.steps = steps;
    }

    @Override
    public Object clone() {
        try {
            TransLogTable table = (TransLogTable)super.clone();
            table.fields = new ArrayList();
            for (LogTableField field : this.fields) {
                table.fields.add((LogTableField)field.clone());
            }
            return table;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("      ").append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
        retval.append("        ").append(XMLHandler.addTagValue((String)"connection", (String)this.connectionName));
        retval.append("        ").append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("        ").append(XMLHandler.addTagValue((String)"table", (String)this.tableName));
        retval.append("        ").append(XMLHandler.addTagValue((String)"size_limit_lines", (String)this.logSizeLimit));
        retval.append("        ").append(XMLHandler.addTagValue((String)"interval", (String)this.logInterval));
        retval.append("        ").append(XMLHandler.addTagValue((String)"timeout_days", (String)this.timeoutInDays));
        retval.append(super.getFieldsXML());
        retval.append("      ").append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node node, List<DatabaseMeta> databases, List<StepMeta> steps) {
        this.connectionName = XMLHandler.getTagValue((Node)node, (String)"connection");
        this.schemaName = XMLHandler.getTagValue((Node)node, (String)"schema");
        this.tableName = XMLHandler.getTagValue((Node)node, (String)"table");
        this.logSizeLimit = XMLHandler.getTagValue((Node)node, (String)"size_limit_lines");
        this.logInterval = XMLHandler.getTagValue((Node)node, (String)"interval");
        this.timeoutInDays = XMLHandler.getTagValue((Node)node, (String)"timeout_days");
        int nr = XMLHandler.countNodes((Node)node, (String)"field");
        for (int i = 0; i < nr; ++i) {
            Node fieldNode = XMLHandler.getSubNodeByNr((Node)node, (String)"field", (int)i);
            String id = XMLHandler.getTagValue((Node)fieldNode, (String)"id");
            LogTableField field = this.findField(id);
            if (field == null && i < this.fields.size()) {
                field = (LogTableField)this.fields.get(i);
            }
            if (field == null) continue;
            field.setFieldName(XMLHandler.getTagValue((Node)fieldNode, (String)"name"));
            field.setEnabled("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)fieldNode, (String)"enabled")));
            field.setSubject((Object)StepMeta.findStep(steps, XMLHandler.getTagValue((Node)fieldNode, (String)"subject")));
        }
    }

    @Override
    public void saveToRepository(RepositoryAttributeInterface attributeInterface) throws KettleException {
        super.saveToRepository(attributeInterface);
        attributeInterface.setAttribute(this.getLogTableCode() + PROP_LOG_TABLE_INTERVAL, this.logInterval);
        attributeInterface.setAttribute(this.getLogTableCode() + PROP_LOG_TABLE_SIZE_LIMIT, this.logSizeLimit);
    }

    @Override
    public void loadFromRepository(RepositoryAttributeInterface attributeInterface) throws KettleException {
        super.loadFromRepository(attributeInterface);
        this.logInterval = attributeInterface.getAttributeString(this.getLogTableCode() + PROP_LOG_TABLE_INTERVAL);
        this.logSizeLimit = attributeInterface.getAttributeString(this.getLogTableCode() + PROP_LOG_TABLE_SIZE_LIMIT);
        for (int i = 0; i < this.getFields().size(); ++i) {
            LogTableField field;
            String id = attributeInterface.getAttributeString(this.getLogTableCode() + PROP_LOG_TABLE_FIELD_ID + i);
            if (id == null || !(field = this.findField(id)).isSubjectAllowed()) continue;
            String stepname = (String)field.getSubject();
            if (!Utils.isEmpty((CharSequence)stepname)) {
                field.setSubject((Object)StepMeta.findStep(this.steps, stepname));
                continue;
            }
            field.setSubject(null);
        }
    }

    public void replaceMeta(LogTableCoreInterface logTableInterface) {
        if (!(logTableInterface instanceof TransLogTable)) {
            return;
        }
        TransLogTable logTable = (TransLogTable)logTableInterface;
        super.replaceMeta(logTable);
    }

    public static TransLogTable getDefault(VariableSpace space, HasDatabasesInterface databasesInterface, List<StepMeta> steps) {
        TransLogTable table = new TransLogTable(space, databasesInterface, steps);
        table.fields.add(new LogTableField(ID.ID_BATCH.id, true, false, "ID_BATCH", BaseMessages.getString(PKG, (String)"TransLogTable.FieldName.BatchID", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLogTable.FieldDescription.BatchID", (String[])new String[0]), 5, 8));
        table.fields.add(new LogTableField(ID.CHANNEL_ID.id, true, false, "CHANNEL_ID", BaseMessages.getString(PKG, (String)"TransLogTable.FieldName.ChannelID", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLogTable.FieldDescription.ChannelID", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.TRANSNAME.id, true, false, "TRANSNAME", BaseMessages.getString(PKG, (String)"TransLogTable.FieldName.TransName", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLogTable.FieldDescription.TransName", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.STATUS.id, true, false, "STATUS", BaseMessages.getString(PKG, (String)"TransLogTable.FieldName.Status", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLogTable.FieldDescription.Status", (String[])new String[0]), 2, 15));
        table.fields.add(new LogTableField(ID.LINES_READ.id, true, true, "LINES_READ", BaseMessages.getString(PKG, (String)"TransLogTable.FieldName.LinesRead", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLogTable.FieldDescription.LinesRead", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_WRITTEN.id, true, true, "LINES_WRITTEN", BaseMessages.getString(PKG, (String)"TransLogTable.FieldName.LinesWritten", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLogTable.FieldDescription.LinesWritten", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_UPDATED.id, true, true, "LINES_UPDATED", BaseMessages.getString(PKG, (String)"TransLogTable.FieldName.LinesUpdated", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLogTable.FieldDescription.LinesUpdated", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_INPUT.id, true, true, "LINES_INPUT", BaseMessages.getString(PKG, (String)"TransLogTable.FieldName.LinesInput", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLogTable.FieldDescription.LinesInput", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_OUTPUT.id, true, true, "LINES_OUTPUT", BaseMessages.getString(PKG, (String)"TransLogTable.FieldName.LinesOutput", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLogTable.FieldDescription.LinesOutput", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_REJECTED.id, true, true, "LINES_REJECTED", BaseMessages.getString(PKG, (String)"TransLogTable.FieldName.LinesRejected", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLogTable.FieldDescription.LinesRejected", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.ERRORS.id, true, false, "ERRORS", BaseMessages.getString(PKG, (String)"TransLogTable.FieldName.Errors", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLogTable.FieldDescription.Errors", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.STARTDATE.id, true, false, "STARTDATE", BaseMessages.getString(PKG, (String)"TransLogTable.FieldName.StartDateRange", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLogTable.FieldDescription.StartDateRange", (String[])new String[0]), 3, -1));
        table.fields.add(new LogTableField(ID.ENDDATE.id, true, false, "ENDDATE", BaseMessages.getString(PKG, (String)"TransLogTable.FieldName.EndDateRange", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLogTable.FieldDescription.EndDateRange", (String[])new String[0]), 3, -1));
        table.fields.add(new LogTableField(ID.LOGDATE.id, true, false, "LOGDATE", BaseMessages.getString(PKG, (String)"TransLogTable.FieldName.LogDate", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLogTable.FieldDescription.LogDate", (String[])new String[0]), 3, -1));
        table.fields.add(new LogTableField(ID.DEPDATE.id, true, false, "DEPDATE", BaseMessages.getString(PKG, (String)"TransLogTable.FieldName.DepDate", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLogTable.FieldDescription.DepDate", (String[])new String[0]), 3, -1));
        table.fields.add(new LogTableField(ID.REPLAYDATE.id, true, false, "REPLAYDATE", BaseMessages.getString(PKG, (String)"TransLogTable.FieldName.ReplayDate", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLogTable.FieldDescription.ReplayDate", (String[])new String[0]), 3, -1));
        table.fields.add(new LogTableField(ID.LOG_FIELD.id, true, false, "LOG_FIELD", BaseMessages.getString(PKG, (String)"TransLogTable.FieldName.LogField", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLogTable.FieldDescription.LogField", (String[])new String[0]), 2, 9999999));
        table.fields.add(new LogTableField(ID.EXECUTING_SERVER.id, false, false, "EXECUTING_SERVER", BaseMessages.getString(PKG, (String)"TransLogTable.FieldName.ExecutingServer", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLogTable.FieldDescription.ExecutingServer", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.EXECUTING_USER.id, false, false, "EXECUTING_USER", BaseMessages.getString(PKG, (String)"TransLogTable.FieldName.ExecutingUser", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLogTable.FieldDescription.ExecutingUser", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.CLIENT.id, false, false, "CLIENT", BaseMessages.getString(PKG, (String)"TransLogTable.FieldName.Client", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLogTable.FieldDescription.Client", (String[])new String[0]), 2, 255));
        table.findField(ID.ID_BATCH).setKey(true);
        table.findField(ID.LOGDATE).setLogDateField(true);
        table.findField(ID.LOG_FIELD).setLogField(true);
        table.findField(ID.CHANNEL_ID).setVisible(false);
        table.findField(ID.TRANSNAME).setVisible(false);
        table.findField(ID.STATUS).setStatusField(true);
        table.findField(ID.ERRORS).setErrorsField(true);
        table.findField(ID.TRANSNAME).setNameField(true);
        return table;
    }

    public LogTableField findField(ID id) {
        return super.findField(id.id);
    }

    public Object getSubject(ID id) {
        return super.getSubject(id.id);
    }

    public String getSubjectString(ID id) {
        return super.getSubjectString(id.id);
    }

    public void setBatchIdUsed(boolean use) {
        this.findField(ID.ID_BATCH).setEnabled(use);
    }

    public boolean isBatchIdUsed() {
        return this.findField(ID.ID_BATCH).isEnabled();
    }

    public void setLogFieldUsed(boolean use) {
        this.findField(ID.LOG_FIELD).setEnabled(use);
    }

    public boolean isLogFieldUsed() {
        return this.findField(ID.LOG_FIELD).isEnabled();
    }

    public String getStepnameRead() {
        return this.getSubjectString(ID.LINES_READ);
    }

    public void setStepRead(StepMeta read) {
        this.findField(ID.LINES_READ).setSubject((Object)read);
    }

    public String getStepnameWritten() {
        return this.getSubjectString(ID.LINES_WRITTEN);
    }

    public void setStepWritten(StepMeta written) {
        this.findField(ID.LINES_WRITTEN).setSubject((Object)written);
    }

    public String getStepnameInput() {
        return this.getSubjectString(ID.LINES_INPUT);
    }

    public void setStepInput(StepMeta input) {
        this.findField(ID.LINES_INPUT).setSubject((Object)input);
    }

    public String getStepnameOutput() {
        return this.getSubjectString(ID.LINES_OUTPUT);
    }

    public void setStepOutput(StepMeta output) {
        this.findField(ID.LINES_OUTPUT).setSubject((Object)output);
    }

    public String getStepnameUpdated() {
        return this.getSubjectString(ID.LINES_UPDATED);
    }

    public void setStepUpdate(StepMeta update) {
        this.findField(ID.LINES_UPDATED).setSubject((Object)update);
    }

    public String getStepnameRejected() {
        return this.getSubjectString(ID.LINES_REJECTED);
    }

    public void setStepRejected(StepMeta rejected) {
        this.findField(ID.LINES_REJECTED).setSubject((Object)rejected);
    }

    public void setLogInterval(String logInterval) {
        this.logInterval = logInterval;
    }

    public String getLogInterval() {
        return this.logInterval;
    }

    public String getLogSizeLimit() {
        return this.logSizeLimit;
    }

    public void setLogSizeLimit(String logSizeLimit) {
        this.logSizeLimit = logSizeLimit;
    }

    public RowMetaAndData getLogRecord(LogStatus status, Object subject, Object parent) {
        if (subject == null || subject instanceof Trans) {
            Trans trans = (Trans)subject;
            Result result = null;
            if (trans != null) {
                result = trans.getResult();
            }
            RowMetaAndData row = new RowMetaAndData();
            for (LogTableField field : this.fields) {
                if (!field.isEnabled()) continue;
                Object value = null;
                if (trans != null) {
                    switch (ID.valueOf(field.getId())) {
                        case ID_BATCH: {
                            value = new Long(trans.getBatchId());
                            break;
                        }
                        case CHANNEL_ID: {
                            value = trans.getLogChannelId();
                            break;
                        }
                        case TRANSNAME: {
                            value = trans.getName();
                            break;
                        }
                        case STATUS: {
                            value = status.getStatus();
                            break;
                        }
                        case LINES_READ: {
                            value = new Long(result.getNrLinesRead());
                            break;
                        }
                        case LINES_WRITTEN: {
                            value = new Long(result.getNrLinesWritten());
                            break;
                        }
                        case LINES_INPUT: {
                            value = new Long(result.getNrLinesInput());
                            break;
                        }
                        case LINES_OUTPUT: {
                            value = new Long(result.getNrLinesOutput());
                            break;
                        }
                        case LINES_UPDATED: {
                            value = new Long(result.getNrLinesUpdated());
                            break;
                        }
                        case LINES_REJECTED: {
                            value = new Long(result.getNrLinesRejected());
                            break;
                        }
                        case ERRORS: {
                            value = new Long(result.getNrErrors());
                            break;
                        }
                        case STARTDATE: {
                            value = trans.getStartDate();
                            break;
                        }
                        case LOGDATE: {
                            value = trans.getLogDate();
                            break;
                        }
                        case ENDDATE: {
                            value = trans.getEndDate();
                            break;
                        }
                        case DEPDATE: {
                            value = trans.getDepDate();
                            break;
                        }
                        case REPLAYDATE: {
                            value = trans.getCurrentDate();
                            break;
                        }
                        case LOG_FIELD: {
                            value = this.getLogBuffer(trans, trans.getLogChannelId(), status, this.logSizeLimit, trans.getLogBufferStartLine());
                            break;
                        }
                        case EXECUTING_SERVER: {
                            value = trans.getExecutingServer();
                            break;
                        }
                        case EXECUTING_USER: {
                            value = trans.getExecutingUser();
                            break;
                        }
                        case CLIENT: {
                            value = KettleClientEnvironment.getInstance().getClient() != null ? KettleClientEnvironment.getInstance().getClient().toString() : "unknown";
                            break;
                        }
                    }
                }
                row.addValue(field.getFieldName(), field.getDataType(), value);
                row.getRowMeta().getValueMeta(row.size() - 1).setLength(field.getLength());
            }
            return row;
        }
        return null;
    }

    @Override
    public String getLogTableCode() {
        return "TRANS";
    }

    public String getLogTableType() {
        return BaseMessages.getString(PKG, (String)"TransLogTable.Type.Description", (String[])new String[0]);
    }

    @Override
    public String getConnectionNameVariable() {
        return "KETTLE_TRANS_LOG_DB";
    }

    @Override
    public String getSchemaNameVariable() {
        return "KETTLE_TRANS_LOG_SCHEMA";
    }

    @Override
    public String getTableNameVariable() {
        return "KETTLE_TRANS_LOG_TABLE";
    }

    public List<RowMetaInterface> getRecommendedIndexes() {
        ArrayList<RowMetaInterface> indexes = new ArrayList<RowMetaInterface>();
        if (this.isBatchIdUsed()) {
            indexes.add(this.addFieldsToIndex(this.getKeyField()));
        }
        indexes.add(this.addFieldsToIndex(this.findField(ID.ERRORS), this.findField(ID.STATUS), this.findField(ID.TRANSNAME)));
        indexes.add(this.addFieldsToIndex(this.findField(ID.TRANSNAME), this.findField(ID.LOGDATE)));
        return indexes;
    }

    @Override
    public void setAllGlobalParametersToNull() {
        boolean clearGlobalVariables = Boolean.valueOf(System.getProperties().getProperty("KETTLE_GLOBAL_LOG_VARIABLES_CLEAR_ON_EXPORT", "false"));
        if (clearGlobalVariables) {
            super.setAllGlobalParametersToNull();
            this.logInterval = this.isGlobalParameter(this.logInterval) ? null : this.logInterval;
            this.logSizeLimit = this.isGlobalParameter(this.logSizeLimit) ? null : this.logSizeLimit;
        }
    }

    public static enum ID {
        ID_BATCH("ID_BATCH"),
        CHANNEL_ID("CHANNEL_ID"),
        TRANSNAME("TRANSNAME"),
        STATUS("STATUS"),
        LINES_READ("LINES_READ"),
        LINES_WRITTEN("LINES_WRITTEN"),
        LINES_UPDATED("LINES_UPDATED"),
        LINES_INPUT("LINES_INPUT"),
        LINES_OUTPUT("LINES_OUTPUT"),
        LINES_REJECTED("LINES_REJECTED"),
        ERRORS("ERRORS"),
        STARTDATE("STARTDATE"),
        ENDDATE("ENDDATE"),
        LOGDATE("LOGDATE"),
        DEPDATE("DEPDATE"),
        REPLAYDATE("REPLAYDATE"),
        LOG_FIELD("LOG_FIELD"),
        EXECUTING_SERVER("EXECUTING_SERVER"),
        EXECUTING_USER("EXECUTING_USER"),
        CLIENT("CLIENT");

        private String id;

        private ID(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }
}

