/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.base;

import org.apache.commons.lang.StringUtils;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.base.IMetaFileCache;
import org.pentaho.di.base.IMetaFileLoader;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.util.CurrentDirectoryResolver;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.job.JobEntryJob;
import org.pentaho.di.job.entries.trans.JobEntryTrans;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.trans.StepWithMappingMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.jobexecutor.JobExecutorMeta;
import org.pentaho.metastore.api.IMetaStore;

public class MetaFileLoaderImpl<T>
implements IMetaFileLoader<T> {
    JobEntryBase jobEntryBase;
    private ObjectLocationSpecificationMethod specificationMethod;
    private Class<? extends AbstractMeta> persistentClass;
    private IMetaFileCache metaFileCache;
    private final String metaName;
    private final String directory;
    private final ObjectId metaObjectId;
    private final String friendlyMetaType;
    private String filename;
    private BaseStepMeta baseStepMeta;

    public MetaFileLoaderImpl(JobEntryBase jobEntryBase, ObjectLocationSpecificationMethod specificationMethod) {
        if (jobEntryBase instanceof JobEntryJob || jobEntryBase instanceof JobEntryTrans) {
            this.jobEntryBase = jobEntryBase;
            this.specificationMethod = specificationMethod;
            this.filename = jobEntryBase.getFilename();
            if (jobEntryBase instanceof JobEntryTrans) {
                JobEntryTrans jobEntryTrans = (JobEntryTrans)jobEntryBase;
                this.metaName = jobEntryTrans.getTransname();
                this.directory = jobEntryTrans.getDirectory();
                this.metaObjectId = jobEntryTrans.getTransObjectId();
                this.friendlyMetaType = "Transformation";
                this.persistentClass = TransMeta.class;
            } else {
                JobEntryJob jobEntryJob = (JobEntryJob)jobEntryBase;
                this.metaName = jobEntryJob.getJobName();
                this.directory = jobEntryJob.getDirectory();
                this.metaObjectId = jobEntryJob.getJobObjectId();
                this.friendlyMetaType = "Job";
                this.persistentClass = JobMeta.class;
            }
        } else {
            throw new IllegalArgumentException("JobEntryBase must be a JobEntryTrans or JobEntryJob object");
        }
    }

    public MetaFileLoaderImpl(BaseStepMeta baseStepMeta, ObjectLocationSpecificationMethod specificationMethod) {
        if (baseStepMeta instanceof StepWithMappingMeta || baseStepMeta instanceof JobExecutorMeta) {
            this.baseStepMeta = baseStepMeta;
            this.specificationMethod = specificationMethod;
            if (baseStepMeta instanceof StepWithMappingMeta) {
                StepWithMappingMeta stepWithMappingMeta = (StepWithMappingMeta)baseStepMeta;
                this.metaName = stepWithMappingMeta.getTransName();
                this.directory = stepWithMappingMeta.getDirectoryPath();
                this.metaObjectId = stepWithMappingMeta.getTransObjectId();
                this.friendlyMetaType = "Transformation";
                this.persistentClass = TransMeta.class;
                this.filename = stepWithMappingMeta.getFileName();
            } else {
                JobExecutorMeta jobExecutorMeta = (JobExecutorMeta)baseStepMeta;
                this.metaName = jobExecutorMeta.getJobName();
                this.directory = jobExecutorMeta.getDirectoryPath();
                this.metaObjectId = jobExecutorMeta.getJobObjectId();
                this.friendlyMetaType = "Job";
                this.persistentClass = JobMeta.class;
                this.filename = jobExecutorMeta.getFileName();
            }
        } else {
            throw new IllegalArgumentException("JobEntryBase must be a JobEntryTrans or JobEntryJob object");
        }
    }

    @Override
    public T getMetaForEntry(Repository rep, IMetaStore metaStore, VariableSpace space) throws KettleException {
        try {
            AbstractMeta theMeta = null;
            if (this.jobEntryBase.getParentJob() != null) {
                this.metaFileCache = this.jobEntryBase.getParentJobMeta().getMetaFileCache();
            }
            CurrentDirectoryResolver r = new CurrentDirectoryResolver();
            VariableSpace tmpSpace = r.resolveCurrentDirectory(this.specificationMethod, space, rep, this.jobEntryBase.getParentJob(), this.filename);
            String[] idContainer = new String[1];
            switch (this.specificationMethod) {
                case FILENAME: {
                    String realFilename = tmpSpace.environmentSubstitute(this.filename);
                    try {
                        theMeta = (AbstractMeta)this.attemptLoadMeta(realFilename, rep, metaStore, tmpSpace, null, idContainer);
                    }
                    catch (KettleException e) {
                        theMeta = rep == null ? (this.isTransMeta() ? new TransMeta(realFilename, metaStore, null, true, this.jobEntryBase.getParentVariableSpace(), null) : new JobMeta(this.jobEntryBase.getParentVariableSpace(), realFilename, rep, metaStore, null)) : (AbstractMeta)this.getMetaFromRepository(rep, r, realFilename, tmpSpace);
                        if (theMeta == null) break;
                        idContainer[0] = realFilename;
                    }
                    break;
                }
                case REPOSITORY_BY_NAME: {
                    String realDirectory = tmpSpace.environmentSubstitute(this.directory != null ? this.directory : "");
                    String realName = tmpSpace.environmentSubstitute(this.metaName);
                    String metaPath = StringUtil.trimEnd((String)realDirectory, (char)'/') + "/" + StringUtil.trimStart((String)realName, (char)'/');
                    if (metaPath.startsWith("file://") || metaPath.startsWith("zip:file://") || metaPath.startsWith("hdfs://")) {
                        String extension;
                        String string = extension = this.isTransMeta() ? RepositoryObjectType.TRANSFORMATION.getExtension() : RepositoryObjectType.JOB.getExtension();
                        if (!metaPath.endsWith(extension)) {
                            metaPath = metaPath + extension;
                        }
                        if ((theMeta = this.attemptCacheRead(metaPath)) != null) break;
                        theMeta = this.isTransMeta() ? new TransMeta(metaPath, metaStore, null, true, this.jobEntryBase.getParentVariableSpace(), null) : new JobMeta(tmpSpace, metaPath, rep, metaStore, null);
                        idContainer[0] = metaPath;
                        break;
                    }
                    theMeta = this.attemptCacheRead(metaPath);
                    if (theMeta != null || (theMeta = this.isTransMeta() ? (rep == null ? new TransMeta(metaPath, metaStore, null, true, this.jobEntryBase.getParentVariableSpace(), null) : this.getMetaFromRepository(rep, r, metaPath, tmpSpace)) : this.getMetaFromRepository(rep, r, metaPath, tmpSpace)) == null) break;
                    idContainer[0] = metaPath;
                    break;
                }
                case REPOSITORY_BY_REFERENCE: {
                    if (this.metaObjectId == null) {
                        if (this.isTransMeta()) {
                            throw new KettleException(BaseMessages.getString(this.persistentClass, (String)"JobTrans.Exception.ReferencedTransformationIdIsNull", (String[])new String[0]));
                        }
                        throw new KettleException(BaseMessages.getString(this.persistentClass, (String)"JobJob.Exception.ReferencedTransformationIdIsNull", (String[])new String[0]));
                    }
                    if (rep != null) {
                        theMeta = (AbstractMeta)this.attemptCacheRead(this.metaObjectId.toString());
                        if (theMeta != null) break;
                        theMeta = this.isTransMeta() ? rep.loadTransformation(this.metaObjectId, null) : rep.loadJob(this.metaObjectId, null);
                        idContainer[0] = this.metaObjectId.toString();
                        break;
                    }
                    throw new KettleException("Could not execute " + this.friendlyMetaType + " specified in a repository since we're not connected to one");
                }
                default: {
                    throw new KettleException("The specified object location specification method '" + this.specificationMethod + "' is not yet supported in this " + this.friendlyMetaType + " entry.");
                }
            }
            this.cacheMeta(idContainer[0], theMeta);
            return (T)theMeta;
        }
        catch (KettleException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(this.persistentClass, (String)"JobTrans.Exception.MetaDataLoad", (String[])new String[0]), (Throwable)e);
        }
    }

    private void cacheMeta(String cacheKey, T theMeta) {
        if (theMeta != null && this.metaFileCache != null) {
            if (this.isTransMeta()) {
                TransMeta transMeta = (TransMeta)theMeta;
                transMeta.setMetaFileCache(this.metaFileCache);
                if (cacheKey != null) {
                    this.metaFileCache.cacheMeta(this.metaFileCache.getKey(this.specificationMethod, cacheKey), transMeta);
                }
            } else {
                JobMeta jobMeta = (JobMeta)theMeta;
                jobMeta.setMetaFileCache(this.metaFileCache);
                if (cacheKey != null) {
                    this.metaFileCache.cacheMeta(this.metaFileCache.getKey(this.specificationMethod, cacheKey), jobMeta);
                }
            }
        }
    }

    private T attemptLoadMeta(String realFilename, Repository rep, IMetaStore metaStore, VariableSpace jobSpace, VariableSpace transSpace, String[] idContainer) throws KettleException {
        AbstractMeta theMeta = null;
        theMeta = (AbstractMeta)this.attemptCacheRead(realFilename);
        if (theMeta == null) {
            theMeta = this.isTransMeta() ? new TransMeta(realFilename, metaStore, null, true, transSpace, null) : new JobMeta(jobSpace, realFilename, rep, metaStore, null);
            idContainer[0] = realFilename;
        }
        return (T)theMeta;
    }

    private T getMetaFromRepository(Repository rep, CurrentDirectoryResolver r, String metaPath, VariableSpace tmpSpace) throws KettleException {
        String realName = "";
        String realDirectory = "/";
        if (StringUtils.isBlank((String)metaPath)) {
            if (this.isTransMeta()) {
                throw new KettleException(BaseMessages.getString(this.persistentClass, (String)"JobTrans.Exception.MissingTransFileName", (String[])new String[0]));
            }
            throw new KettleException(BaseMessages.getString(this.persistentClass, (String)"JobJob.Exception.MissingJobFileName", (String[])new String[0]));
        }
        int index = metaPath.lastIndexOf("/");
        if (index != -1) {
            realName = metaPath.substring(index + 1);
            realDirectory = index == 0 ? "/" : metaPath.substring(0, index);
        }
        realDirectory = r.normalizeSlashes(realDirectory);
        RepositoryDirectoryInterface repositoryDirectory = rep.loadRepositoryDirectoryTree().findDirectory(realDirectory);
        if (repositoryDirectory == null) {
            throw new KettleException("Unable to find repository directory [" + Const.NVL((String)realDirectory, (String)"") + "]");
        }
        AbstractMeta theMeta = null;
        if (this.isTransMeta()) {
            theMeta = rep.loadTransformation(realName, repositoryDirectory, null, true, null);
        } else {
            JobMeta jobMeta = rep.loadJob(realName, repositoryDirectory, null, null);
            if (jobMeta != null) {
                jobMeta.initializeVariablesFrom(tmpSpace);
            }
            theMeta = jobMeta;
        }
        return (T)theMeta;
    }

    private T attemptCacheRead(String realFilename) {
        if ("N".equalsIgnoreCase(System.getProperty("KETTLE_USE_META_FILE_CACHE", "N")) || this.metaFileCache == null) {
            return null;
        }
        return (T)(this.isTransMeta() ? this.metaFileCache.getCachedTransMeta(this.metaFileCache.getKey(this.specificationMethod, realFilename)) : this.metaFileCache.getCachedJobMeta(this.metaFileCache.getKey(this.specificationMethod, realFilename)));
    }

    private boolean isTransMeta() {
        return TransMeta.class.isAssignableFrom(this.persistentClass);
    }

    @Override
    public T getMetaForStep(Repository rep, IMetaStore metaStore, VariableSpace space) throws KettleException {
        this.metaFileCache = this.baseStepMeta.getParentStepMeta() == null || this.baseStepMeta.getParentStepMeta().getParentTransMeta() == null ? null : this.baseStepMeta.getParentStepMeta().getParentTransMeta().getMetaFileCache();
        AbstractMeta theMeta = null;
        CurrentDirectoryResolver r = new CurrentDirectoryResolver();
        VariableSpace tmpSpace = this.isTransMeta() ? r.resolveCurrentDirectory(this.specificationMethod, MetaFileLoaderImpl.getVarSpaceOnlyWithRequiredParentVars(space), rep, this.baseStepMeta.getParentStepMeta(), this.filename) : r.resolveCurrentDirectory(this.specificationMethod, space, rep, this.baseStepMeta.getParentStepMeta(), this.filename);
        String[] idContainer = new String[1];
        switch (this.specificationMethod) {
            case FILENAME: {
                String realFilename = tmpSpace.environmentSubstitute(this.filename);
                if (this.isTransMeta() && space != null) {
                    realFilename = space.environmentSubstitute(realFilename);
                }
                if ((theMeta = (AbstractMeta)this.attemptCacheRead(realFilename)) != null) break;
                try {
                    if (rep != null) {
                        theMeta = this.getMetaFromRepository2(realFilename, rep, r, idContainer);
                    }
                    if (theMeta != null) break;
                    theMeta = this.attemptLoadMeta(realFilename, rep, metaStore, null, tmpSpace, idContainer);
                    LogChannel.GENERAL.logDetailed("Loading " + this.friendlyMetaType + " from repository", new Object[]{this.friendlyMetaType + " was loaded from XML file [" + realFilename + "]"});
                    break;
                }
                catch (Exception e) {
                    if (this.isTransMeta()) {
                        throw new KettleException(BaseMessages.getString(this.persistentClass, (String)"StepWithMappingMeta.Exception.UnableToLoadTrans", (String[])new String[0]), (Throwable)e);
                    }
                    throw new KettleException(BaseMessages.getString(this.persistentClass, (String)"JobExecutorMeta.Exception.UnableToLoadJob", (String[])new String[0]), (Throwable)e);
                }
            }
            case REPOSITORY_BY_NAME: {
                String cacheKey;
                String realMetaName = tmpSpace.environmentSubstitute(Const.NVL((String)this.metaName, (String)""));
                String realDirectory = tmpSpace.environmentSubstitute(Const.NVL((String)this.directory, (String)""));
                if (this.isTransMeta() && space != null) {
                    realMetaName = space.environmentSubstitute(realMetaName);
                    realDirectory = space.environmentSubstitute(realDirectory);
                }
                if (Utils.isEmpty((CharSequence)realDirectory) && !Utils.isEmpty((CharSequence)realMetaName)) {
                    int index = realMetaName.lastIndexOf(47);
                    String transPath = realMetaName;
                    realMetaName = realMetaName.substring(index + 1);
                    realDirectory = transPath.substring(0, index);
                }
                if ((theMeta = this.attemptCacheRead(cacheKey = realDirectory + "/" + realMetaName)) != null) break;
                if (rep != null) {
                    RepositoryDirectoryInterface repdir;
                    if (Utils.isEmpty((CharSequence)realMetaName) || Utils.isEmpty((CharSequence)realDirectory) || (repdir = rep.findDirectory(realDirectory = r.normalizeSlashes(realDirectory))) == null) break;
                    try {
                        AbstractMeta abstractMeta = theMeta = this.isTransMeta() ? rep.loadTransformation(realMetaName, repdir, null, true, null) : rep.loadJob(realMetaName, repdir, null, null);
                        if (theMeta != null) {
                            idContainer[0] = cacheKey;
                        }
                        LogChannel.GENERAL.logDetailed("Loading " + this.friendlyMetaType + " from repository", new Object[]{"Executor " + this.friendlyMetaType + " [" + realMetaName + "] was loaded from the repository"});
                        break;
                    }
                    catch (Exception e) {
                        throw new KettleException("Unable to load " + this.friendlyMetaType + " [" + realMetaName + "]", (Throwable)e);
                    }
                }
                try {
                    theMeta = this.attemptLoadMeta(cacheKey, rep, metaStore, null, tmpSpace, idContainer);
                    break;
                }
                catch (KettleException ke) {
                    try {
                        String extension = this.isTransMeta() ? "ktr" : "kjb";
                        theMeta = this.attemptLoadMeta(cacheKey + "." + extension, rep, metaStore, null, tmpSpace, idContainer);
                        if (idContainer[0] == null) break;
                        idContainer[0] = cacheKey;
                        break;
                    }
                    catch (KettleException ke2) {
                        if (this.isTransMeta()) {
                            throw new KettleException(BaseMessages.getString(this.persistentClass, (String)"StepWithMappingMeta.Exception.UnableToLoadTrans", (String[])new String[]{realMetaName}) + realDirectory);
                        }
                        throw new KettleException(BaseMessages.getString(this.persistentClass, (String)"JobExecutorMeta.Exception.UnableToLoadJob", (String[])new String[]{realMetaName}) + realDirectory);
                    }
                }
            }
            case REPOSITORY_BY_REFERENCE: {
                theMeta = (AbstractMeta)this.attemptCacheRead(this.metaObjectId.toString());
                if (theMeta != null) break;
                AbstractMeta abstractMeta = theMeta = this.isTransMeta() ? rep.loadTransformation(this.metaObjectId, null) : rep.loadJob(this.metaObjectId, null);
                if (theMeta == null) break;
                idContainer[0] = this.metaObjectId.toString();
                break;
            }
        }
        this.cacheMeta(idContainer[0], theMeta);
        return (T)theMeta;
    }

    private static VariableSpace getVarSpaceOnlyWithRequiredParentVars(VariableSpace parentSpace) {
        Variables tmpSpace = new Variables();
        if (parentSpace != null) {
            tmpSpace.setVariable("Internal.Entry.Current.Directory", parentSpace.getVariable("Internal.Entry.Current.Directory"));
            tmpSpace.setVariable("Internal.Job.Filename.Directory", parentSpace.getVariable("Internal.Job.Filename.Directory"));
            tmpSpace.setVariable("Internal.Transformation.Filename.Directory", parentSpace.getVariable("Internal.Transformation.Filename.Directory"));
            tmpSpace.setVariable("Internal.Job.Filename.Name", parentSpace.getVariable("Internal.Job.Filename.Name"));
        }
        return tmpSpace;
    }

    private T getMetaFromRepository2(String realFilename, Repository rep, CurrentDirectoryResolver r, String[] idContainer) throws KettleException {
        AbstractMeta theMeta;
        block5: {
            theMeta = null;
            String normalizedFilename = r.normalizeSlashes(realFilename);
            try {
                String dirStr = normalizedFilename.substring(0, normalizedFilename.lastIndexOf("/"));
                String tmpFilename = normalizedFilename.substring(normalizedFilename.lastIndexOf("/") + 1);
                RepositoryDirectoryInterface dir = rep.findDirectory(dirStr);
                theMeta = this.isTransMeta() ? rep.loadTransformation(tmpFilename, dir, null, true, null) : rep.loadJob(tmpFilename, dir, null, null);
            }
            catch (KettleException ke) {
                String extension;
                String string = extension = this.isTransMeta() ? "ktr" : "kjb";
                if (!normalizedFilename.endsWith(extension)) break block5;
                try {
                    String tmpFilename = normalizedFilename.substring(realFilename.lastIndexOf("/") + 1, normalizedFilename.indexOf("." + extension));
                    String dirStr = normalizedFilename.substring(0, normalizedFilename.lastIndexOf("/"));
                    RepositoryDirectoryInterface dir = rep.findDirectory(dirStr);
                    theMeta = this.isTransMeta() ? rep.loadTransformation(tmpFilename, dir, null, true, null) : rep.loadJob(tmpFilename, dir, null, null);
                }
                catch (KettleException kettleException) {
                    // empty catch block
                }
            }
        }
        if (theMeta != null) {
            idContainer[0] = realFilename;
        }
        return (T)theMeta;
    }
}

