/*
 * Decompiled with CFR 0.152.
 */
package com.totvscrm.pentaho.step.upsertdelete;

import com.totvscrm.pentaho.step.upsertdelete.UpsertDelete;
import com.totvscrm.pentaho.step.upsertdelete.UpsertDeleteData;
import com.totvscrm.pentaho.step.upsertdelete.UpsertDeleteDialog;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="UpsertDelete", image="upsertdelete.png", i18nPackageName="com.totvscrm.pentaho.step.upsertdelete", name="UpsertDelete.Name", description="UpsertDelete.TooltipDesc", categoryDescription="UpsertDelete.CategoryName", documentationUrl="https://wsintegracoes.webnode.com/upsertdelete/", casesUrl="https://wsintegracoes.webnode.com/upsertdelete/", forumUrl="https://wsintegracoes.webnode.com/upsertdelete/")
public class UpsertDeleteMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = UpsertDeleteMeta.class;
    private List<? extends SharedObjectInterface> databases;
    private DatabaseMeta databaseMeta;
    private String flag;
    private String[] fieldStream = new String[0];
    private String tableName;
    private String schemaName;
    private String commitSize = "1000";
    private String[] fieldDatabase = new String[0];
    private boolean useBatchUpdate = true;
    private boolean useSequence;
    private String sequenceName;
    private String valuename;
    private boolean isNumber;
    private String startAt;
    private String incrementBy;
    private String maxValue;
    @Injection(name="COMMIT_SIZE")
    private String commitSizeUp = "100";
    @Injection(name="BATCH_UPDATE")
    private boolean useBatchUpdateUp;
    @Injection(name="KEY_STREAM", group="KEYS")
    private String[] keyStream;
    @Injection(name="KEY_STREAM2", group="KEYS")
    private String[] keyStream2;
    @Injection(name="UPDATE_LOOKUP", group="UPDATES")
    private String[] updateLookup;
    @Injection(name="KEY_CONDITION", group="KEYS")
    private String[] keyCondition;
    @Injection(name="KEY_LOOKUP", group="KEYS")
    private String[] keyLookup;
    @Injection(name="UPDATE_STREAM", group="UPDATES")
    private String[] updateStream;
    private boolean logDB;
    private String camposInativa;
    private String[] keyStreamDel;
    private String[] keyStreamDel2;
    private String[] keyConditionDel;
    private String[] keyLookupDel;
    private String commitSizeDel;
    private boolean delete;
    private boolean inativa;
    private boolean checkBool;
    private String comboInativa;

    @Injection(name="CONNECTIONNAME")
    public void setConnection(String connectionName) {
        this.databaseMeta = DatabaseMeta.findDatabase(this.databases, (String)connectionName);
    }

    public UpsertDeleteMeta() {
        this.log = KettleLogStore.getLogChannelInterfaceFactory().create((Object)this);
    }

    public StepDialogInterface getDialog(Shell shell, StepMetaInterface meta, TransMeta transMeta, String name) {
        return new UpsertDeleteDialog(shell, meta, transMeta, name);
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans disp) {
        return new UpsertDelete(stepMeta, stepDataInterface, cnr, transMeta, disp);
    }

    public StepDataInterface getStepData() {
        return new UpsertDeleteData();
    }

    public void allocate(int nrRows) {
        this.fieldStream = new String[nrRows];
        this.fieldDatabase = new String[nrRows];
    }

    public void allocate(int nrkeys, int nrvalues) {
        this.keyStream = new String[nrkeys];
        this.keyLookup = new String[nrkeys];
        this.keyCondition = new String[nrkeys];
        this.keyStream2 = new String[nrkeys];
        this.updateLookup = new String[nrvalues];
        this.updateStream = new String[nrvalues];
    }

    public void allocateDel(int nrkeys) {
        this.keyStreamDel = new String[nrkeys];
        this.keyLookupDel = new String[nrkeys];
        this.keyConditionDel = new String[nrkeys];
        this.keyStreamDel2 = new String[nrkeys];
    }

    public void setDefault() {
        int i;
        this.databaseMeta = null;
        this.flag = "DIF";
        this.useSequence = true;
        this.sequenceName = "SEQ_";
        this.valuename = "valuename";
        this.startAt = "1";
        this.incrementBy = "1";
        this.maxValue = "999999999";
        this.isNumber = false;
        this.logDB = false;
        this.keyStream = null;
        this.updateLookup = null;
        this.databaseMeta = null;
        this.commitSize = "1000";
        this.commitSizeUp = "100";
        this.schemaName = "";
        this.tableName = BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.DefaultTableName", (String[])new String[0]);
        int nrkeys = 0;
        int nrvalues = 0;
        this.allocate(nrkeys, nrvalues);
        for (i = 0; i < nrkeys; ++i) {
            this.keyLookup[i] = "age";
            this.keyCondition[i] = "BETWEEN";
            this.keyStream[i] = "age_from";
            this.keyStream2[i] = "age_to";
        }
        for (i = 0; i < nrvalues; ++i) {
            this.updateLookup[i] = BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.ColumnName.ReturnField", (String[])new String[0]) + i;
            this.updateStream[i] = BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.ColumnName.NewName", (String[])new String[0]) + i;
        }
        this.delete = false;
        this.inativa = true;
        this.checkBool = false;
        this.comboInativa = "Selecione...";
        this.keyStreamDel = null;
        this.commitSizeDel = "100";
        int nrkeysDel = 0;
        this.allocateDel(nrkeysDel);
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
    }

    public String getFlag() {
        return this.flag;
    }

    public void setFlag(String flag) {
        this.flag = flag;
    }

    public String[] getFieldStream() {
        return this.fieldStream;
    }

    public void setFieldStream(String[] fieldStream) {
        this.fieldStream = fieldStream;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(String commitSize) {
        this.commitSize = commitSize;
    }

    public String[] getFieldDatabase() {
        return this.fieldDatabase;
    }

    public void setFieldDatabase(String[] fieldDatabase) {
        this.fieldDatabase = fieldDatabase;
    }

    public boolean useBatchUpdate() {
        return this.useBatchUpdate;
    }

    public void setUseBatchUpdate(boolean useBatchUpdate) {
        this.useBatchUpdate = useBatchUpdate;
    }

    public boolean useSequence() {
        return this.useSequence;
    }

    public void setUseSequence(boolean useSequence) {
        this.useSequence = useSequence;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public String getValuename() {
        return this.valuename;
    }

    public void setValuename(String valuename) {
        this.valuename = valuename;
    }

    public boolean isNumber() {
        return this.isNumber;
    }

    public void setNumber(boolean isNumber) {
        this.isNumber = isNumber;
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = Long.toString(maxValue);
    }

    public void setStartAt(long startAt) {
        this.startAt = Long.toString(startAt);
    }

    public void setIncrementBy(long incrementBy) {
        this.incrementBy = Long.toString(incrementBy);
    }

    public String getStartAt() {
        return this.startAt;
    }

    public void setStartAt(String startAt) {
        this.startAt = startAt;
    }

    public String getIncrementBy() {
        return this.incrementBy;
    }

    public void setIncrementBy(String incrementBy) {
        this.incrementBy = incrementBy;
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    @Deprecated
    public int getCommitSizeUp() {
        return Integer.parseInt(this.commitSizeUp);
    }

    public String getCommitSizeVar() {
        return this.commitSizeUp;
    }

    public int getCommitSizeUp(VariableSpace vs) {
        this.commitSizeUp = this.commitSizeUp == null ? "0" : this.commitSizeUp;
        return Integer.parseInt(vs.environmentSubstitute(this.commitSizeUp));
    }

    @Deprecated
    public void setCommitSizeUp(int commitSizeUp) {
        this.commitSizeUp = Integer.toString(commitSizeUp);
    }

    public void setCommitSizeUp(String commitSizeUp) {
        this.commitSizeUp = commitSizeUp;
    }

    public boolean useBatchUpdateUp() {
        return this.useBatchUpdateUp;
    }

    public void setUseBatchUpdateUp(boolean useBatchUpdateUp) {
        this.useBatchUpdateUp = useBatchUpdateUp;
    }

    public String[] getKeyStream() {
        return this.keyStream;
    }

    public void setKeyStream(String[] keyStream) {
        this.keyStream = keyStream;
    }

    public String[] getKeyStream2() {
        return this.keyStream2;
    }

    public void setKeyStream2(String[] keyStream2) {
        this.keyStream2 = keyStream2;
    }

    public String[] getUpdateLookup() {
        return this.updateLookup;
    }

    public void setUpdateLookup(String[] updateLookup) {
        this.updateLookup = updateLookup;
    }

    public String[] getKeyCondition() {
        return this.keyCondition;
    }

    public void setKeyCondition(String[] keyCondition) {
        this.keyCondition = keyCondition;
    }

    public String[] getKeyLookup() {
        return this.keyLookup;
    }

    public void setKeyLookup(String[] keyLookup) {
        this.keyLookup = keyLookup;
    }

    public String[] getUpdateStream() {
        return this.updateStream;
    }

    public void setUpdateStream(String[] updateStream) {
        this.updateStream = updateStream;
    }

    public String[] getKeyStreamDel() {
        return this.keyStreamDel;
    }

    public void setKeyStreamDel(String[] keyStreamDel) {
        this.keyStreamDel = keyStreamDel;
    }

    public String[] getKeyStreamDel2() {
        return this.keyStreamDel2;
    }

    public void setKeyStreamDel2(String[] keyStreamDel2) {
        this.keyStreamDel2 = keyStreamDel2;
    }

    public String[] getKeyConditionDel() {
        return this.keyConditionDel;
    }

    public void setKeyConditionDel(String[] keyConditionDel) {
        this.keyConditionDel = keyConditionDel;
    }

    public String[] getKeyLookupDel() {
        return this.keyLookupDel;
    }

    public void setKeyLookupDel(String[] keyLookupDel) {
        this.keyLookupDel = keyLookupDel;
    }

    public String getCommitSizeVarDel() {
        return this.commitSizeDel;
    }

    @Deprecated
    public int getCommitSizeDel() {
        return Integer.parseInt(this.commitSizeDel);
    }

    public int getCommitSizeDel(VariableSpace vs) {
        this.commitSizeDel = this.commitSizeDel == null ? "0" : this.commitSizeDel;
        return Integer.parseInt(vs.environmentSubstitute(this.commitSizeDel));
    }

    @Deprecated
    public void setCommitSizeDel(int commitSizeDel) {
        this.commitSizeDel = Integer.toString(commitSizeDel);
    }

    public void setCommitSizeDel(String commitSizeDel) {
        this.commitSizeDel = commitSizeDel;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean isInativa() {
        return this.inativa;
    }

    public void setInativa(boolean inativa) {
        this.inativa = inativa;
    }

    public String getCamposInativa() {
        return this.camposInativa;
    }

    public void setCamposInativa(String camposInativa) {
        this.camposInativa = camposInativa;
    }

    public boolean isCheckBool() {
        return this.checkBool;
    }

    public void setCheckBool(boolean checkBool) {
        this.checkBool = checkBool;
    }

    public String getComboInativa() {
        return this.comboInativa;
    }

    public void setComboInativa(String comboInativa) {
        this.comboInativa = comboInativa;
    }

    public boolean isLogDB() {
        return this.logDB;
    }

    public void setLogDB(boolean logupdate) {
        this.logDB = logupdate;
    }

    public Object clone() {
        UpsertDeleteMeta retval = (UpsertDeleteMeta)((Object)super.clone());
        int nrRows = this.fieldStream.length;
        retval.allocate(nrRows);
        System.arraycopy(this.fieldStream, 0, retval.fieldStream, 0, nrRows);
        System.arraycopy(this.fieldDatabase, 0, retval.fieldDatabase, 0, nrRows);
        int nrkeys = this.keyStream.length;
        int nrvalues = this.updateLookup.length;
        retval.allocate(nrkeys, nrvalues);
        System.arraycopy(this.keyStream, 0, retval.keyStream, 0, nrkeys);
        System.arraycopy(this.keyLookup, 0, retval.keyLookup, 0, nrkeys);
        System.arraycopy(this.keyCondition, 0, retval.keyCondition, 0, nrkeys);
        System.arraycopy(this.keyStream2, 0, retval.keyStream2, 0, nrkeys);
        System.arraycopy(this.updateLookup, 0, retval.updateLookup, 0, nrvalues);
        System.arraycopy(this.updateStream, 0, retval.updateStream, 0, nrvalues);
        int nrkeysDel = this.keyStreamDel.length;
        retval.allocateDel(nrkeysDel);
        System.arraycopy(this.keyStreamDel, 0, retval.keyStreamDel, 0, nrkeysDel);
        System.arraycopy(this.keyLookupDel, 0, retval.keyLookupDel, 0, nrkeysDel);
        System.arraycopy(this.keyConditionDel, 0, retval.keyConditionDel, 0, nrkeysDel);
        System.arraycopy(this.keyStreamDel2, 0, retval.keyStreamDel2, 0, nrkeysDel);
        return retval;
    }

    public String getXML() {
        int i;
        StringBuilder retval = new StringBuilder(500);
        retval.append("    ").append(XMLHandler.addTagValue((String)"isnumber", (boolean)this.isNumber));
        retval.append("    ").append(XMLHandler.addTagValue((String)"start_at", (String)this.startAt));
        retval.append("    ").append(XMLHandler.addTagValue((String)"increment_by", (String)this.incrementBy));
        retval.append("    ").append(XMLHandler.addTagValue((String)"max_value", (String)this.maxValue));
        retval.append("    ").append(XMLHandler.addTagValue((String)"flag", (String)this.flag));
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"tableName", (String)this.tableName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"commitSize", (String)this.commitSize));
        retval.append("    " + XMLHandler.addTagValue((String)"use_batch", (boolean)this.useBatchUpdate));
        retval.append("    " + XMLHandler.addTagValue((String)"useSequence", (boolean)this.useSequence));
        retval.append("      ").append(XMLHandler.addTagValue((String)"seqname", (String)this.sequenceName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"valuename", (String)this.valuename));
        retval.append("    <fields>").append(Const.CR);
        for (i = 0; i < this.fieldDatabase.length; ++i) {
            retval.append("        <field>").append(Const.CR);
            retval.append("          ").append(XMLHandler.addTagValue((String)"column_name", (String)this.fieldDatabase[i]));
            retval.append("          ").append(XMLHandler.addTagValue((String)"stream_name", (String)this.fieldStream[i]));
            retval.append("        </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append(" " + XMLHandler.addTagValue((String)"commitUp", (String)this.commitSizeUp));
        retval.append("    " + XMLHandler.addTagValue((String)"use_batchUp", (boolean)this.useBatchUpdateUp));
        retval.append("    " + XMLHandler.addTagValue((String)"log_update", (boolean)this.logDB));
        retval.append("    <lookup>" + Const.CR);
        for (i = 0; i < this.keyStream.length; ++i) {
            retval.append("      <key>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.keyStream[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"fieldUp", (String)this.keyLookup[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"condition", (String)this.keyCondition[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"name2", (String)this.keyStream2[i]));
            retval.append("        </key>" + Const.CR);
        }
        for (i = 0; i < this.updateLookup.length; ++i) {
            retval.append("      <value>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.updateLookup[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"rename", (String)this.updateStream[i]));
            retval.append("        </value>" + Const.CR);
        }
        retval.append("      </lookup>" + Const.CR);
        retval.append("    " + XMLHandler.addTagValue((String)"checkdelete", (boolean)this.delete));
        retval.append("    " + XMLHandler.addTagValue((String)"inativa", (boolean)this.inativa));
        retval.append("    " + XMLHandler.addTagValue((String)"checkbool", (boolean)this.checkBool));
        retval.append("    " + XMLHandler.addTagValue((String)"comboinativa", (String)this.comboInativa));
        retval.append("    ").append(XMLHandler.addTagValue((String)"commitDel", (String)this.commitSizeDel));
        retval.append("    <lookupDel>").append(Const.CR);
        for (i = 0; i < this.keyStreamDel.length; ++i) {
            retval.append("      <keyDel>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"nameDel", (String)this.keyStreamDel[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"fieldDel", (String)this.keyLookupDel[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"conditionDel", (String)this.keyConditionDel[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"nameDel2", (String)this.keyStreamDel2[i]));
            retval.append("      </keyDel>").append(Const.CR);
        }
        retval.append("    </lookupDel>").append(Const.CR);
        return retval.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.databases = databases;
        this.readData(stepnode, databases);
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        int i;
        try {
            rep.saveStepAttribute(id_transformation, id_step, "isnumber", this.isNumber);
            rep.saveStepAttribute(id_transformation, id_step, "start_at", this.startAt);
            rep.saveStepAttribute(id_transformation, id_step, "increment_by", this.incrementBy);
            rep.saveStepAttribute(id_transformation, id_step, "max_value", this.maxValue);
            rep.saveStepAttribute(id_transformation, id_step, "flag", this.flag);
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, "schema", this.schemaName);
            rep.saveStepAttribute(id_transformation, id_step, "tableName", this.tableName);
            rep.saveStepAttribute(id_transformation, id_step, "commitSize", this.commitSize);
            rep.saveStepAttribute(id_transformation, id_step, "use_batch", this.useBatchUpdate);
            rep.saveStepAttribute(id_transformation, id_step, "useSequence", this.useSequence);
            rep.saveStepAttribute(id_transformation, id_step, "seqname", this.sequenceName);
            rep.saveStepAttribute(id_transformation, id_step, "valuename", this.valuename);
            int nrRows = this.fieldDatabase.length < this.fieldStream.length ? this.fieldStream.length : this.fieldDatabase.length;
            for (int idx = 0; idx < nrRows; ++idx) {
                String columnName = idx < this.fieldDatabase.length ? this.fieldDatabase[idx] : "";
                String streamName = idx < this.fieldStream.length ? this.fieldStream[idx] : "";
                rep.saveStepAttribute(id_transformation, id_step, idx, "column_name", columnName);
                rep.saveStepAttribute(id_transformation, id_step, idx, "stream_name", streamName);
            }
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + String.valueOf(id_step), (Throwable)e);
        }
        try {
            rep.saveStepAttribute(id_transformation, id_step, "commitUp", this.commitSizeUp);
            rep.saveStepAttribute(id_transformation, id_step, "use_batchUp", this.useBatchUpdateUp);
            rep.saveStepAttribute(id_transformation, id_step, "log_update", this.logDB);
            for (i = 0; i < this.keyStream.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "key_name", this.keyStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "key_field", this.keyLookup[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "key_condition", this.keyCondition[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "key_name2", this.keyStream2[i]);
            }
            for (i = 0; i < this.updateLookup.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "value_name", this.updateLookup[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "value_rename", this.updateStream[i]);
            }
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"UpdateMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + String.valueOf(id_step), (Throwable)e);
        }
        try {
            rep.saveStepAttribute(id_transformation, id_step, "checkdelete", this.delete);
            rep.saveStepAttribute(id_transformation, id_step, "inativa", this.inativa);
            rep.saveStepAttribute(id_transformation, id_step, "checkbool", this.checkBool);
            rep.saveStepAttribute(id_transformation, id_step, "comboinativa", this.comboInativa);
            rep.saveStepAttribute(id_transformation, id_step, "commitDel", this.commitSizeDel);
            for (i = 0; i < this.keyStreamDel.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "key_nameDel", this.keyStreamDel[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "key_fieldDel", this.keyLookupDel[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "key_conditionDel", this.keyConditionDel[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "key_nameDel2", this.keyStreamDel2[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + String.valueOf(id_step), (Throwable)e);
        }
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int nrStreams;
            this.isNumber = rep.getStepAttributeBoolean(id_step, "isnumber");
            this.startAt = rep.getStepAttributeString(id_step, "start_at");
            this.incrementBy = rep.getStepAttributeString(id_step, "increment_by");
            this.maxValue = rep.getStepAttributeString(id_step, "max_value");
            if (this.startAt == null) {
                long start = rep.getStepAttributeInteger(id_step, "start_at");
                this.startAt = Long.toString(start);
            }
            if (this.incrementBy == null) {
                long increment = rep.getStepAttributeInteger(id_step, "increment_by");
                this.incrementBy = Long.toString(increment);
            }
            if (this.maxValue == null) {
                long max = rep.getStepAttributeInteger(id_step, "max_value");
                this.maxValue = Long.toString(max);
            }
            this.flag = rep.getStepAttributeString(id_step, "flag");
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.schemaName = rep.getStepAttributeString(id_step, "schema");
            this.tableName = rep.getStepAttributeString(id_step, "tableName");
            this.commitSize = rep.getStepAttributeString(id_step, "commitSize");
            this.useBatchUpdate = rep.getStepAttributeBoolean(id_step, "use_batch");
            this.useSequence = rep.getStepAttributeBoolean(id_step, "useSequence");
            this.sequenceName = rep.getStepAttributeString(id_step, "seqname");
            this.valuename = rep.getStepAttributeString(id_step, "valuename");
            int nrCols = rep.countNrStepAttributes(id_step, "column_name");
            int nrRows = nrCols < (nrStreams = rep.countNrStepAttributes(id_step, "stream_name")) ? nrStreams : nrCols;
            this.allocate(nrRows);
            for (int idx = 0; idx < nrRows; ++idx) {
                this.fieldDatabase[idx] = Const.NVL((String)rep.getStepAttributeString(id_step, idx, "column_name"), (String)"");
                this.fieldStream[idx] = Const.NVL((String)rep.getStepAttributeString(id_step, idx, "stream_name"), (String)"");
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.Exception.UnexpectedErrorInReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
        this.databases = databases;
        try {
            int i;
            this.commitSizeUp = rep.getStepAttributeString(id_step, "commitUp");
            if (this.commitSizeUp == null) {
                long comSz = -1L;
                try {
                    comSz = rep.getStepAttributeInteger(id_step, "commitUp");
                }
                catch (Exception ex) {
                    this.commitSizeUp = "100";
                }
                if (comSz >= 0L) {
                    this.commitSizeUp = Long.toString(comSz);
                }
            }
            this.useBatchUpdateUp = rep.getStepAttributeBoolean(id_step, "use_batchUp");
            this.logDB = rep.getStepAttributeBoolean(id_step, "log_update");
            int nrkeys = rep.countNrStepAttributes(id_step, "key_name");
            int nrvalues = rep.countNrStepAttributes(id_step, "value_name");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                this.keyStream[i] = rep.getStepAttributeString(id_step, i, "key_name");
                this.keyLookup[i] = rep.getStepAttributeString(id_step, i, "key_field");
                this.keyCondition[i] = rep.getStepAttributeString(id_step, i, "key_condition");
                this.keyStream2[i] = rep.getStepAttributeString(id_step, i, "key_name2");
            }
            for (i = 0; i < nrvalues; ++i) {
                this.updateLookup[i] = rep.getStepAttributeString(id_step, i, "value_name");
                this.updateStream[i] = rep.getStepAttributeString(id_step, i, "value_rename");
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
        try {
            this.delete = rep.getStepAttributeBoolean(id_step, "checkdelete");
            this.inativa = rep.getStepAttributeBoolean(id_step, "inativa");
            this.checkBool = rep.getStepAttributeBoolean(id_step, "checkbool");
            this.comboInativa = rep.getStepAttributeString(id_step, "comboinativa");
            this.commitSizeDel = rep.getStepAttributeString(id_step, "commitDel");
            if (this.commitSizeDel == null) {
                long comSzDel = -1L;
                try {
                    comSzDel = rep.getStepAttributeInteger(id_step, "commitDel");
                }
                catch (Exception ex) {
                    this.commitSizeDel = "100";
                }
                if (comSzDel >= 0L) {
                    this.commitSizeDel = Long.toString(comSzDel);
                }
            }
            int nrkeysDel = rep.countNrStepAttributes(id_step, "key_nameDel");
            this.allocateDel(nrkeysDel);
            for (int i = 0; i < nrkeysDel; ++i) {
                this.keyStreamDel[i] = rep.getStepAttributeString(id_step, i, "key_nameDel");
                this.keyLookupDel[i] = rep.getStepAttributeString(id_step, i, "key_fieldDel");
                this.keyConditionDel[i] = rep.getStepAttributeString(id_step, i, "key_conditionDel");
                this.keyStreamDel2[i] = rep.getStepAttributeString(id_step, i, "key_nameDel2");
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.Exception.UnexpectedErrorInReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.isNumber = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"isnumber"));
            this.startAt = XMLHandler.getTagValue((Node)stepnode, (String)"start_at");
            this.incrementBy = XMLHandler.getTagValue((Node)stepnode, (String)"increment_by");
            this.maxValue = XMLHandler.getTagValue((Node)stepnode, (String)"max_value");
            this.setFlag(XMLHandler.getNodeValue((Node)XMLHandler.getSubNode((Node)stepnode, (String)"flag")));
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            this.schemaName = XMLHandler.getTagValue((Node)stepnode, (String)"schema");
            this.tableName = XMLHandler.getTagValue((Node)stepnode, (String)"tableName");
            this.commitSize = XMLHandler.getTagValue((Node)stepnode, (String)"commitSize");
            this.useBatchUpdate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"use_batch"));
            this.useSequence = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"useSequence"));
            this.sequenceName = XMLHandler.getTagValue((Node)stepnode, (String)"seqname");
            this.valuename = XMLHandler.getTagValue((Node)stepnode, (String)"valuename");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrRows = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrRows);
            for (int i = 0; i < nrRows; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldDatabase[i] = XMLHandler.getTagValue((Node)knode, (String)"column_name");
                this.fieldStream[i] = XMLHandler.getTagValue((Node)knode, (String)"stream_name");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.Exception.UnableToReadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
        try {
            int i;
            String csize = XMLHandler.getTagValue((Node)stepnode, (String)"commitUp");
            this.commitSizeUp = csize == null ? "0" : csize;
            this.useBatchUpdateUp = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"use_batchUp"));
            this.logDB = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"log_update"));
            Node lookup = XMLHandler.getSubNode((Node)stepnode, (String)"lookup");
            int nrkeys = XMLHandler.countNodes((Node)lookup, (String)"key");
            int nrvalues = XMLHandler.countNodes((Node)lookup, (String)"value");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"key", (int)i);
                this.keyStream[i] = XMLHandler.getTagValue((Node)knode, (String)"name");
                this.keyLookup[i] = XMLHandler.getTagValue((Node)knode, (String)"fieldUp");
                this.keyCondition[i] = XMLHandler.getTagValue((Node)knode, (String)"condition");
                if (this.keyCondition[i] == null) {
                    this.keyCondition[i] = "=";
                }
                this.keyStream2[i] = XMLHandler.getTagValue((Node)knode, (String)"name2");
            }
            for (i = 0; i < nrvalues; ++i) {
                Node vnode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"value", (int)i);
                this.updateLookup[i] = XMLHandler.getTagValue((Node)vnode, (String)"name");
                this.updateStream[i] = XMLHandler.getTagValue((Node)vnode, (String)"rename");
                if (this.updateStream[i] != null) continue;
                this.updateStream[i] = this.updateLookup[i];
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"UpdateMeta.Exception.UnableToReadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
        try {
            this.delete = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"checkdelete"));
            this.inativa = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"inativa"));
            this.checkBool = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"checkbool"));
            this.comboInativa = XMLHandler.getTagValue((Node)stepnode, (String)"comboinativa");
            String csizeDel = XMLHandler.getTagValue((Node)stepnode, (String)"commitDel");
            this.commitSizeDel = csizeDel != null ? csizeDel : "0";
            Node lookupDel = XMLHandler.getSubNode((Node)stepnode, (String)"lookupDel");
            int nrkeysDel = XMLHandler.countNodes((Node)lookupDel, (String)"keyDel");
            this.allocateDel(nrkeysDel);
            for (int i = 0; i < nrkeysDel; ++i) {
                Node knodeDel = XMLHandler.getSubNodeByNr((Node)lookupDel, (String)"keyDel", (int)i);
                this.keyStreamDel[i] = XMLHandler.getTagValue((Node)knodeDel, (String)"nameDel");
                this.keyLookupDel[i] = XMLHandler.getTagValue((Node)knodeDel, (String)"fieldDel");
                this.keyConditionDel[i] = XMLHandler.getTagValue((Node)knodeDel, (String)"conditionDel");
                if (this.keyConditionDel[i] == null) {
                    this.keyConditionDel[i] = "=";
                }
                this.keyStreamDel2[i] = XMLHandler.getTagValue((Node)knodeDel, (String)"nameDel2");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.Exception.UnableToReadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (this.useSequence) {
            ValueMetaInteger v = new ValueMetaInteger(space.environmentSubstitute(this.valuename));
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (this.databaseMeta != null) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.CheckResult.ConnectionExists", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            Database db = new Database(loggingObject, this.databaseMeta);
            db.shareVariablesWith((VariableSpace)transMeta);
            try {
                db.connect();
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.CheckResult.ConnectionOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
                if (!this.tableName.equals("") && this.tableName != null) {
                    String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(db.environmentSubstitute(this.schemaName), db.environmentSubstitute(this.tableName));
                    if (db.checkTableExists(schemaTable)) {
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.CheckResult.TableAccessible", (String[])new String[]{schemaTable}), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                        RowMetaInterface r = db.getTableFields(schemaTable);
                        if (r != null) {
                            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.CheckResult.TableOk", (String[])new String[]{schemaTable}), (CheckResultSourceInterface)stepMeta);
                            remarks.add((CheckResultInterface)cr);
                            Object error_message = "";
                            boolean error_found = false;
                            if (prev != null && prev.size() > 0) {
                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (CheckResultSourceInterface)stepMeta);
                                remarks.add((CheckResultInterface)cr);
                                for (int i = 0; i < this.getFieldDatabase().length; ++i) {
                                    int idx = r.indexOfValue(this.getFieldDatabase()[i]);
                                    if (idx >= 0) continue;
                                    error_message = (String)error_message + "\t\t" + this.getFieldDatabase()[i] + Const.CR;
                                    error_found = true;
                                }
                                if (error_found) {
                                    error_message = BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.CheckResult.FieldsSpecifiedNotInTable", (String[])new String[]{error_message});
                                    cr = new CheckResult(4, (String)error_message, (CheckResultSourceInterface)stepMeta);
                                    remarks.add((CheckResultInterface)cr);
                                } else {
                                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.CheckResult.AllFieldsFoundInOutput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                                    remarks.add((CheckResultInterface)cr);
                                }
                                error_message = "";
                            }
                            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.CheckResult.NoFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                            remarks.add((CheckResultInterface)cr);
                        }
                        cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.CheckResult.TableNotAccessible", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.CheckResult.TableError", (String[])new String[]{schemaTable}), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.CheckResult.NoTableName", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            catch (KettleException e) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.CheckResult.UndefinedError", (String[])new String[]{e.getMessage()}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.CheckResult.NoConnection", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, Repository repository, IMetaStore metaStore) {
        return this.getSQLStatements(transMeta, stepMeta, prev, null, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String tk, boolean use_autoinc, String pk) {
        Database db;
        SQLStatement retval = new SQLStatement(stepMeta.getName(), this.databaseMeta, null);
        if (!this.isNumber) {
            if (this.databaseMeta != null) {
                db = new Database(loggingObject, this.databaseMeta);
                db.shareVariablesWith((VariableSpace)transMeta);
                try {
                    db.connect();
                    if (!db.checkSequenceExists(this.schemaName, this.sequenceName)) {
                        String cr_table = db.getCreateSequenceStatement(this.sequenceName, this.startAt, this.incrementBy, this.maxValue, true);
                        retval.setSQL(cr_table);
                    }
                    retval.setSQL(null);
                }
                catch (KettleException e) {
                    retval.setError(BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.ErrorMessage.UnableToConnectDB", (String[])new String[0]) + Const.CR + e.getMessage());
                }
                finally {
                    db.disconnect();
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.ErrorMessage.NoConnectionDefined", (String[])new String[0]));
            }
        }
        if (this.databaseMeta != null) {
            if (prev != null && prev.size() > 0) {
                if (this.tableName != null && !this.tableName.equals("")) {
                    db = new Database(loggingObject, this.databaseMeta);
                    db.shareVariablesWith((VariableSpace)transMeta);
                    try {
                        db.connect();
                        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this.schemaName, this.tableName);
                        String cr_table = db.getDDL(schemaTable, prev, tk, use_autoinc, pk);
                        if (cr_table == null || cr_table.length() == 0) {
                            cr_table = null;
                        }
                        retval.setSQL(cr_table);
                    }
                    catch (KettleDatabaseException dbe) {
                        retval.setError(BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.Error.ErrorConnecting", (String[])new String[]{dbe.getMessage()}));
                    }
                    finally {
                        db.disconnect();
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.Error.NoTable", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.Error.NoInput", (String[])new String[0]));
            }
        } else {
            retval.setError(BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.Error.NoConnection", (String[])new String[0]));
        }
        return retval;
    }

    public RowMetaInterface getRequiredFields(VariableSpace space) throws KettleException {
        String realTableName = space.environmentSubstitute(this.tableName);
        String realSchemaName = space.environmentSubstitute(this.schemaName);
        if (this.databaseMeta != null) {
            Database db = new Database(loggingObject, this.databaseMeta);
            try {
                db.connect();
                String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(realSchemaName, realTableName);
                if (db.checkTableExists(schemaTable)) {
                    RowMetaInterface rowMetaInterface = db.getTableFields(schemaTable);
                    return rowMetaInterface;
                }
                try {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.Exception.TableNotFound", (String[])new String[0]));
                }
                catch (Exception e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
                }
            }
            finally {
                db.disconnect();
            }
        }
        throw new KettleException(BaseMessages.getString(PKG, (String)"UpsertDeleteMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public boolean supportsErrorHandling() {
        if (this.databaseMeta != null) {
            return this.databaseMeta.getDatabaseInterface().supportsErrorHandling();
        }
        return true;
    }

    public List<String> getStreamFields() {
        return Arrays.asList(this.getFieldStream());
    }
}

