/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.jms;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Destination;
import javax.jms.JMSContext;
import javax.jms.JMSProducer;
import org.apache.commons.lang.BooleanUtils;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.util.serialization.BaseSerializingMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.jms.JmsProducerMeta;

public class JmsProducer
extends BaseStep
implements StepInterface {
    JmsProducerMeta meta;
    @VisibleForTesting
    JMSProducer producer;
    private Destination destination;
    private int messageIndex;
    private JMSContext jmsContext;
    private AtomicBoolean closed = new AtomicBoolean(false);

    public JmsProducer(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean init(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) {
        boolean errorsPresent;
        boolean isInitalized = super.init(stepMetaInterface, stepDataInterface);
        this.meta = (JmsProducerMeta)((BaseSerializingMeta)stepMetaInterface).withVariables((VariableSpace)this);
        ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
        this.meta.check(remarks, this.getTransMeta(), this.meta.getParentStepMeta(), null, null, null, null, this.variables, this.getRepository(), this.getMetaStore());
        boolean bl = errorsPresent = remarks.stream().filter(result -> result.getType() == 4).peek(result -> this.logError(result.getText())).count() > 0L;
        if (errorsPresent) {
            return false;
        }
        return isInitalized;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] row = this.getRow();
        if (null == row) {
            if (this.jmsContext != null) {
                this.jmsContext.close();
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.log.logDebug("Connection Details: " + this.meta.jmsDelegate.getJmsProvider().getConnectionDetails(this.meta.jmsDelegate));
            this.jmsContext = this.meta.jmsDelegate.getJmsContext();
            this.producer = this.jmsContext.createProducer();
            this.destination = this.meta.jmsDelegate.getDestination();
            this.messageIndex = this.getInputRowMeta().indexOfValue(this.meta.getFieldToSend());
            this.setOptions(this.producer);
            for (Map.Entry<String, String> entry : this.meta.getPropertyValuesByName().entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                this.logDebug("Setting Jms Property Name: " + key + ", Value: " + value);
                this.producer.setProperty(key, value);
            }
            this.first = false;
        }
        if (this.closed.get()) {
            return false;
        }
        this.producer.send(this.destination, (String)Optional.ofNullable(row[this.messageIndex]).map(Object::toString).orElse(null));
        this.putRow(this.getInputRowMeta(), row);
        return true;
    }

    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) {
        if (this.jmsContext != null && !this.closed.getAndSet(true)) {
            this.jmsContext.close();
        }
    }

    private void setOptions(JMSProducer producer) {
        String optionValue = this.meta.getDisableMessageId();
        this.getLogChannel().logDebug("Disable Message ID is set to " + optionValue);
        if (!StringUtil.isEmpty((String)optionValue)) {
            producer.setDisableMessageID(BooleanUtils.toBoolean((String)optionValue));
        }
        optionValue = this.meta.getDisableMessageTimestamp();
        this.getLogChannel().logDebug("Disable Message Timestamp is set to " + optionValue);
        if (!StringUtil.isEmpty((String)optionValue)) {
            producer.setDisableMessageTimestamp(BooleanUtils.toBoolean((String)optionValue));
        }
        optionValue = this.meta.getDeliveryMode();
        this.getLogChannel().logDebug("Delivery Mode is set to " + optionValue);
        if (!StringUtil.isEmpty((String)optionValue)) {
            producer.setDeliveryMode(Integer.parseInt(optionValue));
        }
        optionValue = this.meta.getPriority();
        this.getLogChannel().logDebug("Priority is set to " + optionValue);
        if (!StringUtil.isEmpty((String)optionValue)) {
            producer.setPriority(Integer.parseInt(optionValue));
        }
        optionValue = this.meta.getTimeToLive();
        this.getLogChannel().logDebug("Time to Live is set to " + optionValue);
        if (!StringUtil.isEmpty((String)optionValue)) {
            producer.setTimeToLive(Long.parseLong(optionValue));
        }
        optionValue = this.meta.getDeliveryDelay();
        this.getLogChannel().logDebug("Delivery Delay is set to " + optionValue);
        if (!StringUtil.isEmpty((String)optionValue)) {
            producer.setDeliveryDelay(Long.parseLong(optionValue));
        }
        optionValue = this.meta.getJmsCorrelationId();
        this.getLogChannel().logDebug("JMS Correlation ID is set to " + optionValue);
        if (!StringUtil.isEmpty((String)optionValue)) {
            producer.setJMSCorrelationID(optionValue);
        }
        optionValue = this.meta.getJmsType();
        this.getLogChannel().logDebug("JMS Type is set to " + optionValue);
        if (!StringUtil.isEmpty((String)optionValue)) {
            producer.setJMSType(optionValue);
        }
    }
}

