/*
 * Decompiled with CFR 0.152.
 */
package com.totvscrm.pentaho.step.mergeupsertdelete;

import com.totvscrm.pentaho.step.mergeupsertdelete.MergeUpsertDeleteData;
import com.totvscrm.pentaho.step.mergeupsertdelete.MergeUpsertDeleteMeta;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseBatchException;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleRowException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.sort.RowTempFile;

public class MergeUpsertDelete
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MergeUpsertDeleteMeta.class;
    private MergeUpsertDeleteMeta meta;
    private MergeUpsertDeleteData data;
    private int countNew;
    private int countChanged;
    private int countDelete;
    private int countInativa;
    private int countIdentical;
    private ArrayList<Object[]> inativaOBject;
    private ArrayList<Object[]> updateOBject;
    private boolean useRefWhenIdentical = false;
    private boolean operations;
    private static final String VALUE_IDENTICAL = "identical";
    private static final String VALUE_CHANGED = "changed";
    private static final String VALUE_NEW = "new";
    private static final String VALUE_DELETED = "deleted";

    public MergeUpsertDelete(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.operations = false;
        for (int i = 0; i < this.listVariables().length; ++i) {
            if (!this.listVariables()[i].equalsIgnoreCase("LOG_OPERATIONS") || !this.getVariable("LOG_OPERATIONS").equalsIgnoreCase("1")) continue;
            this.operations = true;
        }
        this.meta = (MergeUpsertDeleteMeta)smi;
        this.data = (MergeUpsertDeleteData)sdi;
        this.inativaOBject = new ArrayList();
        this.updateOBject = new ArrayList();
        if (super.init(smi, sdi)) {
            Hashtable hashtable;
            this.data.buffer1 = new ArrayList<Object[]>(5000);
            this.data.buffer2 = new ArrayList<Object[]>(5000);
            this.data.rows1 = new ArrayList<Object[]>(5000);
            this.data.rows2 = new ArrayList<Object[]>(5000);
            this.data.sortSize = 1000000;
            this.data.freeMemoryPctLimit = 0;
            if (this.data.sortSize <= 0 && this.data.freeMemoryPctLimit <= 0) {
                this.data.freeMemoryPctLimit = 25;
            }
            this.data.minSortSize = 5000;
            this.data.rowBuffer1 = new ArrayList<Object[]>(5000);
            this.data.rowBuffer2 = new ArrayList<Object[]>(5000);
            this.data.compressFiles = false;
            this.data.tempRows1 = new ArrayList<RowTempFile>();
            this.data.tempRows2 = new ArrayList<RowTempFile>();
            this.meta.setFlag("DIF");
            this.data.rowsMerge = new ArrayList<Object[]>(5000);
            this.data.realSchemaName = this.environmentSubstitute(this.meta.getSchemaName());
            this.data.realSequenceName = this.environmentSubstitute(this.meta.getSequenceName());
            Database db = new Database((LoggingObjectInterface)this, this.meta.getDatabaseMeta());
            db.shareVariablesWith((VariableSpace)this);
            this.data.setDb(db);
            try {
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    Trans trans = this.getTrans();
                    synchronized (trans) {
                        this.data.getDb().connect(this.getTrans().getTransactionId(), this.getPartitionID());
                    }
                } else {
                    this.data.getDb().connect(this.getPartitionID());
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.ConnectedDB", (String[])new String[0]));
                }
            }
            catch (KettleDatabaseException dbe) {
                this.logError(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.CouldNotConnectToDB", (String[])new String[0]) + dbe.getMessage());
            }
            if (this.meta.isNumber()) {
                boolean doAbort = false;
                try {
                    this.data.start = Long.parseLong(this.environmentSubstitute(this.meta.getStartAt()));
                }
                catch (NumberFormatException ex) {
                    this.logError(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.CouldNotParseCounterValue", (String[])new String[]{"start", this.meta.getStartAt(), this.environmentSubstitute(this.meta.getStartAt()), ex.getMessage()}));
                    doAbort = true;
                }
                try {
                    this.data.increment = Long.parseLong(this.meta.getIncrementBy());
                }
                catch (NumberFormatException ex) {
                    this.logError(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.CouldNotParseCounterValue", (String[])new String[]{"increment", this.meta.getIncrementBy(), this.environmentSubstitute(this.meta.getIncrementBy()), ex.getMessage()}));
                    doAbort = true;
                }
                try {
                    this.data.maximum = Long.parseLong(this.meta.getMaxValue());
                }
                catch (NumberFormatException ex) {
                    this.logError(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.CouldNotParseCounterValue", (String[])new String[]{"increment", this.meta.getMaxValue(), this.environmentSubstitute(this.meta.getMaxValue()), ex.getMessage()}));
                    doAbort = true;
                }
                if (doAbort) {
                    return false;
                }
                this.data.setLookup("@@sequence:" + this.meta.getValuename());
                if (this.getTrans().getCounters() != null) {
                    hashtable = this.getTrans().getCounters();
                    synchronized (hashtable) {
                        this.data.counter = (Counter)this.getTrans().getCounters().get(this.data.getLookup());
                        if (this.data.counter == null) {
                            this.data.counter = new Counter(this.data.start, this.data.increment, this.data.maximum);
                            this.getTrans().getCounters().put(this.data.getLookup(), this.data.counter);
                        } else if (this.data.counter.getStart() != this.data.start || this.data.counter.getIncrement() != this.data.increment || this.data.counter.getMaximum() != this.data.maximum) {
                            this.logError(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.CountersWithDifferentCharacteristics", (String[])new String[]{this.data.getLookup()}));
                            return false;
                        }
                    }
                } else {
                    this.logError(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.TransformationCountersHashtableNotAllocated", (String[])new String[0]));
                }
            }
            try {
                this.data.commitSize = Integer.parseInt(this.environmentSubstitute(this.meta.getCommitSize()));
                if (this.meta.useBatchUpdateUp()) {
                    this.data.commitSizeUp = Integer.parseInt(this.environmentSubstitute(this.meta.getCommitSizeVar()));
                }
                this.data.databaseMeta = this.meta.getDatabaseMeta();
                DatabaseInterface dbInterface = this.data.databaseMeta.getDatabaseInterface();
                this.data.useSafePoints = this.data.databaseMeta.getDatabaseInterface().useSafePoints() && this.getStepMeta().isDoingErrorHandling();
                this.data.releaseSavepoint = dbInterface.releaseSavepoint();
                boolean bl = this.data.batchMode = this.meta.useBatchUpdate() && this.data.commitSize > 0 && !this.getTransMeta().isUsingUniqueConnections() && !this.data.useSafePoints;
                if (this.getStepMeta().isDoingErrorHandling() && !dbInterface.supportsErrorHandlingOnBatchUpdates()) {
                    this.log.logMinimal(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Warning.ErrorHandlingIsNotFullySupportedWithBatchProcessing", (String[])new String[0]));
                }
                if (this.meta.getDatabaseMeta() == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Exception.DatabaseNeedsToBeSelected", (String[])new String[0]));
                }
                if (this.meta.getDatabaseMeta() == null) {
                    this.logError(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Init.ConnectionMissing", (String[])new String[]{this.getStepname()}));
                    return false;
                }
                if (this.log.isBasic()) {
                    this.logBasic("Connected to database [" + String.valueOf(this.meta.getDatabaseMeta()) + "] INSERT = (commit=" + this.data.commitSize + ")  UPDATE = (commit=" + this.data.commitSizeUp + ")  DELETE = (commit=" + this.environmentSubstitute(this.meta.getCommitSizeVarDel() + ")"));
                }
                if (this.data.commitSize == 0) {
                    this.data.commitSize = Integer.MAX_VALUE;
                }
                this.data.db.setCommit(this.data.commitSize);
                this.data.tableName = this.environmentSubstitute(this.meta.getTableName());
                this.data.dbUp = new Database((LoggingObjectInterface)this, this.meta.getDatabaseMeta());
                this.data.dbUp.shareVariablesWith((VariableSpace)this);
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    hashtable = this.getTrans();
                    synchronized (hashtable) {
                        this.data.dbUp.connect(this.getTrans().getTransactionId(), this.getPartitionID());
                    }
                } else {
                    this.data.dbUp.connect(this.getPartitionID());
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.Update.ConnectedToDB", (String[])new String[0]));
                }
                this.data.dbUp.setCommit(this.meta.getCommitSizeUp((VariableSpace)this));
                this.data.dbDel = new Database((LoggingObjectInterface)this, this.meta.getDatabaseMeta());
                this.data.dbDel.shareVariablesWith((VariableSpace)this);
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    hashtable = this.getTrans();
                    synchronized (hashtable) {
                        this.data.dbDel.connect(this.getTrans().getTransactionId(), this.getPartitionID());
                    }
                } else {
                    this.data.dbDel.connect(this.getPartitionID());
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.Delete.ConnectedToDB", (String[])new String[0]));
                }
                this.data.dbDel.setCommit(this.meta.getCommitSizeDel((VariableSpace)this));
                this.data.dbIna = new Database((LoggingObjectInterface)this, this.meta.getDatabaseMeta());
                this.data.dbIna.shareVariablesWith((VariableSpace)this);
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    hashtable = this.getTrans();
                    synchronized (hashtable) {
                        this.data.dbIna.connect(this.getTrans().getTransactionId(), this.getPartitionID());
                    }
                } else {
                    this.data.dbIna.connect(this.getPartitionID());
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.Inativa.ConnectedToDB", (String[])new String[0]));
                }
                this.data.dbIna.setCommit(this.meta.getCommitSizeDel((VariableSpace)this));
                return true;
            }
            catch (KettleException ke) {
                this.logError(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.ErrorOccurred", (String[])new String[0]) + ke.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized Object[] lookupValues(RowMetaInterface rowMeta, Object[] row, int nrRow) throws KettleException {
        Object[] outputRow = row;
        Object[] lookupRow = new Object[this.data.lookupParameterRowMeta.size()];
        int lookupIndex = 0;
        for (int i = 0; i < this.data.keynrs.length; ++i) {
            if (this.data.keynrs[i] >= 0) {
                lookupRow[lookupIndex] = row[this.data.keynrs[i]];
                ++lookupIndex;
            }
            if (this.data.keynrs2[i] < 0) continue;
            lookupRow[lookupIndex] = row[this.data.keynrs2[i]];
            ++lookupIndex;
        }
        RowMetaInterface returnRowMeta = null;
        this.data.dbUp.setValues(this.data.lookupParameterRowMeta, lookupRow, this.data.prepStatementLookup);
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.ValuesSetForLookup", (String[])new String[]{this.data.lookupParameterRowMeta.getString(lookupRow), rowMeta.getString(row)}));
        }
        Object[] add = this.data.dbUp.getLookup(this.data.prepStatementLookup);
        returnRowMeta = this.data.dbUp.getReturnRowMeta();
        this.incrementLinesInput();
        if (add == null) {
            if (!this.getStepMeta().isDoingErrorHandling()) throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Exception.KeyCouldNotFound", (String[])new String[0]) + this.data.lookupParameterRowMeta.getString(lookupRow));
            outputRow = null;
            if (this.data.stringErrorKeyNotFound == null) {
                this.data.stringErrorKeyNotFound = BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Exception.KeyCouldNotFound", (String[])new String[0]) + this.data.lookupParameterRowMeta.getString(lookupRow);
                this.data.stringFieldnames = "";
                for (int i = 0; i < this.data.lookupParameterRowMeta.size(); ++i) {
                    if (i > 0) {
                        this.data.stringFieldnames = this.data.stringFieldnames + ", ";
                    }
                    this.data.stringFieldnames = this.data.stringFieldnames + this.data.lookupParameterRowMeta.getValueMeta(i).getName();
                }
            }
            this.putError(rowMeta, row, 1L, this.data.stringErrorKeyNotFound, this.data.stringFieldnames, "UPD001");
            return outputRow;
        } else {
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.FoundRow", (String[])new String[0]) + this.data.lookupReturnRowMeta.getString(add));
            }
            boolean update = false;
            for (int i = 0; i < returnRowMeta.size(); ++i) {
                Object retvalue;
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(this.data.valuenrsUp[i]);
                Object rowvalue = row[this.data.valuenrsUp[i]];
                ValueMetaInterface returnValueMeta = returnRowMeta.getValueMeta(i);
                if (returnValueMeta.compare(retvalue = add[i], valueMeta, rowvalue) == 0) continue;
                update = true;
            }
            if (update) {
                int i;
                Object[] updateRow = new Object[this.data.updateParameterRowMeta.size()];
                for (i = 0; i < returnRowMeta.size(); ++i) {
                    updateRow[i] = row[this.data.valuenrsUp[i]];
                }
                for (i = 0; i < lookupRow.length; ++i) {
                    updateRow[returnRowMeta.size() + i] = lookupRow[i];
                }
                if (this.meta.isLogDB() || this.operations) {
                    this.logBasic("----------LOG UPDATE---------- lineNr: " + nrRow + "\n");
                    for (i = 0; i < rowMeta.getFieldNames().length; ++i) {
                        this.logBasic(rowMeta.getValueMeta(i).getName() + " = " + String.valueOf(row[i]) + "\n");
                    }
                    this.logBasic("\n");
                }
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.UpdateRow", (String[])new String[0]) + this.data.lookupParameterRowMeta.getString(lookupRow));
                }
                this.data.dbUp.setValues(this.data.updateParameterRowMeta, updateRow, this.data.prepStatementUpdate);
                this.data.dbUp.insertRow(this.data.prepStatementUpdate, this.meta.useBatchUpdateUp(), true);
                this.incrementLinesUpdated();
                return outputRow;
            } else {
                this.incrementLinesSkipped();
            }
        }
        return outputRow;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (MergeUpsertDeleteMeta)smi;
        this.data = (MergeUpsertDeleteData)sdi;
        boolean sendToErrorRow = false;
        String errorMessage = null;
        if (this.first) {
            int i;
            this.first = false;
            if (this.meta.getReferenceStepName() != null ^ this.meta.getCompareStepName() != null) {
                this.logError(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.BothTrueAndFalseNeeded", (String[])new String[0]));
                return false;
            }
            this.data.oneRowSet = this.findInputRowSet(this.meta.getReferenceStepName());
            this.data.twoRowSet = this.findInputRowSet(this.meta.getCompareStepName());
            String useRefWhenIdenticalVar = Const.NVL((String)System.getProperty("KETTLE_COMPATIBILITY_MERGE_ROWS_USE_REFERENCE_STREAM_WHEN_IDENTICAL"), (String)"N");
            this.useRefWhenIdentical = !"N".equalsIgnoreCase(useRefWhenIdenticalVar);
            try {
                MergeUpsertDelete.checkInputLayoutValid(this.data.oneRowSet.getRowMeta(), this.data.twoRowSet.getRowMeta());
            }
            catch (KettleRowException e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Merge.Exception.InvalidLayoutDetected", (String[])new String[0]), (Throwable)e);
            }
            this.data.one = this.getRowFrom(this.data.oneRowSet);
            this.data.two = this.getRowFrom(this.data.twoRowSet);
            if (this.data.outputRowMeta == null) {
                this.data.outputRowMeta = new RowMeta();
                if (this.data.one != null) {
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), new RowMetaInterface[]{this.data.oneRowSet.getRowMeta()}, null, (VariableSpace)this, this.repository, this.metaStore);
                    this.data.inputRowMeta = this.data.oneRowSet.getRowMeta();
                } else {
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), new RowMetaInterface[]{this.data.twoRowSet.getRowMeta()}, null, (VariableSpace)this, this.repository, this.metaStore);
                    this.data.inputRowMeta = this.data.twoRowSet.getRowMeta();
                }
            }
            if (this.data.one == null && this.data.two == null) {
                this.setOutputDone();
                return false;
            }
            String[] fieldNames = new String[]{this.meta.getOrderField()};
            this.data.fieldOrdernrs = new int[fieldNames.length];
            this.data.rowComparator = new RowObjectArrayComparator(this.data.inputRowMeta, this.data.fieldOrdernrs);
            this.data.comparator = new RowTemapFileComparator(this.data.inputRowMeta, this.data.fieldOrdernrs);
            for (int i2 = 0; i2 < fieldNames.length; ++i2) {
                this.data.fieldOrdernrs[i2] = this.data.outputRowMeta.indexOfValue((String)fieldNames[i2]);
                if (this.data.fieldOrdernrs[i2] >= 0) continue;
                throw new KettleException(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.CheckResult.StepFieldNotInInputStream", (String[])new String[]{"Order", this.getStepname()}));
            }
            this.data.schemaTable = this.meta.getDatabaseMeta().getQuotedSchemaTableCombination(this.environmentSubstitute(this.meta.getSchemaName()), this.environmentSubstitute(this.meta.getTableName()));
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.CheckingRow", (String[])new String[0]) + this.data.inputRowMeta.getString(this.data.one));
            }
            ArrayList<Integer> keynrs = new ArrayList<Integer>(this.meta.getKeyStream().length);
            ArrayList<Integer> keynrs2 = new ArrayList<Integer>(this.meta.getKeyStream2().length);
            for (i = 0; i < this.meta.getKeyStream().length; ++i) {
                int keynr2;
                int keynr = this.data.inputRowMeta.indexOfValue(this.meta.getKeyStream()[i]);
                if (keynr < 0 && !"IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) && !"IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Exception.FieldRequired", (String[])new String[]{this.meta.getKeyStream()[i]}));
                }
                keynrs.add(keynr);
                if ("= ~NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                    keynrs.add(keynr);
                    keynrs2.add(-1);
                }
                if ((keynr2 = this.data.inputRowMeta.indexOfValue(this.meta.getKeyStream2()[i])) < 0 && "BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Exception.FieldRequired", (String[])new String[]{this.meta.getKeyStream2()[i]}));
                }
                keynrs2.add(keynr2);
                if (!this.log.isDebug()) continue;
                this.logDebug(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.FieldHasDataNumbers", (String[])new String[]{this.meta.getKeyStream()[i]}) + String.valueOf(keynrs.get(keynrs.size() - 1)));
            }
            this.data.keynrs = ArrayUtils.toPrimitive((Integer[])keynrs.toArray(new Integer[0]));
            this.data.keynrs2 = ArrayUtils.toPrimitive((Integer[])keynrs2.toArray(new Integer[0]));
            this.data.valuenrsUp = new int[this.meta.getUpdateStream().length];
            for (i = 0; i < this.meta.getUpdateLookup().length; ++i) {
                this.data.valuenrsUp[i] = this.data.inputRowMeta.indexOfValue(this.meta.getUpdateStream()[i]);
                if (this.data.valuenrsUp[i] < 0) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Exception.FieldRequired", (String[])new String[]{this.meta.getUpdateStream()[i]}));
                }
                if (!this.log.isDebug()) continue;
                this.logDebug(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.FieldHasDataNumbers", (String[])new String[]{this.meta.getUpdateStream()[i]}) + this.data.valuenrsUp[i]);
            }
            this.setLookup(this.data.inputRowMeta);
            this.prepareUpdate(this.data.inputRowMeta);
            if (this.meta.getComboInativa().equalsIgnoreCase("Selecione...") && this.meta.isInativa()) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Exception.FieldInativaRequired", (String[])new String[0]));
            }
            this.data.keynrsDel = new int[this.meta.getKeyStreamDel().length];
            this.data.keynrsDel2 = new int[this.meta.getKeyStreamDel().length];
            for (i = 0; i < this.meta.getKeyStreamDel().length; ++i) {
                this.data.keynrsDel[i] = this.data.inputRowMeta.indexOfValue(this.meta.getKeyStreamDel()[i]);
                if (this.data.keynrsDel[i] < 0 && !"IS NULL".equalsIgnoreCase(this.meta.getKeyConditionDel()[i]) && !"IS NOT NULL".equalsIgnoreCase(this.meta.getKeyConditionDel()[i])) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Exception.FieldRequired", (String[])new String[]{this.meta.getKeyStreamDel()[i]}));
                }
                this.data.keynrsDel2[i] = this.data.inputRowMeta.indexOfValue(this.meta.getKeyStreamDel2()[i]);
                if (this.data.keynrsDel2[i] < 0 && "BETWEEN".equalsIgnoreCase(this.meta.getKeyConditionDel()[i])) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Exception.FieldRequired", (String[])new String[]{this.meta.getKeyStreamDel2()[i]}));
                }
                if (!this.log.isDebug()) continue;
                this.logDebug(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.FieldInfo", (String[])new String[]{this.meta.getKeyStreamDel()[i]}) + this.data.keynrsDel[i]);
            }
            this.prepareDelete(this.data.inputRowMeta);
            this.data.valuenrsIns = new int[this.meta.getFieldDatabase().length];
            for (i = 0; i < this.meta.getFieldDatabase().length; ++i) {
                this.data.valuenrsIns[i] = this.data.outputRowMeta.indexOfValue(this.meta.getFieldStream()[i]);
                if (this.data.valuenrsIns[i] >= 0) continue;
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Exception.FieldRequired", (String[])new String[]{this.meta.getFieldStream()[i]}));
            }
            this.data.insertRowMeta = new RowMeta();
            for (i = 0; i < this.meta.getFieldDatabase().length; ++i) {
                ValueMetaInterface insValue = this.data.outputRowMeta.searchValueMeta(this.meta.getFieldStream()[i]);
                if (insValue == null) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Exception.FailedToFindField", (String[])new String[]{this.meta.getFieldStream()[i]}));
                }
                ValueMetaInterface insertValue = insValue.clone();
                insertValue.setName(this.meta.getFieldDatabase()[i]);
                this.data.insertRowMeta.addValueMeta(insertValue);
            }
        }
        if (this.data.one == null && this.data.two == null && !this.isStopped()) {
            Object[] outputRow;
            this.preSortBeforeFlush(1, this.data.buffer1, this.data.filesOrder1, this.data.bufferSizes1);
            this.preSortBeforeFlush(2, this.data.buffer2, this.data.filesOrder2, this.data.bufferSizes2);
            this.passBuffer(1, this.data.buffer1, this.data.rowBuffer1, this.data.filesOrder1, this.data.bufferSizes1, this.data.dis1, this.data.fis1, this.data.gzis1, this.data.tempRows1, this.data.rows1);
            this.passBuffer(2, this.data.buffer2, this.data.rowBuffer2, this.data.filesOrder2, this.data.bufferSizes2, this.data.dis2, this.data.fis2, this.data.gzis2, this.data.tempRows2, this.data.rows2);
            this.merge();
            int flagIndex = this.data.inputRowMeta.size();
            block30: for (Object[] row : this.data.rowsMerge) {
                if (this.isStopped()) break;
                switch ((String)row[flagIndex]) {
                    case "new": {
                        if (this.meta.useSequence()) {
                            this.addSequence(this.data.outputRowMeta, row);
                            if (!this.data.batchMode || this.data.batchBuffer == null) break;
                            for (int i = 0; i < this.data.batchBuffer.size(); ++i) {
                                this.putRow(this.data.outputRowMeta, this.data.batchBuffer.get(i));
                                this.incrementLinesOutput();
                            }
                            this.data.batchBuffer.clear();
                            break;
                        }
                        try {
                            Object[] outputRowData = this.writeToTable(this.data.inputRowMeta, row);
                            if (outputRowData != null) {
                                this.putRow(this.data.outputRowMeta, outputRowData);
                                this.incrementLinesOutput();
                            }
                            if (!this.checkFeedback(this.getLinesRead()) || !this.log.isBasic()) continue block30;
                            this.logBasic("linenr " + this.getLinesRead());
                            break;
                        }
                        catch (KettleException e) {
                            this.logError("Because of an error, this step can't continue: ", e);
                            this.setErrors(1L);
                            this.stopAll();
                            this.setOutputDone();
                            return false;
                        }
                    }
                    case "changed": {
                        this.updateOBject.add(row);
                        break;
                    }
                    case "deleted": {
                        if (this.meta.isDelete()) {
                            try {
                                this.deleteValues(this.data.inputRowMeta, row);
                                this.putRow(this.data.outputRowMeta, row);
                                ++this.countDelete;
                                if (!this.checkFeedback(this.getLinesRead()) || !this.log.isBasic()) continue block30;
                                this.logBasic(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                            }
                            catch (KettleException e) {
                                if (!this.getStepMeta().isDoingErrorHandling()) {
                                    this.logError(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.ErrorInStepDel", (String[])new String[0]) + e.getMessage());
                                    this.setErrors(1L);
                                    this.stopAll();
                                    this.setOutputDone();
                                    return false;
                                }
                                sendToErrorRow = true;
                                errorMessage = e.toString();
                                if (!sendToErrorRow) continue block30;
                                this.putError(this.data.inputRowMeta, row, 1L, errorMessage, null, "DEL001");
                            }
                            break;
                        }
                        if (!this.meta.isInativa()) break;
                        this.inativaOBject.add(row);
                        break;
                    }
                    case "identical": {
                        try {
                            this.putRow(this.data.outputRowMeta, row);
                            ++this.countIdentical;
                        }
                        catch (Exception e) {
                            this.logError("ERRO NA SAIDA DA LINHA");
                        }
                        break;
                    }
                }
            }
            if (this.updateOBject != null && this.updateOBject.size() > 0) {
                for (int i = 0; i < this.updateOBject.size() && !this.isStopped(); ++i) {
                    try {
                        outputRow = this.lookupValues(this.data.inputRowMeta, this.updateOBject.get(i), i + 1);
                        if (outputRow != null) {
                            this.putRow(this.data.outputRowMeta, outputRow);
                            ++this.countChanged;
                        }
                        if (!this.checkFeedback(this.getLinesRead()) || !this.log.isBasic()) continue;
                        this.logBasic(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                        continue;
                    }
                    catch (KettleException e) {
                        if (!this.getStepMeta().isDoingErrorHandling()) {
                            this.logError(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.ErrorInStep", (String[])new String[0]), e);
                            this.setErrors(1L);
                            this.stopAll();
                            this.setOutputDone();
                            return false;
                        }
                        sendToErrorRow = true;
                        errorMessage = e.toString();
                        if (!sendToErrorRow) continue;
                        this.putError(this.data.inputRowMeta, this.updateOBject.get(i), 1L, errorMessage, null, "UPD001");
                    }
                }
            }
            if (this.inativaOBject != null && this.inativaOBject.size() > 0) {
                for (int i = 0; i < this.inativaOBject.size() && !this.isStopped(); ++i) {
                    try {
                        outputRow = this.inativa(this.data.inputRowMeta, this.inativaOBject.get(i), i + 1);
                        if (outputRow != null) {
                            this.putRow(this.data.outputRowMeta, outputRow);
                            ++this.countInativa;
                        }
                        if (!this.checkFeedback(this.getLinesRead()) || !this.log.isBasic()) continue;
                        this.logBasic(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                        continue;
                    }
                    catch (KettleException e) {
                        if (!this.getStepMeta().isDoingErrorHandling()) {
                            this.logError(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.ErrorInStep", (String[])new String[0]), e);
                            this.setErrors(1L);
                            this.stopAll();
                            this.setOutputDone();
                            return false;
                        }
                        sendToErrorRow = true;
                        errorMessage = e.toString();
                        if (!sendToErrorRow) continue;
                        this.putError(this.data.inputRowMeta, this.inativaOBject.get(i), 1L, errorMessage, null, "UPD001");
                    }
                }
            }
            this.logBasic(this.getTrans().getName() + " - INSERT: " + this.countNew);
            this.logBasic(this.getTrans().getName() + " - UPDATE: " + this.countChanged);
            if (this.meta.isDelete()) {
                this.logBasic(this.getTrans().getName() + " - DELETE: " + this.countDelete);
            } else if (this.meta.isInativa()) {
                this.logBasic(this.getTrans().getName() + " - INATIVA: " + this.countInativa);
            }
            this.logBasic(this.getTrans().getName() + " - IDENTICAL: " + this.countIdentical);
            this.setOutputDone();
            return false;
        }
        if (this.data.one != null) {
            this.addBuffer(1, this.data.buffer1, this.data.one, this.data.filesOrder1, this.data.bufferSizes1);
            this.data.one = this.getRowFrom(this.data.oneRowSet);
        }
        if (this.data.two != null) {
            this.addBuffer(2, this.data.buffer2, this.data.two, this.data.filesOrder2, this.data.bufferSizes2);
            this.data.two = this.getRowFrom(this.data.twoRowSet);
        }
        return true;
    }

    protected Object[] writeToTable(RowMetaInterface rowMeta, Object[] r) throws KettleException {
        if (r == null) {
            if (this.log.isDetailed()) {
                this.logDetailed("Last line inserted: stop");
            }
            return null;
        }
        PreparedStatement insertStatement = null;
        Object[] outputRowData = r;
        String tableName = null;
        boolean sendToErrorRow = false;
        String errorMessage = null;
        boolean rowIsSafe = false;
        int[] updateCounts = null;
        List exceptionsList = null;
        boolean batchProblem = false;
        tableName = this.data.tableName;
        Object[] insertRowData = r;
        insertRowData = new Object[this.data.valuenrsIns.length];
        for (int idx = 0; idx < this.data.valuenrsIns.length; ++idx) {
            insertRowData[idx] = r[this.data.valuenrsIns[idx]];
        }
        if (tableName == null || tableName.equals("")) {
            throw new KettleStepException("The tablename is not defined (empty)");
        }
        insertStatement = this.data.preparedStatements.get(tableName);
        if (insertStatement == null) {
            String sql = this.data.db.getInsertStatement(this.environmentSubstitute(this.meta.getSchemaName()), tableName, this.data.insertRowMeta);
            if (this.log.isDetailed()) {
                this.logDetailed("Prepared statement : " + sql);
            }
            insertStatement = this.data.db.prepareSQL(sql, false);
            this.data.preparedStatements.put(tableName, insertStatement);
        }
        try {
            Integer commitCounter;
            if (this.data.useSafePoints) {
                this.data.savepoint = this.data.db.setSavepoint();
            }
            if (this.meta.isLogDB() || this.operations) {
                this.logBasic("----------LOG INSERT---------- lineNr: " + (this.countNew + 1) + "\n");
                for (int i = 0; i < this.data.insertRowMeta.size(); ++i) {
                    this.logBasic(this.data.insertRowMeta.getValueMeta(i).getName() + " = " + String.valueOf(insertRowData[i]) + "\n");
                }
                this.logBasic("\n");
            }
            this.data.db.setValues(this.data.insertRowMeta, insertRowData, insertStatement);
            this.data.db.insertRow(insertStatement, this.data.batchMode, false);
            if (this.isRowLevel()) {
                this.logRowlevel("Written row: " + this.data.insertRowMeta.getString(insertRowData));
            }
            if ((commitCounter = this.data.commitCounterMap.get(tableName)) == null) {
                commitCounter = 1;
            } else {
                Integer n = commitCounter;
                Integer n2 = commitCounter = Integer.valueOf(commitCounter + 1);
            }
            this.data.commitCounterMap.put(tableName, (int)commitCounter);
            if (this.data.useSafePoints && this.data.releaseSavepoint) {
                this.data.db.releaseSavepoint(this.data.savepoint);
            }
            if (this.data.commitSize > 0 && commitCounter % this.data.commitSize == 0) {
                if (this.data.db.getUseBatchInsert(this.data.batchMode)) {
                    try {
                        insertStatement.executeBatch();
                        this.data.db.commit();
                        insertStatement.clearBatch();
                    }
                    catch (SQLException ex) {
                        throw Database.createKettleDatabaseBatchException((String)"Error updating batch", (SQLException)ex);
                    }
                    catch (Exception ex) {
                        throw new KettleDatabaseException("Unexpected error inserting row", (Throwable)ex);
                    }
                } else {
                    this.data.db.commit();
                }
                this.data.commitCounterMap.put(tableName, 0);
                rowIsSafe = true;
            } else {
                rowIsSafe = false;
            }
        }
        catch (KettleDatabaseBatchException be) {
            errorMessage = be.toString();
            batchProblem = true;
            sendToErrorRow = true;
            updateCounts = be.getUpdateCounts();
            exceptionsList = be.getExceptionsList();
            if (this.getStepMeta().isDoingErrorHandling()) {
                this.data.db.clearBatch(insertStatement);
                this.data.db.commit(true);
            }
            this.data.db.clearBatch(insertStatement);
            this.data.db.rollback();
            StringBuilder msg = new StringBuilder("Error batch inserting rows into table [" + tableName + "].");
            msg.append(Const.CR);
            msg.append("Errors encountered (first 10):").append(Const.CR);
            for (int x = 0; x < be.getExceptionsList().size() && x < 10; ++x) {
                Exception exception = (Exception)be.getExceptionsList().get(x);
                if (exception.getMessage() == null) continue;
                msg.append(exception.getMessage()).append(Const.CR);
            }
            throw new KettleException(msg.toString(), (Throwable)be);
        }
        catch (KettleDatabaseException dbe) {
            if (this.getStepMeta().isDoingErrorHandling()) {
                if (this.isRowLevel()) {
                    this.logRowlevel("Written row to error handling : " + this.data.inputRowMeta.getString(r));
                }
                if (this.data.useSafePoints) {
                    this.data.db.rollback(this.data.savepoint);
                    if (this.data.releaseSavepoint) {
                        this.data.db.releaseSavepoint(this.data.savepoint);
                    }
                }
                sendToErrorRow = true;
                errorMessage = dbe.toString();
            }
            this.setErrors(this.getErrors() + 1L);
            this.data.db.rollback();
            throw new KettleException("Error inserting row into table [" + tableName + "] with values: " + rowMeta.getString(r), (Throwable)dbe);
        }
        if (this.data.batchMode) {
            if (sendToErrorRow) {
                if (batchProblem) {
                    this.data.batchBuffer.add(outputRowData);
                    outputRowData = null;
                    this.processBatchException(errorMessage, updateCounts, exceptionsList);
                } else {
                    this.putError(rowMeta, r, 1L, errorMessage, null, "TOP001");
                    outputRowData = null;
                }
            } else {
                this.data.batchBuffer.add(outputRowData);
                outputRowData = null;
                if (rowIsSafe) {
                    for (int i = 0; i < this.data.batchBuffer.size(); ++i) {
                        Object[] row = this.data.batchBuffer.get(i);
                        this.putRow(this.data.outputRowMeta, row);
                        this.incrementLinesOutput();
                    }
                    this.data.batchBuffer.clear();
                }
            }
        } else if (sendToErrorRow) {
            this.putError(rowMeta, r, 1L, errorMessage, null, "TOP001");
            outputRowData = null;
        }
        ++this.countNew;
        return outputRowData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSequence(RowMetaInterface inputRowMeta, Object[] r) throws KettleException {
        Object[] outputRowData;
        Long next = null;
        if (this.meta.isNumber()) {
            Counter counter = this.data.counter;
            synchronized (counter) {
                long prev = this.data.counter.getCounter();
                long nval = prev + this.data.increment;
                if (this.data.increment > 0L && this.data.maximum > this.data.start && nval > this.data.maximum) {
                    nval = this.data.start;
                }
                if (this.data.increment < 0L && this.data.maximum < this.data.start && nval < this.data.maximum) {
                    nval = this.data.start;
                }
                this.data.counter.setCounter(nval);
                next = prev;
            }
        } else if (!this.meta.isNumber()) {
            try {
                next = this.data.getDb().getNextSequenceValue(this.data.realSchemaName, this.data.realSequenceName, this.meta.getValuename());
            }
            catch (KettleDatabaseException dbe) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Exception.ErrorReadingSequence", (String[])new String[]{this.data.realSequenceName}), (Throwable)dbe);
            }
        } else {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Exception.NoSpecifiedMethod", (String[])new String[0]));
        }
        if (next != null) {
            outputRowData = r;
            if (r.length < inputRowMeta.size() + 1) {
                outputRowData = RowDataUtil.resizeArray((Object[])r, (int)(inputRowMeta.size() + 1));
            }
        } else {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Exception.CouldNotFindNextValueForSequence", (String[])new String[0]) + this.meta.getValuename());
        }
        outputRowData[inputRowMeta.size() - 1] = next;
        try {
            Object[] outputRowData2 = this.writeToTable(inputRowMeta, outputRowData);
            if (outputRowData2 != null) {
                this.putRow(inputRowMeta, outputRowData2);
                this.incrementLinesOutput();
            }
            if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                this.logBasic("linenr " + this.getLinesRead());
            }
        }
        catch (KettleException e) {
            this.logError("Because of an error, this step can't continue: ", e);
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
        }
    }

    public boolean isRowLevel() {
        return this.log.isRowLevel();
    }

    private void processBatchException(String errorMessage, int[] updateCounts, List<Exception> exceptionsList) throws KettleException {
        if (updateCounts != null) {
            int errNr = 0;
            for (int i = 0; i < updateCounts.length; ++i) {
                Object[] row = this.data.batchBuffer.get(i);
                if (updateCounts[i] > 0) {
                    this.putRow(this.data.outputRowMeta, row);
                    this.incrementLinesOutput();
                    continue;
                }
                String exMessage = errorMessage;
                if (errNr < exceptionsList.size()) {
                    SQLException se = (SQLException)exceptionsList.get(errNr);
                    ++errNr;
                    exMessage = se.toString();
                }
                this.putError(this.data.outputRowMeta, row, 1L, exMessage, null, "TOP0002");
            }
        } else {
            for (int i = 0; i < this.data.batchBuffer.size(); ++i) {
                Object[] row = this.data.batchBuffer.get(i);
                this.putError(this.data.outputRowMeta, row, 1L, errorMessage, null, "TOP0003");
            }
        }
        this.data.batchBuffer.clear();
    }

    protected MergeUpsertDeleteMeta getMeta() {
        return this.meta;
    }

    protected MergeUpsertDeleteData getData() {
        return this.data;
    }

    protected void setMeta(MergeUpsertDeleteMeta meta) {
        this.meta = meta;
    }

    protected void setData(MergeUpsertDeleteData data) {
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MergeUpsertDeleteMeta)smi;
        this.data = (MergeUpsertDeleteData)sdi;
        this.clearBuffers(1, this.data.buffer1, this.data.filesOrder1, this.data.dis1, this.data.fis1, this.data.rowBuffer1);
        if (this.meta.isNumber()) {
            if (this.data.getLookup() != null) {
                this.getTrans().getCounters().remove(this.data.getLookup());
            }
            this.data.counter = null;
        }
        if (this.data.db != null) {
            try {
                for (String schemaTable : this.data.preparedStatements.keySet()) {
                    Integer batchCounter = this.data.commitCounterMap.get(schemaTable);
                    if (batchCounter == null) {
                        batchCounter = 0;
                    }
                    PreparedStatement insertStatement = this.data.preparedStatements.get(schemaTable);
                    this.data.db.emptyAndCommit(insertStatement, this.data.batchMode, batchCounter.intValue());
                }
                for (int i = 0; i < this.data.batchBuffer.size(); ++i) {
                    Object[] row = this.data.batchBuffer.get(i);
                    this.putRow(this.data.outputRowMeta, row);
                    this.incrementLinesOutput();
                }
                this.data.batchBuffer.clear();
            }
            catch (KettleDatabaseBatchException be) {
                if (this.getStepMeta().isDoingErrorHandling()) {
                    try {
                        this.processBatchException(be.toString(), be.getUpdateCounts(), be.getExceptionsList());
                    }
                    catch (KettleException e) {
                        this.logError("Unexpected error processing batch error", e);
                        this.setErrors(1L);
                        this.stopAll();
                    }
                } else {
                    this.logError("Unexpected batch update error committing the database connection.", be);
                    this.setErrors(1L);
                    this.stopAll();
                }
            }
            catch (Exception dbe) {
                this.logError("Unexpected error committing the database connection.", dbe);
                this.logError(Const.getStackTracker((Throwable)dbe));
                this.setErrors(1L);
                this.stopAll();
            }
            finally {
                this.setOutputDone();
                if (this.getErrors() > 0L) {
                    try {
                        this.data.db.rollback();
                    }
                    catch (KettleDatabaseException e) {
                        this.logError("Unexpected error rolling back the database connection.", e);
                    }
                }
                this.data.db.disconnect();
            }
        }
        if (this.data.dbDel != null) {
            try {
                if (!this.data.dbDel.isAutoCommit()) {
                    if (this.getErrors() == 0L) {
                        this.data.dbDel.commit();
                    } else {
                        this.data.dbDel.rollback();
                    }
                }
                this.data.dbDel.closeUpdate();
            }
            catch (KettleDatabaseException e) {
                this.logError(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.UnableToCommitDeleteConnection", (String[])new String[0]) + String.valueOf(this.data.dbDel) + "] :" + e.toString());
                this.setErrors(1L);
            }
            finally {
                this.data.dbDel.disconnect();
            }
        }
        if (this.data.dbUp != null) {
            try {
                if (!this.data.dbUp.isAutoCommit()) {
                    if (this.getErrors() == 0L) {
                        this.data.dbUp.emptyAndCommit(this.data.prepStatementUpdate, this.meta.useBatchUpdateUp());
                    } else {
                        this.data.dbUp.rollback();
                    }
                }
                this.data.dbUp.closePreparedStatement(this.data.prepStatementUpdate);
                this.data.dbUp.closePreparedStatement(this.data.prepStatementLookup);
            }
            catch (KettleDatabaseException e) {
                this.logError(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.UnableToCommitUpdateConnection", (String[])new String[0]) + String.valueOf(this.data.dbUp) + "] :" + e.toString());
                this.setErrors(1L);
            }
            finally {
                this.data.dbUp.disconnect();
            }
        }
        if (this.data.dbIna != null) {
            try {
                if (!this.data.dbIna.isAutoCommit()) {
                    if (this.getErrors() == 0L) {
                        this.data.dbIna.emptyAndCommit(this.data.prepStatementInativa, this.meta.useBatchUpdateUp());
                    } else {
                        this.data.dbIna.rollback();
                    }
                }
                this.data.dbIna.closePreparedStatement(this.data.prepStatementInativa);
                this.data.dbIna.closePreparedStatement(this.data.prepStatementLookupIna);
            }
            catch (KettleDatabaseException e) {
                this.logError(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.UnableToCommitInativaConnection", (String[])new String[0]) + String.valueOf(this.data.dbIna) + "] :" + e.toString());
                this.setErrors(1L);
            }
            finally {
                this.data.dbIna.disconnect();
            }
        }
        super.dispose(smi, sdi);
    }

    public void setLookup(RowMetaInterface rowMeta) throws KettleDatabaseException {
        int i;
        this.data.lookupParameterRowMeta = new RowMeta();
        this.data.inativaParameterRowMeta = new RowMeta();
        this.data.lookupReturnRowMeta = new RowMeta();
        this.data.lookupReturnRowMetaIna = new RowMeta();
        DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
        Object sql = "SELECT ";
        Object sqlInativa = "SELECT ";
        for (i = 0; i < this.meta.getUpdateLookup().length; ++i) {
            if (i != 0) {
                sql = (String)sql + ", ";
            }
            sql = (String)sql + databaseMeta.quoteField(this.meta.getUpdateLookup()[i]);
            this.data.lookupReturnRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getUpdateStream()[i]));
        }
        if (this.meta.getKeyLookupDel().length > 0) {
            sqlInativa = (String)sqlInativa + " 0 AS " + this.meta.getComboInativa();
            this.data.lookupReturnRowMetaIna.addValueMeta(rowMeta.searchValueMeta(this.meta.getComboInativa()));
        }
        sql = (String)sql + " FROM " + this.data.schemaTable + " WHERE ";
        sqlInativa = (String)sqlInativa + " FROM " + this.data.schemaTable + " WHERE ";
        for (i = 0; i < this.meta.getKeyLookup().length; ++i) {
            if (i != 0) {
                sql = (String)sql + " AND ";
            }
            sql = (String)sql + " ( ( ";
            sql = (String)sql + databaseMeta.quoteField(this.meta.getKeyLookup()[i]);
            if ("BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = (String)sql + " BETWEEN ? AND ? ";
                this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
                this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream2()[i]));
            } else if ("IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) || "IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = (String)sql + " " + this.meta.getKeyCondition()[i] + " ";
            } else if ("= ~NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = (String)sql + " IS NULL AND ";
                sql = databaseMeta.requiresCastToVariousForIsNull() ? (String)sql + "CAST(? AS VARCHAR(256)) IS NULL" : (String)sql + "? IS NULL";
                this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
                sql = (String)sql + " ) OR ( " + databaseMeta.quoteField(this.meta.getKeyLookup()[i]) + " = ?";
                this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]).clone());
            } else {
                sql = (String)sql + " " + this.meta.getKeyCondition()[i] + " ? ";
                this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
            }
            sql = (String)sql + " ) ) ";
        }
        for (i = 0; i < this.meta.getKeyLookupDel().length; ++i) {
            if (i != 0) {
                sqlInativa = (String)sqlInativa + " AND ";
            }
            sqlInativa = (String)sqlInativa + " ( ( ";
            sqlInativa = (String)sqlInativa + databaseMeta.quoteField(this.meta.getKeyLookupDel()[i]);
            if ("BETWEEN".equalsIgnoreCase(this.meta.getKeyConditionDel()[i])) {
                sqlInativa = (String)sqlInativa + " BETWEEN ? AND ? ";
                this.data.inativaParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel()[i]));
                this.data.inativaParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel2()[i]));
            } else if ("IS NULL".equalsIgnoreCase(this.meta.getKeyConditionDel()[i]) || "IS NOT NULL".equalsIgnoreCase(this.meta.getKeyConditionDel()[i])) {
                sqlInativa = (String)sqlInativa + " " + this.meta.getKeyConditionDel()[i] + " ";
            } else if ("= ~NULL".equalsIgnoreCase(this.meta.getKeyConditionDel()[i])) {
                sqlInativa = (String)sqlInativa + " IS NULL AND ";
                sqlInativa = databaseMeta.requiresCastToVariousForIsNull() ? (String)sqlInativa + "CAST(? AS VARCHAR(256)) IS NULL" : (String)sqlInativa + "? IS NULL";
                this.data.inativaParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel()[i]));
                sqlInativa = (String)sqlInativa + " ) OR ( " + databaseMeta.quoteField(this.meta.getKeyLookupDel()[i]) + " = ?";
                this.data.inativaParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel()[i]).clone());
            } else {
                sqlInativa = (String)sqlInativa + " " + this.meta.getKeyConditionDel()[i] + " ? ";
                this.data.inativaParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel()[i]));
            }
            sqlInativa = (String)sqlInativa + " ) ) ";
        }
        try {
            if (this.log.isDetailed()) {
                this.logDetailed("Setting preparedStatement to [" + (String)sql + "]");
                this.logDetailed("Setting preparedStatement to [" + (String)sqlInativa + "]");
            }
            this.data.prepStatementLookup = this.data.dbUp.getConnection().prepareStatement(databaseMeta.stripCR((String)sql));
            this.data.prepStatementLookupIna = this.data.dbIna.getConnection().prepareStatement(databaseMeta.stripCR((String)sqlInativa));
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to prepare statement for SQL statement [" + (String)sql + "]       OR      [" + (String)sqlInativa + "]", (Throwable)ex);
        }
    }

    public void prepareUpdate(RowMetaInterface rowMeta) throws KettleDatabaseException {
        int i;
        DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
        DatabaseMeta databaseMetaIna = this.meta.getDatabaseMeta();
        this.data.updateParameterRowMeta = new RowMeta();
        this.data.inativaParameterRowMeta = new RowMeta();
        String sql = "UPDATE " + this.data.schemaTable + Const.CR;
        String sqlInativa = "UPDATE " + this.data.schemaTable + Const.CR;
        sql = sql + " SET ";
        sqlInativa = this.meta.isCheckBool() ? sqlInativa + " SET " + this.meta.getComboInativa() + " = false " : sqlInativa + " SET " + this.meta.getComboInativa() + " = 0 ";
        for (i = 0; i < this.meta.getUpdateLookup().length; ++i) {
            if (i != 0) {
                sql = sql + ",   ";
            }
            sql = sql + databaseMeta.quoteField(this.meta.getUpdateLookup()[i]);
            sql = sql + " = ?" + Const.CR;
            this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getUpdateStream()[i]));
        }
        sql = sql + " WHERE ";
        sqlInativa = sqlInativa + " WHERE ";
        for (i = 0; i < this.meta.getKeyLookupDel().length; ++i) {
            if (i != 0) {
                sqlInativa = sqlInativa + " AND   ";
            }
            sqlInativa = sqlInativa + " ( ( ";
            sqlInativa = sqlInativa + databaseMetaIna.quoteField(this.meta.getKeyLookupDel()[i]);
            if ("BETWEEN".equalsIgnoreCase(this.meta.getKeyConditionDel()[i])) {
                sqlInativa = sqlInativa + " BETWEEN ? AND ? ";
                this.data.inativaParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel()[i]));
                this.data.inativaParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel2()[i]));
            } else if ("IS NULL".equalsIgnoreCase(this.meta.getKeyConditionDel()[i]) || "IS NOT NULL".equalsIgnoreCase(this.meta.getKeyConditionDel()[i])) {
                sqlInativa = sqlInativa + " " + this.meta.getKeyConditionDel()[i] + " ";
            } else if ("= ~NULL".equalsIgnoreCase(this.meta.getKeyConditionDel()[i])) {
                sqlInativa = sqlInativa + " IS NULL AND ";
                sqlInativa = databaseMetaIna.requiresCastToVariousForIsNull() ? sqlInativa + "CAST(? AS VARCHAR(256)) IS NULL" : sqlInativa + "? IS NULL";
                this.data.inativaParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel()[i]));
                sqlInativa = sqlInativa + " ) OR ( " + databaseMetaIna.quoteField(this.meta.getKeyLookupDel()[i]) + " = ?";
                this.data.inativaParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel()[i]).clone());
            } else {
                sqlInativa = sqlInativa + " " + this.meta.getKeyConditionDel()[i] + " ? ";
                this.data.inativaParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel()[i]));
            }
            sqlInativa = sqlInativa + " ) ) ";
        }
        for (i = 0; i < this.meta.getKeyLookup().length; ++i) {
            if (i != 0) {
                sql = sql + "AND   ";
            }
            sql = sql + " ( ( ";
            sql = sql + databaseMeta.quoteField(this.meta.getKeyLookup()[i]);
            if ("BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " BETWEEN ? AND ? ";
                this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
                this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream2()[i]));
            } else if ("IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) || "IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " " + this.meta.getKeyCondition()[i] + " ";
            } else if ("= ~NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " IS NULL AND ";
                sql = databaseMeta.requiresCastToVariousForIsNull() ? sql + "CAST(? AS VARCHAR(256)) IS NULL" : sql + "? IS NULL";
                this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
                sql = sql + " ) OR ( " + databaseMeta.quoteField(this.meta.getKeyLookup()[i]) + " = ?";
                this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]).clone());
            } else {
                sql = sql + " " + this.meta.getKeyCondition()[i] + " ? ";
                this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
            }
            sql = sql + " ) ) ";
        }
        try {
            if (this.log.isDetailed()) {
                this.logDetailed("Setting update preparedStatement to [" + sql + "]");
                this.logDetailed("Setting inativa preparedStatement to [" + sqlInativa + "]");
            }
            this.data.prepStatementUpdate = this.data.dbUp.getConnection().prepareStatement(databaseMeta.stripCR(sql));
            this.data.prepStatementInativa = this.data.dbIna.getConnection().prepareStatement(databaseMetaIna.stripCR(sqlInativa));
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to prepare statement for SQL statement [" + sql + "]    OR     [" + sqlInativa + "]", (Throwable)ex);
        }
    }

    private synchronized void deleteValues(RowMetaInterface rowMeta, Object[] row) throws KettleException {
        int i;
        Object[] deleteRow = new Object[this.data.deleteParameterRowMeta.size()];
        int deleteIndex = 0;
        for (i = 0; i < this.meta.getKeyStreamDel().length; ++i) {
            if (this.data.keynrsDel[i] >= 0) {
                deleteRow[deleteIndex] = row[this.data.keynrsDel[i]];
                ++deleteIndex;
            }
            if (this.data.keynrsDel2[i] < 0) continue;
            deleteRow[deleteIndex] = row[this.data.keynrsDel2[i]];
            ++deleteIndex;
        }
        if (this.meta.isLogDB() || this.operations) {
            this.logBasic("----------LOG DELETE---------- lineNr: " + (this.countDelete + 1) + "\n");
            for (i = 0; i < this.data.inputRowMeta.size() - 1; ++i) {
                this.logBasic(rowMeta.getValueMeta(i).getName() + " = " + String.valueOf(row[i]) + "\n");
            }
            this.logBasic("\n");
        }
        this.data.dbDel.setValues(this.data.deleteParameterRowMeta, deleteRow, this.data.prepStatementDelete);
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.SetValuesForDelete", (String[])new String[]{this.data.deleteParameterRowMeta.getString(deleteRow), rowMeta.getString(row)}));
        }
        this.data.dbDel.insertRow(this.data.prepStatementDelete);
        this.incrementLinesUpdated();
    }

    public void prepareDelete(RowMetaInterface rowMeta) throws KettleDatabaseException {
        DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
        this.data.deleteParameterRowMeta = new RowMeta();
        String sql = "DELETE FROM " + this.data.schemaTable + Const.CR;
        sql = sql + "WHERE ";
        for (int i = 0; i < this.meta.getKeyLookupDel().length; ++i) {
            if (i != 0) {
                sql = sql + "AND   ";
            }
            sql = sql + databaseMeta.quoteField(this.meta.getKeyLookupDel()[i]);
            if ("BETWEEN".equalsIgnoreCase(this.meta.getKeyConditionDel()[i])) {
                sql = sql + " BETWEEN ? AND ? ";
                this.data.deleteParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel()[i]));
                this.data.deleteParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel2()[i]));
                continue;
            }
            if ("IS NULL".equalsIgnoreCase(this.meta.getKeyConditionDel()[i]) || "IS NOT NULL".equalsIgnoreCase(this.meta.getKeyConditionDel()[i])) {
                sql = sql + " " + this.meta.getKeyConditionDel()[i] + " ";
                continue;
            }
            sql = sql + " " + this.meta.getKeyConditionDel()[i] + " ? ";
            this.data.deleteParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel()[i]));
        }
        try {
            if (this.log.isDetailed()) {
                this.logDetailed("Setting delete preparedStatement to [" + sql + "]");
            }
            this.data.prepStatementDelete = this.data.dbDel.getConnection().prepareStatement(databaseMeta.stripCR(sql));
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to prepare statement for SQL statement [" + sql + "]", (Throwable)ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized Object[] inativa(RowMetaInterface rowMeta, Object[] row, int nrRow) throws KettleException {
        Object[] outputRow = row;
        Object[] lookupRow = new Object[this.data.keynrsDel.length];
        int lookupIndex = 0;
        for (int i = 0; i < this.data.keynrsDel.length; ++i) {
            if (this.data.keynrsDel[i] >= 0) {
                lookupRow[lookupIndex] = row[this.data.keynrsDel[i]];
                ++lookupIndex;
            }
            if (this.data.keynrsDel2[i] < 0) continue;
            lookupRow[lookupIndex] = row[this.data.keynrsDel2[i]];
            ++lookupIndex;
        }
        RowMetaInterface returnRowMeta = null;
        this.data.dbIna.setValues(this.data.inativaParameterRowMeta, lookupRow, this.data.prepStatementLookupIna);
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.ValuesSetForLookup", (String[])new String[]{this.data.inativaParameterRowMeta.getString(lookupRow), rowMeta.getString(row)}));
        }
        Object[] add = this.data.dbIna.getLookup(this.data.prepStatementLookupIna);
        returnRowMeta = this.data.dbIna.getReturnRowMeta();
        this.incrementLinesInput();
        if (add == null) {
            if (!this.getStepMeta().isDoingErrorHandling()) throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Exception.KeyCouldNotFound", (String[])new String[0]) + this.data.inativaParameterRowMeta.getString(lookupRow));
            outputRow = null;
            if (this.data.stringErrorKeyNotFound == null) {
                this.data.stringErrorKeyNotFound = BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Exception.KeyCouldNotFound", (String[])new String[0]) + this.data.inativaParameterRowMeta.getString(lookupRow);
                this.data.stringFieldnames = "";
                for (int i = 0; i < this.data.inativaParameterRowMeta.size(); ++i) {
                    if (i > 0) {
                        this.data.stringFieldnames = this.data.stringFieldnames + ", ";
                    }
                    this.data.stringFieldnames = this.data.stringFieldnames + this.data.inativaParameterRowMeta.getValueMeta(i).getName();
                }
            }
            this.putError(rowMeta, row, 1L, this.data.stringErrorKeyNotFound, this.data.stringFieldnames, "UPD001");
            return outputRow;
        } else {
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.FoundRow", (String[])new String[0]) + "0");
            }
            boolean update = false;
            for (int i = 0; i < returnRowMeta.size(); ++i) {
                Object retvalue;
                ValueMetaInterface valueMeta = rowMeta.searchValueMeta(this.meta.getComboInativa());
                int idx = rowMeta.indexOfValue(rowMeta.searchValueMeta(this.meta.getComboInativa()).getName());
                Object rowvalue = row[idx];
                ValueMetaInterface returnValueMeta = returnRowMeta.getValueMeta(i);
                if (returnValueMeta.compare(retvalue = add[i], valueMeta, rowvalue) == 0) continue;
                update = true;
            }
            if (update) {
                int indexInativaField;
                int i;
                Object[] updateRow = new Object[this.data.inativaParameterRowMeta.size()];
                for (i = 0; i < returnRowMeta.size(); ++i) {
                    updateRow[i] = row[this.data.valuenrsIns[i]];
                }
                for (i = 0; i < lookupRow.length; ++i) {
                    updateRow[0] = lookupRow[i];
                }
                if (this.meta.isLogDB() || this.operations) {
                    this.logBasic("----------LOG INATIVA---------- lineNr: " + nrRow + "\n");
                    for (i = 0; i < this.data.inputRowMeta.size() - 1; ++i) {
                        if (this.meta.getComboInativa().equalsIgnoreCase(rowMeta.getValueMeta(i).getName())) {
                            this.logBasic("idnAtivo = 0\n");
                            continue;
                        }
                        this.logBasic(rowMeta.getValueMeta(i).getName() + " = " + String.valueOf(row[i]) + "\n");
                    }
                    this.logBasic("\n");
                }
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.UpdateRow", (String[])new String[0]) + this.data.inativaParameterRowMeta.getString(lookupRow));
                }
                if (row[indexInativaField = rowMeta.indexOfValue(this.meta.getComboInativa())].toString().equalsIgnoreCase("1") || row[indexInativaField].toString().equalsIgnoreCase("true")) {
                    this.data.dbIna.setValues(this.data.inativaParameterRowMeta, updateRow, this.data.prepStatementInativa);
                    this.data.dbIna.insertRow(this.data.prepStatementInativa, false, true);
                }
                this.incrementLinesUpdated();
                return outputRow;
            } else {
                this.incrementLinesSkipped();
            }
        }
        return outputRow;
    }

    void merge() throws KettleException {
        int i;
        this.data.one = this.data.rows1.size() == 0 || this.data.rows1 == null ? null : this.data.rows1.get(0);
        Object[] objectArray = this.data.two = this.data.rows2.size() == 0 || this.data.rows2 == null ? null : this.data.rows2.get(0);
        if (this.data.one != null) {
            this.data.keyMergeNrs = new int[this.meta.getKeyMergeFields().length];
            for (i = 0; i < this.data.keyMergeNrs.length; ++i) {
                this.data.keyMergeNrs[i] = this.data.oneRowSet.getRowMeta().indexOfValue(this.meta.getKeyMergeFields()[i]);
                if (this.data.keyMergeNrs[i] >= 0) continue;
                String message = BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Merge.Exception.UnableToFindFieldInReferenceStream", (String[])new String[]{this.meta.getKeyMergeFields()[i]});
                this.logError(message);
                throw new KettleStepException(message);
            }
        }
        if (this.data.two != null) {
            this.data.valueMergeNrs = new int[this.meta.getValueMergeFields().length];
            for (i = 0; i < this.data.valueMergeNrs.length; ++i) {
                this.data.valueMergeNrs[i] = this.data.twoRowSet.getRowMeta().indexOfValue(this.meta.getValueMergeFields()[i]);
                if (this.data.valueMergeNrs[i] >= 0) continue;
                String message = BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Merge.Exception.UnableToFindFieldInReferenceStream", (String[])new String[]{this.meta.getValueMergeFields()[i]});
                this.logError(message);
                throw new KettleStepException(message);
            }
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Log.DataInfo", (String[])new String[]{String.valueOf(this.data.one)}) + String.valueOf(this.data.two));
        }
        i = 1;
        int j = 1;
        while (i <= this.data.rows1.size() || j <= this.data.rows2.size()) {
            int outputIndex;
            Object[] outputRow;
            String flagField = null;
            if (i > this.data.rows1.size() && j <= this.data.rows2.size()) {
                outputRow = this.data.two;
                outputIndex = this.data.twoRowSet.getRowMeta().size();
                flagField = VALUE_NEW;
                this.data.two = j < this.data.rows2.size() ? this.data.rows2.get(j) : null;
                ++j;
            } else if (i <= this.data.rows1.size() && j > this.data.rows2.size()) {
                outputRow = this.data.one;
                outputIndex = this.data.oneRowSet.getRowMeta().size();
                flagField = VALUE_DELETED;
                this.data.one = i < this.data.rows1.size() ? this.data.rows1.get(i) : null;
                ++i;
            } else {
                int compare = this.data.oneRowSet.getRowMeta().compare(this.data.one, this.data.two, this.data.keyMergeNrs);
                if (compare == 0) {
                    int compareValues = this.data.oneRowSet.getRowMeta().compare(this.data.one, this.data.two, this.data.valueMergeNrs);
                    if (compareValues == 0) {
                        if (this.useRefWhenIdentical) {
                            outputRow = this.data.one;
                            outputIndex = this.data.oneRowSet.getRowMeta().size();
                        } else {
                            outputRow = this.data.two;
                            outputIndex = this.data.twoRowSet.getRowMeta().size();
                        }
                        flagField = VALUE_IDENTICAL;
                    } else {
                        outputRow = this.data.two;
                        outputIndex = this.data.twoRowSet.getRowMeta().size();
                        flagField = VALUE_CHANGED;
                    }
                    this.data.one = i < this.data.rows1.size() ? this.data.rows1.get(i) : null;
                    this.data.two = j < this.data.rows2.size() ? this.data.rows2.get(j) : null;
                    ++i;
                    ++j;
                } else if (compare < 0) {
                    outputRow = this.data.one;
                    outputIndex = this.data.oneRowSet.getRowMeta().size();
                    flagField = VALUE_DELETED;
                    this.data.one = i < this.data.rows1.size() ? this.data.rows1.get(i) : null;
                    ++i;
                } else {
                    outputRow = this.data.two;
                    outputIndex = this.data.twoRowSet.getRowMeta().size();
                    flagField = VALUE_NEW;
                    this.data.two = j < this.data.rows2.size() ? this.data.rows2.get(j) : null;
                    ++j;
                }
            }
            this.data.rowsMerge.add(RowDataUtil.addValueData((Object[])outputRow, (int)outputIndex, (Object)flagField));
        }
    }

    static void checkInputLayoutValid(RowMetaInterface referenceRowMeta, RowMetaInterface compareRowMeta) throws KettleRowException {
        if (referenceRowMeta != null && compareRowMeta != null) {
            BaseStep.safeModeChecking((RowMetaInterface)referenceRowMeta, (RowMetaInterface)compareRowMeta);
        }
    }

    public void addBuffer(int buffernr, List<Object[]> buffer, Object[] r, List<FileObject> filesOrder, List<Integer> bufferSizes) throws KettleException {
        buffer.add(r);
        ++this.data.freeCounter;
        if (this.data.sortSize <= 0 && this.data.freeCounter >= 1000) {
            this.data.freeMemoryPct = Const.getPercentageFreeMemory();
            this.data.freeCounter = 0;
            if (this.log.isDetailed()) {
                ++this.data.memoryReporting;
                if (this.data.memoryReporting >= 10) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Detailed.AvailableMemory", (Object[])new Object[]{this.data.freeMemoryPct}));
                    }
                    this.data.memoryReporting = 0;
                }
            }
        }
        boolean doSort = buffer.size() == this.data.sortSize;
        doSort |= this.data.freeMemoryPctLimit > 0 && this.data.freeMemoryPct < this.data.freeMemoryPctLimit && buffer.size() >= this.data.minSortSize;
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Debug.StartDumpToDisk", (Object[])new Object[]{this.data.freeMemoryPct, buffer.size()}));
        }
        if (doSort) {
            this.sortExternalRows(buffernr, buffer, filesOrder, bufferSizes);
        }
    }

    void sortExternalRows(int buffernr, List<Object[]> buffer, List<FileObject> filesOrder, List<Integer> bufferSizes) throws KettleException {
        if (buffer.isEmpty()) {
            return;
        }
        this.quickSort(buffer);
        try {
            DataOutputStream dos;
            GZIPOutputStream gzos;
            FileObject fileObject = KettleVFS.createTempFile((String)this.meta.getPrefixOrder(), (String)".tmp", (String)this.environmentSubstitute(this.meta.getDirectoryOrder()), (VariableSpace)this.getTransMeta());
            filesOrder.add(fileObject);
            OutputStream outputStream = KettleVFS.getOutputStream((FileObject)fileObject, (boolean)false);
            if (this.data.compressFiles) {
                gzos = new GZIPOutputStream(new BufferedOutputStream(outputStream));
                dos = new DataOutputStream(gzos);
            } else {
                dos = new DataOutputStream(new BufferedOutputStream(outputStream, 500000));
                gzos = null;
            }
            ArrayList<Integer> duplicates = new ArrayList<Integer>();
            Object[] previousRow = null;
            if (this.meta.isOnlyPassingUniqueRowsOrder()) {
                for (int index = 0; index < buffer.size(); ++index) {
                    int result;
                    Object[] row = buffer.get(index);
                    if (previousRow != null && (result = this.data.inputRowMeta.compare(row, previousRow, this.data.fieldOrdernrs)) == 0) {
                        duplicates.add(index);
                        if (this.log.isRowLevel()) {
                            this.logRowlevel(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.RowLevel.DuplicateRowRemoved", (String[])new String[]{this.data.inputRowMeta.getString(row)}));
                        }
                    }
                    previousRow = row;
                }
            }
            bufferSizes.add(buffer.size() - duplicates.size());
            int duplicatesIndex = 0;
            for (int p = 0; p < buffer.size(); ++p) {
                boolean skip = false;
                if (duplicatesIndex < duplicates.size() && p == (Integer)duplicates.get(duplicatesIndex)) {
                    skip = true;
                    ++duplicatesIndex;
                }
                if (skip) continue;
                this.data.inputRowMeta.writeData(dos, buffer.get(p));
            }
            if (this.data.sortSize < 0 && buffer.size() > this.data.minSortSize) {
                this.data.minSortSize = buffer.size();
                this.data.minSortSize = (int)Math.round((double)this.data.minSortSize * 0.9);
            }
            buffer.clear();
            dos.close();
            if (gzos != null) {
                gzos.close();
            }
            outputStream.close();
            this.data.freeMemoryPct = Const.getPercentageFreeMemory();
            this.data.freeCounter = 0;
            if (this.data.sortSize <= 0 && this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Detailed.AvailableMemory", (Object[])new Object[]{this.data.freeMemoryPct}));
            }
        }
        catch (Exception e) {
            throw new KettleException("Error processing temp-file!", (Throwable)e);
        }
        if (buffernr == 1) {
            this.data.getBufferIndex1 = 0;
        } else {
            this.data.getBufferIndex2 = 0;
        }
    }

    private void preSortBeforeFlush(int buffernr, List<Object[]> buffer, List<FileObject> filesOrder, List<Integer> bufferSizes) throws KettleException {
        if (filesOrder.size() > 0) {
            this.sortExternalRows(buffernr, buffer, filesOrder, bufferSizes);
        } else {
            this.quickSort(buffer);
        }
    }

    void passBuffer(int buffernr, List<Object[]> buffer, List<Object[]> rowBuffer, List<FileObject> filesOrder, List<Integer> bufferSizes, List<DataInputStream> dis, List<InputStream> fis, List<GZIPInputStream> gzis, List<RowTempFile> tempRows, List<Object[]> rows) throws KettleException {
        Object[] r = this.getBuffer(buffernr, buffer, filesOrder, bufferSizes, dis, fis, gzis, rowBuffer, tempRows);
        Object[] previousRow = null;
        if (this.log.isDebug() && !filesOrder.isEmpty()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Debug.ExternalMergeStarted", (String[])new String[0]));
        }
        while (r != null && !this.isStopped()) {
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.RowLevel.ReadRow", (String[])new String[]{this.data.inputRowMeta.getString(r)}));
            }
            if (this.meta.isOnlyPassingUniqueRowsOrder()) {
                if (previousRow != null) {
                    int result = this.data.inputRowMeta.compare(r, previousRow, this.data.fieldOrdernrs);
                    if (result != 0) {
                        rows.add(r);
                    }
                } else {
                    rows.add(r);
                }
                previousRow = r;
            } else {
                rows.add(r);
            }
            r = this.getBuffer(buffernr, buffer, filesOrder, bufferSizes, dis, fis, gzis, rowBuffer, tempRows);
        }
        if (this.log.isDebug() && !filesOrder.isEmpty()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Debug.ExternalMergeFinished", (String[])new String[0]));
        }
        this.clearBuffers(buffernr, buffer, filesOrder, dis, fis, rowBuffer);
    }

    Object[] getBuffer(int buffernr, List<Object[]> buffer, List<FileObject> filesOrder, List<Integer> bufferSizes, List<DataInputStream> dis, List<InputStream> fis, List<GZIPInputStream> gzis, List<Object[]> rowBuffer, List<RowTempFile> tempRows) throws KettleValueException {
        Object[] retval;
        if (filesOrder.size() > 0 && (dis.size() == 0 || fis.size() == 0)) {
            if (this.log.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Basic.OpeningTempFiles", (Object[])new Object[]{filesOrder.size()}));
            }
            try {
                for (int f = 0; f < filesOrder.size() && !this.isStopped(); ++f) {
                    FileObject fileObject = filesOrder.get(f);
                    String filename = KettleVFS.getFilename((FileObject)fileObject);
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Detailed.OpeningTempFile", (String[])new String[]{filename}));
                    }
                    InputStream fi = KettleVFS.getInputStream((FileObject)fileObject);
                    fis.add(fi);
                    DataInputStream di = this.data.compressFiles ? this.getDataInputStream(new GZIPInputStream(new BufferedInputStream(fi)), gzis) : new DataInputStream(new BufferedInputStream(fi, 50000));
                    dis.add(di);
                    int buffersize = bufferSizes.get(f);
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Detailed.FromFileExpectingRows", (Object[])new Object[]{filename, buffersize}));
                    }
                    if (buffersize <= 0) continue;
                    Object[] row = this.data.inputRowMeta.readData(di);
                    rowBuffer.add(row);
                    tempRows.add(new RowTempFile(row, f));
                }
                Collections.sort(tempRows, this.data.comparator);
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Error.ErrorReadingBackTempFiles", (String[])new String[0]), e);
            }
        }
        if (filesOrder.size() == 0) {
            if (buffernr == 1) {
                if (this.data.getBufferIndex1 < buffer.size()) {
                    retval = buffer.get(this.data.getBufferIndex1);
                    ++this.data.getBufferIndex1;
                } else {
                    retval = null;
                }
            } else if (this.data.getBufferIndex2 < buffer.size()) {
                retval = buffer.get(this.data.getBufferIndex2);
                ++this.data.getBufferIndex2;
            } else {
                retval = null;
            }
        } else if (rowBuffer.size() == 0) {
            retval = null;
        } else {
            if (this.log.isRowLevel()) {
                for (int i = 0; i < rowBuffer.size() && !this.isStopped(); ++i) {
                    Object[] b = rowBuffer.get(i);
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.RowLevel.PrintRow", (Object[])new Object[]{i, this.data.inputRowMeta.getString(b)}));
                }
            }
            RowTempFile rowTempFile = tempRows.remove(0);
            retval = rowTempFile.row;
            int smallest = rowTempFile.fileNumber;
            FileObject file = filesOrder.get(smallest);
            DataInputStream di = dis.get(smallest);
            InputStream fi = fis.get(smallest);
            try {
                Object[] row2 = this.data.inputRowMeta.readData(di);
                RowTempFile extra = new RowTempFile(row2, smallest);
                int index = Collections.binarySearch(tempRows, extra, this.data.comparator);
                if (index < 0) {
                    tempRows.add(index * -1 - 1, extra);
                } else {
                    tempRows.add(index, extra);
                }
            }
            catch (KettleFileException fe) {
                GZIPInputStream gzfi = this.data.compressFiles ? gzis.get(smallest) : null;
                try {
                    di.close();
                    fi.close();
                    if (gzfi != null) {
                        gzfi.close();
                    }
                    file.delete();
                }
                catch (IOException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Error.UnableToCloseFile", (Object[])new Object[]{smallest, file.toString()}));
                    this.setErrors(1L);
                    this.stopAll();
                    return null;
                }
                filesOrder.remove(smallest);
                dis.remove(smallest);
                fis.remove(smallest);
                if (gzfi != null) {
                    gzis.remove(smallest);
                }
                for (RowTempFile rtf : tempRows) {
                    if (rtf.fileNumber <= smallest) continue;
                    --rtf.fileNumber;
                }
            }
            catch (SocketTimeoutException e) {
                throw new KettleValueException((Throwable)e);
            }
        }
        return retval;
    }

    private void clearBuffers(int buffernr, List<Object[]> buffer, List<FileObject> filesOrder, List<DataInputStream> dis, List<InputStream> fis, List<Object[]> rowBuffer) {
        buffer.clear();
        if (buffernr == 1) {
            this.data.getBufferIndex1 = 0;
        } else {
            this.data.getBufferIndex2 = 0;
        }
        rowBuffer.clear();
        if (dis != null && dis.size() > 0) {
            for (DataInputStream di : dis) {
                BaseStep.closeQuietly((Closeable)di);
            }
        }
        if (fis != null && fis.size() > 0) {
            for (InputStream is : fis) {
                BaseStep.closeQuietly((Closeable)is);
            }
        }
        for (int f = 0; f < filesOrder.size(); ++f) {
            FileObject fileToDelete = filesOrder.get(f);
            try {
                if (fileToDelete == null || !fileToDelete.exists()) continue;
                fileToDelete.delete();
                continue;
            }
            catch (FileSystemException e) {
                this.logError(e.getLocalizedMessage(), e);
            }
        }
    }

    private DataInputStream getDataInputStream(GZIPInputStream gzipInputStream, List<GZIPInputStream> gzis) {
        DataInputStream result = new DataInputStream(gzipInputStream);
        gzis.add(gzipInputStream);
        return result;
    }

    void quickSort(List<Object[]> elements) throws KettleException {
        if (elements.size() > 0) {
            Collections.sort(elements, this.data.rowComparator);
            long nrConversions = 0L;
            for (ValueMetaInterface valueMeta : this.data.outputRowMeta.getValueMetaList()) {
                nrConversions += valueMeta.getNumberOfBinaryStringConversions();
                valueMeta.setNumberOfBinaryStringConversions(0L);
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"MergeUpsertDelete.Sort.Detailed.ReportNumberOfBinaryStringConv", (Object[])new Object[]{nrConversions}));
            }
        }
    }

    private class RowObjectArrayComparator
    extends SortRowsComparator
    implements Comparator<Object[]> {
        RowObjectArrayComparator(RowMetaInterface rowMeta, int[] fieldNrs) {
            super(rowMeta, fieldNrs);
        }

        @Override
        public int compare(Object[] o1, Object[] o2) {
            try {
                return this.rowMeta.compare(o1, o2, this.fieldNrs);
            }
            catch (KettleValueException e) {
                MergeUpsertDelete.this.logError("Error comparing rows: " + e.toString());
                return 0;
            }
        }
    }

    private class RowTemapFileComparator
    extends SortRowsComparator
    implements Comparator<RowTempFile> {
        RowTemapFileComparator(RowMetaInterface rowMeta, int[] fieldNrs) {
            super(rowMeta, fieldNrs);
        }

        @Override
        public int compare(RowTempFile o1, RowTempFile o2) {
            try {
                return this.rowMeta.compare(o1.row, o2.row, this.fieldNrs);
            }
            catch (KettleValueException e) {
                MergeUpsertDelete.this.logError("Error comparing rows: " + e.toString());
                return 0;
            }
        }
    }

    private class SortRowsComparator {
        protected RowMetaInterface rowMeta;
        protected int[] fieldNrs;

        SortRowsComparator(RowMetaInterface rowMeta, int[] fieldNrs) {
            this.rowMeta = rowMeta;
            this.fieldNrs = fieldNrs;
        }
    }
}

