/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.docbundle.bundlefactory;

import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.StaticDocumentBundle;
import org.pentaho.reporting.libraries.docbundle.bundleloader.RepositoryResourceBundleData;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.resourceloader.ContentNotRecognizedException;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.SimpleResource;
import org.pentaho.reporting.libraries.resourceloader.cache.CachingResourceBundleData;

public class BundleResourceFactory
implements ResourceFactory {
    public Class getFactoryType() {
        return DocumentBundle.class;
    }

    public Resource create(ResourceManager manager, ResourceData data, ResourceKey context) throws ResourceCreationException, ResourceLoadingException {
        CachingResourceBundleData cachingResourceBundleData;
        if (data instanceof CachingResourceBundleData) {
            cachingResourceBundleData = (CachingResourceBundleData)data;
            data = cachingResourceBundleData.getBackend();
        }
        if (!(data instanceof RepositoryResourceBundleData) && (data = manager.loadResourceBundle(data.getKey())) instanceof CachingResourceBundleData) {
            cachingResourceBundleData = (CachingResourceBundleData)data;
            data = cachingResourceBundleData.getBackend();
        }
        if (!(data instanceof RepositoryResourceBundleData)) {
            throw new ContentNotRecognizedException("No valid handler for the given content.");
        }
        RepositoryResourceBundleData bdata = (RepositoryResourceBundleData)data;
        Repository repository = bdata.getRepository();
        try {
            StaticDocumentBundle bundle = new StaticDocumentBundle(repository, manager, bdata.getBundleKey());
            return new SimpleResource(data.getKey(), (Object)bundle, this.getFactoryType(), data.getVersion(manager));
        }
        catch (ResourceException e) {
            throw new ResourceCreationException("Unable to interpret document-bundle", (Exception)((Object)e));
        }
    }

    public void initializeDefaults() {
    }
}

