/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.GeneratedScrollableResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class InsensitiveScrollableResultSet
extends GeneratedScrollableResultSet {
    protected boolean isAllFetched;
    protected boolean isDoneFetchingRows = false;
    protected final long maxRows;

    InsensitiveScrollableResultSet(PhysicalConnection physicalConnection, OracleStatement oracleStatement) throws SQLException {
        super(physicalConnection, oracleStatement);
        this.fetchedRowCount = oracleStatement.validRows;
        this.isAllFetched = oracleStatement.isAllFetched;
        this.maxRows = oracleStatement.getMaxRows();
        if (this.maxRows > 0L && this.maxRows < this.fetchedRowCount) {
            this.fetchedRowCount = this.maxRows;
            this.doneFetchingRows(false);
        }
    }

    void ensureOpen() throws SQLException {
        this.ensureOpen(null);
    }

    void ensureOpen(String string) throws SQLException {
        if (this.closed) {
            if (this.connection.isClosed()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, string).fillInStackTrace();
            }
            throw (SQLException)DatabaseError.createSqlException(10, string).fillInStackTrace();
        }
        if (this.statement.closed) {
            throw (SQLException)DatabaseError.createSqlException(9, string).fillInStackTrace();
        }
    }

    void ensureOpenPlus(String string) throws SQLException {
        this.ensureOpen(string);
        if (this.isForwardOnly()) {
            throw (SQLException)DatabaseError.createSqlException(75, string).fillInStackTrace();
        }
    }

    protected boolean isForwardOnly() throws SQLException {
        this.ensureOpen("isForwardOnly");
        return false;
    }

    @Override
    public int getType() throws SQLException {
        this.ensureOpen("getType");
        return 1004;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.ensureOpen("getConcurrency");
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getCursorName");
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName").fillInStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                return;
            }
            super.close();
            if (this.statement.numReturnParams <= 0) {
                this.doneFetchingRows(false);
                this.statement.endOfResultSet(false);
                this.statement.closeCursorOnPlainStatement();
            }
            this.statement.closeByDependent();
            if (this.statement.isClosed() && this.statement.wrapper != null) {
                this.statement.wrapper.beClosed(this.connection.isClosed());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasNull() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("wasNull");
            return this.statement.wasNullValue(this.currentRow);
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.ensureOpen("rowDeleted");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getMetaData");
            if (!this.statement.isOpen) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 144, "getMetaData").fillInStackTrace();
            }
            return this.statement.getResultSetMetaData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement getStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getStatement");
            return this.statement.wrapper == null ? this.statement : this.statement.wrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findColumn(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("findColumn");
            return this.statement.getColumnIndex(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("setFetchSize");
            this.statement.setPrefetchInternal(n2, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchSize() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getFetchSize");
            return this.statement.getPrefetchInternal(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBeforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("isBeforeFirst");
            return !this.isEmptyResultSet() && this.currentRow == -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("isAfterLast");
            return this.currentRow == this.fetchedRowCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("isFirst");
            return !this.isEmptyResultSet() && this.currentRow == 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("isLast");
            if (this.isForwardOnly()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "isLast").fillInStackTrace();
            }
            if (!this.isAllFetched && this.currentRow + 1L == this.fetchedRowCount) {
                this.fetchMoreRows();
            }
            assert (this.isAllFetched || this.fetchedRowCount > this.currentRow + 1L) : "isAllFetched: " + this.isAllFetched + ", fetchedRowCount: " + this.fetchedRowCount + ", currentRow: " + this.currentRow;
            if (this.fetchedRowCount == 0L) {
                return false;
            }
            return this.isAllFetched && this.currentRow + 1L == this.fetchedRowCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getRow");
            if (this.isEmptyResultSet()) {
                return 0;
            }
            if (this.currentRow == this.fetchedRowCount) {
                return 0;
            }
            return (int)this.currentRow + 1;
        }
    }

    @Override
    public boolean absolute(int n2) throws SQLException {
        this.ensureOpen("absolute");
        if (this.connection.isClosed()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "absolute").fillInStackTrace();
        }
        if (this.isForwardOnly()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "absolute").fillInStackTrace();
        }
        return this.absoluteInternal(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean first() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("first");
            if (this.connection.isClosed()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "first").fillInStackTrace();
            }
            if (this.isForwardOnly()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "first").fillInStackTrace();
            }
            return this.absoluteInternal(1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("next");
            if (this.statement.sqlKind.isPlsqlOrCall()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 166, "next").fillInStackTrace();
            }
            return this.absoluteInternal(this.currentRow + 2L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean previous() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpenPlus("previous");
            if (this.currentRow > -1L) {
                return this.absoluteInternal(this.currentRow);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean last() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpenPlus("last");
            if (this.isEmptyResultSet()) {
                return false;
            }
            while (!this.isAllFetched) {
                this.fetchMoreRows();
            }
            this.currentRow = this.fetchedRowCount - 1L;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpenPlus("beforeFirst");
            if (this.isForwardOnly()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "beforeFirst").fillInStackTrace();
            }
            this.absolute(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpenPlus("afterLast");
            if (!this.isEmptyResultSet()) {
                while (!this.isAllFetched) {
                    this.fetchMoreRows();
                }
                this.currentRow = this.fetchedRowCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean relative(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpenPlus("relative");
            if (n2 == 0) {
                return this.isValidRow();
            }
            if (n2 == 1) {
                return this.next();
            }
            if (n2 == -1) {
                return this.previous();
            }
            if (this.currentRow + (long)n2 < 0L) {
                return this.absoluteInternal(0L);
            }
            return this.absoluteInternal(this.currentRow + (long)n2 + 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("refreshRow");
            if (!this.statement.isRowidPrepended) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "refreshRow").fillInStackTrace();
            }
            if (this.currentRow < 0L || this.currentRow >= this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11, "refreshRow").fillInStackTrace();
            }
            try {
                long l2 = this.currentRow;
                if (this.getFetchDirection() == 1001) {
                    l2 = Math.max(0L, this.currentRow - (long)this.getFetchSize());
                }
                this.refreshRows(l2, this.getFetchSize());
            }
            catch (SQLRecoverableException sQLRecoverableException) {
                throw sQLRecoverableException;
            }
            catch (SQLException sQLException) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Unsupported syntax for refreshRow()", (Throwable)sQLException).fillInStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getObject(int n2, Class<T> clazz) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getObject");
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getObject").fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14, "getObject").fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289, "getObject").fillInStackTrace();
            }
            return this.statement.getObject(this.currentRow, n2, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBytes(int n2, byte[] byArray, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getBytes").fillInStackTrace();
            }
            if (this.connection.isClosed()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getBytes").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            return this.statement.getBytes(this.currentRow, n2, byArray, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getAuthorizationIndicator");
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14, "getAuthorizationIndicator").fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289, "getAuthorizationIndicator").fillInStackTrace();
            }
            return this.statement.getAuthorizationIndicator(this.currentRow, n2);
        }
    }

    void hackLast() throws SQLException {
        assert (this.isAfterLast()) : "not after last";
        this.currentRow = this.fetchedRowCount - 1L;
    }

    protected boolean absoluteInternal(long l2) throws SQLException {
        long l3 = l2 - 1L;
        if (l2 == 0L) {
            this.currentRow = l3;
        } else if (l3 >= 0L && l3 < this.fetchedRowCount) {
            this.currentRow = l3;
        } else if (l3 >= 0L) {
            while (!this.isAllFetched && this.fetchedRowCount <= l3) {
                this.fetchMoreRows();
            }
            if (l3 < this.fetchedRowCount) {
                this.currentRow = l3;
            } else {
                assert (this.isAllFetched) : "isAllFetched: " + this.isAllFetched;
                this.currentRow = this.fetchedRowCount;
                if (this.isForwardOnly()) {
                    this.doneFetchingRows(false);
                }
            }
        } else {
            while (!this.isAllFetched) {
                this.fetchMoreRows();
            }
            l3 = this.fetchedRowCount + l2;
            this.currentRow = l3 >= 0L && l3 < this.fetchedRowCount ? l3 : -1L;
        }
        assert (this.currentRow < this.fetchedRowCount || this.isAllFetched) : "currentRow: " + this.currentRow + ", fetchedRowCount: " + this.fetchedRowCount + ", isAllFetched: " + this.isAllFetched;
        assert (-1L <= this.currentRow && this.currentRow <= this.fetchedRowCount) : "currentRow: " + this.currentRow + ", fetchedRowCount: " + this.fetchedRowCount;
        return this.currentRow > -1L && this.currentRow < this.fetchedRowCount;
    }

    protected void fetchMoreRows() throws SQLException {
        assert (!this.isAllFetched) : "isAllFetched: " + this.isAllFetched;
        this.clearWarnings();
        this.fetchedRowCount += this.statement.fetchMoreRows(this.fetchedRowCount);
        this.isAllFetched = this.statement.isAllFetched;
        if (this.currentRow == this.fetchedRowCount && this.isForwardOnly()) {
            this.doneFetchingRows(false);
        }
        if (this.maxRows > 0L && this.fetchedRowCount > this.maxRows) {
            this.fetchedRowCount = this.maxRows;
            this.doneFetchingRows(false);
            this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 275);
        }
    }

    @Override
    protected void doneFetchingRows(boolean bl) throws SQLException {
        if (this.isDoneFetchingRows) {
            return;
        }
        this.isDoneFetchingRows = true;
        this.isAllFetched = true;
        try {
            this.statement.closeQuery();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected boolean isEmptyResultSet() throws SQLException {
        if (this.fetchedRowCount > 0L) {
            return false;
        }
        if (this.isAllFetched) {
            return true;
        }
        this.fetchMoreRows();
        assert (this.fetchedRowCount >= 0L) : "fetchedRowCount: " + this.fetchedRowCount;
        return this.fetchedRowCount == 0L;
    }

    @Override
    boolean isValidRow() throws SQLException {
        return this.currentRow > -1L && this.currentRow < this.fetchedRowCount;
    }

    protected long getValidRows() {
        return this.fetchedRowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    OracleStatement getOracleStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.statement;
        }
    }

    @Override
    void removeCurrentRowFromCache() throws SQLException {
        assert (this.currentRow < this.fetchedRowCount) : "currentRow:" + this.currentRow + " fetchedRowCount:" + this.fetchedRowCount;
        if (!this.isAllFetched && this.currentRow + 1L == this.fetchedRowCount) {
            this.fetchMoreRows();
        }
        this.statement.removeRowFromCache(this.currentRow);
        --this.fetchedRowCount;
    }

    @Override
    int refreshRows(long l2, int n2) throws SQLException {
        return this.statement.refreshRows(l2, n2);
    }

    @Override
    void insertRow(RowId rowId) throws SQLException {
        if (this.currentRow < this.fetchedRowCount) {
            this.statement.insertRow(this.currentRow + 1L, rowId);
            ++this.currentRow;
        } else {
            this.statement.insertRow(this.currentRow, rowId);
        }
        ++this.fetchedRowCount;
    }

    @Override
    int getColumnCount() throws SQLException {
        if (this.statement.accessors != null) {
            return this.statement.numberOfDefinePositions - (1 + this.statement.offsetOfFirstUserColumn);
        }
        return this.getMetaData().getColumnCount();
    }

    RowId getPrependedRowId() throws SQLException {
        return this.statement.getPrependedRowId(this.currentRow);
    }
}

