/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.workitem;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.pentaho.platform.api.workitem.IWorkItemLifecycleEvent;
import org.pentaho.platform.api.workitem.IWorkItemLifecycleEventPublisher;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.workitem.WorkItemLifecycleEvent;
import org.pentaho.platform.workitem.WorkItemLifecyclePhase;

public class WorkItemLifecycleEventUtil {
    public static void publish(String workItemUid, Map<String, Serializable> details, WorkItemLifecyclePhase workItemLifecyclePhase) {
        WorkItemLifecycleEventUtil.publish(workItemUid, details, workItemLifecyclePhase, null, null);
    }

    public static void publish(String workItemUid, Map<String, Serializable> details, WorkItemLifecyclePhase workItemLifecyclePhase, String lifecycleDetails) {
        WorkItemLifecycleEventUtil.publish(workItemUid, details, workItemLifecyclePhase, lifecycleDetails, null);
    }

    public static void publish(String workItemUid, Map<String, Serializable> details, WorkItemLifecyclePhase workItemLifecyclePhase, String lifecycleDetails, Date sourceTimestamp) {
        IWorkItemLifecycleEvent workItemLifecycleEvent = WorkItemLifecycleEventUtil.createEvent(workItemUid, WorkItemLifecycleEventUtil.extractDetails(details), workItemLifecyclePhase, lifecycleDetails, sourceTimestamp);
        WorkItemLifecycleEventUtil.publish(workItemLifecycleEvent);
    }

    public static void publish(String workItemUid, String details, WorkItemLifecyclePhase workItemLifecyclePhase, String lifecycleDetails) {
        IWorkItemLifecycleEvent workItemLifecycleEvent = WorkItemLifecycleEventUtil.createEvent(workItemUid, details, workItemLifecyclePhase, lifecycleDetails, null);
        WorkItemLifecycleEventUtil.publish(workItemLifecycleEvent);
    }

    protected static IWorkItemLifecycleEvent createEvent(String workItemUid, String workItemDetails, WorkItemLifecyclePhase workItemLifecyclePhase, String lifecycleDetails, Date sourceTimestamp) {
        return new WorkItemLifecycleEvent(workItemUid, workItemDetails, workItemLifecyclePhase, lifecycleDetails, sourceTimestamp);
    }

    public static void publish(IWorkItemLifecycleEvent workItemLifecycleEvent) {
        IWorkItemLifecycleEventPublisher publisher = PentahoSystem.get(IWorkItemLifecycleEventPublisher.class);
        if (publisher != null) {
            publisher.publish(workItemLifecycleEvent);
        }
    }

    private static String extractDetails(Map<String, Serializable> detailsMap) {
        if (detailsMap == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (detailsMap.containsKey("inputFile")) {
            sb.append(detailsMap.get("inputFile").toString());
            if (detailsMap.containsKey("actionUser")) {
                sb.append("[");
                sb.append(detailsMap.get("actionUser").toString());
                sb.append("]");
            }
        }
        if (detailsMap.containsKey("UUID")) {
            sb.append("UUID").append(" ").append(detailsMap.get("UUID").toString());
        }
        if (detailsMap.containsKey("status")) {
            sb.append(detailsMap.get("status").toString());
        }
        return sb.toString();
    }
}

