/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.action.ActionInvocationException;
import org.pentaho.platform.api.action.IAction;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.PluginBeanException;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;
import org.pentaho.platform.api.workitem.IWorkItemLifecycleEventPublisher;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.Emailer;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.platform.util.messages.Messages;
import org.pentaho.platform.util.web.MimeHelper;

public class ActionUtil {
    private static final Log logger = LogFactory.getLog(ActionUtil.class);
    public static final String QUARTZ_ACTIONCLASS = "ActionAdapterQuartzJob-ActionClass";
    public static final String QUARTZ_ACTIONUSER = "ActionAdapterQuartzJob-ActionUser";
    public static final String QUARTZ_ACTIONID = "ActionAdapterQuartzJob-ActionId";
    public static final String QUARTZ_STREAMPROVIDER = "ActionAdapterQuartzJob-StreamProvider";
    public static final String QUARTZ_STREAMPROVIDER_INPUT_FILE = "ActionAdapterQuartzJob-StreamProvider-InputFile";
    public static final String QUARTZ_STREAMPROVIDER_INLINE_INPUT_FILE = "input file =";
    public static final String QUARTZ_STREAMPROVIDER_INLINE_OUTPUT_FILE = ":output file=";
    public static final String QUARTZ_UIPASSPARAM = "uiPassParam";
    public static final String QUARTZ_LINEAGE_ID = "lineage-id";
    public static final String QUARTZ_RESTART_FLAG = "ActionAdapterQuartzJob-Restart";
    public static final String QUARTZ_AUTO_CREATE_UNIQUE_FILENAME = "autoCreateUniqueFilename";
    public static final String QUARTZ_APPEND_DATE_FORMAT = "appendDateFormat";
    public static final String INVOKER_ACTIONPARAMS = "actionParams";
    public static final String INVOKER_ACTIONCLASS = "actionClass";
    public static final String INVOKER_ACTIONUSER = "actionUser";
    public static final String INVOKER_ACTIONID = "actionId";
    public static final String INVOKER_UUID = "UUID";
    public static final String INVOKER_CONTENT_TYPE = "contentType";
    public static final String INVOKER_STATUS = "status";
    public static final String INVOKER_STREAMPROVIDER = "streamProvider";
    public static final String INVOKER_STREAMPROVIDER_INPUT_FILE = "inputFile";
    public static final String INVOKER_STREAMPROVIDER_OUTPUT_FILE_PATTERN = "outputFilePattern";
    public static final String INVOKER_STREAMPROVIDER_UNIQUE_FILE_NAME = "autoCreateUniqueFilename";
    public static final String INVOKER_UIPASSPARAM = "uiPassParam";
    public static final String INVOKER_RESTART_FLAG = "restart";
    public static final String INVOKER_SESSION = "::session";
    public static final String INVOKER_ASYNC_EXEC = "async";
    public static final String INVOKER_DEFAULT_ASYNC_EXEC_VALUE = "true";
    public static final String INVOKER_SYNC_VALUE = "false";
    public static final String WORK_ITEM_UID = "workItemUid";
    public static final String WORK_ITEM_NAME = "workItemName";
    private static final String WORK_ITEM_UID_INVALID_CHARS = "[^\\w\\\\-]+";
    private static final int WORK_ITEM_LENGTH_LIMIT = 1000;
    private static final Map<String, String> KEY_MAP = new HashMap<String, String>();
    private static final long RETRY_COUNT = 6L;
    private static final long RETRY_SLEEP_AMOUNT = 10000L;

    public static void removeKeyFromMap(Map<String, ?> params, String key) {
        if (params == null || key == null) {
            logger.debug((Object)"Map or key are null, cannot remove.");
            return;
        }
        params.remove(key);
        if (KEY_MAP.containsKey(key)) {
            params.remove(KEY_MAP.get(key));
        } else if (KEY_MAP.containsValue(key)) {
            for (Map.Entry<String, String> entry : KEY_MAP.entrySet()) {
                String keyMapKey = entry.getKey();
                String keyMapValue = entry.getValue();
                if (!key.equals(keyMapValue)) continue;
                params.remove(keyMapKey);
                break;
            }
        }
    }

    public static void prepareMap(Map<String, Serializable> params) {
        if (params == null) {
            return;
        }
        HashMap<String, Serializable> replaced = new HashMap<String, Serializable>();
        for (Map.Entry<String, Serializable> ent : params.entrySet()) {
            String key = ent.getKey();
            Serializable value = params.get(key);
            String altKey = KEY_MAP.get(key);
            replaced.put(altKey == null ? key : altKey, value);
        }
        params.clear();
        params.putAll(replaced);
    }

    public static String extractName(Map<String, Serializable> params) {
        IWorkItemLifecycleEventPublisher publisher = PentahoSystem.get(IWorkItemLifecycleEventPublisher.class);
        if (publisher == null) {
            return null;
        }
        if (params == null) {
            return ActionUtil.generateWorkItemName(params);
        }
        String name = (String)((Object)params.get(WORK_ITEM_NAME));
        if (name == null) {
            name = ActionUtil.generateWorkItemName(params);
            params.put(WORK_ITEM_NAME, (Serializable)((Object)name));
        }
        return name;
    }

    public static String generateWorkItemName(Map<String, Serializable> params) {
        if (params == null) {
            return ActionUtil.generateWorkItemName(null, null);
        }
        String userName = Optional.ofNullable((String)((Object)params.get(INVOKER_ACTIONUSER))).orElse((String)((Object)params.get(QUARTZ_ACTIONUSER)));
        String inputFilePath = Optional.ofNullable((String)((Object)params.get(INVOKER_STREAMPROVIDER_INPUT_FILE))).orElse((String)((Object)params.get(QUARTZ_STREAMPROVIDER_INPUT_FILE)));
        if (StringUtil.isEmpty(inputFilePath) && ActionUtil.isInlinePassingOfInputOnStreamProvider(params)) {
            inputFilePath = ActionUtil.getInlineInputFileOnStreamProvider(params);
        }
        return ActionUtil.generateWorkItemName(inputFilePath, userName);
    }

    public static boolean isInlinePassingOfInputOnStreamProvider(Map<String, Serializable> params) {
        return params != null && ActionUtil.getStreamProviderContent(params).contains(QUARTZ_STREAMPROVIDER_INLINE_INPUT_FILE);
    }

    public static String getInlineInputFileOnStreamProvider(Map<String, Serializable> params) {
        try {
            String streamProviderContent = ActionUtil.getStreamProviderContent(params);
            int startIdx = streamProviderContent.indexOf(QUARTZ_STREAMPROVIDER_INLINE_INPUT_FILE) + QUARTZ_STREAMPROVIDER_INLINE_INPUT_FILE.length();
            int endIdx = streamProviderContent.indexOf(QUARTZ_STREAMPROVIDER_INLINE_OUTPUT_FILE);
            if (startIdx >= 0 && endIdx >= 0 && endIdx > startIdx) {
                return streamProviderContent.substring(startIdx, endIdx).trim();
            }
        }
        catch (Throwable t) {
            logger.error((Object)t);
        }
        return null;
    }

    public static String getStreamProviderContent(Map<String, Serializable> params) {
        return (params.containsKey(QUARTZ_STREAMPROVIDER) ? params.get(QUARTZ_STREAMPROVIDER) : (params.containsKey(INVOKER_STREAMPROVIDER) ? params.get(INVOKER_STREAMPROVIDER) : "")).toString().trim();
    }

    public static String generateWorkItemName(String inputFilePath, String userName) {
        String workItemName;
        if (StringUtil.isEmpty(inputFilePath)) {
            logger.info((Object)"Input file path is not provided.");
        }
        if (StringUtil.isEmpty(userName)) {
            logger.info((Object)"User name is not provided.");
        }
        if ((workItemName = String.format("%s[%s]", Optional.ofNullable(inputFilePath).orElse(""), Optional.ofNullable(userName).orElse(""))).length() > 1000) {
            logger.info((Object)String.format("Work item name exceeds max character limit of %d: %d", 1000, workItemName.length()));
        }
        return workItemName;
    }

    static Class<?> resolveActionClass(String actionClassName, String beanId) throws PluginBeanException, ActionInvocationException {
        return ActionUtil.resolveActionClass(actionClassName, beanId, true);
    }

    static Class<?> resolveActionClass(String actionClassName, String beanId, boolean retryBeanInstantiationIfFailed) throws PluginBeanException, ActionInvocationException {
        Class clazz = null;
        if (StringUtils.isEmpty((String)beanId) && StringUtils.isEmpty((String)actionClassName)) {
            throw new ActionInvocationException(Messages.getInstance().getErrorString("ActionUtil.ERROR_0001_REQUIRED_PARAM_MISSING", INVOKER_ACTIONCLASS, INVOKER_ACTIONID));
        }
        long retryCount = retryBeanInstantiationIfFailed ? 6L : 1L;
        long retrySleepCount = retryBeanInstantiationIfFailed ? 10000L : 1L;
        int i = 0;
        while ((long)i < retryCount) {
            try {
                IPluginManager pluginManager;
                if (!StringUtils.isEmpty((String)beanId) && (clazz = (pluginManager = PentahoSystem.get(IPluginManager.class)).loadClass(beanId)) != null) {
                    return clazz;
                }
                if (!StringUtils.isEmpty((String)actionClassName)) {
                    clazz = Class.forName(actionClassName);
                    return clazz;
                }
            }
            catch (Throwable t) {
                try {
                    Thread.sleep(retrySleepCount);
                }
                catch (InterruptedException ie) {
                    logger.info((Object)ie.getMessage(), (Throwable)ie);
                }
            }
            ++i;
        }
        throw new ActionInvocationException(Messages.getInstance().getErrorString("ActionUtil.ERROR_0002_FAILED_TO_CREATE_ACTION", StringUtils.isEmpty((String)beanId) ? actionClassName : beanId));
    }

    public static IAction createActionBean(String actionClassName, String actionId) throws ActionInvocationException {
        return ActionUtil.createActionBean(actionClassName, actionId, true);
    }

    public static IAction createActionBean(String actionClassName, String actionId, boolean retryBeanInstantiationIfFailed) throws ActionInvocationException {
        Object actionBean = null;
        Class<?> actionClass = null;
        try {
            actionClass = ActionUtil.resolveActionClass(actionClassName, actionId, retryBeanInstantiationIfFailed);
            actionBean = actionClass.newInstance();
        }
        catch (Exception e) {
            Object[] objectArray = new Object[2];
            objectArray[0] = StringUtils.isEmpty((String)actionId) ? (actionClass == null ? "?" : actionClass.getName()) : actionId;
            objectArray[1] = e;
            throw new ActionInvocationException(Messages.getInstance().getErrorString("ActionUtil.ERROR_0002_FAILED_TO_CREATE_ACTION", objectArray));
        }
        if (!(actionBean instanceof IAction)) {
            throw new ActionInvocationException(Messages.getInstance().getErrorString("ActionUtil.ERROR_0003_ACTION_WRONG_TYPE", actionClass.getName(), IAction.class.getName()));
        }
        return actionBean;
    }

    public static void sendEmail(Map<String, Object> actionParams, Map<String, Serializable> params, String filePath) {
        try {
            Emailer emailer = new Emailer();
            if (!emailer.setup()) {
                return;
            }
            if (filePath != null) {
                ActionUtil.addAttachment(actionParams, params, filePath, emailer);
            }
            String to = (String)actionParams.get("_SCH_EMAIL_TO");
            String cc = (String)actionParams.get("_SCH_EMAIL_CC");
            String bcc = (String)actionParams.get("_SCH_EMAIL_BCC");
            if (!(to != null && !"".equals(to) || cc != null && !"".equals(cc) || bcc != null && !"".equals(bcc))) {
                return;
            }
            emailer.setTo(to);
            emailer.setCc(cc);
            emailer.setBcc(bcc);
            String subject = (String)actionParams.get("_SCH_EMAIL_SUBJECT");
            if (subject != null && !"".equals(subject)) {
                emailer.setSubject(subject);
            } else {
                emailer.setSubject("Pentaho Scheduler" + (emailer.getAttachmentName() != null ? " : " + emailer.getAttachmentName() : ""));
            }
            String message = (String)actionParams.get("_SCH_EMAIL_MESSAGE");
            if (subject != null && !"".equals(subject)) {
                emailer.setBody(message);
            }
            emailer.send();
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static void addAttachment(Map<String, Object> actionParams, Map<String, Serializable> params, String filePath, Emailer emailer) {
        IUnifiedRepository repo = PentahoSystem.get(IUnifiedRepository.class);
        RepositoryFile sourceFile = repo.getFile(filePath);
        Map metadata = repo.getFileMetadata(sourceFile.getId());
        String lineageId = (String)((Object)params.get(QUARTZ_LINEAGE_ID));
        metadata.put(QUARTZ_LINEAGE_ID, lineageId);
        repo.setFileMetadata(sourceFile.getId(), metadata);
        SimpleRepositoryFileData data = (SimpleRepositoryFileData)repo.getDataForRead(sourceFile.getId(), SimpleRepositoryFileData.class);
        emailer.setAttachment(data.getInputStream());
        emailer.setAttachmentName("attachment");
        String attachmentName = (String)actionParams.get("_SCH_EMAIL_ATTACHMENT_NAME");
        if (!StringUtils.isEmpty((String)attachmentName)) {
            String extension = MimeHelper.getExtension(data.getMimeType(), ".bin");
            emailer.setAttachmentName(attachmentName.endsWith(extension) ? attachmentName : attachmentName + extension);
        } else if (data != null) {
            String path = filePath;
            if (path.endsWith(".*")) {
                path = path.replace(".*", "");
            }
            String extension = MimeHelper.getExtension(data.getMimeType(), ".bin");
            path = path.substring(path.lastIndexOf("/") + 1, path.length());
            emailer.setAttachmentName(attachmentName.endsWith(extension) ? path : path + extension);
        }
        if (data == null || data.getMimeType() == null || "".equals(data.getMimeType())) {
            emailer.setAttachmentMimeType("binary/octet-stream");
        } else {
            emailer.setAttachmentMimeType(data.getMimeType());
        }
    }

    static {
        KEY_MAP.put(QUARTZ_ACTIONCLASS, INVOKER_ACTIONCLASS);
        KEY_MAP.put(QUARTZ_ACTIONUSER, INVOKER_ACTIONUSER);
        KEY_MAP.put(QUARTZ_ACTIONID, INVOKER_ACTIONID);
        KEY_MAP.put(QUARTZ_STREAMPROVIDER, INVOKER_STREAMPROVIDER);
        KEY_MAP.put(QUARTZ_STREAMPROVIDER_INPUT_FILE, INVOKER_STREAMPROVIDER_INPUT_FILE);
        KEY_MAP.put(QUARTZ_RESTART_FLAG, INVOKER_RESTART_FLAG);
    }
}

