/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Node;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.UnknownKeyException;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.ui.RectangleEdge;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.PentahoDataTransmuter;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.uifoundation.chart.ChartDefinition;
import org.pentaho.platform.uifoundation.chart.JFreeChartEngine;
import org.pentaho.platform.uifoundation.messages.Messages;

public class PieDatasetChartDefinition
extends DefaultPieDataset
implements ChartDefinition {
    protected static final Log logger = LogFactory.getLog(PieDatasetChartDefinition.class);
    private static final long serialVersionUID = 1L;
    private static final String INTERIOR_GAP_NODE_NAME = "interior-gap";
    private static final String START_ANGLE_NODE_NAME = "start-angle";
    private static final String LABEL_FONT_NODE_NAME = "label-font";
    private static final String LABEL_PAINT_NODE_NAME = "label-paint";
    private static final String LABEL_BACKGROUND_PAINT_NODE_NAME = "label-background-paint";
    private static final String LABEL_GAP_NODE_NAME = "label-gap";
    private static final String SLICE_NODE_NAME = "slice";
    private static final String EXPLODE_SLICE_NODE_NAME = "explode-slices";
    private String title = "";
    private String noDataMessage = null;
    private RectangleEdge titlePosition = RectangleEdge.TOP;
    private Font titleFont = TextTitle.DEFAULT_FONT;
    private final List subTitles = new ArrayList();
    private final List explodeSlices = new ArrayList();
    private Paint chartBackgroundPaint = Color.WHITE;
    private Image chartBackgroundImage = null;
    private boolean borderVisible = false;
    private Paint borderPaint = Color.BLACK;
    private int width = 200;
    private int height = 200;
    private Paint plotBackgroundPaint = Color.WHITE;
    private Image plotBackgroundImage = null;
    private Paint[] paintSequence = null;
    private boolean legendIncluded = true;
    private boolean threeD = false;
    private boolean displayLabels = true;
    private double interiorGap = 0.085;
    private double startAngle = 90.0;
    private Font labelFont = new Font("SansSerif", 0, 10);
    private Paint labelPaint = Color.BLACK;
    private Paint labelBackgroundPaint = new Color(255, 255, 204);
    private double labelGap = 0.1;
    private IPentahoSession session;
    private Font legendFont = null;
    private boolean legendBorderVisible = true;
    private RectangleEdge legendPosition = RectangleEdge.BOTTOM;
    private Float backgroundAlpha;
    private Float foregroundAlpha;

    public PieDatasetChartDefinition(IPentahoSession session) {
        this.session = session;
    }

    public PieDatasetChartDefinition(IPentahoResultSet data, boolean byRow, IPentahoSession session) {
        this(session);
        if (byRow) {
            this.setDataByRow(data);
        } else {
            this.setDataByColumn(data);
        }
    }

    public PieDatasetChartDefinition(IPentahoResultSet data, boolean byRow, Node chartAttributes, IPentahoSession session) {
        this(data, byRow, session);
        this.setChartAttributes(chartAttributes);
    }

    public static Log getLogger() {
        return LogFactory.getLog(PieDatasetChartDefinition.class);
    }

    private void setChartAttributes(Node chartAttributes) {
        List subtitles;
        if (chartAttributes == null) {
            return;
        }
        this.setChartBackground(chartAttributes.selectSingleNode("chart-background"));
        this.setPlotBackground(chartAttributes.selectSingleNode("plot-background"));
        this.setLegendIncluded(chartAttributes.selectSingleNode("include-legend"));
        this.setTitle(chartAttributes.selectSingleNode("title"));
        Node backgroundAlphaNode = chartAttributes.selectSingleNode("background-alpha");
        Node foregroundAlphaNode = chartAttributes.selectSingleNode("foreground-alpha");
        if (backgroundAlphaNode != null) {
            this.setBackgroundAlpha(chartAttributes.selectSingleNode("background-alpha"));
        }
        if (foregroundAlphaNode != null) {
            this.setForegroundAlpha(chartAttributes.selectSingleNode("foreground-alpha"));
        }
        if ((subtitles = chartAttributes.selectNodes("subtitle")) == null || subtitles.isEmpty()) {
            Node subTitlesNode = chartAttributes.selectSingleNode("subtitles");
            if (subTitlesNode != null) {
                subtitles = subTitlesNode.selectNodes("subtitle");
            }
        } else {
            PieDatasetChartDefinition.getLogger().warn((Object)Messages.getInstance().getString("CHART.WARN_DEPRECATED_CHILD", "subtitle", "subtitles"));
            PieDatasetChartDefinition.getLogger().warn((Object)Messages.getInstance().getString("CHART.WARN_PROPERTY_WILL_NOT_VALIDATE", "subtitle"));
        }
        if (subtitles != null) {
            this.addSubTitles(subtitles);
        }
        List slicesNodes = null;
        Node slicesNode = chartAttributes.selectSingleNode(EXPLODE_SLICE_NODE_NAME);
        if (slicesNode != null) {
            slicesNodes = slicesNode.selectNodes(SLICE_NODE_NAME);
        }
        if (slicesNodes != null) {
            this.addExplodedSlices(slicesNodes);
        }
        this.setPaintSequence(chartAttributes.selectSingleNode("color-palette"));
        this.setThreeD(chartAttributes.selectSingleNode("is-3D"));
        this.setWidth(chartAttributes.selectSingleNode("width"));
        this.setHeight(chartAttributes.selectSingleNode("height"));
        this.setBorderVisible(chartAttributes.selectSingleNode("border-visible"));
        this.setBorderPaint(JFreeChartEngine.getPaint(chartAttributes.selectSingleNode("border-paint")));
        this.setTitlePosition(chartAttributes.selectSingleNode("title-position"));
        this.setTitleFont(chartAttributes.selectSingleNode("title-font"));
        this.setInteriorGap(chartAttributes.selectSingleNode(INTERIOR_GAP_NODE_NAME));
        this.setStartAngle(chartAttributes.selectSingleNode(START_ANGLE_NODE_NAME));
        this.setDisplayLabels(chartAttributes.selectSingleNode("display-labels"));
        this.setLabelFont(chartAttributes.selectSingleNode(LABEL_FONT_NODE_NAME));
        this.setLabelPaint(JFreeChartEngine.getPaint(chartAttributes.selectSingleNode(LABEL_PAINT_NODE_NAME)));
        this.setLabelBackgroundPaint(JFreeChartEngine.getPaint(chartAttributes.selectSingleNode(LABEL_BACKGROUND_PAINT_NODE_NAME)));
        this.setLabelGap(chartAttributes.selectSingleNode(LABEL_GAP_NODE_NAME));
        this.setLegendFont(chartAttributes.selectSingleNode("legend-font"));
        this.setLegendBorderVisible(chartAttributes.selectSingleNode("legend-border-visible"));
        this.setLegendPosition(chartAttributes.selectSingleNode("legend-position"));
    }

    private void setDataByColumn(IPentahoResultSet data) {
        this.setDataByRow(PentahoDataTransmuter.pivot((IPentahoResultSet)data));
    }

    private void setDataByRow(IPentahoResultSet data) {
        boolean hasColumnHeaders;
        if (data == null) {
            this.noDataMessage = Messages.getInstance().getString("CHART.USER_NO_DATA_AVAILABLE");
            return;
        }
        boolean bl = hasColumnHeaders = data.getMetaData().getColumnHeaders() != null;
        if (!hasColumnHeaders) {
            data = PentahoDataTransmuter.transmute((IPentahoResultSet)data, (boolean)false);
        }
        String[] columnHeaders = null;
        try {
            columnHeaders = PentahoDataTransmuter.getCollapsedHeaders((int)0, (IPentahoResultSet)data, (char)'|');
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
        }
        int row = 0;
        if (!hasColumnHeaders) {
            data.next();
            row = 1;
        }
        Object[] rowData = data.next();
        while (rowData != null && row < data.getRowCount() + 1) {
            for (int column = 0; column < rowData.length; ++column) {
                if (!(rowData[column] instanceof Number)) continue;
                Number currentNumber = null;
                try {
                    if (columnHeaders != null && column < columnHeaders.length) {
                        currentNumber = this.getValue((Comparable)((Object)columnHeaders[column]));
                    }
                }
                catch (UnknownKeyException uke) {
                    currentNumber = new Double(0.0);
                }
                if (currentNumber == null) {
                    currentNumber = new Double(0.0);
                }
                double currentValue = currentNumber.doubleValue();
                double newValue = ((Number)rowData[column]).doubleValue();
                if (columnHeaders == null || column >= columnHeaders.length) continue;
                this.setValue((Comparable)((Object)columnHeaders[column]), new Double(newValue + currentValue));
            }
            rowData = data.next();
            ++row;
        }
        if (data.getRowCount() > 0 && this.getItemCount() <= 0) {
            this.noDataMessage = Messages.getInstance().getString("CHART.USER_INCORRECT_DATA_FORMAT");
        }
    }

    public void setHeight(Node heightNode) {
        if (heightNode != null) {
            this.setHeight(Integer.parseInt(heightNode.getText()));
        }
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setWidth(Node widthNode) {
        if (widthNode != null) {
            this.setWidth(Integer.parseInt(widthNode.getText()));
        }
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public void setTitle(Node chartTitleNode) {
        if (chartTitleNode != null) {
            this.setTitle(chartTitleNode.getText());
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public void setTitleFont(Node titleFontNode) {
        Font font = JFreeChartEngine.getFont(titleFontNode);
        if (font != null) {
            this.setTitleFont(font);
        }
    }

    @Override
    public Font getTitleFont() {
        return this.titleFont;
    }

    public void addSubTitles(List subTitleNodes) {
        if (subTitleNodes != null) {
            Iterator iter = subTitleNodes.iterator();
            while (iter.hasNext()) {
                this.addSubTitle(((Node)iter.next()).getText());
            }
        }
    }

    public void addSubTitle(String subTitle) {
        this.subTitles.add(subTitle);
    }

    @Override
    public List getSubtitles() {
        return this.subTitles;
    }

    public void addExplodedSlices(List nodes) {
        if (nodes != null) {
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                this.addExplodedSlice(((Node)iter.next()).getText());
            }
        }
    }

    public void addExplodedSlice(String slice) {
        this.explodeSlices.add(slice);
    }

    public List getExplodedSlices() {
        return this.explodeSlices;
    }

    public void setChartBackground(Node chartBackgroundNode) {
        Node backgroundTypeNode;
        if (chartBackgroundNode != null && (backgroundTypeNode = chartBackgroundNode.selectSingleNode("@type")) != null) {
            String backgroundTypeStr = backgroundTypeNode.getText();
            if ("color".equalsIgnoreCase(backgroundTypeStr)) {
                this.setChartBackgroundPaint(JFreeChartEngine.getPaint(chartBackgroundNode));
                this.setChartBackgroundImage((Image)null);
            } else if ("image".equalsIgnoreCase(backgroundTypeStr)) {
                this.setChartBackgroundImage(chartBackgroundNode);
                this.setChartBackgroundPaint(null);
            } else if ("texture".equalsIgnoreCase(backgroundTypeStr)) {
                this.setChartBackgroundPaint(JFreeChartEngine.getTexturePaint(chartBackgroundNode, this.getWidth(), this.getHeight(), this.getSession()));
                this.setChartBackgroundImage((Image)null);
            } else if ("gradient".equalsIgnoreCase(backgroundTypeStr)) {
                this.setChartBackgroundPaint(JFreeChartEngine.getGradientPaint(chartBackgroundNode, this.getWidth(), this.getHeight()));
                this.setChartBackgroundImage((Image)null);
            }
        }
    }

    public void setChartBackgroundPaint(Paint chartBackgroundPaint) {
        if (chartBackgroundPaint != null) {
            this.chartBackgroundPaint = chartBackgroundPaint;
        }
    }

    @Override
    public Paint getChartBackgroundPaint() {
        return this.chartBackgroundPaint;
    }

    public void setChartBackgroundImage(Node chartBackgroundImageNode) {
        this.setChartBackgroundImage(JFreeChartEngine.getImage(chartBackgroundImageNode, this.getSession()));
    }

    public void setChartBackgroundImage(Image chartBackgroundImage) {
        this.chartBackgroundImage = chartBackgroundImage;
    }

    @Override
    public Image getChartBackgroundImage() {
        return this.chartBackgroundImage;
    }

    public void setBorderVisible(Node borderVisibleNode) {
        if (borderVisibleNode != null) {
            String boolStr = borderVisibleNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setBorderVisible(booleanValue);
        }
    }

    public void setBorderVisible(boolean borderVisible) {
        this.borderVisible = borderVisible;
    }

    @Override
    public boolean isBorderVisible() {
        return this.borderVisible;
    }

    @Override
    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public void setBorderPaint(Paint borderPaint) {
        if (borderPaint != null) {
            this.borderPaint = borderPaint;
        }
    }

    private RectangleEdge getPosition(Node positionNode) {
        if (positionNode != null) {
            String positionStr = positionNode.getText();
            if ("top".equalsIgnoreCase(positionStr)) {
                return RectangleEdge.TOP;
            }
            if ("left".equalsIgnoreCase(positionStr)) {
                return RectangleEdge.LEFT;
            }
            if ("bottom".equalsIgnoreCase(positionStr)) {
                return RectangleEdge.BOTTOM;
            }
            if ("right".equalsIgnoreCase(positionStr)) {
                return RectangleEdge.RIGHT;
            }
        }
        return null;
    }

    public void setTitlePosition(Node titlePositionNode) {
        RectangleEdge position = this.getPosition(titlePositionNode);
        if (position != null) {
            this.setTitlePosition(position);
        }
    }

    @Override
    public RectangleEdge getTitlePosition() {
        return this.titlePosition;
    }

    public void setTitlePosition(RectangleEdge titlePosition) {
        this.titlePosition = titlePosition;
    }

    public void setLegendPosition(Node legendPositionNode) {
        RectangleEdge position = this.getPosition(legendPositionNode);
        if (position != null) {
            this.setLegendPosition(position);
        }
    }

    @Override
    public RectangleEdge getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendPosition(RectangleEdge legendPosition) {
        this.legendPosition = legendPosition;
    }

    public void setPaintSequence(Node paletteNode) {
        if (paletteNode != null) {
            List colorNodes = paletteNode.selectNodes("color");
            Paint[] paints = new Paint[colorNodes.size()];
            for (int i = 0; i < colorNodes.size(); ++i) {
                paints[i] = JFreeChartEngine.getPaint((Node)colorNodes.get(i));
            }
            this.setPaintSequence(paints);
        }
    }

    public void setPaintSequence(Paint[] paintSequence) {
        this.paintSequence = paintSequence;
    }

    @Override
    public Paint[] getPaintSequence() {
        return this.paintSequence;
    }

    public void setPlotBackground(Node plotBackgroundNode) {
        Node backgroundTypeNode;
        if (plotBackgroundNode != null && (backgroundTypeNode = plotBackgroundNode.selectSingleNode("@type")) != null) {
            String backgroundTypeStr = backgroundTypeNode.getText();
            if ("color".equalsIgnoreCase(backgroundTypeStr)) {
                this.setPlotBackgroundPaint(JFreeChartEngine.getPaint(plotBackgroundNode));
                this.setPlotBackgroundImage((Image)null);
            } else if ("image".equalsIgnoreCase(backgroundTypeStr)) {
                this.setPlotBackgroundImage(plotBackgroundNode);
                this.setPlotBackgroundPaint(null);
            } else if ("texture".equalsIgnoreCase(backgroundTypeStr)) {
                this.setPlotBackgroundPaint(JFreeChartEngine.getTexturePaint(plotBackgroundNode, this.getWidth(), this.getHeight(), this.getSession()));
                this.setPlotBackgroundImage((Image)null);
            } else if ("gradient".equalsIgnoreCase(backgroundTypeStr)) {
                this.setPlotBackgroundPaint(JFreeChartEngine.getGradientPaint(plotBackgroundNode, this.getWidth(), this.getHeight()));
                this.setPlotBackgroundImage((Image)null);
            }
        }
    }

    public void setPlotBackgroundPaint(Paint plotBackgroundPaint) {
        if (plotBackgroundPaint != null) {
            this.plotBackgroundPaint = plotBackgroundPaint;
        }
    }

    @Override
    public Paint getPlotBackgroundPaint() {
        return this.plotBackgroundPaint;
    }

    public void setPlotBackgroundImage(Image plotBackgroundImage) {
        this.plotBackgroundImage = plotBackgroundImage;
    }

    public void setPlotBackgroundImage(Node plotBackgroundImageNode) {
        this.setPlotBackgroundImage(JFreeChartEngine.getImage(plotBackgroundImageNode, this.getSession()));
    }

    @Override
    public Image getPlotBackgroundImage() {
        return this.plotBackgroundImage;
    }

    public void setLegendIncluded(Node legendNode) {
        if (legendNode != null) {
            String boolStr = legendNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setLegendIncluded(booleanValue);
        }
    }

    public void setLegendIncluded(boolean legendIncluded) {
        this.legendIncluded = legendIncluded;
    }

    @Override
    public boolean isLegendIncluded() {
        return this.legendIncluded;
    }

    public void setThreeD(Node threeDNode) {
        if (threeDNode != null) {
            String boolStr = threeDNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setThreeD(booleanValue);
        }
    }

    public void setThreeD(boolean threeD) {
        this.threeD = threeD;
    }

    @Override
    public boolean isThreeD() {
        return this.threeD;
    }

    private void setInteriorGap(Node interiorGapNode) {
        if (interiorGapNode != null) {
            String gapNodeStr = interiorGapNode.getText();
            Double doubleValue = new Double(gapNodeStr);
            this.setInteriorGap(doubleValue);
        }
    }

    public void setInteriorGap(double interiorGap) {
        this.interiorGap = interiorGap;
    }

    public double getInteriorGap() {
        return this.interiorGap;
    }

    private void setStartAngle(Node startAngleNode) {
        if (startAngleNode != null) {
            String gapNodeStr = startAngleNode.getText();
            Double doubleValue = new Double(gapNodeStr);
            this.setStartAngle(doubleValue);
        }
    }

    public void setStartAngle(double startAngle) {
        this.startAngle = startAngle;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    private void setLabelFont(Node labelFontNode) {
        Font font = JFreeChartEngine.getFont(labelFontNode);
        if (font != null) {
            this.setLabelFont(font);
        }
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelPaint(Paint labelPaint) {
        if (labelPaint != null) {
            this.labelPaint = labelPaint;
        }
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public Paint getLabelBackgroundPaint() {
        return this.labelBackgroundPaint;
    }

    public void setLabelBackgroundPaint(Paint labelBackgroundPaint) {
        if (labelBackgroundPaint != null) {
            this.labelBackgroundPaint = labelBackgroundPaint;
        }
    }

    public double getLabelGap() {
        return this.labelGap;
    }

    public void setLabelGap(Node labelGapNode) {
        if (labelGapNode != null) {
            String gapNodeStr = labelGapNode.getText();
            Double doubleValue = new Double(gapNodeStr);
            this.setLabelGap(doubleValue);
        }
    }

    public void setLabelGap(double labelGap) {
        this.labelGap = labelGap;
    }

    @Override
    public boolean isDisplayLabels() {
        return this.displayLabels;
    }

    public void setDisplayLabels(Node threeDNode) {
        if (threeDNode != null) {
            String boolStr = threeDNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setDisplayLabels(booleanValue);
        }
    }

    public void setDisplayLabels(boolean displayLabels) {
        this.displayLabels = displayLabels;
    }

    public IPentahoSession getSession() {
        return this.session;
    }

    public void setSession(IPentahoSession session) {
        this.session = session;
    }

    @Override
    public Font getLegendFont() {
        return this.legendFont;
    }

    public void setLegendFont(Font legendFont) {
        this.legendFont = legendFont;
    }

    public void setLegendFont(Node legendFontNode) {
        Font font = JFreeChartEngine.getFont(legendFontNode);
        if (font != null) {
            this.setLegendFont(font);
        }
    }

    public void setLegendBorderVisible(Node legendBorderVisibleNode) {
        if (legendBorderVisibleNode != null) {
            boolean legBorderVisible = new Boolean(legendBorderVisibleNode.getText());
            this.setLegendBorderVisible(legBorderVisible);
        }
    }

    public void setLegendBorderVisible(boolean legendBorderVisible) {
        this.legendBorderVisible = legendBorderVisible;
    }

    @Override
    public boolean isLegendBorderVisible() {
        return this.legendBorderVisible;
    }

    @Override
    public String getNoDataMessage() {
        return this.noDataMessage;
    }

    @Override
    public Float getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public void setBackgroundAlpha(Node backgroundAlphaNode) {
        if (backgroundAlphaNode != null) {
            Float backgroundAlphaValue;
            this.backgroundAlpha = backgroundAlphaValue = new Float(backgroundAlphaNode.getText());
        }
    }

    @Override
    public Float getForegroundAlpha() {
        return this.foregroundAlpha;
    }

    public void setForegroundAlpha(Node foregroundAlphaNode) {
        if (foregroundAlphaNode != null) {
            Float foregroundAlphaValue;
            this.foregroundAlpha = foregroundAlphaValue = new Float(foregroundAlphaNode.getText());
        }
    }
}

