/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.solution;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.IActionResource;
import org.pentaho.actionsequence.dom.IActionSequenceOutput;
import org.pentaho.platform.api.action.ActionPreProcessingException;
import org.pentaho.platform.api.action.IAction;
import org.pentaho.platform.api.action.IDefinitionAwareAction;
import org.pentaho.platform.api.action.ILoggingAction;
import org.pentaho.platform.api.action.IPreProcessingAction;
import org.pentaho.platform.api.action.ISessionAwareAction;
import org.pentaho.platform.api.action.IStreamingAction;
import org.pentaho.platform.api.engine.ActionExecutionException;
import org.pentaho.platform.api.engine.ActionValidationException;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.engine.core.output.SimpleContentItem;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.engine.services.solution.ActionSequenceCompatibilityFormatter;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.util.beans.ActionHarness;
import org.pentaho.platform.util.beans.AlternateIndexFormatter;
import org.pentaho.platform.util.beans.PropertyNameFormatter;
import org.pentaho.platform.util.beans.SuffixAppenderFormatter;
import org.pentaho.platform.util.beans.ValueGenerator;
import org.pentaho.platform.util.beans.ValueSetErrorCallback;
import org.pentaho.platform.util.web.MimeHelper;

public class ActionDelegate
extends ComponentBase {
    private ActionHarness actionHarness;
    protected static final PropertyNameFormatter ALTERNATE_INDEX_FORMATTER = new AlternateIndexFormatter();
    protected static final PropertyNameFormatter COMPATIBILITY_FORMATTER = new ActionSequenceCompatibilityFormatter();
    protected static final PropertyNameFormatter STREAM_APPENDER_FORMATTER = new SuffixAppenderFormatter("Stream");
    private Object actionBean;
    private IActionInput[] actionDefintionInputs;
    private IActionOutput[] actionDefintionOutputs;

    public ActionDelegate(Object actionBean) {
        this.actionBean = actionBean;
        this.actionHarness = new ActionHarness((IAction)actionBean);
    }

    public Object getActionBean() {
        return this.actionBean;
    }

    @Override
    public void done() {
    }

    protected boolean hasPublicDestination(IActionOutput contentOutput) {
        String resolvedName = contentOutput.getPublicName();
        IActionSequenceOutput publicOutput = this.getActionDefinition().getDocument().getOutput(resolvedName);
        if (publicOutput == null) {
            return false;
        }
        return publicOutput.getType().equals("content") && publicOutput.getDestinations().length > 0;
    }

    @Override
    protected boolean executeAction() throws Throwable {
        InputErrorCallback errorCallback = new InputErrorCallback();
        for (IActionInput input : this.getActionDefinition().getInputs()) {
            Object inputValue = input.getValue();
            if (input instanceof ActionInputConstant) {
                inputValue = input.getStringValue(true);
            }
            errorCallback.setValue(inputValue);
            this.actionHarness.setValue(input.getName(), inputValue, errorCallback, COMPATIBILITY_FORMATTER, ALTERNATE_INDEX_FORMATTER);
        }
        ResourceCallback resourceCallback = new ResourceCallback();
        for (IActionResource res : this.getActionDefinition().getResources()) {
            this.actionHarness.setValue(res.getName(), (Object)res.getInputStream(), resourceCallback, COMPATIBILITY_FORMATTER, ALTERNATE_INDEX_FORMATTER);
        }
        HashMap<String, IContentItem> outputContentItems = new HashMap<String, IContentItem>();
        StreamOutputErrorCallback streamingOutputCallback = new StreamOutputErrorCallback();
        OuputStreamGenerator outputStreamGenerator = new OuputStreamGenerator(outputContentItems);
        IActionOutput[] contentOutputs = this.getActionDefinition().getOutputs("content");
        if (contentOutputs.length > 0) {
            for (IActionOutput contentOutput : contentOutputs) {
                outputStreamGenerator.setContentOutput(contentOutput);
                this.actionHarness.setValue(contentOutput.getName(), (Object)outputStreamGenerator, streamingOutputCallback, STREAM_APPENDER_FORMATTER, COMPATIBILITY_FORMATTER, ALTERNATE_INDEX_FORMATTER);
            }
        }
        if (this.actionBean instanceof IAction) {
            ((IAction)this.actionBean).execute();
        }
        for (IActionOutput output : this.actionDefintionOutputs) {
            String outputName = output.getName();
            if (outputContentItems.containsKey(outputName = COMPATIBILITY_FORMATTER.format(outputName))) {
                IContentItem contentItem = (IContentItem)outputContentItems.get(outputName);
                if (contentItem instanceof SimpleContentItem) continue;
                output.setValue((Object)contentItem);
                continue;
            }
            if (this.actionHarness.isReadable(outputName)) {
                Object outputVal = this.actionHarness.getValue(outputName);
                output.setValue(outputVal);
                continue;
            }
            if (this.loggingLevel > 4) continue;
            this.warn(Messages.getInstance().getString("ActionDelegate.WARN_OUTPUT_NOT_READABLE", outputName, output.getType(), this.actionBean.getClass().getSimpleName()));
        }
        return true;
    }

    @Override
    public boolean init() {
        return true;
    }

    @Override
    protected boolean validateAction() {
        if (this.actionBean == null) {
            throw new IllegalArgumentException(Messages.getInstance().getErrorString("ActionDelegate.ERROR_0007_NO_ACTION_BEAN_SPECIFIED"));
        }
        if (this.actionBean instanceof ILoggingAction) {
            ((ILoggingAction)this.actionBean).setLogger(LogFactory.getLog(this.actionBean.getClass()));
        }
        if (this.actionBean instanceof ISessionAwareAction) {
            ((ISessionAwareAction)this.actionBean).setSession(this.getSession());
        }
        this.actionDefintionInputs = this.getActionDefinition().getInputs();
        this.actionDefintionOutputs = this.getActionDefinition().getOutputs();
        ArrayList<String> inputNames = new ArrayList<String>();
        for (IActionInput input : this.actionDefintionInputs) {
            inputNames.add(input.getName());
        }
        ArrayList<String> outputNames = new ArrayList<String>();
        for (IActionOutput output : this.actionDefintionOutputs) {
            outputNames.add(output.getName());
        }
        if (this.actionBean instanceof IDefinitionAwareAction) {
            IDefinitionAwareAction definitionAwareAction = (IDefinitionAwareAction)this.actionBean;
            definitionAwareAction.setInputNames(inputNames);
            definitionAwareAction.setOutputNames(outputNames);
        }
        if (this.actionBean instanceof IPreProcessingAction) {
            try {
                ((IPreProcessingAction)this.actionBean).doPreExecution();
            }
            catch (ActionPreProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    @Override
    protected boolean validateSystemSettings() {
        return true;
    }

    @Override
    public Log getLogger() {
        return LogFactory.getLog(ActionDelegate.class);
    }

    class InputErrorCallback
    implements ValueSetErrorCallback {
        private Object curValue;

        InputErrorCallback() {
        }

        public void setValue(Object value) throws Exception {
            this.curValue = value;
        }

        @Override
        public void failedToSetValue(Object bean, String name, Object value, String destPropertyType, Throwable cause) throws ActionExecutionException {
            String className = value != null ? value.getClass().getName() : "ClassNameNotAvailable";
            throw new ActionExecutionException(Messages.getInstance().getErrorString("ActionDelegate.ERROR_0005_FAILED_TO_SET_INPUT", name, className, ActionDelegate.this.actionBean.getClass().getSimpleName(), destPropertyType), cause);
        }

        @Override
        public void propertyNotWritable(Object bean, String name) throws Exception {
            if (ActionDelegate.this.loggingLevel <= 4) {
                String valueType = this.curValue == null ? null : this.curValue.getClass().getName();
                ActionDelegate.this.warn(Messages.getInstance().getString("ActionDelegate.WARN_INPUT_NOT_WRITABLE", ActionDelegate.this.actionBean.getClass().getSimpleName(), name, valueType));
            }
        }
    }

    class ResourceCallback
    implements ValueSetErrorCallback {
        ResourceCallback() {
        }

        @Override
        public void failedToSetValue(Object bean, String name, Object value, String destPropertyType, Throwable cause) throws ActionExecutionException {
            String className = value != null ? value.getClass().getName() : "ClassNameNotAvailable";
            throw new ActionExecutionException(Messages.getInstance().getErrorString("ActionDelegate.ERROR_0006_FAILED_TO_SET_RESOURCE", name, className, ActionDelegate.this.actionBean.getClass().getSimpleName(), destPropertyType), cause);
        }

        @Override
        public void propertyNotWritable(Object bean, String name) {
            if (ActionDelegate.this.loggingLevel <= 4) {
                ActionDelegate.this.warn(Messages.getInstance().getString("ActionDelegate.WARN_RESOURCE_NOT_WRITABLE", ActionDelegate.this.actionBean.getClass().getSimpleName(), name, InputStream.class.getName()));
            }
        }
    }

    class OuputStreamGenerator
    implements ValueGenerator {
        private Map<String, IContentItem> outputContentItems;
        private IActionOutput curActionOutput;
        private boolean streamingCheckPerformed = false;

        public OuputStreamGenerator(Map<String, IContentItem> outputContentItems) {
            this.outputContentItems = outputContentItems;
        }

        public void setContentOutput(IActionOutput actionOutput) throws Exception {
            this.curActionOutput = actionOutput;
        }

        @Override
        public Object getValue(String name) throws Exception {
            if (!this.streamingCheckPerformed && !(ActionDelegate.this.actionBean instanceof IStreamingAction)) {
                throw new ActionExecutionException(Messages.getInstance().getErrorString("ActionDelegate.ERROR_0002_ACTION_CANNOT_ACCEPT_STREAM", name, ActionDelegate.this.actionBean.getClass().getSimpleName()));
            }
            this.streamingCheckPerformed = true;
            String mimeType = ((IStreamingAction)ActionDelegate.this.actionBean).getMimeType(name);
            if (StringUtils.isEmpty((String)mimeType)) {
                throw new ActionValidationException(Messages.getInstance().getErrorString("ActionDelegate.ERROR_0001_MIMETYPE_NOT_DECLARED"));
            }
            IContentItem contentItem = null;
            if (ActionDelegate.this.hasPublicDestination(this.curActionOutput)) {
                contentItem = ActionDelegate.this.getRuntimeContext().getOutputContentItem(this.curActionOutput.getPublicName(), mimeType);
            } else {
                String extension = MimeHelper.getExtension(mimeType);
                if (extension == null) {
                    extension = ".bin";
                }
                contentItem = ActionDelegate.this.getRuntimeContext().getOutputItem(this.curActionOutput.getName(), mimeType, extension);
            }
            if (contentItem == null) {
                throw new ActionValidationException(Messages.getInstance().getErrorString("ActionDelegate.ERROR_0003_OUTPUT_STREAM_NOT_AVAILABLE_1", this.curActionOutput.getPublicName()));
            }
            OutputStream contentOutputStream = contentItem.getOutputStream(ActionDelegate.this.getActionName());
            if (contentOutputStream == null) {
                throw new ActionExecutionException(Messages.getInstance().getErrorString("ActionDelegate.ERROR_0004_OUTPUT_STREAM_NOT_AVAILABLE_2", ActionDelegate.this.actionBean.getClass().getSimpleName()));
            }
            this.outputContentItems.put(this.curActionOutput.getName(), contentItem);
            return contentOutputStream;
        }
    }

    class StreamOutputErrorCallback
    implements ValueSetErrorCallback {
        StreamOutputErrorCallback() {
        }

        @Override
        public void failedToSetValue(Object bean, String name, Object value, String destPropertyType, Throwable cause) throws ActionExecutionException {
            throw new ActionExecutionException(Messages.getInstance().getErrorString("ActionDelegate.ERROR_0008_FAILED_TO_SET_STREAM", name, OutputStream.class.getName(), ActionDelegate.this.actionBean.getClass().getSimpleName(), destPropertyType), cause);
        }

        @Override
        public void propertyNotWritable(Object bean, String name) {
            if (ActionDelegate.this.loggingLevel <= 4) {
                ActionDelegate.this.warn(Messages.getInstance().getString("ActionDelegate.WARN_INPUT_NOT_WRITABLE", ActionDelegate.this.actionBean.getClass().getSimpleName(), name, OutputStream.class.getName()));
            }
        }
    }
}

