/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.audit;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.platform.api.engine.AuditException;
import org.pentaho.platform.api.engine.IAuditEntry;
import org.pentaho.platform.engine.core.audit.AuditHelper;
import org.pentaho.platform.engine.core.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.audit.AuditConnection;
import org.pentaho.platform.util.logging.Logger;

public class AuditSQLEntry
implements IAuditEntry {
    private static AuditConnection audc;
    private Map<String, String> columnsSizeMap;
    private static String TABLE_NAME;
    private static final String CONFIG_FILE_NAME = "audit_sql.xml";
    private static final String TABLE_NAME_XML_KEY = "auditConnection/tableName";
    private static final String INSERT_XML_KEY = "auditConnection/insertSQL";
    private static String INSERT_STMT;

    public AuditSQLEntry() {
        this.retrieveParameters();
    }

    private void retrieveParameters() {
        String tmp = PentahoSystem.getSystemSetting(CONFIG_FILE_NAME, INSERT_XML_KEY, null);
        INSERT_STMT = tmp != null ? tmp : PentahoSystem.getSystemSetting(INSERT_XML_KEY, Messages.getInstance().getString("AUDSQLENT.CODE_AUDIT_INSERT_STATEMENT"));
    }

    private void setString(PreparedStatement stmt, int num, String val) throws SQLException {
        if (val != null) {
            stmt.setString(num, this.getStringPreparedForColumn(num, val));
        } else {
            stmt.setNull(num, 12);
        }
    }

    private String getStringPreparedForColumn(int columnIndex, String value) {
        Map<String, String> colMetaData = this.getColumnsSizeMap();
        if (colMetaData != null && colMetaData.containsKey("" + columnIndex) && value != null && !value.isEmpty()) {
            int columnLength = Integer.parseInt(colMetaData.get("" + columnIndex));
            return value.substring(0, Math.min(value.length(), columnLength));
        }
        return value;
    }

    private void setObject(PreparedStatement stmt, int num, String val) throws SQLException {
        if (val != null) {
            stmt.setObject(num, val);
        } else {
            stmt.setNull(num, 2005);
        }
    }

    private void setBigDec(PreparedStatement stmt, int num, BigDecimal val) throws SQLException {
        if (val != null) {
            stmt.setBigDecimal(num, val);
        } else {
            stmt.setNull(num, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void auditAll(String jobId, String instId, String objId, String objType, String actor, String messageType, String messageName, String messageTxtValue, BigDecimal messageNumValue, double duration) throws AuditException {
        Connection con = null;
        try {
            con = audc.getAuditConnection();
            try (PreparedStatement stmt = con.prepareStatement(INSERT_STMT);){
                this.setString(stmt, 1, jobId);
                this.setString(stmt, 2, instId);
                this.setString(stmt, 3, objId);
                this.setString(stmt, 4, objType);
                this.setString(stmt, 5, actor);
                this.setString(stmt, 6, messageType);
                this.setString(stmt, 7, messageName);
                this.setObject(stmt, 8, messageTxtValue);
                this.setBigDec(stmt, 9, messageNumValue);
                this.setBigDec(stmt, 10, BigDecimal.valueOf(duration));
                stmt.setTimestamp(11, new Timestamp(System.currentTimeMillis()));
                stmt.executeUpdate();
            }
            finally {
                con.close();
            }
        }
        catch (SQLException ex) {
            throw new AuditException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getColumnsSizeMap() {
        if (this.columnsSizeMap == null && TABLE_NAME != null) {
            Connection con = null;
            try {
                con = audc.getAuditConnection();
                ResultSet columns = this.getColumnsMetadata(con, TABLE_NAME);
                if (columns != null) {
                    this.columnsSizeMap = new HashMap<String, String>();
                    int index = 0;
                    while (columns.next()) {
                        this.columnsSizeMap.put("" + index, "" + columns.getInt("COLUMN_SIZE"));
                        ++index;
                    }
                }
            }
            catch (SQLException ex) {
                Logger.error(this.getClass().getName(), ex.getMessage(), (Throwable)ex);
            }
            finally {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException ex) {
                    Logger.error(this.getClass().getName(), ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return this.columnsSizeMap;
    }

    private ResultSet getColumnsMetadata(Connection con, String tableNameFilter) {
        try {
            DatabaseMetaData dbMetaData;
            if (con != null && (dbMetaData = con.getMetaData()) != null) {
                return dbMetaData.getColumns(null, null, tableNameFilter, "%");
            }
        }
        catch (SQLException ex) {
            Logger.error(this.getClass().getName(), ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    static {
        TABLE_NAME = PentahoSystem.getSystemSetting(CONFIG_FILE_NAME, TABLE_NAME_XML_KEY, null);
        String tmp = PentahoSystem.getSystemSetting(CONFIG_FILE_NAME, INSERT_XML_KEY, null);
        INSERT_STMT = tmp != null ? tmp : PentahoSystem.getSystemSetting(INSERT_XML_KEY, Messages.getInstance().getString("AUDSQLENT.CODE_AUDIT_INSERT_STATEMENT"));
        try {
            audc = new AuditConnection();
            audc.initialize();
        }
        catch (Exception ex) {
            Logger.error(AuditHelper.class.getName(), Messages.getInstance().getErrorString("AUDSQLENT.ERROR_0001_INVALID_CONNECTION"), (Throwable)ex);
        }
    }
}

