/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security.acls.voter;

import java.util.List;
import org.pentaho.platform.api.engine.IAclEntry;
import org.pentaho.platform.api.engine.IAclHolder;
import org.pentaho.platform.api.engine.IAclVoter;
import org.pentaho.platform.api.engine.IPentahoAclEntry;
import org.pentaho.platform.api.engine.IPentahoBasicAclEntry;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.engine.security.acls.PentahoAclEntry;
import org.pentaho.platform.engine.security.acls.PentahoGrantedAuthorityEffectiveAclsResolver;
import org.pentaho.platform.engine.security.acls.voter.AbstractPentahoAclVoter;
import org.springframework.security.core.Authentication;

public class PentahoBasicAclVoter
extends AbstractPentahoAclVoter
implements IAclVoter {
    @Override
    public Authentication getAuthentication(IPentahoSession session) {
        return SecurityHelper.getInstance().getAuthentication();
    }

    public boolean hasAccess(IPentahoSession session, IAclHolder holder, int mask) {
        Authentication auth = this.getAuthentication(session);
        if (auth == null) {
            return false;
        }
        if (this.isPentahoAdministrator(session)) {
            return true;
        }
        IAclEntry[] effectiveAcls = this.getEffectiveAcls(session, holder);
        if (effectiveAcls == null || effectiveAcls.length == 0) {
            return false;
        }
        for (IAclEntry element : effectiveAcls) {
            IPentahoBasicAclEntry acl = (IPentahoBasicAclEntry)element;
            if (!acl.isPermitted(mask)) continue;
            return true;
        }
        return false;
    }

    public IAclEntry[] getEffectiveAcls(IPentahoSession session, IAclHolder holder) {
        Authentication auth = this.getAuthentication(session);
        if (auth == null) {
            return null;
        }
        List allAcls = holder.getEffectiveAccessControls();
        IAclEntry[] acls = new IAclEntry[allAcls.size()];
        acls = allAcls.toArray(acls);
        PentahoGrantedAuthorityEffectiveAclsResolver resolver = new PentahoGrantedAuthorityEffectiveAclsResolver();
        IAclEntry[] resolvedAcls = resolver.resolveEffectiveAcls(acls, auth);
        return resolvedAcls;
    }

    public PentahoAclEntry getEffectiveAcl(IPentahoSession session, IAclHolder holder) {
        IAclEntry[] effectiveAcls = this.getEffectiveAcls(session, holder);
        PentahoAclEntry entry = new PentahoAclEntry();
        entry.setMask(0);
        if (effectiveAcls != null && effectiveAcls.length > 0) {
            int[] allAcls = new int[effectiveAcls.length];
            for (int i = 0; i < effectiveAcls.length; ++i) {
                allAcls[i] = ((IPentahoAclEntry)effectiveAcls[i]).getMask();
            }
            entry.addPermissions(allAcls);
            return entry;
        }
        return entry;
    }
}

