/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.audit;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.slf4j.MDC;

public class MDCUtil {
    public static final String SESSION_ID = "sessionId";
    public static final String REMOTE_ADDR = "remoteAddr";
    public static final String REMOTE_HOST = "remoteHost";
    public static final String REMOTE_PORT = "remotePort";
    public static final String SERVER_NAME = "serverName";
    public static final String SERVER_PORT = "serverPort";
    public static final String LOCAL_ADDR = "localAddr";
    public static final String LOCAL_NAME = "localName";
    public static final String LOCAL_PORT = "localPort";
    public static final String SESSION_NAME = "sessionName";
    public static final String INSTANCE_ID = "instanceId";
    private final Map<String, String> mdc = new HashMap<String, String>();

    public MDCUtil() {
        Map map = MDC.getCopyOfContextMap();
        if (map != null) {
            this.mdc.putAll(map);
        }
    }

    public static void setInstanceId(String instanceId) {
        if (instanceId != null) {
            MDC.put((String)INSTANCE_ID, (String)instanceId);
        }
    }

    public static String getInstanceId() {
        return MDC.get((String)INSTANCE_ID);
    }

    public static void setupSchedulerMDC(Object sessionName, Object instanceId) {
        MDC.clear();
        if (PentahoSessionHolder.getSession() != null && PentahoSessionHolder.getSession().getId() != null) {
            MDC.put((String)SESSION_ID, (String)PentahoSessionHolder.getSession().getId());
        }
        if (sessionName != null) {
            MDC.put((String)SESSION_NAME, (String)sessionName.toString());
        }
        if (instanceId != null) {
            MDC.put((String)INSTANCE_ID, (String)instanceId.toString());
        }
    }

    public void setContextMap() {
        MDC.setContextMap(this.mdc);
    }

    public static void clear() {
        MDC.clear();
    }

    public Map<String, String> getContextMap() {
        return this.mdc;
    }
}

