/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.service.ProviderServicePriority;
import org.pentaho.di.core.service.ServiceProviderInterface;
import org.pentaho.di.core.service.ServiceProviderPluginType;

public class PluginServiceLoader {
    private static final ConcurrentHashMap<PluginInterface, ServiceProviderInterface<?>> spiCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<ServiceProviderInterface<?>, ProviderServicePriority<?>> singletonCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Collection<ProviderServicePriority<?>>> dynamicallyAddedServices = new ConcurrentHashMap();

    public static <T> Collection<T> loadServices(Class<T> apiInterface) throws KettlePluginException {
        PluginRegistry registry = PluginRegistry.getInstance();
        List plugins = registry.getPlugins(ServiceProviderPluginType.class);
        ArrayList unsortedServices = new ArrayList();
        for (PluginInterface pi : plugins) {
            for (Map.Entry<Class<?>, String> e : pi.getClassMap().entrySet()) {
                Class<?> clz = e.getKey();
                boolean result = apiInterface.isAssignableFrom(clz);
                if (!result) continue;
                ServiceProviderInterface spi = spiCache.computeIfAbsent(pi, pinf -> {
                    try {
                        return (ServiceProviderInterface)PluginRegistry.getInstance().loadClass((PluginInterface)pinf);
                    }
                    catch (KettlePluginException e1) {
                        throw new RuntimeException(e1);
                    }
                });
                ProviderServicePriority<Object> providerServicePriority = null;
                if (spi.isSingleton() && null != (providerServicePriority = singletonCache.get(spi))) {
                    unsortedServices.add(providerServicePriority);
                    continue;
                }
                Object service = spi.useFactory() ? spi.factoryCreate() : apiInterface.cast(PluginRegistry.getInstance().loadClass(pi, e.getKey()));
                if (spi.useProxyWrap()) {
                    service = Proxy.newProxyInstance(PluginServiceLoader.class.getClassLoader(), new Class[]{apiInterface}, (InvocationHandler)new WrappingClassLoaderChangingInvocationHandler(service));
                }
                if (service == null) continue;
                providerServicePriority = new ProviderServicePriority(null, service, spi.getPriority());
                if (spi.isSingleton()) {
                    singletonCache.put(spi, providerServicePriority);
                }
                unsortedServices.add(providerServicePriority);
            }
        }
        if (dynamicallyAddedServices.containsKey(apiInterface.getName())) {
            unsortedServices.addAll(dynamicallyAddedServices.get(apiInterface.getName()));
        }
        return unsortedServices.stream().sorted(Comparator.comparing(ProviderServicePriority::getPriority)).map(ProviderServicePriority::getService).map(s -> s).collect(Collectors.toCollection(ArrayList::new));
    }

    public static <I, S extends I> void registerService(Object provider, Class<I> apiInterface, S service, int priority) {
        Collection<Object> providersAndServices;
        if (dynamicallyAddedServices.containsKey(apiInterface.getName())) {
            providersAndServices = dynamicallyAddedServices.get(apiInterface.getName());
            providersAndServices.removeIf(e -> e.getProvider().equals(provider));
        } else {
            providersAndServices = new ArrayList<ProviderServicePriority<S>>();
        }
        providersAndServices.add(new ProviderServicePriority<S>(provider, service, priority));
        dynamicallyAddedServices.put(apiInterface.getName(), providersAndServices);
    }

    private static class WrappingClassLoaderChangingInvocationHandler
    implements InvocationHandler {
        private final Object o;

        public WrappingClassLoaderChangingInvocationHandler(Object o) {
            this.o = o;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.o.getClass().getClassLoader());
                Object object = method.invoke(this.o, args);
                return object;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }
}

