/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import com.google.common.base.Preconditions;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;

public class SnowflakeHVDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    private static final String ALTER_TABLE = "ALTER TABLE ";
    public static final String WAREHOUSE = "warehouse";

    @Override
    public int[] getAccessTypeList() {
        return new int[]{0, 4};
    }

    @Override
    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 443;
        }
        return -1;
    }

    @Override
    public Map<String, String> getDefaultOptions() {
        HashMap<String, String> defaultOptions = new HashMap<String, String>();
        defaultOptions.put(this.getPluginId() + ".ssl", "on");
        return defaultOptions;
    }

    @Override
    public boolean isFetchSizeSupported() {
        return false;
    }

    @Override
    public String getDriverClass() {
        return "com.snowflake.client.jdbc.SnowflakeDriver";
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) {
        Preconditions.checkArgument((!Utils.isEmpty(hostname) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Utils.isEmpty(databaseName) ? 1 : 0) != 0);
        String realHostname = hostname;
        String account = hostname;
        if (!realHostname.contains(".")) {
            realHostname = hostname + ".snowflakecomputing.com";
        } else {
            account = hostname.substring(0, hostname.indexOf(46));
        }
        this.addExtraOption(this.getPluginId(), WAREHOUSE, this.getAttribute(WAREHOUSE, ""));
        return "jdbc:snowflake://" + realHostname + this.getParamIfSet(":", port) + "/?account=" + account + "&db=" + databaseName;
    }

    private String getParamIfSet(String param, String val) {
        if (!Utils.isEmpty(val)) {
            return param + val;
        }
        return "";
    }

    @Override
    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return ALTER_TABLE + tablename + " ADD COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    @Override
    public String getDropColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return ALTER_TABLE + tablename + " DROP COLUMN " + v.getName() + Const.CR;
    }

    @Override
    public String getSQLListOfSchemas(DatabaseMeta databaseMeta) {
        String databaseName = this.getDatabaseName();
        if (databaseMeta != null) {
            databaseName = databaseMeta.environmentSubstitute(databaseName);
        }
        return "SELECT SCHEMA_NAME AS \"name\" FROM " + databaseName + ".INFORMATION_SCHEMA.SCHEMATA";
    }

    @Override
    public String getSQLListOfSchemas() {
        return this.getSQLListOfSchemas(null);
    }

    @Override
    public String getModifyColumnStatement(String tableName, ValueMetaInterface v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return ALTER_TABLE + tableName + " MODIFY COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    @Override
    public String getFieldDefinition(ValueMetaInterface v, String surrogateKey, String primaryKey, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        boolean isKeyField;
        String fieldDefinitionDdl = "";
        String newline = addCr ? Const.CR : "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        int type = v.getType();
        boolean bl = isKeyField = fieldname.equalsIgnoreCase(surrogateKey) || fieldname.equalsIgnoreCase(primaryKey);
        if (addFieldName) {
            fieldDefinitionDdl = fieldDefinitionDdl + fieldname + " ";
        }
        if (isKeyField) {
            Preconditions.checkState((type == 1 || type == 5 || type == 6 ? 1 : 0) != 0);
            return this.ddlForPrimaryKey(useAutoinc) + newline;
        }
        switch (type) {
            case 3: 
            case 9: {
                fieldDefinitionDdl = fieldDefinitionDdl + "TIMESTAMP_LTZ";
                break;
            }
            case 4: {
                fieldDefinitionDdl = fieldDefinitionDdl + this.ddlForBooleanValue();
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (precision == 0) {
                    fieldDefinitionDdl = fieldDefinitionDdl + this.ddlForIntegerValue(length);
                    break;
                }
                fieldDefinitionDdl = fieldDefinitionDdl + this.ddlForFloatValue(length, precision);
                break;
            }
            case 2: {
                if (length <= 0) {
                    fieldDefinitionDdl = fieldDefinitionDdl + "VARCHAR";
                    break;
                }
                fieldDefinitionDdl = fieldDefinitionDdl + "VARCHAR(" + length + ")";
                break;
            }
            case 8: {
                fieldDefinitionDdl = fieldDefinitionDdl + "VARIANT";
                break;
            }
            default: {
                fieldDefinitionDdl = fieldDefinitionDdl + " UNKNOWN";
            }
        }
        return fieldDefinitionDdl + newline;
    }

    private String ddlForBooleanValue() {
        if (this.supportsBooleanDataType()) {
            return "BOOLEAN";
        }
        return "CHAR(1)";
    }

    private String ddlForIntegerValue(int length) {
        if (length > 9) {
            if (length < 19) {
                return "BIGINT";
            }
            return "NUMBER(" + length + ", 0 )";
        }
        return "INT";
    }

    private String ddlForFloatValue(int length, int precision) {
        if (length > 15) {
            return "NUMBER(" + length + ", " + precision + ")";
        }
        return "FLOAT";
    }

    private String ddlForPrimaryKey(boolean useAutoinc) {
        if (useAutoinc) {
            return "BIGINT AUTOINCREMENT NOT NULL PRIMARY KEY";
        }
        return "BIGINT NOT NULL PRIMARY KEY";
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"snowflake_jdbc.jar"};
    }

    @Override
    public String getLimitClause(int nrRows) {
        return " LIMIT " + nrRows;
    }

    @Override
    public String getSQLQueryFields(String tableName) {
        return "SELECT * FROM " + tableName + " LIMIT 0";
    }

    @Override
    public String getSQLTableExists(String tablename) {
        return this.getSQLQueryFields(tablename);
    }

    @Override
    public String getSQLColumnExists(String columnname, String tablename) {
        return this.getSQLQueryColumnFields(columnname, tablename);
    }

    public String getSQLQueryColumnFields(String columnname, String tableName) {
        return "SELECT " + columnname + " FROM " + tableName + " LIMIT 0";
    }

    @Override
    public int getNotFoundTK(boolean useAutoinc) {
        if (this.supportsAutoInc() && useAutoinc) {
            return 1;
        }
        return super.getNotFoundTK(useAutoinc);
    }

    @Override
    public String getExtraOptionSeparator() {
        return "&";
    }

    @Override
    public String getExtraOptionIndicator() {
        return "&";
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public boolean supportsTimeStampToDateConversion() {
        return false;
    }

    @Override
    public boolean supportsBitmapIndex() {
        return false;
    }

    @Override
    public boolean supportsViews() {
        return true;
    }

    @Override
    public boolean supportsSynonyms() {
        return false;
    }

    @Override
    public String[] getReservedWords() {
        return new String[]{"ALL", "ALTER", "AND", "ANY", "AS", "ASC", "BETWEEN", "BY", "CASE", "CAST", "CHECK", "CLUSTER", "COLUMN", "CONNECT", "CREATE", "CROSS", "CURRENT", "DELETE", "DESC", "DISTINCT", "DROP", "ELSE", "EXCLUSIVE", "EXISTS", "FALSE", "FOR", "FROM", "FULL", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INNER", "INSERT", "INTERSECT", "INTO", "IS", "JOIN", "LATERAL", "LEFT", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MODIFY", "NATURAL", "NOT", "NULL", "OF", "ON", "OPTION", "OR", "ORDER", "REGEXP", "RENAME", "REVOKE", "RIGHT", "RLIKE", "ROW", "ROWS", "SELECT", "SET", "SOME", "START", "TABLE", "THEN", "TO", "TRIGGER", "TRUE", "UNION", "UNIQUE", "UPDATE", "USING", "VALUES", "WHEN", "WHENEVER", "WHERE", "WITH"};
    }

    @Override
    public String getExtraOptionsHelpText() {
        return "https://docs.snowflake.net/manuals/user-guide/jdbc-configure.html";
    }

    @Override
    public String getSQLInsertAutoIncUnknownDimensionRow(String schemaTable, String keyField, String versionField) {
        return "insert into " + schemaTable + "(" + keyField + ", " + versionField + ") values (1, 1)";
    }

    @Override
    public boolean supportsIndexes() {
        return false;
    }

    @Override
    public String quoteSQLString(String string) {
        string = string.replaceAll("'", "\\\\'");
        string = string.replaceAll("\\n", "\\\\n");
        string = string.replaceAll("\\r", "\\\\r");
        return "'" + string + "'";
    }

    @Override
    public boolean releaseSavepoint() {
        return false;
    }

    @Override
    public boolean supportsErrorHandlingOnBatchUpdates() {
        return true;
    }

    @Override
    public boolean isRequiringTransactionsOnQueries() {
        return false;
    }

    @Override
    public boolean supportsRepository() {
        return false;
    }

    @Override
    public void putOptionalOptions(Map<String, String> extraOptions) {
        extraOptions.put("SNOWFLAKEHV.warehouse", this.getAttribute(WAREHOUSE, ""));
    }

    @Override
    public ResultSet getSchemas(DatabaseMetaData databaseMetaData, DatabaseMeta dbMeta) throws SQLException {
        return databaseMetaData.getSchemas(dbMeta.environmentSubstitute(dbMeta.getDatabaseName()), null);
    }

    @Override
    public ResultSet getTables(DatabaseMetaData databaseMetaData, DatabaseMeta dbMeta, String schemaPattern, String tableNamePattern, String[] tableTypes) throws SQLException {
        return databaseMetaData.getTables(dbMeta.environmentSubstitute(dbMeta.getDatabaseName()), schemaPattern, tableNamePattern, tableTypes);
    }
}

