/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.connections.vfs.provider;

import java.util.Collection;
import java.util.function.Supplier;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.pentaho.di.connections.ConnectionDetails;
import org.pentaho.di.connections.ConnectionManager;
import org.pentaho.di.connections.vfs.VFSConnectionDetails;
import org.pentaho.di.connections.vfs.provider.ConnectionFileName;
import org.pentaho.di.connections.vfs.provider.ConnectionFileObject;
import org.pentaho.di.connections.vfs.provider.ConnectionFileProvider;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.vfs.configuration.IKettleFileSystemConfigBuilder;
import org.pentaho.di.core.vfs.configuration.KettleFileSystemConfigBuilderFactory;

public class ConnectionFileSystem
extends AbstractFileSystem
implements FileSystem {
    public static final String CONNECTION = "connection";
    public static final String DOMAIN_ROOT = "[\\w]+://";
    private Supplier<ConnectionManager> connectionManager = ConnectionManager::getInstance;

    public ConnectionFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
    }

    public static String getUrl(AbstractFileName abstractFileName, ConnectionDetails connectionDetails) {
        VFSConnectionDetails vfsConnectionDetails = (VFSConnectionDetails)connectionDetails;
        String url = null;
        if (vfsConnectionDetails != null) {
            String domain = vfsConnectionDetails.getDomain();
            if (!domain.equals("")) {
                domain = "/" + domain;
            }
            if ((url = vfsConnectionDetails.getType() + ":/" + domain + abstractFileName.getPath()).matches(DOMAIN_ROOT)) {
                url = url + vfsConnectionDetails.getName();
            }
        }
        return url;
    }

    protected FileObject createFile(AbstractFileName abstractFileName) throws Exception {
        String connectionName = ((ConnectionFileName)abstractFileName).getConnection();
        VFSConnectionDetails connectionDetails = (VFSConnectionDetails)this.connectionManager.get().getConnectionDetails(connectionName);
        FileSystemOptions opts = super.getFileSystemOptions();
        IKettleFileSystemConfigBuilder configBuilder = KettleFileSystemConfigBuilderFactory.getConfigBuilder(new Variables(), "pvfs");
        VariableSpace varSpace = (VariableSpace)configBuilder.getVariableSpace(super.getFileSystemOptions());
        if (connectionDetails != null) {
            connectionDetails.setSpace(varSpace);
        }
        String url = ConnectionFileSystem.getUrl(abstractFileName, connectionDetails);
        AbstractFileObject fileObject = null;
        String domain = null;
        if (url != null) {
            domain = connectionDetails.getDomain();
            varSpace.setVariable(CONNECTION, connectionName);
            fileObject = (AbstractFileObject)KettleVFS.getFileObject(url, varSpace);
        }
        return new ConnectionFileObject(abstractFileName, this, fileObject, domain);
    }

    protected void addCapabilities(Collection<Capability> collection) {
        collection.addAll(ConnectionFileProvider.capabilities);
    }

    public FileObject resolveFile(FileName name) throws FileSystemException {
        try {
            return this.createFile((AbstractFileName)name);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/resolve-file.error", (Object)name, (Throwable)e);
        }
    }
}

