/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.excelinput.ExcelInputMeta;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.IMetaverseObjectFactory;
import org.pentaho.metaverse.api.MetaverseException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.step.ExternalResourceStepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.IClonableStepAnalyzer;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelInputStepAnalyzer
extends ExternalResourceStepAnalyzer<ExcelInputMeta> {
    private Logger log = LoggerFactory.getLogger(ExcelInputStepAnalyzer.class);

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        return new HashSet<Class<? extends BaseStepMeta>>(){
            {
                this.add(ExcelInputMeta.class);
            }
        };
    }

    protected Set<StepField> getUsedFields(ExcelInputMeta meta) {
        HashSet<StepField> usedFields = new HashSet<StepField>();
        if (meta.isAcceptingFilenames() && StringUtils.isNotEmpty((String)meta.getAcceptingStepName())) {
            StepField stepField = new StepField(meta.getAcceptingStepName(), meta.getAcceptingField());
            usedFields.add(stepField);
        }
        return usedFields;
    }

    public IMetaverseNode createResourceNode(IExternalResourceInfo resource) throws MetaverseException {
        return this.createFileNode(resource.getName(), this.descriptor);
    }

    public String getResourceInputNodeType() {
        return "File Field";
    }

    public String getResourceOutputNodeType() {
        return null;
    }

    public boolean isOutput() {
        return false;
    }

    public boolean isInput() {
        return true;
    }

    public IClonableStepAnalyzer newInstance() {
        return new ExcelInputStepAnalyzer();
    }

    protected void setObjectFactory(IMetaverseObjectFactory factory) {
        this.metaverseObjectFactory = factory;
    }
}

