/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.colorchooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.ExtendedColorModel;

public class HSBColorSelectorPanel
extends JComponent {
    private ColorSelectionHandler colorSelectionHandler;
    private ExtendedColorModel colorSelectionModel;
    private BufferedImage backend = new BufferedImage(360, 360, 1);
    private ColorComponents component = ColorComponents.HUE;
    private int[] selection;
    private float lastPointX;
    private float lastPointY;

    public HSBColorSelectorPanel() {
        this.colorSelectionHandler = new ColorSelectionHandler();
        this.addMouseListener(new MouseHandler());
        this.addMouseMotionListener(new MouseHandler());
        this.updateImage();
    }

    public ColorComponents getComponent() {
        return this.component;
    }

    public void setComponent(ColorComponents component) {
        if (component == null) {
            throw new NullPointerException();
        }
        this.component = component;
        this.updateImage();
        this.repaint();
    }

    private float[] computeColor(float selectedValue, int x, int y) {
        if (this.component == ColorComponents.HUE) {
            return new float[]{selectedValue, (float)x / 360.0f, (float)y / 360.0f};
        }
        if (this.component == ColorComponents.SATURATION) {
            return new float[]{(float)x / 360.0f, selectedValue, (float)y / 360.0f};
        }
        if (this.component == ColorComponents.BRIGHTNESS) {
            return new float[]{(float)x / 360.0f, (float)y / 360.0f, selectedValue};
        }
        throw new IllegalStateException();
    }

    private void updateImage() {
        float selectedComponent = this.getSelectedComponent();
        for (int x = 0; x < 360; ++x) {
            for (int y = 0; y < 360; ++y) {
                float[] floats = this.computeColor(selectedComponent, x, y);
                this.backend.setRGB(x, 359 - y, Color.HSBtoRGB(floats[0], floats[1], floats[2]));
            }
        }
    }

    private float getSelectedComponent() {
        float selectedComponent;
        if (this.selection == null) {
            selectedComponent = 0.5f;
        } else {
            float[] hsb = new float[]{(float)this.selection[0] / 360.0f, (float)this.selection[1] / 100.0f, (float)this.selection[2] / 100.0f};
            switch (this.component) {
                case HUE: {
                    selectedComponent = hsb[0];
                    break;
                }
                case SATURATION: {
                    selectedComponent = hsb[1];
                    break;
                }
                case BRIGHTNESS: {
                    selectedComponent = hsb[2];
                    break;
                }
                default: {
                    selectedComponent = 0.5f;
                }
            }
        }
        return selectedComponent;
    }

    public ExtendedColorModel getColorSelectionModel() {
        return this.colorSelectionModel;
    }

    public void setColorSelectionModel(ExtendedColorModel colorSelectionModel) {
        if (this.colorSelectionModel != null) {
            this.colorSelectionModel.removeChangeListener(this.colorSelectionHandler);
        }
        this.colorSelectionModel = colorSelectionModel;
        if (this.colorSelectionModel != null) {
            this.colorSelectionModel.addChangeListener(this.colorSelectionHandler);
            this.selection = new int[]{colorSelectionModel.getHue(), colorSelectionModel.getSaturation(), colorSelectionModel.getValue()};
            float[] point = this.computeSelectedPosition();
            this.lastPointX = point[0];
            this.lastPointY = point[1];
            this.updateImage();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.drawImage(this.backend, 0, 0, this.getWidth(), this.getHeight(), this);
        if (this.selection != null) {
            float[] floats = new float[]{(float)this.selection[0] / 360.0f, (float)this.selection[1] / 100.0f, (float)this.selection[2] / 100.0f};
            floats[1] = 0.0f;
            floats[2] = floats[2] < 0.5f ? 1.0f : 0.0f;
            Graphics graphics = g.create();
            graphics.setColor(Color.getHSBColor(floats[0], floats[1], floats[2]));
            graphics.drawOval((int)(this.lastPointX * (float)this.getWidth() - 2.0f), (int)(this.lastPointY * (float)this.getHeight() - 2.0f), 4, 4);
            graphics.dispose();
        }
    }

    private float[] computeSelectedPosition() {
        if (this.selection == null) {
            return null;
        }
        float[] floats = new float[]{(float)this.selection[0] / 360.0f, (float)this.selection[1] / 100.0f, (float)this.selection[2] / 100.0f};
        switch (this.component) {
            case HUE: {
                return new float[]{floats[1], 1.0f - floats[2]};
            }
            case SATURATION: {
                return new float[]{floats[0], 1.0f - floats[2]};
            }
            case BRIGHTNESS: {
                return new float[]{floats[0], 1.0f - floats[1]};
            }
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(360, 360);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(360, 360);
    }

    static /* synthetic */ int[] access$502(HSBColorSelectorPanel x0, int[] x1) {
        x0.selection = x1;
        return x1;
    }

    private class ColorSelectionHandler
    implements ChangeListener {
        private ColorSelectionHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (HSBColorSelectorPanel.this.selection != null && HSBColorSelectorPanel.this.selection[0] == HSBColorSelectorPanel.this.colorSelectionModel.getHue() && HSBColorSelectorPanel.this.selection[1] == HSBColorSelectorPanel.this.colorSelectionModel.getSaturation() && HSBColorSelectorPanel.this.selection[2] == HSBColorSelectorPanel.this.colorSelectionModel.getValue()) {
                return;
            }
            HSBColorSelectorPanel.access$502(HSBColorSelectorPanel.this, new int[]{HSBColorSelectorPanel.this.colorSelectionModel.getHue(), HSBColorSelectorPanel.this.colorSelectionModel.getSaturation(), HSBColorSelectorPanel.this.colorSelectionModel.getValue()});
            float[] point = HSBColorSelectorPanel.this.computeSelectedPosition();
            HSBColorSelectorPanel.this.lastPointX = point[0];
            HSBColorSelectorPanel.this.lastPointY = point[1];
            HSBColorSelectorPanel.this.updateImage();
            HSBColorSelectorPanel.this.repaint();
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.handleMouse(e);
        }

        private void handleMouse(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            if (HSBColorSelectorPanel.this.getWidth() == 0 || HSBColorSelectorPanel.this.getHeight() == 0) {
                return;
            }
            if (e.getX() > HSBColorSelectorPanel.this.getWidth()) {
                return;
            }
            if (e.getY() > HSBColorSelectorPanel.this.getHeight()) {
                return;
            }
            if (HSBColorSelectorPanel.this.colorSelectionModel == null) {
                return;
            }
            float x = (float)e.getX() / (float)HSBColorSelectorPanel.this.getWidth();
            float y = (float)e.getY() / (float)HSBColorSelectorPanel.this.getHeight();
            float[] color = HSBColorSelectorPanel.this.computeColor(HSBColorSelectorPanel.this.getSelectedComponent(), (int)(x * 360.0f), (int)(360.0f - y * 360.0f));
            HSBColorSelectorPanel.this.colorSelectionModel.setHSB((int)(color[0] * 360.0f), (int)(color[1] * 100.0f), (int)(color[2] * 100.0f));
            HSBColorSelectorPanel.this.lastPointX = x;
            HSBColorSelectorPanel.this.lastPointY = y;
            HSBColorSelectorPanel.this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.handleMouse(e);
        }
    }

    public static enum ColorComponents {
        HUE,
        SATURATION,
        BRIGHTNESS;

    }
}

