/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jmi.model.AggregationKindEnum;
import javax.jmi.model.Association;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.Attribute;
import javax.jmi.model.Classifier;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.Feature;
import javax.jmi.model.GeneralizableElement;
import javax.jmi.model.Import;
import javax.jmi.model.ModelElement;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofPackage;
import javax.jmi.model.Namespace;
import javax.jmi.model.Operation;
import javax.jmi.model.ScopeKindEnum;
import javax.jmi.model.StructureField;
import javax.jmi.model.StructureType;
import javax.jmi.model.Tag;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.XmiReader;
import org.netbeans.api.mdr.CreationFailedException;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.mdr.events.ExtentEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.handlers.ImmutableList;
import org.netbeans.mdr.handlers.InstanceHandler;
import org.netbeans.mdr.handlers.gen.TagSupport;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.BootReader;
import org.netbeans.mdr.storagemodel.DatatypeDescriptor;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.StorableAssociation;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.storagemodel.StorablePackage;
import org.netbeans.mdr.storagemodel.TransientStorableAssociation;
import org.netbeans.mdr.storagemodel.TransientStorableClass;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;
import org.netbeans.mdr.util.MountFailedException;
import org.netbeans.mdr.util.TransactionMutex;
import org.openide.util.Lookup;

public class NBMDRepositoryImpl
implements MDRepository {
    private static final URL MOF_XML_URL;
    private static final URL BOOTMOF_XML_URL;
    private static final String TAGID_INDEX = "org.netbeans.attributeIndex";
    private static final String PARAM_STORAGE_CLASS = "storage";
    private static final String TRANSIENT_TAG_ID = "org.netbeans.mdr.transient";
    private static final String TAG_VALUE_TRUE = "true";
    public static final String BOOT_MOF = "BootMOF";
    public static final String PURE_MOF = "MOF";
    private MdrStorage mdrStorage = null;
    private Map classProxies = null;
    private Map associationProxies = null;
    private Map classProxiesMofIds = null;
    private int waitCount = 0;
    private final Map parameters;
    private Map constructorCache = new HashMap();
    private Set shutdownListeners = new HashSet();
    private final Map facilityCache = new FacilityCache();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.jmi.model.ModelPackage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MOF_XML_URL = clazz.getResource("resources/mof.xml");
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("javax.jmi.model.ModelPackage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BOOTMOF_XML_URL = clazz2.getResource("resources/mof.xml");
    }

    public NBMDRepositoryImpl() {
        Properties props = System.getProperties();
        String storageClass = props.getProperty("org.netbeans.mdr.storagemodel.StorageFactoryClassName", "org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeFactory");
        String storageFile = props.getProperty("org.netbeans.mdr.persistence.Dir");
        String storageUUID = props.getProperty("org.netbeans.mdr.persistence.UUID");
        Logger.getDefault().log("Storage factory: " + storageClass);
        this.parameters = new HashMap();
        this.parameters.put(PARAM_STORAGE_CLASS, storageClass);
        this.parameters.put("org.netbeans.mdr.persistence.btreeimpl.filename", storageFile);
        this.parameters.put("org.netbeans.mdr.persistence.btreeimpl.uuid", storageUUID);
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith("MDRStorageProperty.")) continue;
            this.parameters.put(name.substring(19), props.getProperty(name));
        }
    }

    public NBMDRepositoryImpl(Map parameters) {
        Logger.getDefault().log("Creating MDRepository implementation ...");
        this.parameters = parameters;
    }

    public void addListener(MDRChangeListener listener) {
        this.addListener(listener, 0xFFFFFFF);
    }

    public void addListener(MDRChangeListener listener, int mask) {
        this.initCheck();
        this.mdrStorage.getEventNotifier().REPOSITORY.addListener(listener, mask, this.mdrStorage);
    }

    public void removeListener(MDRChangeListener listener) {
        this.initCheck();
        this.mdrStorage.getEventNotifier().REPOSITORY.removeListener(listener, this.mdrStorage);
    }

    public void removeListener(MDRChangeListener listener, int mask) {
        this.initCheck();
        this.mdrStorage.getEventNotifier().REPOSITORY.removeListener(listener, mask, this.mdrStorage);
    }

    public void enableEvents() {
        this.initCheck();
        this.mdrStorage.enableEvents();
    }

    public void disableEvents() {
        this.beginTrans(false);
        this.mdrStorage.disableEvents();
        this.endTrans();
    }

    public MdrStorage getMdrStorage() {
        this.initCheck();
        return this.mdrStorage;
    }

    public TransactionMutex getTransactionMutex() {
        this.initCheck();
        return this.mdrStorage.getRepositoryMutex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTrans(boolean writeAccess) {
        NBMDRepositoryImpl nBMDRepositoryImpl = this;
        synchronized (nBMDRepositoryImpl) {
            this.initCheck();
            ++this.waitCount;
        }
        try {
            this.mdrStorage.getRepositoryMutex().enter(writeAccess);
        }
        catch (RuntimeException e) {
            this.decrementWait();
            throw e;
        }
        catch (Error e) {
            this.decrementWait();
            throw e;
        }
    }

    private synchronized void decrementWait() {
        --this.waitCount;
    }

    public void endTrans() {
        this.endTrans(false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endTrans(boolean rollback) {
        this.initCheck();
        try {
            try {
                if (this.mdrStorage.getRepositoryMutex().leave(rollback)) {
                    this.mdrStorage.enableEvents();
                }
            }
            catch (RuntimeException e) {
                this.mdrStorage.enableEvents();
                throw e;
            }
            catch (Error e) {
                this.mdrStorage.enableEvents();
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.decrementWait();
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.decrementWait();
            return;
        }
    }

    public RefPackage createExtent(String substName) throws CreationFailedException {
        return this.createExtent(substName, null);
    }

    public RefPackage createExtent(String substName, RefObject metaPackage) throws CreationFailedException {
        return this.createExtent(substName, metaPackage, null);
    }

    public RefPackage createExtent(String substName, RefObject metaPackage, RefPackage[] existingInstances) throws CreationFailedException {
        return this.createExtent(substName, metaPackage, existingInstances, null);
    }

    public RefPackage getExtent(String name) {
        this.initCheck();
        this.beginTrans(false);
        try {
            StorablePackage pkg;
            try {
                pkg = this.mdrStorage.getContextOutermostPackage(name);
            }
            catch (NullPointerException e) {
                pkg = null;
            }
            catch (StorageBadRequestException e) {
                pkg = null;
            }
            catch (StorageException e) {
                throw new DebugException("Storage exception: " + e);
            }
            RefPackage refPackage = (RefPackage)this.getHandler(pkg);
            Object var4_7 = null;
            this.endTrans();
            return refPackage;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.endTrans();
            throw throwable;
        }
    }

    public boolean renameExtent(RefPackage extent, String newName) {
        this.initCheck();
        boolean fail = true;
        this.beginTrans(true);
        try {
            boolean result = this.mdrStorage.renameContext(((BaseObjectHandler)extent)._getMofId(), newName);
            fail = false;
            boolean bl = result;
            Object var5_7 = null;
            this.endTrans(fail);
            return bl;
        }
        catch (StorageException e) {
            try {
                throw new DebugException("Renaming failed: " + e);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.endTrans(fail);
                throw throwable;
            }
        }
    }

    public String[] getExtentNames() {
        this.initCheck();
        String[] result = new String[]{};
        this.beginTrans(false);
        try {
            String[] stringArray = result = this.mdrStorage.getContexts().toArray(result);
            Object var3_3 = null;
            this.endTrans();
            return stringArray;
        }
        catch (StorageException e) {
            try {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.endTrans();
                throw throwable;
            }
        }
    }

    public RefBaseObject getByMofId(String mofId) {
        return this.getByMofId(MOFID.fromString(mofId));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefBaseObject getByMofId(MOFID mofId) {
        this.initCheck();
        this.beginTrans(false);
        try {
            try {
                StorableBaseObject storable = this.mdrStorage.getObject(mofId);
                RefBaseObject refBaseObject = this.getHandler(storable);
                Object var3_5 = null;
                this.endTrans();
                return refBaseObject;
            }
            catch (StorageException storageException) {
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.endTrans();
            throw throwable;
        }
        {
            Object var3_7 = null;
            this.endTrans();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandler(MOFID mofId) {
        Map map = this.facilityCache;
        synchronized (map) {
            this.facilityCache.remove(mofId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(BaseObjectHandler handler) {
        StorableBaseObject s = handler._getDelegate();
        MOFID mofId = s.getMofId();
        Object lock = s.getMdrStorage().getStorageByMofId(mofId);
        if (lock == null) {
            lock = this.facilityCache;
        }
        Storage storage = lock;
        synchronized (storage) {
            Map map = this.facilityCache;
            synchronized (map) {
                this.facilityCache.put(mofId, handler);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void shutdown() {
        block8: {
            if (this.mdrStorage == null) break block8;
            try {
                try {
                    while (true) {
                        block9: {
                            if (this.waitCount > 0) break block9;
                            this.mdrStorage.shutDown();
                            break;
                        }
                        try {
                            this.wait(100L);
                        }
                        catch (InterruptedException e) {
                            Logger.getDefault().notify(1, (Throwable)e);
                        }
                    }
                }
                catch (StorageException e) {
                    throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.mdrStorage = null;
                throw throwable;
            }
            {
                Object var2_5 = null;
                this.mdrStorage = null;
            }
        }
        this.notifyShutdownListeners();
        this.notifyShutdownStep();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("IDE MOF Repository");
        return sb.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefPackage createExtent(String substName, RefObject metaPackage, RefPackage[] existingInstances, String storageId) throws CreationFailedException {
        RefPackage result;
        this.initCheck();
        boolean fail = true;
        if (metaPackage == null) {
            metaPackage = this.getMOFModelPackage();
        }
        this.beginTrans(true);
        try {
            if (this.getExtent(substName) != null) {
                throw new CreationFailedException("Package extent named '" + substName + "' already exists.");
            }
            if (this.mdrStorage.eventsEnabled()) {
                ExtentEvent event = new ExtentEvent((Object)this, 0x8010001, substName, metaPackage, (Collection)new ImmutableList(existingInstances));
                this.mdrStorage.getEventNotifier().REPOSITORY.firePlannedChange(this.mdrStorage, (MDRChangeEvent)event);
            }
            HashMap instancesToCluster = new HashMap();
            this.classProxies = new HashMap();
            this.associationProxies = new HashMap();
            this.classProxiesMofIds = new HashMap();
            if (existingInstances != null) {
                int i = 0;
                while (i < existingInstances.length) {
                    this.collectPackageInstances(existingInstances[i], instancesToCluster);
                    ++i;
                }
            }
            try {
                this.instantiatePackage(substName, null, (MofPackage)metaPackage, instancesToCluster, storageId, false);
            }
            catch (RuntimeException e) {
                throw (CreationFailedException)Logger.getDefault().annotate((Throwable)new CreationFailedException("Cannot instantiate package because of unexpected exception: " + e), (Throwable)e);
            }
            this.classProxies = null;
            this.associationProxies = null;
            this.classProxiesMofIds = null;
            result = this.getExtent(substName);
            if (result == null) {
                throw new CreationFailedException("Cannot find created package.");
            }
            fail = false;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.endTrans(fail);
            throw throwable;
        }
        {
            Object var9_12 = null;
            this.endTrans(fail);
            return result;
        }
    }

    public String mountStorage(String storageFactoryClass, Map properties) throws MountFailedException {
        boolean failed = true;
        this.beginTrans(true);
        try {
            String storageId = this.mdrStorage.mountStorage(storageFactoryClass, properties);
            failed = false;
            String string = storageId;
            Object var5_7 = null;
            this.endTrans(failed);
            return string;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new MountFailedException("Partition mount failed.", e);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.endTrans(failed);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unmountStorage(String storageId) {
        boolean failed = true;
        this.beginTrans(true);
        try {
            try {
                if (this.mdrStorage.eventsEnabled()) {
                    Collection c = this.mdrStorage.getContexts(storageId);
                    Iterator it = c.iterator();
                    while (it.hasNext()) {
                        String extentName = (String)it.next();
                        RefPackage pkg = this.getExtent(extentName);
                        ExtentEvent event = new ExtentEvent((Object)pkg, 134283266, extentName, pkg.refMetaObject(), null);
                        this.mdrStorage.getEventNotifier().PACKAGE.firePlannedChange(pkg, (MDRChangeEvent)event);
                    }
                }
                this.mdrStorage.unmountStorage(storageId);
                failed = false;
            }
            catch (StorageException e) {
                throw new DebugException("Unmounting failed: " + e.toString());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.endTrans(failed);
            throw throwable;
        }
        {
            Object var8_11 = null;
            this.endTrans(failed);
            return;
        }
    }

    public String getMOFInstanceName() {
        return PURE_MOF;
    }

    public String getParameter(String name) {
        return (String)this.parameters.get(name);
    }

    public void freeCache() {
        this.facilityCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefBaseObject getHandler(MOFID mofId) {
        Map map = this.facilityCache;
        synchronized (map) {
            return (BaseObjectHandler)this.facilityCache.get(mofId);
        }
    }

    public RefBaseObject getHandler(StorableBaseObject s) {
        if (s == null) {
            return null;
        }
        RefBaseObject refBO = this.getHandler(s.getMofId());
        if (refBO == null) {
            Class ifc = BaseObjectHandler.resolveClass(s);
            refBO = this.getHandler(s, ifc);
        }
        return refBO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefBaseObject getHandler(StorableBaseObject s, Class ifc) {
        if (s == null) {
            return null;
        }
        Class cl = BaseObjectHandler.getHandlerClass(ifc, s);
        try {
            Class<?> cls = s.getClass();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.netbeans.mdr.storagemodel.TransientStorableClass");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (cls.equals(clazz)) {
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("org.netbeans.mdr.storagemodel.StorableClass");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                cls = clazz2;
            } else {
                Class<?> clazz3 = class$3;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$3 = Class.forName("org.netbeans.mdr.storagemodel.TransientStorableObject");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (cls.equals(clazz3)) {
                    Class<?> clazz4 = class$4;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$4 = Class.forName("org.netbeans.mdr.storagemodel.StorableObject");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    cls = clazz4;
                } else {
                    Class<?> clazz5 = class$5;
                    if (clazz5 == null) {
                        try {
                            clazz5 = class$5 = Class.forName("org.netbeans.mdr.storagemodel.TransientStorableAssociation");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (cls.equals(clazz5)) {
                        Class<?> clazz6 = class$6;
                        if (clazz6 == null) {
                            try {
                                clazz6 = class$6 = Class.forName("org.netbeans.mdr.storagemodel.StorableAssociation");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        cls = clazz6;
                    } else {
                        Class<?> clazz7 = class$4;
                        if (clazz7 == null) {
                            try {
                                clazz7 = class$4 = Class.forName("org.netbeans.mdr.storagemodel.StorableObject");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (cls != clazz7) {
                            Class<?> clazz8 = class$4;
                            if (clazz8 == null) {
                                try {
                                    clazz8 = class$4 = Class.forName("org.netbeans.mdr.storagemodel.StorableObject");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (clazz8.isAssignableFrom(cls)) {
                                Class<?> clazz9 = class$4;
                                if (clazz9 == null) {
                                    try {
                                        clazz9 = class$4 = Class.forName("org.netbeans.mdr.storagemodel.StorableObject");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                cls = clazz9;
                            }
                        }
                    }
                }
            }
            MOFID mofId = s.getMofId();
            Object lock = s.getMdrStorage().getStorageByMofId(mofId);
            if (lock == null) {
                lock = this.facilityCache;
            }
            Storage storage = lock;
            synchronized (storage) {
                Map map = this.facilityCache;
                synchronized (map) {
                    Object oldRecord = this.facilityCache.get(mofId);
                    if (oldRecord == null) {
                        Constructor cons = (Constructor)this.constructorCache.get(cl);
                        if (cons == null) {
                            cons = cl.getConstructor(cls);
                            this.constructorCache.put(cl, cons);
                        }
                        oldRecord = cons.newInstance(s);
                        this.facilityCache.put(mofId, oldRecord);
                    }
                    return (BaseObjectHandler)oldRecord;
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutdownListener(ShutdownListener listener) {
        Set set = this.shutdownListeners;
        synchronized (set) {
            this.shutdownListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShutdownListener(ShutdownListener listener) {
        Set set = this.shutdownListeners;
        synchronized (set) {
            this.shutdownListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyShutdownListeners() {
        Set set = this.shutdownListeners;
        synchronized (set) {
            Iterator iter = this.shutdownListeners.iterator();
            while (iter.hasNext()) {
                ShutdownListener listener = (ShutdownListener)iter.next();
                listener.shutdown();
            }
        }
    }

    public int getShutdownSteps() {
        return this.mdrStorage != null ? this.mdrStorage.getShutdownSteps() + 1 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyShutdownStep() {
        Set set = this.shutdownListeners;
        synchronized (set) {
            Iterator iter = this.shutdownListeners.iterator();
            while (iter.hasNext()) {
                ShutdownListener listener = (ShutdownListener)iter.next();
                listener.stepFinished();
            }
        }
    }

    private MofPackage getMOFModelPackage() {
        ModelPackage mofPackage = (ModelPackage)this.getExtent(this.getMOFInstanceName());
        Iterator it = mofPackage.getMofPackage().refAllOfClass().iterator();
        while (it.hasNext()) {
            MofPackage result = (MofPackage)it.next();
            if (!result.getName().equals("Model")) continue;
            return result;
        }
        return null;
    }

    private synchronized void initCheck() {
        if (this.mdrStorage == null) {
            String storageClass = (String)this.parameters.get(PARAM_STORAGE_CLASS);
            this.mdrStorage = new MdrStorage(this, storageClass, this.parameters);
            try {
                Logger.getDefault().log("initializing...");
                if (!this.mdrStorage.init()) {
                    Logger.getDefault().log("booting...");
                    this.boot();
                }
                return;
            }
            catch (StorageException e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException("Fatal error: Repository boot/initialization failed with message: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void collectPackageInstances(RefPackage pkg, Map packages) throws CreationFailedException {
        RefPackage result = packages.put(((BaseObjectHandler)pkg.refMetaObject())._getDelegate().getMofId(), pkg);
        if (result != null && !result.equals(pkg)) {
            throw new CreationFailedException("The provided list of existing package instances contains duplicities.");
        }
        Iterator it = pkg.refAllPackages().iterator();
        while (it.hasNext()) {
            RefPackage nested = (RefPackage)it.next();
            this.collectPackageInstances(nested, packages);
        }
    }

    private RefPackage instantiatePackage(String substName, StorablePackage immediatePackage, MofPackage metaPackage, Map clusteredInstances, String storageId, boolean clustered) {
        StorablePackage newPackage = this.createPackageHandler(metaPackage, immediatePackage, substName, storageId, clustered);
        RefPackage result = (RefPackage)this.getHandler(newPackage);
        Logger.getDefault().log("new package: " + newPackage.getMofId() + ", metapackage: " + metaPackage.refMofId());
        HashSet localAssocProxies = new HashSet();
        ArrayList localClassProxies = new ArrayList();
        this.instantiatePackageContent(metaPackage, newPackage, clusteredInstances, localClassProxies, localAssocProxies, storageId);
        this.resolveSuperclasses(metaPackage, localClassProxies);
        this.resolveAssociations(localAssocProxies);
        return result;
    }

    private void resolveAssociations(Collection localAssocProxies) {
        try {
            Iterator it = localAssocProxies.iterator();
            while (it.hasNext()) {
                MOFID saMofId = (MOFID)it.next();
                StorableAssociation sa = (StorableAssociation)this.mdrStorage.getObject(saMofId);
                if (((Association)this.getHandler(sa.getMetaObject())).isDerived()) continue;
                Classifier metaCls = ((AssociationEnd)this.getByMofId(sa.getEnd1Id())).getType();
                StorableClass cls = (StorableClass)this.classProxies.get(metaCls);
                cls.addAssociationEnd(saMofId, sa.getEnd1Name(), sa.isAggregateA());
                metaCls = ((AssociationEnd)this.getByMofId(sa.getEnd2Id())).getType();
                cls = (StorableClass)this.classProxies.get(metaCls);
                if (cls == null) continue;
                cls.addAssociationEnd(saMofId, sa.getEnd2Name(), sa.isAggregateB());
            }
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    private void resolveSuperclasses(MofPackage metaPackage, List localClassProxies) {
        StorableClass sc;
        HashMap<MofClass, LinkedList<Tag>> indexes = new HashMap<MofClass, LinkedList<Tag>>();
        if (!localClassProxies.isEmpty()) {
            ModelPackage modelPackage = (ModelPackage)metaPackage.refImmediatePackage();
            Iterator iter = modelPackage.getTag().refAllOfClass().iterator();
            while (iter.hasNext()) {
                Tag tag = (Tag)iter.next();
                if (!TAGID_INDEX.equals(tag.getTagId())) continue;
                Iterator elements = tag.getElements().iterator();
                MofClass tempOwner = null;
                MofClass owner = null;
                boolean oneClass = true;
                while (elements.hasNext()) {
                    ModelElement elem = (ModelElement)elements.next();
                    if (elem instanceof MofClass) {
                        oneClass = true;
                        owner = (MofClass)elem;
                        break;
                    }
                    if (elem instanceof Attribute) {
                        tempOwner = (MofClass)elem.getContainer();
                    } else if (elem instanceof AssociationEnd) {
                        tempOwner = (MofClass)((AssociationEnd)elem).otherEnd().getType();
                    }
                    if (owner == null && tempOwner != null) {
                        owner = tempOwner;
                        continue;
                    }
                    boolean bl = oneClass = oneClass && owner == tempOwner;
                }
                if (owner == null || !oneClass) continue;
                LinkedList<Tag> tags = (LinkedList<Tag>)indexes.get(owner);
                if (tags == null) {
                    tags = new LinkedList<Tag>();
                    indexes.put(owner, tags);
                }
                tags.add(tag);
            }
        }
        Iterator it = localClassProxies.iterator();
        while (it.hasNext()) {
            MofClass cls;
            sc = (StorableClass)it.next();
            try {
                cls = (MofClass)this.getHandler(sc.getMetaObject());
            }
            catch (StorageException e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
            Iterator supers = cls.getSupertypes().iterator();
            while (supers.hasNext()) {
                Object superMeta = supers.next();
                StorableClass current = (StorableClass)this.classProxies.get(superMeta);
                if (current == null) {
                    throw new DebugException("Package definition is incomplete: class " + cls.getName() + " super = " + (superMeta instanceof MofClass ? ((MofClass)superMeta).getName() : superMeta));
                }
                sc.addSuperclass(current.getMofId());
                current.addSubclass(sc.getMofId());
            }
            Iterator contents = cls.getContents().iterator();
            while (contents.hasNext()) {
                ModelElement me = (ModelElement)contents.next();
                if (!(me instanceof javax.jmi.model.Reference)) continue;
                AssociationEnd end = ((javax.jmi.model.Reference)me).getExposedEnd();
                sc.addReferenceDescriptor(((BaseObjectHandler)me)._getDelegate().getMofId(), me.getName(), (MOFID)this.associationProxies.get(((BaseObjectHandler)end.getContainer())._getDelegate().getMofId()), end.getName());
            }
            List indexTags = (List)indexes.get(cls);
            if (indexTags == null) continue;
            try {
                sc.buildAdditionalIndexes(indexTags, this.associationProxies);
            }
            catch (StorageException e) {
                throw new DebugException("Storage exception: " + e);
            }
        }
        Class[] iface = new Class[1];
        Iterator it2 = localClassProxies.iterator();
        while (it2.hasNext()) {
            sc = (StorableClass)it2.next();
            try {
                iface[0] = null;
                sc.initInstanceSuperclass(iface);
                sc.initClassSuperclass(null);
            }
            catch (Exception e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
        }
    }

    private void instantiatePackageContent(MofPackage metaPackage, StorablePackage newPackage, Map clusteredInstances, List localClassProxies, Set localAssocProxies, String storageId) {
        Iterator superTypes = metaPackage.allSupertypes().iterator();
        boolean thisTypeNotProcessed = true;
        while (thisTypeNotProcessed || superTypes.hasNext()) {
            Iterator it;
            if (thisTypeNotProcessed) {
                it = metaPackage.getContents().iterator();
                thisTypeNotProcessed = false;
            } else {
                it = ((MofPackage)superTypes.next()).getContents().iterator();
            }
            while (it.hasNext()) {
                Object o = it.next();
                ModelElement element = (ModelElement)o;
                if (element instanceof MofClass) {
                    this.createClassProxyHandler((MofClass)element, newPackage, localClassProxies);
                    continue;
                }
                if (element instanceof Association) {
                    boolean indexedB;
                    Class typeB;
                    Class typeA;
                    Association assoc = (Association)element;
                    List content = assoc.getContents();
                    int i = 0;
                    AssociationEnd[] ends = new AssociationEnd[2];
                    Iterator cit = content.iterator();
                    while (i < 2 && cit.hasNext()) {
                        ModelElement containedElement = (ModelElement)cit.next();
                        if (!(containedElement instanceof AssociationEnd)) continue;
                        ends[i++] = (AssociationEnd)containedElement;
                    }
                    int minA = ends[0].getMultiplicity().getLower();
                    int maxA = ends[0].getMultiplicity().getUpper();
                    int minB = ends[1].getMultiplicity().getLower();
                    int maxB = ends[1].getMultiplicity().getUpper();
                    try {
                        typeA = BaseObjectHandler.resolveInterface(TagSupport.getDataTypeName((StorableObject)((InstanceHandler)ends[0].getType())._getDelegate()));
                        typeB = BaseObjectHandler.resolveInterface(TagSupport.getDataTypeName((StorableObject)((InstanceHandler)ends[1].getType())._getDelegate()));
                    }
                    catch (Exception e) {
                        throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
                    }
                    boolean orderA = ends[0].getMultiplicity().isOrdered();
                    boolean orderB = ends[1].getMultiplicity().isOrdered();
                    boolean uniqueA = ends[0].getMultiplicity().isUnique();
                    boolean uniqueB = ends[1].getMultiplicity().isUnique();
                    boolean aggrA = ends[0].getAggregation().equals((Object)AggregationKindEnum.COMPOSITE);
                    boolean aggrB = ends[1].getAggregation().equals((Object)AggregationKindEnum.COMPOSITE);
                    boolean indexedA = TagSupport.getTagValue((StorableObject)((BaseObjectHandler)ends[0])._getDelegate(), TAGID_INDEX) != null;
                    boolean bl = indexedB = TagSupport.getTagValue((StorableObject)((BaseObjectHandler)ends[1])._getDelegate(), TAGID_INDEX) != null;
                    if (TagSupport.getTagValue((StorableObject)((BaseObjectHandler)ends[0].getType())._getDelegate(), TRANSIENT_TAG_ID, "").equals(TAG_VALUE_TRUE) || TagSupport.getTagValue((StorableObject)((BaseObjectHandler)ends[1].getType())._getDelegate(), TRANSIENT_TAG_ID, "").equals(TAG_VALUE_TRUE)) {
                        this.createTransientAssociationHandler((Association)element, newPackage, ends[0].getName(), ((BaseObjectHandler)ends[0])._getDelegate().getMofId(), ends[1].getName(), ((BaseObjectHandler)ends[1])._getDelegate().getMofId(), typeA, typeB, minA, maxA, minB, maxB, orderA, orderB, uniqueA, uniqueB, aggrA, aggrB, localAssocProxies);
                        continue;
                    }
                    this.createAssociationHandler((Association)element, newPackage, ends[0].getName(), ((BaseObjectHandler)ends[0])._getDelegate().getMofId(), ends[1].getName(), ((BaseObjectHandler)ends[1])._getDelegate().getMofId(), typeA, typeB, minA, maxA, minB, maxB, orderA, orderB, uniqueA, uniqueB, aggrA, aggrB, indexedA, indexedB, localAssocProxies);
                    continue;
                }
                if (element instanceof MofPackage) {
                    StorablePackage pkg = this.createPackageHandler((MofPackage)element, newPackage, null, storageId, false);
                    this.instantiatePackageContent((MofPackage)element, pkg, clusteredInstances, localClassProxies, localAssocProxies, storageId);
                    continue;
                }
                if (!(element instanceof Import)) continue;
                Import imp = (Import)element;
                Namespace metaElement = imp.getImportedNamespace();
                if (metaElement instanceof MofPackage) {
                    MofPackage metaPkg = (MofPackage)metaElement;
                    this.collectDTDescriptors(storageId, (GeneralizableElement)metaPkg, new HashSet());
                    if (!imp.isClustered()) continue;
                    RefPackage pkg = (RefPackage)clusteredInstances.get(((BaseObjectHandler)metaPkg)._getDelegate().getMofId());
                    if (pkg == null) {
                        pkg = this.instantiatePackage(null, newPackage, metaPkg, clusteredInstances, storageId, true);
                        clusteredInstances.put(((BaseObjectHandler)metaPkg)._getDelegate().getMofId(), pkg);
                    } else {
                        this.collectAllProxies(pkg);
                    }
                    try {
                        newPackage.clusterPackage(imp.getName(), ((BaseObjectHandler)pkg)._getDelegate().getMofId());
                        continue;
                    }
                    catch (StorageException e) {
                        throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
                    }
                }
                if (metaElement instanceof EnumerationType) {
                    this.createDTDescriptor(storageId, (EnumerationType)metaElement);
                    continue;
                }
                if (metaElement instanceof StructureType) {
                    this.createDTDescriptor(storageId, (StructureType)metaElement);
                    continue;
                }
                if (!(metaElement instanceof MofClass)) continue;
                this.collectDTDescriptors(storageId, (GeneralizableElement)((MofClass)metaElement), new HashSet());
            }
        }
    }

    private void collectDTDescriptors(String storageId, GeneralizableElement metaElement, Set visited) {
        Iterator superTypes = metaElement.allSupertypes().iterator();
        boolean thisTypeNotProcessed = true;
        while (thisTypeNotProcessed || superTypes.hasNext()) {
            Iterator it;
            if (thisTypeNotProcessed) {
                it = metaElement.getContents().iterator();
                thisTypeNotProcessed = false;
            } else {
                GeneralizableElement ge = (GeneralizableElement)superTypes.next();
                if (!visited.add(ge)) continue;
                it = ge.getContents().iterator();
            }
            this.collectDTDescriptors(storageId, it, visited);
        }
    }

    private void collectDTDescriptors(String storageId, Iterator it, Set visited) {
        while (it.hasNext()) {
            Object element = it.next();
            if (element instanceof MofPackage || element instanceof MofClass) {
                if (!visited.add(element)) continue;
                this.collectDTDescriptors(storageId, (GeneralizableElement)element, visited);
                continue;
            }
            if (element instanceof EnumerationType) {
                this.createDTDescriptor(storageId, (EnumerationType)element);
                continue;
            }
            if (!(element instanceof StructureType)) continue;
            this.createDTDescriptor(storageId, (StructureType)element);
        }
    }

    private void collectAllProxies(RefPackage pkg) {
        Iterator it = pkg.refAllAssociations().iterator();
        while (it.hasNext()) {
            RefAssociation assoc = (RefAssociation)it.next();
            if (this.associationProxies.put(((BaseObjectHandler)assoc.refMetaObject())._getDelegate().getMofId(), ((BaseObjectHandler)assoc)._getDelegate().getMofId()) == null) continue;
            return;
        }
        it = pkg.refAllClasses().iterator();
        while (it.hasNext()) {
            RefClass cls = (RefClass)it.next();
            if (this.classProxiesMofIds.put(((BaseObjectHandler)cls.refMetaObject())._getDelegate().getMofId(), ((BaseObjectHandler)cls)._getDelegate().getMofId()) != null) {
                return;
            }
            this.classProxies.put(cls.refMetaObject(), ((BaseObjectHandler)cls)._getDelegate());
        }
        it = pkg.refAllPackages().iterator();
        while (it.hasNext()) {
            this.collectAllProxies((RefPackage)it.next());
        }
    }

    private StorablePackage createPackageHandler(MofPackage metaObject, StorablePackage immediatePackage, String context, String storageId, boolean clustered) {
        try {
            HashMap<String, DatatypeDescriptor> datatypes = new HashMap<String, DatatypeDescriptor>();
            Iterator supers = null;
            while (supers == null || supers.hasNext()) {
                MofPackage metaPackage;
                if (supers == null) {
                    supers = metaObject.allSupertypes().iterator();
                    metaPackage = metaObject;
                } else {
                    metaPackage = (MofPackage)supers.next();
                }
                Iterator it = metaPackage.getContents().iterator();
                while (it.hasNext()) {
                    ModelElement element = (ModelElement)it.next();
                    if (element instanceof EnumerationType) {
                        datatypes.put(element.getName(), this.createDTDescriptor(storageId, (EnumerationType)element));
                        continue;
                    }
                    if (!(element instanceof StructureType)) continue;
                    datatypes.put(element.getName(), this.createDTDescriptor(storageId, (StructureType)element));
                }
            }
            StorablePackage result = null;
            result = storageId != null ? new StorablePackage(this.mdrStorage, immediatePackage == null ? null : immediatePackage.getMofId(), ((BaseObjectHandler)metaObject)._getDelegate().getMofId(), context, datatypes, storageId) : new StorablePackage(this.mdrStorage, immediatePackage == null ? null : immediatePackage.getMofId(), ((BaseObjectHandler)metaObject)._getDelegate().getMofId(), context, datatypes);
            if (immediatePackage != null && !clustered) {
                immediatePackage.addPackage(metaObject.getName(), result.getMofId());
            }
            return result;
        }
        catch (StorageException e) {
            throw new DebugException("Storage exception: " + e.getMessage());
        }
    }

    private DatatypeDescriptor createDTDescriptor(String storageId, EnumerationType e) {
        ArrayList members = new ArrayList(e.getLabels());
        String ifcName = TagSupport.getTypeFullName((StorableObject)((BaseObjectHandler)e)._getDelegate());
        return new DatatypeDescriptor(this.mdrStorage, members, ifcName, storageId);
    }

    private DatatypeDescriptor createDTDescriptor(String storageId, StructureType struct) {
        ArrayList<String> members = new ArrayList<String>();
        ArrayList<Class> memberTypes = new ArrayList<Class>();
        Iterator it2 = struct.getContents().iterator();
        while (it2.hasNext()) {
            ModelElement me = (ModelElement)it2.next();
            if (!(me instanceof StructureField)) continue;
            members.add(me.getName());
            try {
                memberTypes.add(BaseObjectHandler.resolveInterface(TagSupport.getDataTypeName((StorableObject)((BaseObjectHandler)((StructureField)me).getType())._getDelegate())));
            }
            catch (ClassNotFoundException e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
        }
        String ifcName = TagSupport.getTypeFullName((StorableObject)((BaseObjectHandler)struct)._getDelegate());
        return new DatatypeDescriptor(this.mdrStorage, struct.getQualifiedName(), members, memberTypes, ifcName, storageId);
    }

    private StorableClass createClassProxyHandler(MofClass metaObject, StorablePackage immediatePackage, List localClassProxies) {
        boolean classDerived = false;
        boolean instanceDerived = false;
        boolean isDerived = false;
        try {
            ArrayList<StorableClass.AttributeDescriptor> attrDescs = new ArrayList<StorableClass.AttributeDescriptor>();
            ArrayList<StorableClass.AttributeDescriptor> clAttrDescs = new ArrayList<StorableClass.AttributeDescriptor>();
            HashMap<String, DatatypeDescriptor> datatypes = new HashMap<String, DatatypeDescriptor>();
            Iterator it = metaObject.getContents().iterator();
            while (it.hasNext()) {
                ModelElement element = (ModelElement)it.next();
                if (element instanceof Attribute) {
                    Attribute attr = (Attribute)element;
                    isDerived = attr.isDerived();
                    if (!isDerived) {
                        Class type;
                        try {
                            type = BaseObjectHandler.resolveInterface(TagSupport.getDataTypeName((StorableObject)((InstanceHandler)attr.getType())._getDelegate()));
                        }
                        catch (Exception e) {
                            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
                        }
                        StorableClass.AttributeDescriptor desc = new StorableClass.AttributeDescriptor(this.mdrStorage, ((BaseObjectHandler)attr)._getDelegate().getMofId(), attr.getName(), type, attr.getMultiplicity().getLower(), attr.getMultiplicity().getUpper(), attr.getMultiplicity().isUnique(), attr.getMultiplicity().isOrdered(), attr.isChangeable(), MdrStorage.getStorageIdFromMofId(immediatePackage.getMofId()));
                        if (ScopeKindEnum.INSTANCE_LEVEL.equals((Object)attr.getScope())) {
                            attrDescs.add(desc);
                        } else {
                            clAttrDescs.add(desc);
                        }
                    }
                } else if (element instanceof Operation) {
                    isDerived = true;
                } else {
                    if (element instanceof EnumerationType) {
                        ArrayList members = new ArrayList(((EnumerationType)element).getLabels());
                        String ifcName = TagSupport.getTypeFullName((StorableObject)((BaseObjectHandler)element)._getDelegate());
                        datatypes.put(element.getName(), new DatatypeDescriptor(this.mdrStorage, members, ifcName, MdrStorage.getStorageIdFromMofId(immediatePackage.getMofId())));
                    } else if (element instanceof StructureType) {
                        ArrayList<String> members = new ArrayList<String>();
                        ArrayList<Class> memberTypes = new ArrayList<Class>();
                        Iterator it2 = ((StructureType)element).getContents().iterator();
                        while (it2.hasNext()) {
                            ModelElement me = (ModelElement)it2.next();
                            if (!(me instanceof StructureField)) continue;
                            members.add(me.getName());
                            try {
                                memberTypes.add(BaseObjectHandler.resolveInterface(TagSupport.getDataTypeName((StorableObject)((BaseObjectHandler)((StructureField)me).getType())._getDelegate())));
                            }
                            catch (ClassNotFoundException e) {
                                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
                            }
                        }
                        String ifcName = TagSupport.getTypeFullName((StorableObject)((BaseObjectHandler)element)._getDelegate());
                        datatypes.put(element.getName(), new DatatypeDescriptor(this.mdrStorage, element.getQualifiedName(), members, memberTypes, ifcName, MdrStorage.getStorageIdFromMofId(immediatePackage.getMofId())));
                    }
                    isDerived = false;
                }
                if (!isDerived) continue;
                if (((Feature)element).getScope().equals((Object)ScopeKindEnum.CLASSIFIER_LEVEL)) {
                    classDerived = true;
                    continue;
                }
                instanceDerived = true;
            }
            String tagValue = TagSupport.getTagValue((StorableObject)((BaseObjectHandler)metaObject)._getDelegate(), TRANSIENT_TAG_ID, "");
            StorableClass storable = tagValue.equals(TAG_VALUE_TRUE) ? new TransientStorableClass(this.mdrStorage, immediatePackage.getMofId(), ((BaseObjectHandler)metaObject)._getDelegate().getMofId(), attrDescs, clAttrDescs, datatypes, classDerived, instanceDerived, metaObject.isSingleton(), metaObject.isAbstract()) : new StorableClass(this.mdrStorage, immediatePackage.getMofId(), ((BaseObjectHandler)metaObject)._getDelegate().getMofId(), attrDescs, clAttrDescs, datatypes, classDerived, instanceDerived, metaObject.isSingleton(), metaObject.isAbstract());
            immediatePackage.addClass(metaObject.getName(), storable.getMofId());
            this.classProxies.put(metaObject, storable);
            this.classProxiesMofIds.put(((BaseObjectHandler)metaObject)._getDelegate().getMofId(), storable.getMofId());
            localClassProxies.add(storable);
            return storable;
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    private StorableAssociation createAssociationHandler(Association metaObject, StorablePackage immediatePackage, String assocationEnd1, MOFID assocEnd1MofId, String assocationEnd2, MOFID assocEnd2MofId, Class type1, Class type2, int min1, int max1, int min2, int max2, boolean isOrdered1, boolean isOrdered2, boolean isUnique1, boolean isUnique2, boolean isAggr1, boolean isAggr2, boolean isIndexed1, boolean isIndexed2, Set localAssocProxies) {
        try {
            StorableAssociation result = new StorableAssociation(this.mdrStorage, immediatePackage.getMofId(), ((BaseObjectHandler)metaObject)._getDelegate().getMofId(), assocationEnd1, assocEnd1MofId, assocationEnd2, assocEnd2MofId, type1, type2, min1, max1, min2, max2, isOrdered1, isOrdered2, isUnique1, isUnique2, isAggr1, isAggr2, isIndexed1, isIndexed2);
            immediatePackage.addAssociation(metaObject.getName(), result.getMofId());
            this.associationProxies.put(((BaseObjectHandler)metaObject)._getDelegate().getMofId(), result.getMofId());
            localAssocProxies.add(result.getMofId());
            return result;
        }
        catch (StorageException e) {
            throw new DebugException("Storage exception: " + e);
        }
    }

    private StorableAssociation createTransientAssociationHandler(Association metaObject, StorablePackage immediatePackage, String assocationEnd1, MOFID assocEnd1MofId, String assocationEnd2, MOFID assocEnd2MofId, Class type1, Class type2, int min1, int max1, int min2, int max2, boolean isOrdered1, boolean isOrdered2, boolean isUnique1, boolean isUnique2, boolean isAggr1, boolean isAggr2, Set localAssocProxies) {
        try {
            TransientStorableAssociation result = new TransientStorableAssociation(this.mdrStorage, immediatePackage.getMofId(), ((BaseObjectHandler)metaObject)._getDelegate().getMofId(), assocationEnd1, assocEnd1MofId, assocationEnd2, assocEnd2MofId, type1, type2, min1, max1, min2, max2, isOrdered1, isOrdered2, isUnique1, isUnique2, isAggr1, isAggr2);
            immediatePackage.addAssociation(metaObject.getName(), result.getMofId());
            this.associationProxies.put(((BaseObjectHandler)metaObject)._getDelegate().getMofId(), result.getMofId());
            localAssocProxies.add(result.getMofId());
            return result;
        }
        catch (StorageException e) {
            throw new DebugException("Storage exception: " + e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void boot() {
        boolean fail = true;
        Logger.getDefault().log("Booting repository ...");
        this.mdrStorage.setBooting(true);
        this.beginTrans(true);
        try {
            try {
                this.installFakeMof();
                this.installPureMof();
                fail = false;
            }
            catch (Throwable e) {
                Logger.getDefault().notify(1, e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.mdrStorage.setBooting(false);
            this.endTrans(fail);
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.mdrStorage.setBooting(false);
            this.endTrans(fail);
            return;
        }
    }

    private void installFakeMof() {
        Logger.getDefault().log("Creating boot MOF metamodel ...");
        this.createBootMOF();
        if (this.getExtent(BOOT_MOF) == null) {
            throw new DebugException("Cannot create instance of BOOT_MOF: Fatal error during bootstrapping.");
        }
    }

    private void installPureMof() {
        Logger.getDefault().log("Installing pure MOF Metamodel ... ");
        try {
            Logger.getDefault().log("Parsing MOF model to DOM represtentation ....");
            ModelPackage modelPackage = (ModelPackage)this.createExtent(PURE_MOF, (RefObject)this.getBMModelPackage());
            Lookup lookup = Lookup.getDefault();
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("javax.jmi.xmi.XmiReader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            XmiReader xmiReader = (XmiReader)lookup.lookup((Class)clazz);
            xmiReader.read(MOF_XML_URL.toString(), (RefPackage)modelPackage);
            this.mdrStorage.rebuildMofContext();
        }
        catch (Exception e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException("Boot failed."), (Throwable)e);
        }
    }

    private MofPackage getBMModelPackage() {
        Iterator it = ((ModelPackage)this.getExtent(BOOT_MOF)).getMofPackage().refAllOfClass().iterator();
        while (it.hasNext()) {
            MofPackage result = (MofPackage)it.next();
            if (!result.getName().equals("Model")) continue;
            return result;
        }
        return null;
    }

    private void createBootMOF() {
        try {
            BootReader br = new BootReader(this.mdrStorage, BOOTMOF_XML_URL);
            br.read();
        }
        catch (Exception e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException("Unable to read MOF XMI: " + e.getMessage()), (Throwable)e);
        }
    }

    private static class FacilityCache
    extends HashMap {
        private final ReferenceQueue queue = new ReferenceQueue();
        private boolean cleaningUp = false;

        private FacilityCache() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void cleanUp() {
            this.cleaningUp = true;
            try {
                HandlerReference reference;
                while ((reference = (HandlerReference)this.queue.poll()) != null) {
                    MOFID mofId = reference.getProxyMofId();
                    Reference currentRef = (Reference)super.remove(mofId);
                    if (currentRef == null || currentRef == reference || currentRef.get() == null) continue;
                    super.put(mofId, currentRef);
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.cleaningUp = false;
                throw throwable;
            }
            {
                Object var4_6 = null;
                this.cleaningUp = false;
                return;
            }
        }

        public Object put(Object key, Object value) {
            this.cleanUp();
            HandlerReference result = super.put(key, new HandlerReference((BaseObjectHandler)value));
            return null;
        }

        public Object remove(Object key) {
            this.cleanUp();
            Object result = super.remove(key);
            return result == null ? null : ((HandlerReference)result).get();
        }

        public Object get(Object key) {
            this.cleanUp();
            Object result = super.get(key);
            return result == null ? null : ((HandlerReference)result).get();
        }

        private class HandlerReference
        extends WeakReference {
            private MOFID mofId;
            private RefBaseObject baseObject;

            public HandlerReference(BaseObjectHandler handler) {
                super(handler, FacilityCache.this.queue);
                this.mofId = handler._getMofId();
                this.baseObject = handler.refImmediatePackage() instanceof ModelPackage || !(handler instanceof RefObject) ? handler : null;
            }

            public MOFID getProxyMofId() {
                return this.mofId;
            }
        }
    }

    public static interface ShutdownListener {
        public void shutdown();

        public void stepFinished();
    }
}

