/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.parser;

import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.CubeFileProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.parser.CubeFileProviderReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.StringReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DefaultCubeFileProviderReadHandler
extends AbstractXmlReadHandler
implements CubeFileProviderReadHandler {
    private StringReadHandler pathReadHandler;
    private StringReadHandler connectionNameReadHandler;

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("cube-filename".equals(tagName)) {
            this.pathReadHandler = new StringReadHandler();
            return this.pathReadHandler;
        }
        if ("cube-connection-name".equals(tagName)) {
            this.connectionNameReadHandler = new StringReadHandler();
            return this.connectionNameReadHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        if (this.pathReadHandler == null) {
            throw new ParseException("Required element 'cube-filename' is not present.", this.getLocator());
        }
    }

    public Object getObject() throws SAXException {
        return this.getProvider();
    }

    protected String getPath() {
        if (this.pathReadHandler == null) {
            return null;
        }
        return this.pathReadHandler.getResult();
    }

    protected String getCubeConnectionName() {
        if (this.connectionNameReadHandler == null) {
            return null;
        }
        return this.connectionNameReadHandler.getResult();
    }

    @Override
    public CubeFileProvider getProvider() {
        CubeFileProvider fileProvider = (CubeFileProvider)ClassicEngineBoot.getInstance().getObjectFactory().get(CubeFileProvider.class);
        if (this.pathReadHandler != null) {
            fileProvider.setDesignTimeFile(this.pathReadHandler.getResult());
        }
        if (this.connectionNameReadHandler != null) {
            fileProvider.setCubeConnectionName(this.connectionNameReadHandler.getResult());
        }
        return fileProvider;
    }
}

