/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.sql.DataSource;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.MondrianConnectionProvider;

public class DefaultMondrianConnectionProvider
implements MondrianConnectionProvider {
    private static final Log logger = LogFactory.getLog(DefaultMondrianConnectionProvider.class);

    protected String computeConnectionString(Properties parameters) {
        StringBuffer connectionStr = new StringBuffer(100);
        connectionStr.append("provider=mondrian");
        connectionStr.append("; ");
        connectionStr.append("Catalog=");
        connectionStr.append(parameters.getProperty("Catalog"));
        Enumeration<Object> objectEnumeration = parameters.keys();
        while (objectEnumeration.hasMoreElements()) {
            String value;
            String key = (String)objectEnumeration.nextElement();
            if ("Catalog".equals(key) || (value = parameters.getProperty(key)) == null) continue;
            connectionStr.append("; ");
            connectionStr.append(key);
            connectionStr.append("=");
            connectionStr.append((Object)value);
        }
        return connectionStr.toString();
    }

    @Override
    public Connection createConnection(Properties properties, DataSource dataSource) throws ReportDataFactoryException {
        logger.debug((Object)("Creating Mondrian connection: " + Util.parseConnectString((String)this.computeConnectionString(properties))));
        return DriverManager.getConnection((Util.PropertyList)Util.parseConnectString((String)this.computeConnectionString(properties)), null, (DataSource)dataSource);
    }

    @Override
    public Object getConnectionHash(Properties properties) throws ReportDataFactoryException {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getClass().getName());
        list.add(properties.clone());
        return list;
    }
}

