/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.infobrightoutput;

import java.io.IOException;
import java.sql.SQLException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.infobrightoutput.InfobrightLoaderData;
import org.pentaho.di.trans.steps.infobrightoutput.InfobrightLoaderMeta;
import org.pentaho.di.trans.steps.infobrightoutput.KettleRecordPopulator;
import org.pentaho.di.trans.steps.infobrightoutput.WindowsJNILibraryUtil;

public class InfobrightLoader
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = InfobrightLoaderMeta.class;
    private final KettleRecordPopulator populator;
    private InfobrightLoaderMeta meta;
    private InfobrightLoaderData data;
    private boolean triedToClosePipe = false;

    public InfobrightLoader(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        WindowsJNILibraryUtil.fixJavaLibraryPath();
        this.populator = new KettleRecordPopulator();
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (InfobrightLoaderMeta)smi;
        this.data = (InfobrightLoaderData)sdi;
        Object[] row = this.getRow();
        if (row == null) {
            this.setOutputDone();
            this.closePipe();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
            this.data.insertRowMeta = this.getInputRowMeta().clone();
        }
        try {
            Object[] outputRowData = this.writeToLoader(row, this.data.insertRowMeta);
            if (outputRowData != null) {
                this.putRow(this.data.outputRowMeta, row);
                this.incrementLinesOutput();
            }
            if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                this.logBasic("linenr " + this.getLinesRead());
            }
        }
        catch (Exception e) {
            this.logError("Because of an error, this step can't continue: " + e.getMessage());
            this.logError(Const.getStackTracker((Throwable)e));
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            this.closePipe();
            return false;
        }
        return true;
    }

    protected void verifyDatabaseConnection() throws KettleException {
        if (this.meta.getDatabaseMeta() == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"InfobrightLoaderMeta.GetSQL.NoConnectionDefined", (String[])new String[0]));
        }
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        boolean res = false;
        this.meta = (InfobrightLoaderMeta)smi;
        this.data = (InfobrightLoaderData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.verifyDatabaseConnection();
                this.data.databaseSetup(this.meta, this);
                res = true;
            }
            catch (Exception ex) {
                this.logError("An error occurred intialising this step", ex);
                this.logError(Const.getStackTracker((Throwable)ex));
                this.stopAll();
                this.setErrors(1L);
                return false;
            }
        }
        return res;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.safeClosePipe();
        super.dispose(smi, sdi);
    }

    public void stopRunning(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.data.loader != null) {
            this.logDebug("Trying to kill the loader statement...");
            try {
                this.data.loader.killQuery();
                this.logDebug("Loader statement killed.");
            }
            catch (SQLException sqle) {
                this.logError(BaseMessages.getString(PKG, (String)"InfobrightLoader.Log.FailedToKillQuery", (String[])new String[0]) + " : " + sqle.toString());
                this.logError(Const.getStackTracker((Throwable)sqle));
            }
        }
    }

    private synchronized void closePipe() throws KettleException {
        try {
            if (this.data != null) {
                this.data.dispose();
            }
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        finally {
            this.triedToClosePipe = true;
        }
    }

    private synchronized void safeClosePipe() {
        if (!this.triedToClosePipe) {
            try {
                this.closePipe();
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"InfobrightLoader.Log.UnexpectedError", (String[])new String[0]) + " : " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
            }
            finally {
                this.triedToClosePipe = true;
            }
        }
    }

    private Object[] writeToLoader(Object[] row, RowMetaInterface rowMeta) throws KettleException {
        Object[] outputRowData = row;
        try {
            this.populator.populate(this.data.record, row, rowMeta);
            this.data.record.writeTo(this.data.loader.getOutputStream2());
        }
        catch (IOException ex) {
            throw new KettleException((Throwable)ex);
        }
        return outputRowData;
    }
}

