/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.truetype;

import java.io.IOException;
import org.pentaho.reporting.libraries.fonts.tools.FontStrictGeomUtility;
import org.pentaho.reporting.libraries.fonts.truetype.FontHeaderTable;
import org.pentaho.reporting.libraries.fonts.truetype.HorizontalHeaderTable;
import org.pentaho.reporting.libraries.fonts.truetype.OS2Table;
import org.pentaho.reporting.libraries.fonts.truetype.PostscriptInformationTable;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFont;

public class ScalableTrueTypeFontMetrics {
    private TrueTypeFont font;
    private long ascent;
    private long descent;
    private long leading;
    private long xHeight;
    private long strikethroughPosition;
    private long maxAscent;
    private long maxDescent;
    private long underlinePosition;
    private long italicAngle;
    private long maxCharAdvance;

    public ScalableTrueTypeFontMetrics(TrueTypeFont font) throws IOException {
        PostscriptInformationTable postTable;
        if (font == null) {
            throw new NullPointerException("The font must not be null");
        }
        this.font = font;
        FontHeaderTable head = (FontHeaderTable)font.getTable(1751474532L);
        if (head == null) {
            throw new IllegalStateException("Font has no HEAD table and is not a usable font.");
        }
        int unitsPerEm = head.getUnitsPerEm();
        long strictScaleFactor = FontStrictGeomUtility.toInternalValue(1.0);
        this.maxAscent = strictScaleFactor * (long)head.getyMax() / (long)unitsPerEm;
        this.maxDescent = strictScaleFactor * (long)(-head.getyMin()) / (long)unitsPerEm;
        HorizontalHeaderTable hhea = (HorizontalHeaderTable)font.getTable(1751672161L);
        if (hhea == null) {
            throw new IllegalStateException("The font has no HHEA table and is not a valid font.");
        }
        this.createMacMetrics(hhea, unitsPerEm, strictScaleFactor);
        OS2Table table = (OS2Table)font.getTable(1330851634L);
        if (table != null) {
            this.computeWindowsMetrics(table, unitsPerEm, strictScaleFactor);
        }
        if ((postTable = (PostscriptInformationTable)font.getTable(1886352244L)) != null) {
            this.italicAngle = FontStrictGeomUtility.toInternalValue(postTable.getItalicAngle());
            this.underlinePosition = this.getAscent() + strictScaleFactor * (long)(-postTable.getUnderlinePosition() + postTable.getUnderlineThickness() / 2) / (long)unitsPerEm;
        }
        font.dispose();
    }

    private void createMacMetrics(HorizontalHeaderTable hhea, int unitsPerEm, long scaleFactor) {
        this.maxCharAdvance = scaleFactor * (long)hhea.getMaxAdvanceWidth() / (long)unitsPerEm;
        this.ascent = scaleFactor * (long)hhea.getAscender() / (long)unitsPerEm;
        this.descent = scaleFactor * (long)(-hhea.getDescender()) / (long)unitsPerEm;
        this.leading = scaleFactor * (long)hhea.getLineGap() / (long)unitsPerEm;
        this.xHeight = (long)((double)this.ascent * 0.5 / 0.7);
        this.strikethroughPosition = this.getMaxAscent() - (long)((double)this.xHeight * 0.5);
        this.italicAngle = FontStrictGeomUtility.toInternalValue(-StrictMath.atan2(hhea.getCaretSlopeRun(), hhea.getCaretSlopeRise()) * 180.0 / Math.PI);
    }

    private void computeWindowsMetrics(OS2Table table, int unitsPerEm, long scaleFactor) {
        short strikethroughPosition;
        short xHeightRaw = table.getxHeight();
        if (xHeightRaw != 0) {
            this.xHeight = scaleFactor * (long)xHeightRaw / (long)unitsPerEm;
        }
        if ((strikethroughPosition = table.getyStrikeoutPosition()) != 0) {
            this.strikethroughPosition = this.getMaxAscent() - scaleFactor * (long)strikethroughPosition / (long)unitsPerEm;
        }
    }

    public long getAscent() {
        return this.ascent;
    }

    public long getDescent() {
        return this.descent;
    }

    public long getLeading() {
        return this.leading;
    }

    public long getXHeight() {
        return this.xHeight;
    }

    public long getUnderlinePosition() {
        return this.underlinePosition;
    }

    public long getStrikeThroughPosition() {
        return this.strikethroughPosition;
    }

    public TrueTypeFont getFont() {
        return this.font;
    }

    public long getItalicAngle() {
        return this.italicAngle;
    }

    public long getMaxAscent() {
        return this.maxAscent;
    }

    public long getMaxDescent() {
        return this.maxDescent;
    }

    public long getMaxCharAdvance() {
        return this.maxCharAdvance;
    }
}

