/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.model.catalog;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.metaverse.api.analyzer.kettle.KettleAnalyzerUtil;
import org.pentaho.metaverse.api.model.catalog.FieldLevelRelationship;

public class LineageDataResource {
    private final Pattern hdfsPathPattern = Pattern.compile("/?(\\w+\\:.+\\@)?([\\w\\.]+)(\\:(\\d+))?(/.*)");
    private final Pattern s3PvfsPathPattern = Pattern.compile("/(\\w+)/(.*)");
    private final String name;
    private String path;
    private List<String> fields;
    private final List<FieldLevelRelationship> fieldRelationships = new ArrayList<FieldLevelRelationship>();
    private String catalogResourceID;
    private Object vertexId;
    private String dbSchema;
    private String dbHost;
    private String dbName;
    private String dbPort;
    private String hdfsHost;
    private String hdfsPort;
    private String s3Bucket;

    public LineageDataResource(String name) {
        this.name = name;
        this.path = "";
        this.catalogResourceID = "";
        this.vertexId = null;
        this.dbSchema = "";
        this.dbHost = "";
        this.dbName = "";
        this.dbPort = "";
        this.hdfsHost = "";
        this.hdfsPort = "";
    }

    public String getName() {
        return this.name;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<FieldLevelRelationship> getFieldLevelRelationships() {
        return this.fieldRelationships;
    }

    public void addFieldLevelRelationship(FieldLevelRelationship fieldRelationship) {
        this.fieldRelationships.add(fieldRelationship);
    }

    public void setCatalogResourceID(String catalogResourceID) {
        this.catalogResourceID = catalogResourceID;
    }

    public String getCatalogResourceID() {
        return this.catalogResourceID;
    }

    public Object getVertexId() {
        return this.vertexId;
    }

    public void setVertexId(Object vertexId) {
        this.vertexId = vertexId;
    }

    public String getDbSchema() {
        return this.dbSchema;
    }

    public void setDbSchema(String dbSchema) {
        this.dbSchema = dbSchema;
    }

    public String getDbHost() {
        return this.dbHost;
    }

    public void setDbHost(String dbHost) {
        this.dbHost = dbHost;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDbPort() {
        return this.dbPort;
    }

    public void setDbPort(String dbPort) {
        this.dbPort = dbPort;
    }

    public String getHdfsPort() {
        return this.hdfsPort;
    }

    public void setHdfsPort(String hdfsPort) {
        this.hdfsPort = hdfsPort;
    }

    public String getHdfsHost() {
        return this.hdfsHost;
    }

    public void setHdfsHost(String hdfsHost) {
        this.hdfsHost = hdfsHost;
    }

    public void parseHdfsPath(String path) {
        Matcher m = this.hdfsPathPattern.matcher(path);
        if (m.matches()) {
            String host = m.group(2);
            String port = m.group(4);
            String filePath = m.group(5);
            this.setHdfsPort(null == port ? "" : port);
            this.setHdfsHost(null == host ? "" : host);
            this.setPath(null == filePath ? "" : filePath);
        }
    }

    public void parseS3PvfsPath(String path) {
        Matcher m = this.s3PvfsPathPattern.matcher(path);
        if (m.matches()) {
            String bucket = m.group(1);
            String key = m.group(2);
            this.setS3Bucket(null == bucket ? "" : bucket);
            this.setPath(null == key ? "" : key);
        }
    }

    public String getHdfsDataSourceUri() {
        return "hdfs://".concat(this.getHdfsHost()).concat(":").concat(this.getHdfsPort());
    }

    public boolean isHdfsResource() {
        return null != this.getHdfsHost() && !this.getHdfsHost().isEmpty();
    }

    public boolean isS3Resource() {
        return null != this.getS3Bucket() && !this.getS3Bucket().isEmpty();
    }

    public String toString() {
        return "name: ".concat(this.name).concat(" path: ").concat(this.path).concat(" catalogResourceId: ").concat(this.catalogResourceID).concat(" dbHost: ").concat(this.dbHost).concat(" dbPort: ").concat(this.dbPort).concat(" dbSchema: ").concat(this.dbSchema).concat(" hdfsHost: ").concat(this.hdfsHost).concat(" hdfsPort: ").concat(this.hdfsPort);
    }

    public boolean equals(Object o) {
        if (o instanceof LineageDataResource) {
            LineageDataResource r2 = (LineageDataResource)o;
            return this.shallowEquals(r2) && KettleAnalyzerUtil.safeListMatch(this.getFieldLevelRelationships(), r2.getFieldLevelRelationships());
        }
        return false;
    }

    public boolean shallowEquals(LineageDataResource r2) {
        return KettleAnalyzerUtil.safeStringMatch(this.getName(), r2.getName()) && KettleAnalyzerUtil.safeStringMatch(this.getPath(), r2.getPath()) && KettleAnalyzerUtil.safeStringMatch(this.getDbSchema(), r2.getDbSchema()) && KettleAnalyzerUtil.safeStringMatch(this.getDbHost(), r2.getDbHost()) && KettleAnalyzerUtil.safeStringMatch(this.getDbPort(), r2.getDbPort()) && KettleAnalyzerUtil.safeStringMatch(this.getDbName(), r2.getDbName()) && KettleAnalyzerUtil.safeStringMatch(this.getHdfsHost(), r2.getHdfsHost()) && KettleAnalyzerUtil.safeStringMatch(this.getHdfsPort(), r2.getHdfsPort()) && KettleAnalyzerUtil.safeStringMatch(this.getS3Bucket(), r2.getS3Bucket()) && KettleAnalyzerUtil.safeListMatch(this.getFields(), r2.getFields()) && KettleAnalyzerUtil.safeStringMatch(this.getCatalogResourceID(), r2.getCatalogResourceID()) && (null != this.vertexId && this.vertexId.equals(r2.getVertexId()) || null == this.getVertexId() && null == r2.getVertexId());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.path, this.fields, this.fieldRelationships, this.catalogResourceID, this.vertexId, this.dbSchema, this.dbName, this.dbHost, this.dbPort, this.hdfsHost, this.hdfsPort, this.s3Bucket);
    }

    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public void setS3Bucket(String s3Bucket) {
        this.s3Bucket = s3Bucket;
    }
}

