/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.model.catalog;

import java.util.Objects;
import org.pentaho.metaverse.api.analyzer.kettle.KettleAnalyzerUtil;
import org.pentaho.metaverse.api.model.catalog.LineageDataResource;

public class FieldLevelRelationship {
    private LineageDataResource inputSourceResource;
    private String inputSourceResourceField;
    private LineageDataResource outputTargetResource;
    private String outputTargetResourceField;

    public FieldLevelRelationship() {
        this.inputSourceResourceField = null;
        this.inputSourceResource = null;
        this.outputTargetResourceField = null;
        this.outputTargetResource = null;
    }

    public FieldLevelRelationship(LineageDataResource inputSourceResource, LineageDataResource outputTargetResource, String inputSourceResourceField, String outputTargetResourceField) {
        this.inputSourceResource = inputSourceResource;
        this.outputTargetResource = outputTargetResource;
        this.inputSourceResourceField = inputSourceResourceField;
        this.outputTargetResourceField = outputTargetResourceField;
    }

    public LineageDataResource getInputSourceResource() {
        return this.inputSourceResource;
    }

    public void setInputSourceResource(LineageDataResource inputSourceResource) {
        this.inputSourceResource = inputSourceResource;
    }

    public String getInputSourceResourceField() {
        return this.inputSourceResourceField;
    }

    public void setInputSourceResourceField(String inputSourceResourceField) {
        this.inputSourceResourceField = inputSourceResourceField;
    }

    public LineageDataResource getOutputTargetResource() {
        return this.outputTargetResource;
    }

    public void setOutputTargetResource(LineageDataResource outputTargetResource) {
        this.outputTargetResource = outputTargetResource;
    }

    public String getOutputTargetResourceField() {
        return this.outputTargetResourceField;
    }

    public void setOutputTargetResourceField(String outputTargetResourceField) {
        this.outputTargetResourceField = outputTargetResourceField;
    }

    public String toString() {
        return this.inputSourceResource.getName() + ":" + this.inputSourceResourceField + " -> " + this.outputTargetResource.getName() + ":" + this.outputTargetResourceField;
    }

    public boolean equals(Object o) {
        if (o instanceof FieldLevelRelationship) {
            FieldLevelRelationship r2 = (FieldLevelRelationship)o;
            return this.inputSourceResource.shallowEquals(r2.getInputSourceResource()) && this.outputTargetResource.shallowEquals(r2.getOutputTargetResource()) && KettleAnalyzerUtil.safeStringMatch(this.inputSourceResourceField, r2.getInputSourceResourceField()) && KettleAnalyzerUtil.safeStringMatch(this.outputTargetResourceField, r2.getOutputTargetResourceField());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.inputSourceResource, this.inputSourceResourceField, this.outputTargetResource, this.outputTargetResourceField);
    }
}

