/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.model;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.GraphFactory;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.util.wrappers.id.IdGraph;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.configuration.Configuration;
import org.pentaho.metaverse.api.messages.Messages;
import org.pentaho.metaverse.api.model.BaseSynchronizedGraph;

public class BaseSynchronizedGraphFactory {
    private static final Map<String, String> configMap = new HashMap<String, String>();

    protected BaseSynchronizedGraphFactory() {
        throw new UnsupportedOperationException();
    }

    public static Graph getDefaultGraph() {
        return BaseSynchronizedGraphFactory.open(configMap);
    }

    public static Graph open(Configuration configuration) {
        Graph graph = GraphFactory.open((Configuration)configuration);
        return BaseSynchronizedGraphFactory.wrapGraph(graph);
    }

    public static Graph open(Map<String, String> configuration) {
        Graph graph = GraphFactory.open(configuration);
        return BaseSynchronizedGraphFactory.wrapGraph(graph);
    }

    public static Graph open(String configurationFile) {
        Graph graph = GraphFactory.open((String)configurationFile);
        return BaseSynchronizedGraphFactory.wrapGraph(graph);
    }

    public static Graph open(ResourceBundle configBundle) {
        HashMap<String, String> graphProps = new HashMap<String, String>();
        Enumeration<String> keys = configBundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String value = configBundle.getString(key);
            graphProps.put(key, value);
        }
        return BaseSynchronizedGraphFactory.open(graphProps);
    }

    public static Graph wrapGraph(Graph graph) {
        if (graph instanceof KeyIndexableGraph) {
            KeyIndexableGraph keyIndexableGraph = (KeyIndexableGraph)graph;
            IdGraph idGraph = new IdGraph(keyIndexableGraph);
            return new BaseSynchronizedGraph((IdGraph<KeyIndexableGraph>)idGraph);
        }
        throw new IllegalArgumentException(Messages.getString("ERROR.BackingGraph.MustImplement.KeyIndexableGraph"));
    }

    static {
        configMap.put("blueprints.graph", "com.tinkerpop.blueprints.impls.tg.TinkerGraph");
    }
}

