/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.analyzer.kettle;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.metaverse.api.IMetaverseConfig;
import org.pentaho.metaverse.api.analyzer.kettle.KettleAnalyzerUtil;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalResourceCache {
    private static final Logger log = LoggerFactory.getLogger(ExternalResourceCache.class);
    protected static final long DEFAULT_TIMEOUT_SECONDS = 21600L;
    protected Cache<String, ExternalResourceValues> resourceCache;
    private static ExternalResourceCache INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExternalResourceCache getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ExternalResourceCache> clazz = ExternalResourceCache.class;
        synchronized (ExternalResourceCache.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ExternalResourceCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private ExternalResourceCache() {
        this((IMetaverseConfig)PentahoSystem.get(IMetaverseConfig.class));
    }

    protected ExternalResourceCache(IMetaverseConfig config) {
        long cacheExpireTime = this.getCacheExpireTime(config);
        this.initCache(cacheExpireTime, TimeUnit.SECONDS);
    }

    protected long getCacheExpireTime(IMetaverseConfig config) {
        String expireTime = config != null ? config.getExternalResourceCacheExpireTime() : null;
        return expireTime != null ? Long.parseLong(expireTime) : 21600L;
    }

    void initCache(long time, TimeUnit timeUnit) {
        this.resourceCache = CacheBuilder.newBuilder().expireAfterAccess(time, timeUnit).build();
        log.debug("{} cache expire time set to {} {}", new Object[]{this.getClass().getSimpleName(), time, timeUnit});
    }

    protected String getUniqueId(StepMeta meta) {
        if (meta == null || meta.getParentTransMeta() == null) {
            return null;
        }
        TransMeta transMeta = meta.getParentTransMeta();
        if (transMeta.getRepository() == null) {
            String transName = transMeta.getFilename() == null ? transMeta.getName() : transMeta.getFilename();
            return KettleAnalyzerUtil.normalizeFilePathSafely(transName) + "::" + meta.getName();
        }
        return transMeta.getPathAndName() + "." + transMeta.getDefaultExtension() + "::" + meta.getName();
    }

    public void removeCachedResources(Trans trans) {
        TransMeta transMeta = trans.getTransMeta();
        List steps = transMeta.getSteps();
        for (StepMeta step : steps) {
            String uniqueMetaId = this.getUniqueId(step);
            this.resourceCache.invalidate((Object)uniqueMetaId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resources<IExternalResourceInfo> get(BaseStepMeta meta) {
        if (meta == null) {
            return null;
        }
        String uniqueMetaId = this.getUniqueId(meta.getParentStepMeta());
        ExternalResourceCache externalResourceCache = this;
        synchronized (externalResourceCache) {
            return (Resources)this.resourceCache.getIfPresent((Object)uniqueMetaId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cache(BaseStepMeta meta, ExternalResourceValues resources) {
        String uniqueMetaId = this.getUniqueId(meta.getParentStepMeta());
        ExternalResourceCache externalResourceCache = this;
        synchronized (externalResourceCache) {
            this.resourceCache.put((Object)uniqueMetaId, (Object)resources);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.resourceCache != null) {
            for (Map.Entry entry : this.resourceCache.asMap().entrySet()) {
                sb.append(" ---- " + (String)entry.getKey() + ": " + ((ExternalResourceValues)entry.getValue()).size() + "\n");
                sb.append(((ExternalResourceValues)entry.getValue()).toString());
            }
        }
        log.debug("\n {}", (Object)sb);
        return sb.toString();
    }

    public ExternalResourceValues newExternalResourceValues() {
        return new ExternalResourceValues();
    }

    public abstract class Resources<V> {
        protected Set<V> internal = new ConcurrentHashSet();

        public void add(V value) {
            this.internal.add(value);
        }

        public boolean remove(V value) {
            return this.internal.remove(value);
        }

        public int size() {
            return this.internal.size();
        }

        public boolean contains(V value) {
            return this.internal.contains(value);
        }

        public Set<V> getInternal() {
            return new HashSet<V>(this.internal);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (V value : this.internal) {
                sb.append(" ............ ").append(value.getClass().getSimpleName()).append(" ").append(value.hashCode()).append("\n");
            }
            return sb.toString();
        }
    }

    public class ExternalResourceValues
    extends Resources<IExternalResourceInfo> {
        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (IExternalResourceInfo resource : this.internal) {
                sb.append(" ............ ").append(resource.getClass().getSimpleName()).append(" ").append(resource.getName()).append(" (").append(resource.hashCode()).append(") \n");
            }
            return sb.toString();
        }
    }
}

