/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.StringEscapeUtils;
import org.pentaho.metaverse.api.IHasProperties;
import org.pentaho.metaverse.api.ILogicalIdGenerator;

public class MetaverseLogicalIdGenerator
implements ILogicalIdGenerator {
    protected SortedSet<String> logicalIdPropertyKeys;
    protected static final String DEFUALT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    protected DateFormat dateFormat;
    protected static final String LEFT_BRACE = "{";
    protected static final String RIGHT_BRACE = "}";
    protected static final String EQUALS = ":";
    protected static final String QUOTE = "\"";

    public MetaverseLogicalIdGenerator(String ... logicalIdPropertyKeys) {
        this.setLogicalIdPropertyKeys(logicalIdPropertyKeys);
        this.setDateFormat(new SimpleDateFormat(DEFUALT_DATE_FORMAT));
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    public void setLogicalIdPropertyKeys(String ... keys) {
        if (this.logicalIdPropertyKeys == null) {
            this.logicalIdPropertyKeys = new TreeSet<String>();
        } else {
            this.logicalIdPropertyKeys.clear();
        }
        this.logicalIdPropertyKeys.addAll(Arrays.asList(keys));
    }

    @Override
    public Set<String> getLogicalIdPropertyKeys() {
        return this.logicalIdPropertyKeys;
    }

    @Override
    public String generateId(IHasProperties propertiesNode) {
        Set<String> propertyKeys = this.getLogicalIdPropertyKeys();
        if (propertiesNode.getPropertyKeys().size() == 0) {
            return null;
        }
        String logicalId = null;
        if (propertyKeys != null && propertyKeys.size() > 0) {
            StringBuilder sb = new StringBuilder();
            if (propertyKeys.size() > 0) {
                sb.append(LEFT_BRACE);
                int i = 0;
                for (String key : propertyKeys) {
                    if (i++ > 0) {
                        sb.append(',');
                    }
                    sb.append(QUOTE).append(key).append(QUOTE).append(EQUALS);
                    Object prop = propertiesNode.getProperty(key);
                    if (prop != null) {
                        if (prop instanceof Date) {
                            DateFormat df = this.getDateFormat();
                            sb.append(QUOTE).append(df.format(prop)).append(QUOTE);
                            continue;
                        }
                        String value = prop.toString();
                        if (value.startsWith(LEFT_BRACE) && value.endsWith(RIGHT_BRACE)) {
                            sb.append(value);
                            continue;
                        }
                        String escaped = StringEscapeUtils.escapeJavaScript((String)value);
                        sb.append(QUOTE).append(escaped).append(QUOTE);
                        continue;
                    }
                    sb.append(QUOTE).append(QUOTE);
                }
                sb.append(RIGHT_BRACE);
            }
            logicalId = sb.toString();
            propertiesNode.setProperty("logicalId", logicalId);
        }
        return logicalId;
    }
}

