/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api;

import org.pentaho.metaverse.api.AnalysisContext;
import org.pentaho.metaverse.api.IAnalysisContext;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.ILogicalIdGenerator;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.INamespace;
import org.pentaho.metaverse.api.Namespace;

public class MetaverseComponentDescriptor
implements IComponentDescriptor {
    private String name;
    private String type;
    private INamespace namespace;
    private IAnalysisContext context;

    public MetaverseComponentDescriptor(String name, String type, INamespace namespace) {
        this.name = name;
        this.type = type;
        this.namespace = namespace;
        this.context = new AnalysisContext("static", null);
    }

    public MetaverseComponentDescriptor(String name, String type, INamespace namespace, IAnalysisContext context) {
        this.name = name;
        this.type = type;
        this.namespace = namespace;
        this.context = context;
    }

    public MetaverseComponentDescriptor(String name, String type, IMetaverseNode parentNode) {
        this(name, type, parentNode, (IAnalysisContext)new AnalysisContext("static"));
    }

    public MetaverseComponentDescriptor(String name, String type, IMetaverseNode parentNode, IAnalysisContext context) {
        this.name = name;
        this.type = type;
        if (parentNode != null) {
            this.namespace = new Namespace(parentNode.getLogicalId());
        }
        this.context = context;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getStringID() {
        return this.getNamespaceId();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getLogicalId() {
        return this.getNamespaceId();
    }

    @Override
    public void setLogicalIdGenerator(ILogicalIdGenerator idGenerator) {
    }

    @Override
    public String getNamespaceId() {
        return this.namespace == null ? null : this.namespace.getNamespaceId();
    }

    @Override
    public INamespace getParentNamespace() {
        return this.namespace.getParentNamespace();
    }

    @Override
    public INamespace getSiblingNamespace(String name, String type) {
        return this.namespace.getSiblingNamespace(name, type);
    }

    @Override
    public void setNamespace(INamespace namespace) {
        this.namespace = namespace;
    }

    @Override
    public INamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public IAnalysisContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(IAnalysisContext context) {
        this.context = context;
    }
}

