/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;

public class LoaderUtils {
    private LoaderUtils() {
    }

    public static String stripLeadingSlashes(String s) {
        int leadingSlashes;
        for (leadingSlashes = 0; s.length() > leadingSlashes && s.charAt(leadingSlashes) == '/'; ++leadingSlashes) {
        }
        if (leadingSlashes == 0) {
            return s;
        }
        return s.substring(leadingSlashes);
    }

    public static String mergePaths(String parent, String child) throws ResourceKeyCreationException {
        String parentPrefix;
        String parentResource;
        int childPrefix = child.indexOf("://");
        if (childPrefix > 0) {
            return child;
        }
        int parentPrefixPos = parent.indexOf("://");
        if (parentPrefixPos > 0) {
            parentResource = parent.substring(parentPrefixPos + 3);
            parentPrefix = parent.substring(0, parentPrefixPos + 3);
        } else {
            parentResource = parent;
            parentPrefix = "";
        }
        List<String> parentList = parentResource.length() > 0 && parentResource.charAt(parentResource.length() - 1) == '/' ? LoaderUtils.parseName(parentResource, false) : LoaderUtils.parseName(parentResource, true);
        parentList.addAll(LoaderUtils.parseName(child, false));
        ArrayList<String> normalizedList = new ArrayList<String>();
        for (int i = 0; i < parentList.size(); ++i) {
            String o = parentList.get(i);
            if (".".equals(o)) continue;
            if ("..".equals(o)) {
                if (normalizedList.isEmpty()) continue;
                normalizedList.remove(normalizedList.size() - 1);
                continue;
            }
            normalizedList.add(o);
        }
        if (normalizedList.isEmpty()) {
            throw new ResourceKeyCreationException("Unable to build a valid key.");
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(parentPrefix);
        for (int i = 0; i < normalizedList.size(); ++i) {
            String s = (String)normalizedList.get(i);
            if (i > 0) {
                buffer.append('/');
            }
            buffer.append(s);
        }
        return buffer.toString();
    }

    private static List<String> parseName(String name, boolean skipLast) {
        StringTokenizer strTok = new StringTokenizer(name, "/");
        int count = strTok.countTokens();
        ArrayList<String> list = new ArrayList<String>(count);
        while (strTok.hasMoreElements()) {
            String s = (String)strTok.nextElement();
            if (s.length() == 0) continue;
            list.add(s);
        }
        if (skipLast && !list.isEmpty()) {
            list.remove(list.size() - 1);
        }
        return list;
    }

    public static String getFileName(String file) {
        int last = file.lastIndexOf(47);
        if (last < 0) {
            return file;
        }
        return file.substring(last + 1);
    }
}

