/*
 * Decompiled with CFR 0.152.
 */
package com.totvscrm.pentaho.step.rollbacklog;

import com.totvscrm.pentaho.step.rollbacklog.RollbacklogStep;
import com.totvscrm.pentaho.step.rollbacklog.RollbacklogStepData;
import com.totvscrm.pentaho.step.rollbacklog.RollbacklogStepDialog;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.selectvalues.SelectValuesMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="RollbackLogStep", image="rollbacklog.png", i18nPackageName="com.totvscrm.pentaho.step.rollbacklog", name="RollbackLogStep.Name", description="RollbackLogStep.TooltipDesc", categoryDescription="RollbackLog.CategoryName", documentationUrl="http://cms.wsintegracoes.webnode.com/rollbacklog/", casesUrl="http://cms.wsintegracoes.webnode.com/rollbacklog/", forumUrl="http://cms.wsintegracoes.webnode.com/rollbacklog/")
public class RollbacklogStepMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = RollbacklogStepMeta.class;
    protected LogChannelInterface log;
    public static final int UNDEFINED = -2;
    private String loglevel;
    private boolean isotherkey;
    private String otherkey;
    private String selectItems;
    private String[] fieldStream;
    @InjectionDeep
    private SelectValuesMeta.SelectField[] selectFields = new SelectValuesMeta.SelectField[0];
    public static String[] logLevelCodes = new String[]{"log_level_nothing", "log_level_error", "log_level_minimal", "log_level_basic", "log_level_detailed", "log_level_debug", "log_level_rowlevel"};

    public RollbacklogStepMeta() {
        this.log = KettleLogStore.getLogChannelInterfaceFactory().create((Object)this);
        this.fieldStream = new String[0];
    }

    public StepDialogInterface getDialog(Shell shell, StepMetaInterface meta, TransMeta transMeta, String name) {
        return new RollbacklogStepDialog(shell, meta, transMeta, name);
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans disp) {
        return new RollbacklogStep(stepMeta, stepDataInterface, cnr, transMeta, disp);
    }

    public StepDataInterface getStepData() {
        return new RollbacklogStepData();
    }

    public void setDefault() {
        this.loglevel = logLevelCodes[3];
        this.isotherkey = false;
        this.otherkey = "codigoerp";
        this.selectItems = "codigoerp";
        this.allocateSelect(0);
    }

    public void allocate(int nrRows) {
        this.fieldStream = new String[nrRows];
    }

    public void allocateSelect(int nrFields) {
        this.selectFields = new SelectValuesMeta.SelectField[nrFields];
        for (int i = 0; i < nrFields; ++i) {
            this.selectFields[i] = new SelectValuesMeta.SelectField();
        }
    }

    public boolean isOtherkey() {
        return this.isotherkey;
    }

    public void setIsotherkey(boolean isotherkey) {
        this.isotherkey = isotherkey;
    }

    public String getOtherkey() {
        return this.otherkey;
    }

    public void setOtherkey(String otherkey) {
        this.otherkey = otherkey;
    }

    public int getLogLevel() {
        return Arrays.asList(logLevelCodes).indexOf(this.loglevel);
    }

    public void setLogLevel(int i) {
        this.loglevel = logLevelCodes[i];
    }

    public String getLoglevel() {
        return this.loglevel;
    }

    public void setLoglevel(String loglevel) {
        this.loglevel = loglevel;
    }

    public String[] getFieldStream() {
        return this.fieldStream;
    }

    public void setFieldStream(String[] fieldStream) {
        this.fieldStream = fieldStream;
    }

    public LogLevel getLogLevelByDesc() {
        if (this.loglevel == null) {
            return LogLevel.BASIC;
        }
        LogLevel retval = this.loglevel.equals(logLevelCodes[0]) ? LogLevel.NOTHING : (this.loglevel.equals(logLevelCodes[1]) ? LogLevel.ERROR : (this.loglevel.equals(logLevelCodes[2]) ? LogLevel.MINIMAL : (this.loglevel.equals(logLevelCodes[3]) ? LogLevel.BASIC : (this.loglevel.equals(logLevelCodes[4]) ? LogLevel.DETAILED : (this.loglevel.equals(logLevelCodes[5]) ? LogLevel.DEBUG : LogLevel.ROWLEVEL)))));
        return retval;
    }

    public String getSelectItems() {
        return this.selectItems;
    }

    public void setSelectItems(String selectItems) {
        this.selectItems = selectItems;
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public SelectValuesMeta.SelectField[] getSelectFields() {
        return this.selectFields;
    }

    public void setSelectFields(SelectValuesMeta.SelectField[] selectFields) {
        this.selectFields = selectFields == null ? new SelectValuesMeta.SelectField[]{} : selectFields;
    }

    public void setSelectName(String[] selectName) {
        this.resizeSelectFields(selectName.length);
        for (int i = 0; i < this.selectFields.length; ++i) {
            this.selectFields[i].setName(selectName[i]);
        }
    }

    public String[] getSelectName() {
        String[] selectName = new String[this.selectFields.length];
        for (int i = 0; i < selectName.length; ++i) {
            selectName[i] = this.selectFields[i].getName();
        }
        return selectName;
    }

    private void resizeSelectFields(int length) {
        int fillStartIndex = this.selectFields.length;
        this.selectFields = Arrays.copyOf(this.selectFields, length);
        for (int i = fillStartIndex; i < this.selectFields.length; ++i) {
            this.selectFields[i] = new SelectValuesMeta.SelectField();
            this.selectFields[i].setLength(-2);
            this.selectFields[i].setPrecision(-2);
        }
    }

    public Object clone() {
        RollbacklogStepMeta retval = (RollbacklogStepMeta)((Object)super.clone());
        int nrRows = this.fieldStream.length;
        retval.allocate(nrRows);
        System.arraycopy(this.fieldStream, 0, retval.fieldStream, 0, nrRows);
        int nrfields = this.selectFields == null ? 0 : this.selectFields.length;
        retval.allocateSelect(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.getSelectFields()[i] = this.selectFields[i].clone();
        }
        return retval;
    }

    public String getXML() throws KettleValueException {
        StringBuilder xml = new StringBuilder(500);
        xml.append(XMLHandler.addTagValue((String)"loglevel", (String)this.loglevel));
        xml.append(XMLHandler.addTagValue((String)"otherkey", (String)this.otherkey));
        xml.append(XMLHandler.addTagValue((String)"isotherkey", (boolean)this.isotherkey));
        xml.append(XMLHandler.addTagValue((String)"selectItems", (String)this.selectItems));
        xml.append("<fields>");
        for (int i = 0; i < this.selectFields.length; ++i) {
            xml.append("<field>");
            xml.append(XMLHandler.addTagValue((String)"selectFields", (String)this.selectFields[i].getName()));
            xml.append("</field>");
        }
        xml.append("</fields>");
        return xml.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        try {
            this.setLoglevel(XMLHandler.getNodeValue((Node)XMLHandler.getSubNode((Node)stepnode, (String)"loglevel")));
            this.setOtherkey(XMLHandler.getNodeValue((Node)XMLHandler.getSubNode((Node)stepnode, (String)"otherkey")));
            String isOtherKey = XMLHandler.getNodeValue((Node)XMLHandler.getSubNode((Node)stepnode, (String)"isotherkey"));
            if ("N".equals(isOtherKey)) {
                this.setIsotherkey(false);
            } else {
                this.setIsotherkey(true);
            }
            this.setSelectItems(XMLHandler.getNodeValue((Node)XMLHandler.getSubNode((Node)stepnode, (String)"selectItems")));
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocateSelect(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node line = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.selectFields[i].setName(XMLHandler.getTagValue((Node)line, (String)"selectFields"));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Plug-in RollbackLog foi incapaz de ler informa\u00e7\u00f5es dos steps do XML", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "loglevel", this.loglevel);
            rep.saveStepAttribute(id_transformation, id_step, "otherkey", this.otherkey);
            rep.saveStepAttribute(id_transformation, id_step, "isotherkey", this.isotherkey);
            rep.saveStepAttribute(id_transformation, id_step, "selectItems", this.selectItems);
            for (int i = 0; i < this.selectFields.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("FIELD_NAME"), this.selectFields[i].getName());
            }
        }
        catch (Exception e) {
            throw new KettleException("Imposs\u00edvel salvar step no reposit\u00f3rio: " + String.valueOf(id_step), (Throwable)e);
        }
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.loglevel = rep.getStepAttributeString(id_step, "loglevel");
            this.otherkey = rep.getStepAttributeString(id_step, "otherkey");
            this.isotherkey = rep.getStepAttributeBoolean(id_step, "isotherkey");
            this.selectItems = rep.getStepAttributeString(id_step, "selectItems");
            int nrfields = rep.countNrStepAttributes(id_step, this.getRepCode("FIELD_NAME"));
            this.allocateSelect(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.selectFields[i].setName(rep.getStepAttributeString(id_step, i, this.getRepCode("FIELD_NAME")));
            }
        }
        catch (Exception e) {
            throw new KettleException("Imposs\u00edvel carregar o step do reposit\u00f3rio", (Throwable)e);
        }
    }

    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        try {
            RowMetaInterface rowMeta = inputRowMeta.clone();
            inputRowMeta.clear();
            inputRowMeta.addRowMeta(rowMeta);
            this.getSelectFields(inputRowMeta, name);
        }
        catch (Exception e) {
            throw new KettleStepException((Throwable)e);
        }
        try {
            ValueMetaInterface v = ValueMetaFactory.createValueMeta((String)"rollback", (int)2);
            v.setOrigin(name);
            inputRowMeta.addValueMeta(v);
        }
        catch (KettlePluginException e) {
            throw new KettleStepException((Throwable)e);
        }
    }

    public void getSelectFields(RowMetaInterface inputRowMeta, String name) throws KettleStepException {
        if (this.selectFields != null && this.selectFields.length > 0) {
            RowMeta row = new RowMeta();
            for (int i = 0; i < this.selectFields.length; ++i) {
                ValueMetaInterface v = inputRowMeta.searchValueMeta(this.selectFields[i].getName());
                if (v == null) continue;
                if (!(v = v.clone()).getName().equals(this.selectFields[i].getRename()) && this.selectFields[i].getRename() != null && this.selectFields[i].getRename().length() > 0) {
                    v.setName(this.selectFields[i].getRename());
                    v.setOrigin(name);
                }
                if (this.selectFields[i].getLength() != -2) {
                    v.setLength(this.selectFields[i].getLength());
                    v.setOrigin(name);
                }
                if (this.selectFields[i].getPrecision() != -2) {
                    v.setPrecision(this.selectFields[i].getPrecision());
                    v.setOrigin(name);
                }
                row.addValueMeta(v);
            }
            inputRowMeta.clear();
            inputRowMeta.addRowMeta((RowMetaInterface)row);
        }
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        boolean error_found;
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RollbackLog.CheckResult.ReceivingRows.OK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RollbackLog.CheckResult.ReceivingRows.ERROR", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (prev != null && prev.size() > 0) {
            int i;
            Object error_message = "";
            error_found = false;
            for (i = 0; i < this.selectFields.length; ++i) {
                int idx = prev.indexOfValue(this.selectFields[i].getName());
                if (idx >= 0) continue;
                error_message = (String)error_message + "\t\t" + this.selectFields[i].getName() + Const.CR;
                error_found = true;
            }
            if (this.selectFields.length > 0) {
                for (i = 0; i < prev.size(); ++i) {
                    ValueMetaInterface pv = prev.getValueMeta(i);
                    int idx = Const.indexOfString((String)pv.getName(), (String[])this.getSelectName());
                    if (idx >= 0) continue;
                    error_message = (String)error_message + "\t\t" + pv.getName() + " (" + pv.getTypeDesc() + ")" + Const.CR;
                    error_found = true;
                }
                if (error_found) {
                    error_message = BaseMessages.getString(PKG, (String)"RollbackLog.CheckResult.FieldsNotFound", (String[])new String[0]) + Const.CR + Const.CR + (String)error_message;
                    cr = new CheckResult(2, (String)error_message, (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                } else {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RollbackLog.CheckResult.AllSelectedFieldsFound2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RollbackLog.CheckResult.NoInputReceivedError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        int[] cnt = new int[this.selectFields.length];
        error_found = false;
        Object error_message = "";
        for (int i = 0; i < this.selectFields.length; ++i) {
            cnt[i] = 0;
            for (int j = 0; j < this.selectFields.length; ++j) {
                if (!this.selectFields[i].getName().equals(this.selectFields[j].getName())) continue;
                int n = i;
                cnt[n] = cnt[n] + 1;
            }
            if (cnt[i] <= 1) continue;
            if (!error_found) {
                error_message = BaseMessages.getString(PKG, (String)"RollbackLog.CheckResult.DuplicateFieldsSpecified", (String[])new String[0]) + Const.CR;
            } else {
                error_found = true;
            }
            error_message = (String)error_message + BaseMessages.getString(PKG, (String)"RollbackLog.CheckResult.OccurentRow", (String[])new String[]{i + " : " + this.selectFields[i].getName() + "  (" + cnt[i]}) + Const.CR;
            error_found = true;
        }
        this.logBasic((String)error_message);
    }

    public void logBasic(String message) {
        this.log.logBasic(message);
    }
}

