/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.avro;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SwtUniversalImage;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.avro.input.AvroInputMeta;
import org.pentaho.di.ui.core.FormDataBuilder;
import org.pentaho.di.ui.core.events.dialog.SelectionAdapterFileDialogTextVar;
import org.pentaho.di.ui.core.events.dialog.SelectionAdapterOptions;
import org.pentaho.di.ui.core.events.dialog.SelectionOperation;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public abstract class BaseAvroStepDialog
extends BaseStepDialog
implements StepDialogInterface {
    protected static final Class<?> BPKG = BaseAvroStepDialog.class;
    protected ModifyListener lsMod;
    public static final int MARGIN = 15;
    public static final int FIELDS_SEP = 10;
    public static final int FIELD_LABEL_SEP = 5;
    public static final int FIELD_SMALL = 150;
    public static final int FIELD_MEDIUM = 250;
    public static final int FIELD_LARGE = 350;
    private static final String ELLIPSIS = "...";
    private static final int TABLE_ITEM_MARGIN = 2;
    private static final int TOOLTIP_SHOW_DELAY = 350;
    private static final int TOOLTIP_HIDE_DELAY = 2000;
    protected static final int VAR_EXTRA_WIDTH = GUIResource.getInstance().getImageVariable().getBounds().width;
    protected Image icon;
    protected TextVar wPath;
    protected Button wbBrowse;
    protected Button wbGetDataFromField;
    protected Button wbGetDataFromFile;
    protected ComboVar wFieldNameCombo;
    protected CCombo encodingCombo;
    protected Composite wDataFileComposite;
    protected Composite wDataFieldComposite;
    protected boolean isInputStep;
    private Map<String, Integer> incomingFields = new HashMap<String, Integer>();
    protected static final String HDFS_SCHEME = "hdfs";

    public BaseAvroStepDialog(Shell parent, BaseStepMeta in, TransMeta transMeta, String sname) {
        super(parent, in, transMeta, sname);
        if (this.baseStepMeta instanceof AvroInputMeta) {
            this.isInputStep = true;
        }
    }

    public BaseStepMeta getStepMeta() {
        return (BaseStepMeta)this.baseStepMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 2160);
        this.setShellImage(this.shell, this.baseStepMeta);
        this.lsMod = e -> this.getStepMeta().setChanged();
        this.changed = this.getStepMeta().hasChanged();
        this.createUI();
        this.props.setLook((Control)this.shell);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                BaseAvroStepDialog.this.cancel();
            }
        });
        int height = Math.max(this.getMinHeight((Composite)this.shell, this.getWidth()), this.getHeight());
        this.shell.setMinimumSize(this.getWidth(), height);
        this.shell.setSize(this.getWidth(), height);
        this.getData();
        this.shell.open();
        this.wStepname.setFocus();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void createUI() {
        Label prev = this.createHeader();
        if (!this.isInputStep) {
            prev = this.addFileWidgets((Composite)this.shell, (Control)prev);
        }
        this.createFooter((Composite)this.shell);
        Composite afterFile = new Composite((Composite)this.shell, 0);
        afterFile.setLayout((Layout)new FormLayout());
        Label separator = new Label((Composite)this.shell, 258);
        separator.setLayoutData((Object)new FormDataBuilder().left().right().bottom((Control)this.wCancel, -15).height(2).result());
        afterFile.setLayoutData((Object)new FormDataBuilder().left().top((Control)prev, 0).right().bottom((Control)separator, -15).result());
        this.createAfterFile(afterFile);
    }

    protected Control createFooter(Composite shell) {
        this.wCancel = new Button(shell, 8);
        this.wCancel.setText(BaseMessages.getString((String)"System.Button.Cancel"));
        this.wCancel.addListener(13, this.lsCancel);
        this.wCancel.setLayoutData((Object)new FormDataBuilder().right().bottom().result());
        this.wOK = new Button(shell, 8);
        this.wOK.setText(BaseMessages.getString((String)"System.Button.OK"));
        this.wOK.addListener(13, this.lsOK);
        this.wOK.setLayoutData((Object)new FormDataBuilder().right((Control)this.wCancel, -5).bottom().result());
        this.lsPreview = this.getPreview();
        if (this.lsPreview != null) {
            this.wPreview = new Button(shell, 8);
            this.wPreview.setText(this.getBaseMsg("BaseStepDialog.Preview"));
            this.wPreview.pack();
            this.wPreview.addListener(13, this.lsPreview);
            int offset = this.wPreview.getBounds().width / 2;
            this.wPreview.setLayoutData((Object)new FormDataBuilder().bottom().left(new FormAttachment(50, -offset)).result());
        }
        return this.wCancel;
    }

    protected void cancel() {
        this.stepname = null;
        this.getStepMeta().setChanged(this.changed);
        this.dispose();
    }

    protected void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.getInfo(false);
        this.dispose();
    }

    protected abstract Control createAfterFile(Composite var1);

    protected abstract String getStepTitle();

    protected abstract void getData();

    protected abstract void getInfo(boolean var1);

    protected abstract int getWidth();

    protected abstract int getHeight();

    protected abstract Listener getPreview();

    protected Label createHeader() {
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.getStepTitle());
        this.lsOK = e -> this.ok();
        this.lsCancel = e -> this.cancel();
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(this.getBaseMsg("BaseStepDialog.StepName"));
        this.wlStepname.setLayoutData((Object)new FormDataBuilder().left().top().result());
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.wStepname.setLayoutData((Object)new FormDataBuilder().left().top((Control)this.wlStepname, 5).width(250).result());
        Label separator = new Label((Composite)this.shell, 258);
        separator.setLayoutData((Object)new FormDataBuilder().left().right().top((Control)this.wStepname, 15).height(2).result());
        this.addIcon();
        return separator;
    }

    protected void addIcon() {
        Label wicon = new Label((Composite)this.shell, 131072);
        String stepId = this.getStepMeta().getParentStepMeta().getStepID();
        wicon.setImage(((SwtUniversalImage)GUIResource.getInstance().getImagesSteps().get(stepId)).getAsBitmapForSize((Device)this.shell.getDisplay(), 48, 48));
        wicon.setLayoutData((Object)new FormDataBuilder().top().right().result());
    }

    protected Control addFileWidgets(Composite parent, Control prev) {
        Label wlPath = new Label(parent, 131072);
        wlPath.setText(this.getBaseMsg("AvroDialog.Filename.Label"));
        wlPath.setLayoutData((Object)new FormDataBuilder().left().top(prev, 15).result());
        this.wbBrowse = new Button(parent, 8);
        this.wbBrowse.setText(BaseMessages.getString((String)"System.Button.Browse"));
        this.wbBrowse.setLayoutData((Object)new FormDataBuilder().top((Control)wlPath).right().result());
        this.wPath = new TextVar((VariableSpace)this.transMeta, parent, 18436);
        this.wPath.addModifyListener(event -> {
            if (this.wPreview != null) {
                this.wPreview.setEnabled(!Utils.isEmpty((CharSequence)this.wPath.getText()));
            }
        });
        this.wPath.addModifyListener(this.lsMod);
        this.wPath.setLayoutData((Object)new FormDataBuilder().left().right((Control)this.wbBrowse, -5).top((Control)wlPath, 5).result());
        this.wbBrowse.addSelectionListener((SelectionListener)new SelectionAdapterFileDialogTextVar((LogChannelInterface)this.log, this.wPath, (AbstractMeta)this.transMeta, new SelectionAdapterOptions(this.selectionOperation())));
        return this.wPath;
    }

    protected abstract SelectionOperation selectionOperation();

    protected String getBaseMsg(String key) {
        return BaseMessages.getString(BPKG, (String)key, (String[])new String[0]);
    }

    protected int getMinHeight(Composite comp, int minWidth) {
        comp.pack();
        return comp.computeSize((int)minWidth, (int)-1).y;
    }

    protected void setTruncatedColumn(Table table, int targetColumn) {
        table.addListener(40, event -> {
            if (event.index == targetColumn) {
                event.detail &= 0xFFFFFFEF;
            }
        });
        table.addListener(42, event -> {
            TableItem item = (TableItem)event.item;
            int colIdx = event.index;
            if (colIdx == targetColumn) {
                String contents = item.getText(colIdx);
                if (Utils.isEmpty((CharSequence)contents)) {
                    return;
                }
                Point size = event.gc.textExtent(contents);
                int targetWidth = item.getBounds((int)colIdx).width;
                int yOffset = Math.max(0, (event.height - size.y) / 2);
                if (size.x > targetWidth) {
                    contents = this.shortenText(event.gc, contents, targetWidth);
                }
                event.gc.drawText(contents, event.x + 2, event.y + yOffset, true);
            }
        });
    }

    protected void addColumnTooltip(final Table table, final int columnIndex) {
        final DefaultToolTip toolTip = new DefaultToolTip((Control)table, 1, true);
        toolTip.setRespectMonitorBounds(true);
        toolTip.setRespectDisplayBounds(true);
        toolTip.setPopupDelay(350);
        toolTip.setHideDelay(2000);
        toolTip.setShift(new Point(5, 5));
        table.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                String contents;
                Point coord = new Point(e.x, e.y);
                TableItem item = table.getItem(coord);
                if (item != null && item.getBounds(columnIndex).contains(coord) && !Utils.isEmpty((CharSequence)(contents = item.getText(columnIndex)))) {
                    toolTip.setText(contents);
                    toolTip.show(coord);
                    return;
                }
                toolTip.hide();
            }

            public void mouseExit(MouseEvent e) {
                toolTip.hide();
            }
        });
    }

    protected String shortenText(GC gc, String text, int targetWidth) {
        if (Utils.isEmpty((CharSequence)text)) {
            return "";
        }
        int textWidth = gc.textExtent((String)text).x;
        int extra = gc.textExtent((String)ELLIPSIS).x + 4;
        if (targetWidth <= extra || textWidth <= targetWidth) {
            return text;
        }
        int len = text.length();
        for (int chomp = 1; chomp < len && textWidth + extra >= targetWidth; ++chomp) {
            text = text.substring(0, text.length() - 1);
            textWidth = gc.textExtent((String)text).x;
        }
        return text + ELLIPSIS;
    }

    protected void updateIncomingFieldList(ComboVar comboVar) {
        StepMeta stepMeta = this.transMeta.findStep(this.stepname);
        if (stepMeta != null) {
            try {
                RowMetaInterface row = this.transMeta.getPrevStepFields(stepMeta);
                this.incomingFields.clear();
                for (int i = 0; i < row.size(); ++i) {
                    this.incomingFields.put(row.getValueMeta(i).getName(), i);
                }
                HashMap<String, Integer> fields = new HashMap<String, Integer>(this.incomingFields);
                Set keySet = fields.keySet();
                ArrayList entries = new ArrayList(keySet);
                String[] fieldNames = entries.toArray(new String[0]);
                Const.sortStrings((String[])fieldNames);
                comboVar.setItems(fieldNames);
            }
            catch (KettleException e) {
                this.logError(this.getBaseMsg("System.Dialog.GetFieldsFailed.Message"));
            }
        }
    }
}

