/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.kafka;

import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.DoubleDeserializer;
import org.apache.kafka.common.serialization.DoubleSerializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaConsumerInputMeta;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;

public class KafkaConsumerField {
    private static final Class<?> PKG = KafkaConsumerField.class;
    private Name kafkaName;
    @Injection(name="OUTPUT_NAME")
    private String outputName;
    @Injection(name="TYPE")
    private Type outputType = Type.String;

    public KafkaConsumerField() {
    }

    public KafkaConsumerField(KafkaConsumerField orig) {
        this.kafkaName = orig.kafkaName;
        this.outputName = orig.outputName;
        this.outputType = orig.outputType;
    }

    public KafkaConsumerField(Name kafkaName, String outputName) {
        this(kafkaName, outputName, Type.String);
    }

    public KafkaConsumerField(Name kafkaName, String outputName, Type outputType) {
        this.kafkaName = kafkaName;
        this.outputName = outputName;
        this.outputType = outputType;
    }

    public Name getKafkaName() {
        return this.kafkaName;
    }

    public void setKafkaName(Name kafkaName) {
        this.kafkaName = kafkaName;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    public Type getOutputType() {
        return this.outputType;
    }

    public void setOutputType(Type outputType) {
        this.outputType = outputType;
    }

    public static enum Name {
        KEY("key"){

            @Override
            public void setFieldOnMeta(KafkaConsumerInputMeta meta, KafkaConsumerField field) {
                meta.setKeyField(field);
            }

            @Override
            public KafkaConsumerField getFieldFromMeta(KafkaConsumerInputMeta meta) {
                return meta.getKeyField();
            }
        }
        ,
        MESSAGE("message"){

            @Override
            public void setFieldOnMeta(KafkaConsumerInputMeta meta, KafkaConsumerField field) {
                meta.setMessageField(field);
            }

            @Override
            public KafkaConsumerField getFieldFromMeta(KafkaConsumerInputMeta meta) {
                return meta.getMessageField();
            }
        }
        ,
        TOPIC("topic"){

            @Override
            public void setFieldOnMeta(KafkaConsumerInputMeta meta, KafkaConsumerField field) {
                meta.setTopicField(field);
            }

            @Override
            public KafkaConsumerField getFieldFromMeta(KafkaConsumerInputMeta meta) {
                return meta.getTopicField();
            }
        }
        ,
        PARTITION("partition"){

            @Override
            public void setFieldOnMeta(KafkaConsumerInputMeta meta, KafkaConsumerField field) {
                meta.setPartitionField(field);
            }

            @Override
            public KafkaConsumerField getFieldFromMeta(KafkaConsumerInputMeta meta) {
                return meta.getPartitionField();
            }
        }
        ,
        OFFSET("offset"){

            @Override
            public void setFieldOnMeta(KafkaConsumerInputMeta meta, KafkaConsumerField field) {
                meta.setOffsetField(field);
            }

            @Override
            public KafkaConsumerField getFieldFromMeta(KafkaConsumerInputMeta meta) {
                return meta.getOffsetField();
            }
        }
        ,
        TIMESTAMP("timestamp"){

            @Override
            public void setFieldOnMeta(KafkaConsumerInputMeta meta, KafkaConsumerField field) {
                meta.setTimestampField(field);
            }

            @Override
            public KafkaConsumerField getFieldFromMeta(KafkaConsumerInputMeta meta) {
                return meta.getTimestampField();
            }
        };

        private final String name;

        private Name(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public abstract void setFieldOnMeta(KafkaConsumerInputMeta var1, KafkaConsumerField var2);

        public abstract KafkaConsumerField getFieldFromMeta(KafkaConsumerInputMeta var1);
    }

    public static enum Type {
        String("String", 2, StringSerializer.class, StringDeserializer.class),
        Integer("Integer", 5, LongSerializer.class, LongDeserializer.class),
        Binary("Binary", 8, ByteArraySerializer.class, ByteArrayDeserializer.class),
        Number("Number", 1, DoubleSerializer.class, DoubleDeserializer.class);

        private final String value;
        private final int valueMetaInterfaceType;
        private final Class kafkaSerializerClass;
        private final Class kafkaDeserializerClass;

        private Type(String value, int valueMetaInterfaceType, Class kafkaSerializerClass, Class kafkaDeserializerClass) {
            this.value = value;
            this.valueMetaInterfaceType = valueMetaInterfaceType;
            this.kafkaSerializerClass = kafkaSerializerClass;
            this.kafkaDeserializerClass = kafkaDeserializerClass;
        }

        public String toString() {
            return this.value;
        }

        public int getValueMetaInterfaceType() {
            return this.valueMetaInterfaceType;
        }

        public Class getKafkaSerializerClass() {
            return this.kafkaSerializerClass;
        }

        public Class getKafkaDeserializerClass() {
            return this.kafkaDeserializerClass;
        }

        public static Type fromValueMetaInterface(ValueMetaInterface vmi) {
            if (vmi != null) {
                for (Type t : Type.values()) {
                    if (vmi.getType() != t.getValueMetaInterfaceType()) continue;
                    return t;
                }
                throw new IllegalArgumentException(BaseMessages.getString((Class)PKG, (String)"KafkaConsumerField.Type.ERROR.NoValueMetaInterfaceMapping", (Object[])new Object[]{vmi.getName(), vmi.getType()}));
            }
            return String;
        }
    }
}

