/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.capabilities.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.pentaho.capabilities.api.ICapability;
import org.pentaho.capabilities.api.ICapabilityManager;
import org.pentaho.capabilities.api.ICapabilityProvider;

public class DefaultCapabilityManager
implements ICapabilityManager {
    public static final String ID = "default";
    private Map<String, ICapabilityProvider> providers = new HashMap<String, ICapabilityProvider>();
    private static DefaultCapabilityManager INSTANCE = new DefaultCapabilityManager();

    protected DefaultCapabilityManager() {
    }

    public static DefaultCapabilityManager getInstance() {
        return INSTANCE;
    }

    public void registerCapabilityProvider(ICapabilityProvider provider) {
        this.providers.put(provider.getId(), provider);
    }

    @Override
    public Set<String> listProviders() {
        return this.providers.keySet();
    }

    @Override
    public ICapabilityProvider getProvider(String id) {
        return this.providers.get(id);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public Set<String> listCapabilities() {
        HashSet<String> capabilities = new HashSet<String>();
        for (ICapabilityProvider iCapabilityProvider : this.providers.values()) {
            Set<String> caps = iCapabilityProvider.listCapabilities();
            if (caps == null) continue;
            capabilities.addAll(caps);
        }
        return capabilities;
    }

    @Override
    public ICapability getCapabilityById(String id) {
        for (ICapabilityProvider iCapabilityProvider : this.providers.values()) {
            ICapability capabilityById = iCapabilityProvider.getCapabilityById(id);
            if (capabilityById == null) continue;
            return capabilityById;
        }
        return null;
    }

    @Override
    public boolean capabilityExist(String id) {
        for (ICapabilityProvider iCapabilityProvider : this.providers.values()) {
            if (!iCapabilityProvider.capabilityExist(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<ICapability> getAllCapabilities() {
        HashSet<ICapability> capabilities = new HashSet<ICapability>();
        for (ICapabilityProvider iCapabilityProvider : this.providers.values()) {
            Set<ICapability> caps = iCapabilityProvider.getAllCapabilities();
            if (caps == null) continue;
            capabilities.addAll(caps);
        }
        return capabilities;
    }
}

