/*
 * Decompiled with CFR 0.152.
 */
package com.totvscrm.pentaho;

import java.io.File;
import java.net.BindException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.filerep.KettleFileRepository;
import org.pentaho.di.repository.filerep.KettleFileRepositoryMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.www.Carte;
import org.pentaho.di.www.SlaveServerConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Main {
    public static void main(String[] args) throws Exception {
        String tipoExecucao = args[0].toString();
        Object jobTransformation = "";
        try {
            jobTransformation = String.valueOf(Main.class.getClassLoader().getResource("integracao/source/")) + args[1].toString();
            if (((String)jobTransformation).startsWith("null")) {
                System.out.println("Diretorio do job/transformation nao encontrado: " + (String)jobTransformation);
                System.exit(0);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        String diretorioKettle = new File(".").getAbsolutePath() + "/config/";
        String defaultJndiRoot = System.getenv("DEFAULT_JNDI_ROOT");
        String diretorioPluginsWS = new File(".").getAbsolutePath() + "/plugins/";
        System.setProperty("Dhttps.protocols", "TLSv1,TLSv1.1,TLSv1.2");
        System.setProperty("file.encoding", "UTF-8");
        System.setProperty("DEFAULT_PLUGIN_BASE_FOLDERS", diretorioPluginsWS);
        System.setProperty("KETTLE_HOME", diretorioKettle);
        System.setProperty("org.eclipse.jetty.server.Request.maxFormContentSize", "10485760");
        if (defaultJndiRoot == null || defaultJndiRoot.isEmpty()) {
            System.setProperty("KETTLE_JNDI_ROOT", diretorioKettle);
        } else {
            System.setProperty("KETTLE_JNDI_ROOT", defaultJndiRoot);
        }
        if (tipoExecucao.equals("carte")) {
            System.setProperty("KETTLE_COMPATIBILITY_SEND_RESULT_XML_WITH_FULL_STATUS", "Y");
            try {
                Element tElement;
                Node node;
                int i;
                SlaveServer carteMaster = new SlaveServer();
                SlaveServerConfig config = new SlaveServerConfig();
                File file = new File(diretorioKettle + ".kettle/carte-configuration.xml");
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(file);
                doc.getDocumentElement().normalize();
                NodeList nodeList = doc.getElementsByTagName("slaveserver");
                for (i = 0; i < nodeList.getLength(); ++i) {
                    node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    tElement = (Element)node;
                    carteMaster.setName(tElement.getElementsByTagName("name").item(0).getTextContent());
                    carteMaster.setHostname(tElement.getElementsByTagName("hostname").item(0).getTextContent());
                    carteMaster.setPort(tElement.getElementsByTagName("port").item(0).getTextContent());
                    carteMaster.setUsername(tElement.getElementsByTagName("username").item(0).getTextContent());
                    carteMaster.setPassword(tElement.getElementsByTagName("password").item(0).getTextContent());
                    carteMaster.setMaster(tElement.getElementsByTagName("master").item(0).getTextContent() == "Y");
                }
                nodeList = doc.getElementsByTagName("slave_config");
                for (i = 0; i < nodeList.getLength(); ++i) {
                    node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    tElement = (Element)node;
                    config.setMaxLogLines(Integer.parseInt(tElement.getElementsByTagName("max_log_lines").item(0).getTextContent()));
                    config.setMaxLogTimeoutMinutes(Integer.parseInt(tElement.getElementsByTagName("max_log_timeout_minutes").item(0).getTextContent()));
                    config.setObjectTimeoutMinutes(Integer.parseInt(tElement.getElementsByTagName("object_timeout_minutes").item(0).getTextContent()));
                }
                config.setSlaveServer(carteMaster);
                Carte.runCarte((SlaveServerConfig)config);
            }
            catch (BindException e) {
                System.out.println("Ja existe uma instancia na porta solicitada.");
                System.exit(0);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        } else {
            try {
                KettleEnvironment.init();
                String repositoryName = "DEFAULT";
                String repositoryDirectory = Main.class.getClassLoader().getResource("integracao/source/").toString();
                KettleFileRepositoryMeta repositoryMeta = new KettleFileRepositoryMeta();
                repositoryMeta.setName(repositoryName);
                repositoryMeta.setBaseDirectory(repositoryDirectory);
                KettleFileRepository repository = new KettleFileRepository();
                repository.init((RepositoryMeta)repositoryMeta);
                if (tipoExecucao.equals("job")) {
                    JobMeta metadata = new JobMeta((String)jobTransformation + ".kjb", null);
                    Job job = new Job(null, metadata);
                    job.shareVariablesWith((VariableSpace)metadata);
                    job.setRepository((Repository)repository);
                    if (args[2].toString().equals("MINIMAL")) {
                        job.setLogLevel(LogLevel.MINIMAL);
                    } else if (args[2].toString().equals("DETAILED")) {
                        job.setLogLevel(LogLevel.DETAILED);
                    } else if (args[2].toString().equals("DEBUG")) {
                        job.setLogLevel(LogLevel.DEBUG);
                    } else if (args[2].toString().equals("ROWLEVEL")) {
                        job.setLogLevel(LogLevel.ROWLEVEL);
                    } else if (args[2].toString().equals("ERROR")) {
                        job.setLogLevel(LogLevel.ERROR);
                    } else {
                        job.setLogLevel(LogLevel.BASIC);
                    }
                    job.initializeVariablesFrom(null);
                    job.getJobMeta().setInternalKettleVariables((VariableSpace)job);
                    job.copyParametersFrom((NamedParams)job.getJobMeta());
                    for (int index = 3; index < args.length; ++index) {
                        int pos = args[index].toString().indexOf("=");
                        metadata.setParameterValue(args[index].toString().substring(0, pos), args[index].toString().substring(pos + 1));
                    }
                    metadata.setInternalKettleVariables((VariableSpace)job);
                    metadata.activateParameters();
                    job.start();
                    job.waitUntilFinished();
                    if (job.getErrors() > 0) {
                        System.out.println("Erro ao tentar executar o job!!!");
                    }
                    job.setFinished(true);
                } else {
                    TransMeta metadata = new TransMeta((String)jobTransformation + ".ktr");
                    Trans trans = new Trans(metadata);
                    if (args[2].toString().equals("BASIC")) {
                        trans.setLogLevel(LogLevel.BASIC);
                    } else if (args[2].toString().equals("DEBUG")) {
                        trans.setLogLevel(LogLevel.DEBUG);
                    }
                    for (int index = 3; index < args.length; ++index) {
                        int pos = args[index].toString().indexOf("=");
                        trans.setParameterValue(args[index].toString().substring(0, pos), args[index].toString().substring(pos + 1));
                    }
                    trans.execute(null);
                    trans.waitUntilFinished();
                    if (trans.getErrors() > 0) {
                        System.out.println("Erro ao tentar executar a transformacao!!!");
                    }
                }
                repository.disconnect();
            }
            catch (KettleException e) {
                e.printStackTrace();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println("Verifique se os parametros estao informados corretamente no bat ou sh.");
            }
        }
    }
}

