/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags;

import java.beans.Expression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulEventSource;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.DefaultBinding;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.dnd.DropEffectType;
import org.pentaho.ui.xul.dnd.DropEvent;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swt.AbstractSwtXulContainer;
import org.pentaho.ui.xul.swt.tags.SwtListitem;

public class SwtListbox
extends AbstractSwtXulContainer
implements XulListbox {
    private static final long serialVersionUID = 3064125049914932493L;
    private ListViewer listBox;
    private boolean disabled = false;
    private String selType;
    private int rowsToDisplay = 0;
    String onSelect = null;
    private XulDomContainer container;
    private String binding;
    private Collection elements;
    private String command;
    private int[] curSelectedIndices = null;
    private int curSelectedIndex = -1;
    private Object prevSelectedObject;
    private boolean suppressEvents;
    private List<Binding> elementBindings = new ArrayList<Binding>();

    public SwtListbox(Element self, XulComponent parent, XulDomContainer container, String tagName) {
        super(tagName);
        this.container = container;
        int style = 2560;
        style = self.getAttributeValue("seltype") != null && self.getAttributeValue("seltype").equals("multi") ? (style |= 2) : (style |= 4);
        this.listBox = new ListViewer((Composite)parent.getManagedObject(), style);
        this.listBox.getList().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SwtListbox.this.fireSelectedEvents();
            }
        });
        this.setManagedObject(this.listBox);
    }

    private void fireSelectedEvents() {
        if (this.suppressEvents) {
            return;
        }
        int[] indices = this.listBox.getList().getSelectionIndices();
        this.changeSupport.firePropertyChange("selectedIndices", this.curSelectedIndices, indices);
        this.curSelectedIndices = indices;
        this.changeSupport.firePropertyChange("selectedIndex", this.curSelectedIndex, this.getSelectedIndex());
        this.curSelectedIndex = this.getSelectedIndex();
        if (this.elements != null) {
            Object newSelectedObject = this.getSelectedItem();
            this.changeSupport.firePropertyChange("selectedItem", this.prevSelectedObject, newSelectedObject);
            this.prevSelectedObject = newSelectedObject;
            Object[] newSelectedObjectList = this.getSelectedItems();
            this.changeSupport.firePropertyChange("selectedItems", null, newSelectedObjectList);
        }
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        if (!this.listBox.getList().isDisposed()) {
            this.listBox.getList().setEnabled(!disabled);
        }
    }

    public void setDisabled(String dis) {
        this.disabled = Boolean.parseBoolean(dis);
        if (!this.listBox.getList().isDisposed()) {
            this.listBox.getList().setEnabled(!this.disabled);
        }
    }

    public int getRows() {
        return this.rowsToDisplay;
    }

    public void setRows(int rowsToDisplay) {
        this.rowsToDisplay = rowsToDisplay;
        if (!this.listBox.getList().isDisposed() && rowsToDisplay > 0) {
            int ht = rowsToDisplay * this.listBox.getList().getItemHeight();
            if (this.listBox.getList().getLayoutData() != null) {
                ((GridData)this.listBox.getList().getLayoutData()).heightHint = ht;
                ((GridData)this.listBox.getList().getLayoutData()).minimumHeight = ht;
            }
        }
    }

    public String getSeltype() {
        return this.selType;
    }

    public void setSeltype(String selType) {
        this.selType = selType;
    }

    public void addItem(Object item) {
        this.listBox.add(item);
    }

    public void removeItems() {
        this.listBox.getList().removeAll();
    }

    public String getOnselect() {
        return this.onSelect;
    }

    public void setOnselect(final String method) {
        this.onSelect = method;
        this.listBox.getList().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SwtListbox.this.invoke(method);
            }
        });
    }

    public Object getSelectedItem() {
        if (this.listBox.getList().getSelection() == null || this.listBox.getList().getSelectionCount() <= 0) {
            return null;
        }
        int selIdx = this.getSelectedIndex();
        if (this.elements != null && selIdx >= 0 && selIdx < this.elements.size()) {
            return this.elements.toArray()[selIdx];
        }
        return this.listBox.getList().getSelection()[0];
    }

    public Object[] getSelectedItems() {
        int[] selIndices = this.getSelectedIndices();
        if (this.elements != null && selIndices.length > 0) {
            Object[] returnArray = new Object[selIndices.length];
            Object[] valueArray = this.elements.toArray();
            for (int i = 0; i < selIndices.length; ++i) {
                returnArray[i] = valueArray[selIndices[i]];
            }
            return returnArray;
        }
        return this.listBox.getList().getSelection();
    }

    public int getSelectedIndex() {
        return this.listBox.getList().getSelectionIndex();
    }

    public int[] getSelectedIndices() {
        return this.listBox.getList().getSelectionIndices();
    }

    public void setSelectedItem(Object item) {
        this.setSelectedItems(new Object[]{item});
    }

    public void setSelectedItems(Object[] items) {
        if (this.elements != null) {
            int[] indices = new int[items.length];
            int pos = 0;
            for (Object o : items) {
                int index = this.getIndex(o);
                indices[pos++] = index >= 0 ? index : -1;
            }
            this.setSelectedIndices(indices);
        } else {
            String[] sel = new String[items.length];
            for (int i = 0; i < items.length; ++i) {
                sel[i] = items[i].toString();
            }
            this.suppressEvents = true;
            this.listBox.getList().setSelection(sel);
            this.suppressEvents = false;
            this.listBox.getList().notifyListeners(13, new Event());
        }
    }

    private int getIndex(Object o) {
        Object[] elementArray = this.elements.toArray();
        for (int i = 0; i < elementArray.length; ++i) {
            if (elementArray[i] != o) continue;
            return i;
        }
        return -1;
    }

    public int getRowCount() {
        return !this.listBox.getList().isDisposed() ? this.listBox.getList().getItemCount() : 0;
    }

    public void setSelectedIndex(int index) {
        if (index > this.listBox.getList().getItemCount()) {
            return;
        }
        if (this.listBox.getList().isDisposed()) {
            System.out.println("Warning: attempting to access listbox after disposal.");
        }
        this.listBox.getList().setSelection(index);
    }

    public void setSelectedindex(String index) {
        if (this.listBox.getList().isDisposed()) {
            System.out.println("Warning: attempting to access listbox after disposal.");
        }
        this.listBox.getList().setSelection(Integer.parseInt(index));
    }

    public <T> Collection<T> getElements() {
        return this.elements;
    }

    public <T> void setElements(Collection<T> elements) {
        if (elements != null) {
            this.destroyPreviousBindings();
            this.elements = elements;
            this.prevSelectedObject = null;
            this.curSelectedIndex = -1;
            this.curSelectedIndices = null;
            this.listBox.getList().removeAll();
            for (T t : elements) {
                SwtListitem item = null;
                try {
                    item = (SwtListitem)this.container.getDocumentRoot().createElement("listitem");
                }
                catch (XulException e) {
                    e.printStackTrace();
                }
                this.addChild((Element)item);
                if (t instanceof XulEventSource) {
                    item.setValue(t);
                }
                this.wireLabel(t, item);
            }
            this.layout();
        }
    }

    public void setSelectedIndices(int[] indices) {
        this.suppressEvents = true;
        this.listBox.getList().deselectAll();
        this.listBox.getList().select(indices);
        this.suppressEvents = false;
        this.fireSelectedEvents();
    }

    public void setBinding(String binding) {
        this.binding = binding;
    }

    public String getBinding() {
        return this.binding;
    }

    public void updateLabel(SwtListitem item) {
        this.listBox.update(item.getValue(), null);
    }

    private <T> void wireLabel(T t, SwtListitem item) {
        if (t == null) {
            return;
        }
        String attribute = this.getBinding();
        if (StringUtils.isNotEmpty((String)attribute)) {
            try {
                if (t instanceof XulEventSource) {
                    Binding binding = this.createBinding((XulEventSource)t, attribute, (XulEventSource)item, "label");
                    this.elementBindings.add(binding);
                    binding.setBindingType(Binding.Type.ONE_WAY);
                    this.container.addBinding(binding);
                    binding.fireSourceChanged();
                }
                String getter = "get" + String.valueOf(attribute.charAt(0)).toUpperCase() + attribute.substring(1);
                String label = "" + new Expression(t, getter, null).getValue();
                item.setValue(label);
                item.setLabel(label);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            item.setLabel(t.toString());
        }
    }

    private Binding createBinding(XulEventSource source, String prop1, XulEventSource target, String prop2) {
        if (this.bindingProvider != null) {
            return this.bindingProvider.getBinding(source, prop1, target, prop2);
        }
        return new DefaultBinding((Object)source, prop1, (Object)target, prop2);
    }

    private void destroyPreviousBindings() {
        for (Binding bind : this.elementBindings) {
            bind.destroyBindings();
        }
        this.elementBindings.clear();
    }

    @Override
    protected List<Object> getSwtDragData() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.elements != null && this.elements instanceof List) {
            int[] indices = this.listBox.getList().getSelectionIndices();
            for (int i = 0; i < indices.length; ++i) {
                list.add(((List)this.elements).get(indices[i]));
            }
        } else {
            for (String str : this.listBox.getList().getSelection()) {
                list.add(str);
            }
        }
        return list;
    }

    @Override
    protected void onSwtDragFinished(DropEffectType effect, DropEvent event) {
        if (effect == DropEffectType.MOVE) {
            if (this.elements != null) {
                throw new UnsupportedOperationException("Bindings not yet supported in drag with move");
            }
            int[] indices = this.listBox.getList().getSelectionIndices();
            for (int i = indices.length - 1; i >= 0; --i) {
                this.removeChild((Element)this.getChildNodes().get(indices[i]));
            }
            this.listBox.remove((Object)indices);
        }
    }

    @Override
    protected void onSwtDragDropAccepted(DropEvent event) {
        if (this.elements != null) {
            throw new UnsupportedOperationException("Bindings not yet supported on drop");
        }
        List data = event.getDataTransfer().getData();
        for (int i = 0; i < data.size(); ++i) {
            SwtListitem item = null;
            try {
                item = (SwtListitem)this.container.getDocumentRoot().createElement("listitem");
            }
            catch (XulException e) {
                e.printStackTrace();
            }
            this.addChild((Element)item);
            item.setValue(data.get(i));
        }
        this.layout();
    }

    public void setOndrop(String ondrop) {
        super.setOndrop(ondrop);
        super.enableDrop();
    }

    public void setOndrag(String ondrag) {
        super.setOndrag(ondrag);
        if (this.getDrageffect() != null) {
            super.enableDrag(DropEffectType.valueOfIgnoreCase((String)this.getDrageffect()));
        }
    }

    public void setDrageffect(String drageffect) {
        super.setDrageffect(drageffect);
        if (this.getOndrag() != null) {
            super.enableDrag(DropEffectType.valueOfIgnoreCase((String)this.getDrageffect()));
        }
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(final String command) {
        this.command = command;
        this.listBox.getList().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                SwtListbox.this.invoke(command);
            }
        });
    }
}

