/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulSettingsManager;
import org.pentaho.ui.xul.components.XulDialogheader;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulRoot;
import org.pentaho.ui.xul.containers.XulWindow;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swt.AbstractSwtXulContainer;
import org.pentaho.ui.xul.swt.DialogButton;
import org.pentaho.ui.xul.swt.custom.BasicDialog;
import org.pentaho.ui.xul.swt.tags.SwtButton;
import org.pentaho.ui.xul.util.Orient;
import org.pentaho.ui.xul.util.SwtXulUtil;

public class SwtDialog
extends AbstractSwtXulContainer
implements XulDialog {
    protected XulDomContainer domContainer = null;
    protected BasicDialog dialog = null;
    protected String title = null;
    protected String onload;
    protected String onclose;
    protected String onunload;
    protected XulDialogheader header;
    protected int height = -999;
    protected int width = -999;
    protected boolean isDialogHidden = true;
    protected int returnCode = -9999;
    protected BUTTON_ALIGN buttonAlignment;
    protected Map<String, SwtButton> activeDialogButtons = new HashMap<String, SwtButton>();
    protected String buttonlabelaccept;
    protected String buttonlabelcancel;
    protected String buttonlabelextra1;
    protected String buttonlabelextra2;
    protected String[] buttons = new String[]{"accept", "cancel"};
    protected String ondialogaccept;
    protected String ondialogcancel;
    protected String ondialogextra1;
    protected String ondialogextra2;
    protected boolean resizable = false;
    protected boolean buttonsCreated = false;
    protected String appIcon;
    protected static final Log logger = LogFactory.getLog(SwtDialog.class);
    protected boolean pack;
    protected XulSettingsManager settingsManager;
    protected boolean closing;
    protected boolean letDialogDispose;

    public SwtDialog(Element self, XulComponent parent, XulDomContainer container, String tagName) {
        super(tagName);
        this.setOrient(Orient.VERTICAL.toString());
        this.domContainer = container;
        this.setId(self.getAttributeValue("ID"));
        String resizableStr = self.getAttributeValue("resizable");
        this.setResizable(resizableStr == null || resizableStr.equals("true"));
        if (self != null) {
            this.setAppicon(self.getAttributeValue("appicon"));
        }
        this.dialog = this.createDialog(self, parent);
        Composite c = this.createDialogComposite();
        this.setManagedObject(c);
        this.settingsManager = container.getSettingsManager();
    }

    protected Shell getParentShell(XulComponent parent) {
        Shell parentShell = null;
        if (parent != null) {
            if (parent instanceof XulWindow && this.domContainer.getOuterContext() != null) {
                parentShell = (Shell)this.domContainer.getOuterContext();
            }
            if (parentShell == null && parent instanceof XulRoot) {
                parentShell = (Shell)((XulRoot)parent).getRootObject();
            }
        }
        if (parentShell == null) {
            parentShell = new Shell(1264);
        }
        return parentShell;
    }

    private BasicDialog createDialog(XulComponent parent) {
        return this.createDialog(null, parent);
    }

    private BasicDialog createDialog(Element self, XulComponent parent) {
        Image parentImg;
        Shell parentShell = self != null && self.getAttributeValue("proxyoutercontext") != null && this.domContainer.getOuterContext() != null && this.domContainer.getOuterContext() instanceof Shell ? (Shell)this.domContainer.getOuterContext() : this.getParentShell(parent);
        BasicDialog newDialog = new BasicDialog(parentShell, this.getResizable());
        newDialog.getShell().setBackgroundMode(1);
        newDialog.getShell().addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (!SwtDialog.this.letDialogDispose) {
                    try {
                        SwtDialog.this.hide();
                    }
                    catch (SWTException e) {
                        logger.error((Object)e);
                    }
                }
            }
        });
        if (StringUtils.isNotEmpty((String)this.appIcon)) {
            this.setAppicon(this.appIcon);
        } else if (parentShell != null && !parentShell.isDisposed() && (parentImg = parentShell.getImage()) != null) {
            newDialog.getShell().setImage(parentImg);
        }
        return newDialog;
    }

    private Composite createDialogComposite() {
        Composite c = new Composite((Composite)this.dialog.getMainDialogArea(), 0);
        GridData gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        c.setLayoutData((Object)gd);
        return c;
    }

    public Shell getShell() {
        return this.dialog != null ? this.dialog.getShell() : null;
    }

    public void dispose() {
        this.letDialogDispose = true;
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            this.getShell().dispose();
        }
    }

    public String getButtonlabelaccept() {
        return this.buttonlabelaccept;
    }

    public String getButtonlabelcancel() {
        return this.buttonlabelcancel;
    }

    public String getButtons() {
        return StringUtils.join((Object[])this.buttons, (String)",");
    }

    public String getOndialogaccept() {
        return this.ondialogaccept;
    }

    public String getOndialogcancel() {
        return this.ondialogcancel;
    }

    public String getTitle() {
        return this.title;
    }

    public void setButtonlabelaccept(String label) {
        this.buttonlabelaccept = label;
    }

    public void setButtonlabelcancel(String label) {
        this.buttonlabelcancel = label;
    }

    public void setButtons() {
        this.setButtons(this.dialog);
        this.buttonsCreated = true;
    }

    public void setButtons(String buttonList) {
        if (buttonList.equals("")) {
            this.buttons = null;
        } else {
            List<String> newButtons = Arrays.asList(buttonList.split(","));
            for (int i = 0; i < newButtons.size(); ++i) {
                newButtons.set(i, newButtons.get(i).trim().toUpperCase());
            }
            String[] existingButtons = this.buttons;
            this.buttons = (String[])newButtons.stream().toArray(String[]::new);
            for (String existingButton : existingButtons) {
                if (newButtons.contains(existingButton.trim().toUpperCase())) continue;
                this.removeButton(existingButton);
            }
        }
        if (this.buttonsCreated) {
            this.setButtons(this.dialog);
        }
    }

    protected void removeButton(String button) {
        String bName = button.trim().toUpperCase();
        if (this.activeDialogButtons.containsKey(bName)) {
            SwtButton b = this.activeDialogButtons.get(bName);
            Button swtB = (Button)b.getManagedObject();
            if (!swtB.isDisposed()) {
                swtB.dispose();
            }
            this.activeDialogButtons.remove(bName);
            this.removeChild((Element)b);
        }
    }

    public void setOndialogaccept(String command) {
        this.ondialogaccept = command;
    }

    public void setOndialogcancel(String command) {
        this.ondialogcancel = command;
        if (this.ondialogcancel != null) {
            this.dialog.addShellListener(new ShellAdapter(){

                public void shellClosed(ShellEvent e) {
                    SwtDialog.this.invoke(SwtDialog.this.ondialogcancel);
                }
            });
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void show() {
        this.show(true);
    }

    public void show(boolean force) {
        if (force || !this.buttonsCreated) {
            this.setButtons();
        }
        this.isDialogHidden = false;
        this.dialog.getShell().setText(this.title);
        int storedHeight = 0;
        int storedWidth = 0;
        int storedLeft = 0;
        int storedTop = 0;
        if (this.settingsManager != null) {
            String sWidth = this.settingsManager.getSetting(this.getId() + ".Width");
            String sHeight = this.settingsManager.getSetting(this.getId() + ".Height");
            String sTop = this.settingsManager.getSetting(this.getId() + ".Top");
            String sLeft = this.settingsManager.getSetting(this.getId() + ".Left");
            if (sWidth != null && sHeight != null) {
                storedWidth = Integer.parseInt(sWidth);
                storedHeight = Integer.parseInt(sHeight);
            }
            if (sTop != null && sLeft != null) {
                storedLeft = Integer.parseInt(sLeft);
                storedTop = Integer.parseInt(sTop);
            }
        }
        if (storedHeight > 0 && storedWidth > 0) {
            this.dialog.setHeight(storedHeight);
            this.dialog.setWidth(storedWidth);
        } else if (this.height > 0 && this.width > 0) {
            this.dialog.setHeight(this.height);
            this.dialog.setWidth(this.width);
        }
        this.dialog.resizeBounds();
        if (this.pack) {
            this.dialog.getShell().pack();
        }
        this.dialog.getMainArea().layout(true, true);
        this.notifyListeners(555);
        if (storedTop > 0 && storedLeft > 0) {
            this.dialog.getShell().setLocation(new Point(storedLeft, storedTop));
        }
        this.setAppicon(this.appIcon);
        this.returnCode = this.dialog.open();
    }

    public void setButtons(BasicDialog d) {
        if (this.buttons == null) {
            d.getButtonArea().setVisible(false);
            d.getButtonArea().getParent().setVisible(false);
            ((GridData)d.getButtonArea().getParent().getLayoutData()).exclude = true;
            d.getShell().layout(true);
            return;
        }
        for (String buttonName : this.buttons) {
            SwtButton existingButton;
            if (StringUtils.isEmpty((String)buttonName)) {
                return;
            }
            DialogButton thisButton = DialogButton.valueOf(buttonName.trim().toUpperCase());
            SwtButton swtButton = null;
            SwtButton swtButton2 = existingButton = this.getDocument() != null ? (SwtButton)this.getElementById(this.getId() + "_" + buttonName.trim().toLowerCase()) : null;
            if (this.getId() != null && existingButton != null) {
                swtButton = existingButton;
                Widget w = (Widget)existingButton.getManagedObject();
                if (w == null || w.isDisposed()) {
                    Button button = d.createButton(thisButton, false);
                    swtButton.setButton(button);
                }
            } else {
                Button button = d.createButton(thisButton, false);
                swtButton = new SwtButton(button);
                swtButton.setId(this.getId() + "_" + buttonName.trim().toLowerCase());
                this.addChild((Element)swtButton);
            }
            switch (thisButton) {
                case ACCEPT: {
                    if (this.getButtonlabelaccept() != null && this.getButtonlabelaccept().trim().length() > 0) {
                        swtButton.setLabel(this.getButtonlabelaccept());
                    }
                    if (this.getOndialogaccept() == null || this.getOndialogaccept().trim().length() <= 0) break;
                    swtButton.setOnclick(this.getOndialogaccept());
                    break;
                }
                case CANCEL: {
                    if (this.getButtonlabelcancel() != null && this.getButtonlabelcancel().trim().length() > 0) {
                        swtButton.setLabel(this.getButtonlabelcancel());
                    }
                    if (this.getOndialogcancel() == null || this.getOndialogcancel().trim().length() <= 0) break;
                    swtButton.setOnclick(this.getOndialogcancel());
                    break;
                }
                case EXTRA1: {
                    if (this.getButtonlabelextra1() != null && this.getButtonlabelextra1().trim().length() > 0) {
                        swtButton.setLabel(this.getButtonlabelextra1());
                    }
                    if (this.getOndialogextra1() == null || this.getOndialogextra1().trim().length() <= 0) break;
                    swtButton.setOnclick(this.getOndialogextra1());
                    break;
                }
                case EXTRA2: {
                    if (this.getButtonlabelextra2() != null && this.getButtonlabelextra2().trim().length() > 0) {
                        swtButton.setLabel(this.getButtonlabelextra2());
                    }
                    if (this.getOndialogextra2() == null || this.getOndialogextra2().trim().length() <= 0) break;
                    swtButton.setOnclick(this.getOndialogextra2());
                }
            }
            this.activeDialogButtons.put(thisButton.toString().toUpperCase(), swtButton);
        }
        int width = 75;
        for (Map.Entry<String, SwtButton> entry : this.activeDialogButtons.entrySet()) {
            width = Math.max(width, entry.getValue().button.computeSize((int)-1, (int)-1, (boolean)true).x);
        }
        GridData gd = new GridData();
        gd.widthHint = width;
        for (Map.Entry<String, SwtButton> entry : this.activeDialogButtons.entrySet()) {
            entry.getValue().button.setLayoutData((Object)gd);
        }
    }

    public boolean isDisposing() {
        return this.letDialogDispose;
    }

    public void hide() {
        Control[] controls;
        Control[] controlz;
        if (this.closing || this.dialog.getMainArea().isDisposed() || this.getParentShell(this.getParent()).isDisposed() || this.getParent() instanceof SwtDialog && ((SwtDialog)this.getParent()).isDisposing()) {
            return;
        }
        this.closing = true;
        if (this.settingsManager != null) {
            this.settingsManager.storeSetting(this.getId() + ".Left", "" + this.dialog.getShell().getLocation().x);
            this.settingsManager.storeSetting(this.getId() + ".Top", "" + this.dialog.getShell().getLocation().y);
            this.settingsManager.storeSetting(this.getId() + ".Height", "" + this.dialog.getShell().getSize().y);
            this.settingsManager.storeSetting(this.getId() + ".Width", "" + this.dialog.getShell().getSize().x);
            try {
                this.settingsManager.save();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        this.returnCode = 12;
        BasicDialog newDialog = this.createDialog(this.getParent());
        for (Control c : controlz = newDialog.getMainArea().getChildren()) {
            if (c == null || c.isDisposed()) continue;
            c.dispose();
        }
        for (Control c : controls = this.dialog.getMainArea().getChildren()) {
            c.setParent(newDialog.getMainArea());
        }
        this.setButtons(newDialog);
        this.setAppicon(this.appIcon);
        newDialog.getShell().layout();
        BasicDialog outgoingDialog = this.dialog;
        this.dialog = newDialog;
        outgoingDialog.close();
        this.isDialogHidden = true;
        this.setManagedObject(this.dialog.getMainArea());
        this.closing = false;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.show();
        } else {
            this.hide();
        }
    }

    @Override
    public void layout() {
        this.setButtons();
        super.layout();
        for (XulComponent comp : this.getChildNodes()) {
            if (!(comp instanceof XulDialogheader)) continue;
            this.header = (XulDialogheader)comp;
        }
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String getButtonalign() {
        return this.buttonAlignment.toString().toLowerCase();
    }

    public void setButtonalign(String align) {
        this.buttonAlignment = BUTTON_ALIGN.valueOf(align.toUpperCase());
    }

    public String getOnload() {
        return this.onload;
    }

    public void setOnload(String method) {
        this.onload = method;
    }

    @Deprecated
    public void notifyListeners(int event) {
        if (!this.dialog.getShell().isDisposed()) {
            this.dialog.getShell().notifyListeners(event, new Event());
        }
    }

    public boolean isHidden() {
        return this.isDialogHidden;
    }

    public String getButtonlabelextra1() {
        return this.buttonlabelextra1;
    }

    public void setButtonlabelextra1(String buttonlabelextra1) {
        this.buttonlabelextra1 = buttonlabelextra1;
    }

    public String getButtonlabelextra2() {
        return this.buttonlabelextra2;
    }

    public void setButtonlabelextra2(String buttonlabelextra2) {
        this.buttonlabelextra2 = buttonlabelextra2;
    }

    public String getOndialogextra1() {
        return this.ondialogextra1;
    }

    public void setOndialogextra1(String ondialogextra1) {
        this.ondialogextra1 = ondialogextra1;
    }

    public String getOndialogextra2() {
        return this.ondialogextra2;
    }

    public void setOndialogextra2(String ondialogextra2) {
        this.ondialogextra2 = ondialogextra2;
    }

    public XulDomContainer getXulDomContainer() {
        return this.domContainer;
    }

    public void setXulDomContainer(XulDomContainer xulDomContainer) {
        this.domContainer = xulDomContainer;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public Object getRootObject() {
        return this.dialog.getShell();
    }

    public String getOnclose() {
        return this.onclose;
    }

    public String getOnunload() {
        return this.onunload;
    }

    public void setOnclose(String onclose) {
        this.onclose = onclose;
    }

    public void setOnunload(String onunload) {
        this.onunload = onunload;
    }

    public void invokeLater(Runnable runnable) {
        this.dialog.getShell().getDisplay().asyncExec(runnable);
    }

    public Boolean getResizable() {
        return this.resizable;
    }

    public void setResizable(Boolean resizable) {
        this.resizable = resizable;
    }

    public void setModal(Boolean modal) {
        throw new RuntimeException("Not Yet Implemented");
    }

    public void applyParentShellIcon() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppicon(String icon) {
        Image img;
        this.appIcon = icon;
        if (this.appIcon == null || this.dialog == null) {
            return;
        }
        Display d = this.dialog.getShell().getDisplay();
        if (d == null) {
            Display display = d = Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault();
        }
        if ((img = SwtXulUtil.getCachedImage(this.appIcon, this.domContainer, d)) == null) {
            InputStream in = null;
            in = ((Object)((Object)this)).getClass().getResourceAsStream(this.appIcon);
            if (in == null) {
                try {
                    File f = new File(icon);
                    if (f.exists()) {
                        try {
                            in = new FileInputStream(f);
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                    } else {
                        logger.warn((Object)("could not find image: " + this.appIcon));
                        return;
                    }
                    img = new Image((Device)this.dialog.getShell().getDisplay(), in);
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (img != null && this.dialog != null) {
            this.dialog.getShell().setImage(img);
        }
    }

    public boolean isPack() {
        return this.pack;
    }

    public void setPack(boolean pack) {
        this.pack = pack;
    }

    public void center() {
    }

    protected static enum BUTTON_ALIGN {
        START,
        CENTER,
        END,
        LEFT,
        RIGHT,
        MIDDLE;

    }
}

