/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags;

import java.util.WeakHashMap;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swt.SwtElement;
import org.pentaho.ui.xul.util.Direction;
import org.pentaho.ui.xul.util.SwtXulUtil;

public class SwtButton
extends SwtElement
implements XulButton {
    private static final long serialVersionUID = -7218075117194366698L;
    protected Button button;
    private String label;
    private boolean disabled;
    private String image;
    private String disabledImage;
    private String selectedImage;
    private Direction dir;
    private XulButton.Type type;
    private String group;
    private String onclick;
    private boolean selected;
    private XulComponent parent;
    private XulDomContainer domContainer;
    private Label imageButton;
    private static WeakHashMap<Display, Cursor> cursorMap = new WeakHashMap();

    public SwtButton(Button button) {
        super("button");
        this.button = button;
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SwtButton.this.invoke(SwtButton.this.onclick);
            }
        });
        this.setManagedObject(this.button);
    }

    public SwtButton(Element self, XulComponent parent, XulDomContainer container, String tagName) {
        super(tagName);
        this.parent = parent;
        this.domContainer = container;
        if (self != null) {
            this.disabledImage = self.getAttributeValue("disabledimage");
            this.selectedImage = self.getAttributeValue("selectedimage");
            this.image = self.getAttributeValue("image");
            this.label = self.getAttributeValue("label");
        }
        if (this.image != null && this.label == null) {
            this.setManagedObject(this.createImageButton());
        } else {
            this.button = this.createNewButton((Composite)parent.getManagedObject());
            this.setManagedObject(this.button);
        }
    }

    private Control createImageButton() {
        this.imageButton = new Label((Composite)this.parent.getManagedObject(), 0);
        this.imageButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent arg0) {
                if (!SwtButton.this.disabled && SwtButton.this.onclick != null) {
                    SwtButton.this.invoke(SwtButton.this.onclick);
                }
            }
        });
        Display display = ((Composite)this.parent.getManagedObject()).getDisplay();
        Cursor cursor = cursorMap.get(display);
        if (cursor == null) {
            cursor = new Cursor((Device)((Composite)this.parent.getManagedObject()).getDisplay(), 21);
            cursorMap.put(display, cursor);
        }
        this.imageButton.setCursor(cursor);
        return this.imageButton;
    }

    public void setButton(Button button) {
        this.button = button;
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SwtButton.this.invoke(SwtButton.this.onclick);
            }
        });
        this.setManagedObject(button);
        this.setVisible(this.isVisible());
        button.setEnabled(!this.isDisabled());
    }

    protected Button createNewButton(Composite parent) {
        Button button = new Button(parent, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SwtButton.this.invoke(SwtButton.this.onclick);
            }
        });
        return button;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        if (this.button != null) {
            if (this.button.isDisposed()) {
                return;
            }
            this.button.setEnabled(!disabled);
        } else {
            if (this.imageButton.isDisposed()) {
                return;
            }
            this.imageButton.setEnabled(!disabled);
        }
        if (this.disabled) {
            this.displayImage(this.disabledImage);
        } else {
            this.displayImage(this.image);
        }
    }

    public void setOnclick(String method) {
        this.onclick = method;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        if (this.button != null) {
            this.button.setText(label);
        } else {
            this.imageButton.setText(label);
        }
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String src) {
        this.image = src;
        this.displayImage(src);
    }

    public String getDisabledImage() {
        return this.disabledImage;
    }

    public void setDisabledImage(String src) {
        this.disabledImage = src;
    }

    public String getDir() {
        return this.dir.toString().toLowerCase();
    }

    public void setDir(String dir) {
        this.dir = Direction.valueOf((String)dir.toUpperCase());
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getType() {
        return this.type.toString();
    }

    public void setType(String type) {
        this.type = XulButton.Type.valueOf((String)type.toUpperCase());
    }

    public String getOnclick() {
        return this.onclick;
    }

    public void setSelected(String selected) {
        this.setSelected(Boolean.parseBoolean(selected));
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        if (this.button != null) {
            this.button.setSelection(this.selected);
        }
        if (this.selected) {
            this.displayImage(this.selectedImage);
        } else {
            this.displayImage(this.image);
        }
    }

    public void doClick() {
        if (this.button != null) {
            this.button.setSelection(true);
        } else if (this.onclick != null) {
            this.invoke(this.onclick);
        }
    }

    protected void displayImage(String src) {
        Image img;
        if (src == null) {
            return;
        }
        Display d = ((Composite)this.parent.getManagedObject()).getDisplay();
        if (d == null) {
            Display display = d = Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault();
        }
        if ((img = SwtXulUtil.getCachedImage(src, this.domContainer, d)) != null) {
            if (this.button != null) {
                this.button.setImage(img);
            } else {
                this.imageButton.setImage(img);
            }
        }
    }
}

