/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mongodbinput;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.trans.steps.mongodb.MongoDbMeta;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.IConnectionAnalyzer;
import org.pentaho.metaverse.api.ILogicalIdGenerator;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.MetaverseComponentDescriptor;
import org.pentaho.metaverse.api.MetaverseLogicalIdGenerator;
import org.pentaho.metaverse.api.analyzer.kettle.BaseKettleMetaverseComponent;

public class MongoDbConnectionAnalyzer
extends BaseKettleMetaverseComponent
implements IConnectionAnalyzer<MongoDbMeta, MongoDbMeta> {
    public static final String HOST_NAMES = "hostNames";
    public static final String DATABASE_NAME = "databaseName";
    public static final String USE_ALL_REPLICA_SET_MEMBERS = "useAllReplicaSetMembers";
    public static final String USE_KERBEROS_AUTHENTICATION = "useKerberosAuthentication";
    public static final String CONNECTION_TIMEOUT = "connectionTimeout";
    public static final String SOCKET_TIMEOUT = "socketTimeout";
    public static final String CONNECTION_STRING = "connectionString";
    public static final ILogicalIdGenerator ID_GENERATOR = new MetaverseLogicalIdGenerator(new String[]{"hostNames", "databaseName", "port", "userName"});

    public IMetaverseNode analyze(IComponentDescriptor descriptor, MongoDbMeta mongoDbMeta) throws MetaverseAnalyzerException {
        IMetaverseNode datasourceNode = this.createNodeFromDescriptor(descriptor);
        String database = mongoDbMeta.getDbName();
        datasourceNode.setName(database);
        datasourceNode.setProperty(DATABASE_NAME, (Object)database);
        datasourceNode.setType("MongoDB Connection");
        datasourceNode.setLogicalIdGenerator(this.getLogicalIdGenerator());
        if (mongoDbMeta.isUseLegacyOptions()) {
            String port = mongoDbMeta.getPort();
            String hostNames = mongoDbMeta.getHostnames();
            String user = mongoDbMeta.getAuthenticationUser();
            boolean useAllReplicaSetMembers = mongoDbMeta.getUseAllReplicaSetMembers();
            boolean useKerberosAuthentication = mongoDbMeta.getUseKerberosAuthentication();
            String connectTimeout = mongoDbMeta.getConnectTimeout();
            String socketTimeout = mongoDbMeta.getSocketTimeout();
            datasourceNode.setProperty(HOST_NAMES, (Object)hostNames);
            datasourceNode.setProperty("userName", (Object)user);
            datasourceNode.setProperty("port", (Object)port);
            datasourceNode.setProperty(USE_ALL_REPLICA_SET_MEMBERS, (Object)useAllReplicaSetMembers);
            datasourceNode.setProperty(USE_KERBEROS_AUTHENTICATION, (Object)useKerberosAuthentication);
            datasourceNode.setProperty(CONNECTION_TIMEOUT, (Object)connectTimeout);
            datasourceNode.setProperty(SOCKET_TIMEOUT, (Object)socketTimeout);
        } else if (mongoDbMeta.isUseConnectionString()) {
            String connectionString = mongoDbMeta.getConnectionString();
            datasourceNode.setProperty(CONNECTION_STRING, (Object)connectionString);
        }
        return datasourceNode;
    }

    public List<MongoDbMeta> getUsedConnections(MongoDbMeta meta) {
        ArrayList<MongoDbMeta> metas = new ArrayList<MongoDbMeta>();
        metas.add(meta);
        return metas;
    }

    public IComponentDescriptor buildComponentDescriptor(IComponentDescriptor parentDescriptor, MongoDbMeta connection) {
        MetaverseComponentDescriptor dbDescriptor = new MetaverseComponentDescriptor(connection.getDbName(), "MongoDB Connection", parentDescriptor.getNamespace(), parentDescriptor.getContext());
        return dbDescriptor;
    }

    protected ILogicalIdGenerator getLogicalIdGenerator() {
        return ID_GENERATOR;
    }
}

