/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.addsequence;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.PluginDialog;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.addsequence.AddSequenceMeta;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

@PluginDialog(id="Sequence", image="SEQ.svg", pluginType=PluginDialog.PluginType.STEP, documentationUrl="Products/Add_sequence")
public class AddSequenceDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = AddSequenceDialog.class;
    private Label wlValuename;
    private Text wValuename;
    private Group gDatabase;
    private Group gCounter;
    private FormData fdDatabase;
    private FormData fdCounter;
    private Label wlUseDatabase;
    private Button wUseDatabase;
    private Button wbSequence;
    private FormData fdbSequence;
    private Label wlConnection;
    private CCombo wConnection;
    private Button wbnConnection;
    private Button wbeConnection;
    private Button wbwConnection;
    private Label wlSchema;
    private TextVar wSchema;
    private FormData fdbSchema;
    private Button wbSchema;
    private Label wlSeqname;
    private TextVar wSeqname;
    private Label wlUseCounter;
    private Button wUseCounter;
    private Label wlCounterName;
    private Text wCounterName;
    private Label wlStartAt;
    private TextVar wStartAt;
    private Label wlIncrBy;
    private TextVar wIncrBy;
    private Label wlMaxVal;
    private TextVar wMaxVal;
    private AddSequenceMeta input;

    public AddSequenceDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (AddSequenceMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddSequenceDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.StepName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlValuename = new Label((Composite)this.shell, 131072);
        this.wlValuename.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.Valuename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlValuename);
        FormData fdlValuename = new FormData();
        fdlValuename.left = new FormAttachment(0, 0);
        fdlValuename.top = new FormAttachment((Control)this.wStepname, margin);
        fdlValuename.right = new FormAttachment(middle, -margin);
        this.wlValuename.setLayoutData((Object)fdlValuename);
        this.wValuename = new Text((Composite)this.shell, 18436);
        this.wValuename.setText("");
        this.props.setLook((Control)this.wValuename);
        this.wValuename.addModifyListener(lsMod);
        FormData fdValuename = new FormData();
        fdValuename.left = new FormAttachment(middle, 0);
        fdValuename.top = new FormAttachment((Control)this.wStepname, margin);
        fdValuename.right = new FormAttachment(100, 0);
        this.wValuename.setLayoutData((Object)fdValuename);
        this.gDatabase = new Group((Composite)this.shell, 0);
        this.gDatabase.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.UseDatabaseGroup.Label", (String[])new String[0]));
        FormLayout databaseLayout = new FormLayout();
        databaseLayout.marginHeight = margin;
        databaseLayout.marginWidth = margin;
        this.gDatabase.setLayout((Layout)databaseLayout);
        this.props.setLook((Control)this.gDatabase);
        this.fdDatabase = new FormData();
        this.fdDatabase.left = new FormAttachment(0, 0);
        this.fdDatabase.right = new FormAttachment(100, 0);
        this.fdDatabase.top = new FormAttachment((Control)this.wValuename, 2 * margin);
        this.gDatabase.setLayoutData((Object)this.fdDatabase);
        this.wlUseDatabase = new Label((Composite)this.gDatabase, 131072);
        this.wlUseDatabase.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.UseDatabase.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlUseDatabase);
        FormData fdlUseDatabase = new FormData();
        fdlUseDatabase.left = new FormAttachment(0, 0);
        fdlUseDatabase.top = new FormAttachment(0, 0);
        fdlUseDatabase.right = new FormAttachment(middle, -margin);
        this.wlUseDatabase.setLayoutData((Object)fdlUseDatabase);
        this.wUseDatabase = new Button((Composite)this.gDatabase, 32);
        this.props.setLook((Control)this.wUseDatabase);
        this.wUseDatabase.setToolTipText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.UseDatabase.Tooltip", (String[])new String[0]));
        FormData fdUseDatabase = new FormData();
        fdUseDatabase.left = new FormAttachment(middle, 0);
        fdUseDatabase.top = new FormAttachment(0, 0);
        this.wUseDatabase.setLayoutData((Object)fdUseDatabase);
        this.wUseDatabase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddSequenceDialog.this.wUseCounter.setSelection(!AddSequenceDialog.this.wUseDatabase.getSelection());
                AddSequenceDialog.this.enableFields();
                AddSequenceDialog.this.input.setChanged();
            }
        });
        this.wlConnection = new Label((Composite)this.gDatabase, 131072);
        this.wbwConnection = new Button((Composite)this.gDatabase, 8);
        this.wbnConnection = new Button((Composite)this.gDatabase, 8);
        this.wbeConnection = new Button((Composite)this.gDatabase, 8);
        this.wConnection = this.addConnectionLine((Composite)this.gDatabase, (Control)this.wUseDatabase, middle, margin, this.wlConnection, this.wbwConnection, this.wbnConnection, this.wbeConnection);
        if (this.input.getDatabase() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        this.wConnection.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddSequenceDialog.this.activeSequence();
            }
        });
        this.wlSchema = new Label((Composite)this.gDatabase, 131072);
        this.wlSchema.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.TargetSchema.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSchema);
        FormData fdlSchema = new FormData();
        fdlSchema.left = new FormAttachment(0, 0);
        fdlSchema.right = new FormAttachment(middle, -margin);
        fdlSchema.top = new FormAttachment((Control)this.wConnection, 2 * margin);
        this.wlSchema.setLayoutData((Object)fdlSchema);
        this.wbSchema = new Button((Composite)this.gDatabase, 0x1000008);
        this.props.setLook((Control)this.wbSchema);
        this.wbSchema.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.GetSchemas.Label", (String[])new String[0]));
        this.fdbSchema = new FormData();
        this.fdbSchema.top = new FormAttachment((Control)this.wConnection, 2 * margin);
        this.fdbSchema.right = new FormAttachment(100, 0);
        this.wbSchema.setLayoutData((Object)this.fdbSchema);
        this.wSchema = new TextVar((VariableSpace)this.transMeta, (Composite)this.gDatabase, 18436);
        this.props.setLook((Control)this.wSchema);
        this.wSchema.addModifyListener(lsMod);
        FormData fdSchema = new FormData();
        fdSchema.left = new FormAttachment(middle, 0);
        fdSchema.top = new FormAttachment((Control)this.wConnection, 2 * margin);
        fdSchema.right = new FormAttachment((Control)this.wbSchema, -margin);
        this.wSchema.setLayoutData((Object)fdSchema);
        this.wlSeqname = new Label((Composite)this.gDatabase, 131072);
        this.wlSeqname.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.Seqname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSeqname);
        FormData fdlSeqname = new FormData();
        fdlSeqname.left = new FormAttachment(0, 0);
        fdlSeqname.right = new FormAttachment(middle, -margin);
        fdlSeqname.top = new FormAttachment((Control)this.wbSchema, margin);
        this.wlSeqname.setLayoutData((Object)fdlSeqname);
        this.wbSequence = new Button((Composite)this.gDatabase, 0x1000008);
        this.props.setLook((Control)this.wbSequence);
        this.wbSequence.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.GetSequences.Label", (String[])new String[0]));
        this.fdbSequence = new FormData();
        this.fdbSequence.right = new FormAttachment(100, -margin);
        this.fdbSequence.top = new FormAttachment((Control)this.wbSchema, margin);
        this.wbSequence.setLayoutData((Object)this.fdbSequence);
        this.wSeqname = new TextVar((VariableSpace)this.transMeta, (Composite)this.gDatabase, 18436);
        this.wSeqname.setText("");
        this.props.setLook((Control)this.wSeqname);
        this.wSeqname.addModifyListener(lsMod);
        FormData fdSeqname = new FormData();
        fdSeqname.left = new FormAttachment(middle, 0);
        fdSeqname.top = new FormAttachment((Control)this.wbSchema, margin);
        fdSeqname.right = new FormAttachment((Control)this.wbSequence, -margin);
        this.wSeqname.setLayoutData((Object)fdSeqname);
        this.gCounter = new Group((Composite)this.shell, 0);
        this.gCounter.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.UseCounterGroup.Label", (String[])new String[0]));
        FormLayout counterLayout = new FormLayout();
        counterLayout.marginHeight = margin;
        counterLayout.marginWidth = margin;
        this.gCounter.setLayout((Layout)counterLayout);
        this.props.setLook((Control)this.gCounter);
        this.fdCounter = new FormData();
        this.fdCounter.left = new FormAttachment(0, 0);
        this.fdCounter.right = new FormAttachment(100, 0);
        this.fdCounter.top = new FormAttachment((Control)this.gDatabase, 2 * margin);
        this.gCounter.setLayoutData((Object)this.fdCounter);
        this.wlUseCounter = new Label((Composite)this.gCounter, 131072);
        this.wlUseCounter.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.UseCounter.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlUseCounter);
        FormData fdlUseCounter = new FormData();
        fdlUseCounter.left = new FormAttachment(0, 0);
        fdlUseCounter.top = new FormAttachment((Control)this.wSeqname, margin);
        fdlUseCounter.right = new FormAttachment(middle, -margin);
        this.wlUseCounter.setLayoutData((Object)fdlUseCounter);
        this.wUseCounter = new Button((Composite)this.gCounter, 32);
        this.props.setLook((Control)this.wUseCounter);
        this.wUseCounter.setToolTipText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.UseCounter.Tooltip", (String[])new String[0]));
        FormData fdUseCounter = new FormData();
        fdUseCounter.left = new FormAttachment(middle, 0);
        fdUseCounter.top = new FormAttachment((Control)this.wSeqname, margin);
        this.wUseCounter.setLayoutData((Object)fdUseCounter);
        this.wUseCounter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddSequenceDialog.this.wUseDatabase.setSelection(!AddSequenceDialog.this.wUseCounter.getSelection());
                AddSequenceDialog.this.enableFields();
                AddSequenceDialog.this.input.setChanged();
            }
        });
        this.wlCounterName = new Label((Composite)this.gCounter, 131072);
        this.wlCounterName.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.CounterName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCounterName);
        FormData fdlCounterName = new FormData();
        fdlCounterName.left = new FormAttachment(0, 0);
        fdlCounterName.right = new FormAttachment(middle, -margin);
        fdlCounterName.top = new FormAttachment((Control)this.wUseCounter, margin);
        this.wlCounterName.setLayoutData((Object)fdlCounterName);
        this.wCounterName = new Text((Composite)this.gCounter, 18436);
        this.wCounterName.setText("");
        this.props.setLook((Control)this.wCounterName);
        this.wCounterName.addModifyListener(lsMod);
        FormData fdCounterName = new FormData();
        fdCounterName.left = new FormAttachment(middle, 0);
        fdCounterName.top = new FormAttachment((Control)this.wUseCounter, margin);
        fdCounterName.right = new FormAttachment(100, 0);
        this.wCounterName.setLayoutData((Object)fdCounterName);
        this.wlStartAt = new Label((Composite)this.gCounter, 131072);
        this.wlStartAt.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.StartAt.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStartAt);
        FormData fdlStartAt = new FormData();
        fdlStartAt.left = new FormAttachment(0, 0);
        fdlStartAt.right = new FormAttachment(middle, -margin);
        fdlStartAt.top = new FormAttachment((Control)this.wCounterName, margin);
        this.wlStartAt.setLayoutData((Object)fdlStartAt);
        this.wStartAt = new TextVar((VariableSpace)this.transMeta, (Composite)this.gCounter, 18436);
        this.wStartAt.setText("");
        this.props.setLook((Control)this.wStartAt);
        this.wStartAt.addModifyListener(lsMod);
        FormData fdStartAt = new FormData();
        fdStartAt.left = new FormAttachment(middle, 0);
        fdStartAt.top = new FormAttachment((Control)this.wCounterName, margin);
        fdStartAt.right = new FormAttachment(100, 0);
        this.wStartAt.setLayoutData((Object)fdStartAt);
        this.wlIncrBy = new Label((Composite)this.gCounter, 131072);
        this.wlIncrBy.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.IncrBy.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlIncrBy);
        FormData fdlIncrBy = new FormData();
        fdlIncrBy.left = new FormAttachment(0, 0);
        fdlIncrBy.right = new FormAttachment(middle, -margin);
        fdlIncrBy.top = new FormAttachment((Control)this.wStartAt, margin);
        this.wlIncrBy.setLayoutData((Object)fdlIncrBy);
        this.wIncrBy = new TextVar((VariableSpace)this.transMeta, (Composite)this.gCounter, 18436);
        this.wIncrBy.setText("");
        this.props.setLook((Control)this.wIncrBy);
        this.wIncrBy.addModifyListener(lsMod);
        FormData fdIncrBy = new FormData();
        fdIncrBy.left = new FormAttachment(middle, 0);
        fdIncrBy.top = new FormAttachment((Control)this.wStartAt, margin);
        fdIncrBy.right = new FormAttachment(100, 0);
        this.wIncrBy.setLayoutData((Object)fdIncrBy);
        this.wlMaxVal = new Label((Composite)this.gCounter, 131072);
        this.wlMaxVal.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.MaxVal.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlMaxVal);
        FormData fdlMaxVal = new FormData();
        fdlMaxVal.left = new FormAttachment(0, 0);
        fdlMaxVal.right = new FormAttachment(middle, -margin);
        fdlMaxVal.top = new FormAttachment((Control)this.wIncrBy, margin);
        this.wlMaxVal.setLayoutData((Object)fdlMaxVal);
        this.wMaxVal = new TextVar((VariableSpace)this.transMeta, (Composite)this.gCounter, 18436);
        this.wMaxVal.setText("");
        this.props.setLook((Control)this.wMaxVal);
        this.wMaxVal.addModifyListener(lsMod);
        FormData fdMaxVal = new FormData();
        fdMaxVal.left = new FormAttachment(middle, 0);
        fdMaxVal.top = new FormAttachment((Control)this.wIncrBy, margin);
        fdMaxVal.right = new FormAttachment(100, 0);
        this.wMaxVal.setLayoutData((Object)fdMaxVal);
        this.wbSequence.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddSequenceDialog.this.getSequences();
            }
        });
        this.wbSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddSequenceDialog.this.getSchemaNames();
            }
        });
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, (Control)this.gCounter);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                AddSequenceDialog.this.ok();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                AddSequenceDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AddSequenceDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wValuename.addSelectionListener((SelectionListener)this.lsDef);
        this.wSchema.addSelectionListener(this.lsDef);
        this.wSeqname.addSelectionListener(this.lsDef);
        this.wStartAt.addSelectionListener(this.lsDef);
        this.wIncrBy.addSelectionListener(this.lsDef);
        this.wMaxVal.addSelectionListener(this.lsDef);
        this.wCounterName.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                AddSequenceDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void enableFields() {
        boolean useDatabase = this.wUseDatabase.getSelection();
        boolean useCounter = this.wUseCounter.getSelection();
        this.wbSchema.setEnabled(useDatabase);
        this.wlConnection.setEnabled(useDatabase);
        this.wConnection.setEnabled(useDatabase);
        this.wbwConnection.setEnabled(useDatabase);
        this.wbnConnection.setEnabled(useDatabase);
        this.wbeConnection.setEnabled(useDatabase);
        this.wlSchema.setEnabled(useDatabase);
        this.wSchema.setEnabled(useDatabase);
        this.wlSeqname.setEnabled(useDatabase);
        this.wSeqname.setEnabled(useDatabase);
        this.wlCounterName.setEnabled(useCounter);
        this.wCounterName.setEnabled(useCounter);
        this.wlStartAt.setEnabled(useCounter);
        this.wStartAt.setEnabled(useCounter);
        this.wlIncrBy.setEnabled(useCounter);
        this.wIncrBy.setEnabled(useCounter);
        this.wlMaxVal.setEnabled(useCounter);
        this.wMaxVal.setEnabled(useCounter);
        this.activeSequence();
    }

    public void getData() {
        this.logDebug(BaseMessages.getString(PKG, (String)"AddSequenceDialog.Log.GettingKeyInfo", (String[])new String[0]));
        if (this.input.getValuename() != null) {
            this.wValuename.setText(this.input.getValuename());
        }
        this.wUseDatabase.setSelection(this.input.isDatabaseUsed());
        if (this.input.getDatabase() != null) {
            this.wConnection.setText(this.input.getDatabase().getName());
        } else if (this.transMeta.nrDatabases() == 1) {
            this.wConnection.setText(this.transMeta.getDatabase(0).getName());
        }
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getSequenceName() != null) {
            this.wSeqname.setText(this.input.getSequenceName());
        }
        this.wUseCounter.setSelection(this.input.isCounterUsed());
        this.wCounterName.setText(Const.NVL((String)this.input.getCounterName(), (String)""));
        this.wStartAt.setText(this.input.getStartAt());
        this.wIncrBy.setText(this.input.getIncrementBy());
        this.wMaxVal.setText(this.input.getMaxValue());
        this.enableFields();
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.input.setUseCounter(this.wUseCounter.getSelection());
        this.input.setUseDatabase(this.wUseDatabase.getSelection());
        String connection = this.wConnection.getText();
        this.input.setDatabase(this.transMeta.findDatabase(connection));
        this.input.setSchemaName(this.wSchema.getText());
        this.input.setSequenceName(this.wSeqname.getText());
        this.input.setValuename(this.wValuename.getText());
        this.input.setCounterName(this.wCounterName.getText());
        this.input.setStartAt(this.wStartAt.getText());
        this.input.setIncrementBy(this.wIncrBy.getText());
        this.input.setMaxValue(this.wMaxVal.getText());
        if (this.input.isDatabaseUsed() && this.transMeta.findDatabase(connection) == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"AddSequenceDialog.NoValidConnectionError.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.NoValidConnectionError.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void activeSequence() {
        boolean useDatabase = this.wUseDatabase.getSelection();
        DatabaseMeta databaseMeta = this.transMeta.findDatabase(this.wConnection.getText());
        this.wbSequence.setEnabled(databaseMeta == null ? false : useDatabase && databaseMeta.supportsSequences());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSequences() {
        DatabaseMeta databaseMeta = this.transMeta.findDatabase(this.wConnection.getText());
        if (databaseMeta != null) {
            Database database = new Database(loggingObject, databaseMeta);
            try {
                database.connect();
                String[] sequences = database.getSequences();
                if (null != sequences && sequences.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, sequences = Const.sortStrings((String[])sequences), BaseMessages.getString(PKG, (String)"AddSequenceDialog.SelectSequence.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"AddSequenceDialog.SelectSequence.Message", (String[])new String[0]));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSeqname.setText(Const.NVL((String)d.toString(), (String)""));
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"AddSequenceDialog.NoSequence.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.NoSequence.Title", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AddSequenceDialog.ErrorGettingSequences", (String[])new String[0]), e);
            }
            finally {
                if (database != null) {
                    database.disconnect();
                    database = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSchemaNames() {
        if (this.wSchema.isDisposed()) {
            return;
        }
        DatabaseMeta databaseMeta = this.transMeta.findDatabase(this.wConnection.getText());
        if (databaseMeta != null) {
            Database database = new Database(loggingObject, databaseMeta);
            try {
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"AddSequenceDialog.SelectSequence.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"AddSequenceDialog.SelectSequence.Message", (String[])new String[0]));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchema.setText(Const.NVL((String)d.toString(), (String)""));
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"AddSequenceDialog.NoSchema.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.NoSchema.Title", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AddSequenceDialog.ErrorGettingSchemas", (String[])new String[0]), e);
            }
            finally {
                if (database != null) {
                    database.disconnect();
                    database = null;
                }
            }
        }
    }
}

